/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.text.Charsets;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class CordovaVersionDetector
extends Detector
implements ClassScanner {
    private static final Implementation IMPL = new Implementation(CordovaVersionDetector.class, EnumSet.of(Scope.CLASS_FILE, Scope.JAVA_LIBRARIES));
    public static final Issue ISSUE = Issue.create((String)"VulnerableCordovaVersion", (String)"Vulnerable Cordova Version", (String)"The version of Cordova used in the app is vulnerable to security issues. Please update to the latest Apache Cordova version.", (Category)Category.SECURITY, (int)9, (Severity)Severity.WARNING, (Implementation)IMPL).addMoreInfo("https://cordova.apache.org/announcements/2015/11/20/security.html").setAndroidSpecific(true);
    private static final Pattern VERSION_STR = Pattern.compile("(\\d+\\.\\d+\\.\\d+).*");
    private static final String FQN_CORDOVA_DEVICE = "org/apache/cordova/Device";
    private static final String FIELD_NAME_CORDOVA_VERSION = "cordovaVersion";
    private static final String FQN_CORDOVA_WEBVIEW = "org/apache/cordova/CordovaWebView";
    private static final String FIELD_NAME_CORDOVA_VERSION_WEBVIEW = "CORDOVA_VERSION";
    private static final String CORDOVA_DOT_JS = "cordova.js";
    private static final FilenameFilter CORDOVA_JS_FILTER = (dir, filename) -> filename.startsWith(CORDOVA_DOT_JS) || new File(dir, filename).isDirectory();
    private GradleVersion cordovaVersion;

    public void afterCheckRootProject(Context context) {
        this.checkAssetsFolder(context);
    }

    private void checkAssetsFolder(final Context context) {
        if (this.cordovaVersion != null) {
            return;
        }
        if (!context.getProject().getReportIssues()) {
            return;
        }
        Project project = context.getProject();
        List assetFolders = project.getAssetFolders();
        for (File assetFolder : assetFolders) {
            Path start = assetFolder.toPath();
            try {
                Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        if (path.getFileName().toString().startsWith(CordovaVersionDetector.CORDOVA_DOT_JS)) {
                            File file = path.toFile();
                            CharSource source = com.google.common.io.Files.asCharSource((File)file, (Charset)Charsets.UTF_8);
                            CordovaVersionDetector.this.cordovaVersion = (GradleVersion)source.readLines((LineProcessor)new JsVersionLineProcessor());
                            if (CordovaVersionDetector.this.cordovaVersion != null) {
                                CordovaVersionDetector.validateCordovaVersion(context, CordovaVersionDetector.this.cordovaVersion, Location.create((File)file));
                            }
                            return FileVisitResult.TERMINATE;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException iOException) {}
        }
    }

    private static void validateCordovaVersion(Context context, GradleVersion cordovaVersion, Location location) {
        if (!cordovaVersion.isAtLeast(6, 1, 2)) {
            String message2 = String.format("You are using a vulnerable version of Cordova: %1$s", cordovaVersion.toString());
            context.report(ISSUE, location, message2);
        }
    }

    public void checkClass(ClassContext context, ClassNode classNode) {
        block5: {
            block4: {
                if (this.cordovaVersion != null) {
                    return;
                }
                if (!classNode.name.equals(FQN_CORDOVA_DEVICE)) break block4;
                List methods = classNode.methods;
                block0: for (MethodNode method : methods) {
                    if (!"<clinit>".equals(method.name)) continue;
                    InsnList nodes = method.instructions;
                    int n = nodes.size();
                    for (int i = 0; i < n; ++i) {
                        AbstractInsnNode instruction = nodes.get(i);
                        int type = instruction.getType();
                        if (type != 4) continue;
                        this.checkInstructionInternal(context, classNode, instruction);
                        continue block0;
                    }
                }
                break block5;
            }
            if (!classNode.name.equals(FQN_CORDOVA_WEBVIEW)) break block5;
            List fields = classNode.fields;
            for (FieldNode node : fields) {
                if (!FIELD_NAME_CORDOVA_VERSION_WEBVIEW.equals(node.name) || (node.access & 0x10) != 16 || (node.access & 8) != 8 || !(node.value instanceof String)) continue;
                this.cordovaVersion = CordovaVersionDetector.createVersion((String)node.value);
                if (this.cordovaVersion == null) continue;
                CordovaVersionDetector.validateCordovaVersion((Context)context, this.cordovaVersion, context.getLocation(classNode));
            }
        }
    }

    private void checkInstructionInternal(ClassContext context, ClassNode classNode, AbstractInsnNode instruction) {
        FieldInsnNode node = (FieldInsnNode)instruction;
        if (node.getOpcode() == 179 && node.owner.equals(FQN_CORDOVA_DEVICE) && node.name.equals(FIELD_NAME_CORDOVA_VERSION)) {
            AbstractInsnNode prevInstruction = Lint.getPrevInstruction((AbstractInsnNode)node);
            if (prevInstruction == null || prevInstruction.getOpcode() != 18) {
                return;
            }
            LdcInsnNode ldcInsnNode = (LdcInsnNode)prevInstruction;
            if (ldcInsnNode.cst instanceof String) {
                this.cordovaVersion = CordovaVersionDetector.createVersion((String)ldcInsnNode.cst);
                if (this.cordovaVersion != null) {
                    CordovaVersionDetector.validateCordovaVersion((Context)context, this.cordovaVersion, context.getLocation(classNode));
                }
            }
        }
    }

    private static GradleVersion createVersion(String version) {
        Matcher matcher = VERSION_STR.matcher(version);
        if (matcher.matches()) {
            return GradleVersion.tryParse((String)matcher.group(1));
        }
        return null;
    }

    public static class JsVersionLineProcessor
    implements LineProcessor<GradleVersion> {
        private static final Pattern PATTERN = Pattern.compile("var\\s*(PLATFORM_VERSION_BUILD_LABEL|CORDOVA_JS_BUILD_LABEL)\\s*=\\s*'(\\d+\\.\\d+\\.\\d+)[^']*';.*");
        private GradleVersion mVersion;

        public boolean processLine(String line) {
            Matcher matcher;
            if ((line.contains("PLATFORM_VERSION_BUILD_LABEL") || line.contains("CORDOVA_JS_BUILD_LABEL")) && (matcher = PATTERN.matcher(line)).matches()) {
                this.mVersion = GradleVersion.tryParse((String)matcher.group(2));
                return false;
            }
            return true;
        }

        public GradleVersion getResult() {
            return this.mVersion;
        }
    }
}

