/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0003\u001a\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J|\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0016\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/RequiresFeatureDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "usage", "Lorg/jetbrains/uast/UElement;", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "qualifiedName", "method", "Lcom/intellij/psi/PsiMethod;", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "Companion", "EnforcementChecker", "NameLookup", "lint-checks"})
public final class RequiresFeatureDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final String ATTR_ENFORCEMENT = "enforcement";
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue REQUIRES_FEATURE;
    public static final Companion Companion;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{"android.support.annotation.RequiresFeature", "androidx.annotation.RequiresFeature"});
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        if (method == null) {
            return;
        }
        if (type != AnnotationUsageType.METHOD_CALL && type != AnnotationUsageType.METHOD_CALL_CLASS && type != AnnotationUsageType.METHOD_CALL_PACKAGE) {
            return;
        }
        UExpression nameAttribute = annotation.findAttributeValue("name");
        Object object = nameAttribute;
        if (object == null || (object = UastLiteralUtils.getValueIfStringLiteral((UElement)((UElement)object))) == null) {
            return;
        }
        Object name = object;
        UExpression enforcementAttribute = annotation.findAttributeValue(ATTR_ENFORCEMENT);
        Object object2 = enforcementAttribute;
        if (object2 == null || (object2 = UastLiteralUtils.getValueIfStringLiteral((UElement)((UElement)object2))) == null) {
            return;
        }
        Object reference = object2;
        EnforcementChecker checker2 = new EnforcementChecker((String)name, (String)reference);
        if (!EnforcementChecker.isWithinNameCheckConditional$default(checker2, context.getEvaluator(), usage, null, 4, null) && !checker2.isPrecededByFeatureCheck(usage)) {
            JavaContext.report$default((JavaContext)context, (Issue)REQUIRES_FEATURE, (UElement)usage, (Location)context.getLocation(usage), (String)('`' + method.getName() + "` should only be called if the feature `" + (String)name + "` is " + "present; to check call `" + (String)reference + '`'), null, (int)16, null);
        }
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(RequiresFeatureDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.WARNING;
        int n = 6;
        String string = null;
        Category category = Category.CORRECTNESS;
        REQUIRES_FEATURE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"RequiresFeature", (String)"Requires Feature", (String)"\n                Some APIs require optional features to be present. This check makes sure that \\\n                calls to these APIs are surrounded by a check which enforces this.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/RequiresFeatureDetector$NameLookup;", "", "arguments", "", "Lorg/jetbrains/uast/UExpression;", "(Ljava/util/List;)V", "getArguments", "()Ljava/util/List;", "getName", "", "argument", "Lorg/jetbrains/uast/UElement;", "lint-checks"})
    public static final class NameLookup {
        @NotNull
        private final List<UExpression> arguments;

        @Nullable
        public final String getName(@NotNull UElement argument) {
            int index;
            PsiParameterList parameterList;
            PsiElement resolved;
            Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
            if (argument instanceof UReferenceExpression && (resolved = ((UReferenceExpression)argument).resolve()) instanceof PsiParameter && (parameterList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiParameterList.class)) != null && (index = parameterList.getParameterIndex((PsiParameter)resolved)) != -1 && index < this.arguments.size()) {
                return UastLiteralUtils.getValueIfStringLiteral((UElement)((UElement)this.arguments.get(index)));
            }
            return null;
        }

        @NotNull
        public final List<UExpression> getArguments() {
            return this.arguments;
        }

        public NameLookup(@NotNull List<? extends UExpression> arguments) {
            Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
            this.arguments = arguments;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002J3\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ)\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0018J1\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u001bJ$\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/checks/RequiresFeatureDetector$EnforcementChecker;", "", "featureName", "", "enforcement", "(Ljava/lang/String;Ljava/lang/String;)V", "className", "methodName", "isAndedWithConditional", "", "element", "Lorg/jetbrains/uast/UElement;", "before", "isNameCheckConditional", "and", "prev", "nameLookup", "Lcom/android/tools/lint/checks/RequiresFeatureDetector$NameLookup;", "(Lorg/jetbrains/uast/UElement;ZLorg/jetbrains/uast/UElement;Lcom/android/tools/lint/checks/RequiresFeatureDetector$NameLookup;)Ljava/lang/Boolean;", "isOredWithConditional", "isPrecededByFeatureCheck", "isValidFeatureCheckCall", "call", "Lorg/jetbrains/uast/UCallExpression;", "(ZLorg/jetbrains/uast/UCallExpression;Lcom/android/tools/lint/checks/RequiresFeatureDetector$NameLookup;)Ljava/lang/Boolean;", "method", "Lcom/intellij/psi/PsiMethod;", "(ZLorg/jetbrains/uast/UElement;Lcom/intellij/psi/PsiMethod;Lcom/android/tools/lint/checks/RequiresFeatureDetector$NameLookup;)Ljava/lang/Boolean;", "isWithinNameCheckConditional", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "FeatureCheckExitFinder", "lint-checks"})
    public static final class EnforcementChecker {
        private final String className;
        private final String methodName;
        private final String featureName;

        public final boolean isPrecededByFeatureCheck(@NotNull UElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            UElement current = element;
            UExpression currentExpression = (UExpression)UastUtils.getParentOfType((UElement)current, UExpression.class, (boolean)true, (Class[])new Class[]{UMethod.class, UClass.class});
            while (currentExpression != null) {
                FeatureCheckExitFinder visitor2 = new FeatureCheckExitFinder(this, current);
                currentExpression.accept((UastVisitor)visitor2);
                if (visitor2.found()) {
                    return true;
                }
                current = (UElement)currentExpression;
                currentExpression = (UExpression)UastUtils.getParentOfType((UElement)((UElement)currentExpression), UExpression.class, (boolean)true, (Class[])new Class[]{UMethod.class, UClass.class});
            }
            return false;
        }

        @JvmOverloads
        public final boolean isWithinNameCheckConditional(@NotNull JavaEvaluator evaluator, @NotNull UElement element, @Nullable NameLookup nameLookup) {
            Intrinsics.checkParameterIsNotNull((Object)evaluator, (String)"evaluator");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            UElement current = Lint.skipParentheses((UElement)element.getUastParent());
            UElement prev = element;
            while (current != null) {
                Boolean ok;
                if (current instanceof UIfExpression) {
                    boolean fromThen;
                    UExpression condition = ((UIfExpression)current).getCondition();
                    if (prev != condition && (ok = this.isNameCheckConditional((UElement)condition, fromThen = Intrinsics.areEqual((Object)prev, (Object)((UIfExpression)current).getThenExpression()), prev, nameLookup)) != null && ok.booleanValue()) {
                        return true;
                    }
                } else {
                    if (current instanceof UPolyadicExpression && (this.isAndedWithConditional(current, prev) || this.isOredWithConditional(current, prev))) {
                        return true;
                    }
                    if (current instanceof USwitchClauseExpressionWithBody) {
                        for (UExpression condition : ((USwitchClauseExpressionWithBody)current).getCaseValues()) {
                            ok = this.isNameCheckConditional((UElement)condition, true, prev, nameLookup);
                            if (ok == null || !ok.booleanValue()) continue;
                            return true;
                        }
                    } else if (current instanceof UCallExpression && prev instanceof ULambdaExpression) {
                        Map mapping;
                        PsiParameter parameter;
                        UElement call = current;
                        PsiMethod method = ((UCallExpression)call).resolve();
                        if (method != null && (parameter = (PsiParameter)(mapping = evaluator.computeArgumentMapping((UCallExpression)call, method)).get(prev)) != null) {
                            String parameterName;
                            UastContext context = UastUtils.getUastContext((UElement)element);
                            UMethod uMethod = context.getMethod(method);
                            Ref match = new Ref();
                            Intrinsics.checkExpressionValueIsNotNull((Object)parameter.getName(), (String)"parameter.name");
                            uMethod.accept((UastVisitor)new AbstractUastVisitor(parameterName, match){
                                final /* synthetic */ String $parameterName;
                                final /* synthetic */ Ref $match;

                                public boolean visitCallExpression(@NotNull UCallExpression node) {
                                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                                    String callName = Lint.getMethodName((UCallExpression)node);
                                    if (Intrinsics.areEqual((Object)callName, (Object)this.$parameterName)) {
                                        this.$match.set((Object)node);
                                    }
                                    return super.visitCallExpression(node);
                                }
                                {
                                    this.$parameterName = $captured_local_variable$0;
                                    this.$match = $captured_local_variable$1;
                                }
                            });
                            UCallExpression lambdaInvocation = (UCallExpression)match.get();
                            NameLookup newApiLookup2 = new NameLookup(((UCallExpression)call).getValueArguments());
                            if (lambdaInvocation != null && this.isWithinNameCheckConditional(evaluator, (UElement)lambdaInvocation, newApiLookup2)) {
                                return true;
                            }
                        }
                    } else if (current instanceof UMethod || current instanceof PsiFile) {
                        return false;
                    }
                }
                prev = current;
                current = Lint.skipParentheses((UElement)current.getUastParent());
            }
            return false;
        }

        public static /* synthetic */ boolean isWithinNameCheckConditional$default(EnforcementChecker enforcementChecker, JavaEvaluator javaEvaluator, UElement uElement, NameLookup nameLookup, int n, Object object) {
            if ((n & 4) != 0) {
                nameLookup = null;
            }
            return enforcementChecker.isWithinNameCheckConditional(javaEvaluator, uElement, nameLookup);
        }

        @JvmOverloads
        public final boolean isWithinNameCheckConditional(@NotNull JavaEvaluator evaluator, @NotNull UElement element) {
            return EnforcementChecker.isWithinNameCheckConditional$default(this, evaluator, element, null, 4, null);
        }

        private final Boolean isNameCheckConditional(UElement element, boolean and, UElement prev, NameLookup nameLookup) {
            if (element instanceof UPolyadicExpression) {
                UastBinaryOperator tokenType = ((UPolyadicExpression)element).getOperator();
                if (and && tokenType == UastBinaryOperator.LOGICAL_AND ? this.isAndedWithConditional(element, prev) : !and && tokenType == UastBinaryOperator.LOGICAL_OR && this.isOredWithConditional(element, prev)) {
                    return true;
                }
            } else {
                UExpression operand;
                Boolean ok;
                if (element instanceof UCallExpression) {
                    return this.isValidFeatureCheckCall(and, (UCallExpression)element, nameLookup);
                }
                if (element instanceof UReferenceExpression) {
                    PsiElement resolved = ((UReferenceExpression)element).resolve();
                    if (resolved instanceof PsiMethod && element instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)element).getSelector() instanceof UCallExpression) {
                        UExpression uExpression = ((UQualifiedReferenceExpression)element).getSelector();
                        if (uExpression == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                        }
                        UCallExpression call = (UCallExpression)uExpression;
                        return this.isValidFeatureCheckCall(and, call, nameLookup);
                    }
                    if (resolved instanceof PsiMethod && element instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)element).getReceiver() instanceof UReferenceExpression) {
                        return this.isValidFeatureCheckCall(and, element, (PsiMethod)resolved, nameLookup);
                    }
                } else if (element instanceof UUnaryExpression && ((UUnaryExpression)element).getOperator() == UastPrefixOperator.LOGICAL_NOT && (ok = this.isNameCheckConditional((UElement)(operand = ((UUnaryExpression)element).getOperand()), !and, null, null)) != null) {
                    return ok;
                }
            }
            return null;
        }

        private final Boolean isValidFeatureCheckCall(boolean and, UCallExpression call, NameLookup nameLookup) {
            PsiMethod psiMethod = call.resolve();
            if (psiMethod == null) {
                return null;
            }
            PsiMethod method = psiMethod;
            return this.isValidFeatureCheckCall(and, (UElement)call, method, nameLookup);
        }

        private final Boolean isValidFeatureCheckCall(boolean and, UElement call, PsiMethod method, NameLookup nameLookup) {
            String string = method.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
            String name = string;
            if (Intrinsics.areEqual((Object)this.methodName, (Object)name) && and) {
                if (this.className != null) {
                    String qualifiedName;
                    PsiClass containingClass;
                    PsiClass psiClass = containingClass = method.getContainingClass();
                    String string2 = qualifiedName = psiClass != null ? psiClass.getQualifiedName() : null;
                    if (qualifiedName != null && !StringsKt.contains$default((CharSequence)qualifiedName, (CharSequence)this.className, (boolean)false, (int)2, null)) {
                        return false;
                    }
                }
                if (call instanceof UCallExpression) {
                    List valueArguments = ((UCallExpression)call).getValueArguments();
                    for (UExpression first : valueArguments) {
                        PsiType expressionType = first.getExpressionType();
                        if (expressionType != null && !Intrinsics.areEqual((Object)expressionType.getCanonicalText(), (Object)"java.lang.String")) continue;
                        String argString = ConstantEvaluator.evaluateString(null, (UElement)((UElement)first), (boolean)false);
                        if (Intrinsics.areEqual((Object)this.featureName, (Object)argString)) {
                            return true;
                        }
                        if (argString != null || nameLookup == null) break;
                        String level = nameLookup.getName((UElement)first);
                        return Intrinsics.areEqual((Object)this.featureName, (Object)level);
                    }
                }
                return false;
            }
            if (!method.hasModifierProperty("abstract")) {
                UastContext context = UastUtils.getUastContext((UElement)call);
                UExpression uExpression = context.getMethodBody(method);
                if (uExpression == null) {
                    return null;
                }
                UExpression body = uExpression;
                List expressions = null;
                List list = expressions = body instanceof UBlockExpression ? ((UBlockExpression)body).getExpressions() : CollectionsKt.listOf((Object)body);
                if (expressions.size() == 1) {
                    UExpression statement = (UExpression)expressions.get(0);
                    UExpression returnValue = null;
                    if (statement instanceof UReturnExpression) {
                        returnValue = ((UReturnExpression)statement).getReturnExpression();
                    } else if (statement != null) {
                        returnValue = statement;
                    }
                    if (returnValue != null) {
                        NameLookup lookup2;
                        Boolean ok;
                        Object arguments;
                        Object object;
                        UElement uElement = call;
                        if (!(uElement instanceof UCallExpression)) {
                            uElement = null;
                        }
                        if ((object = (UCallExpression)uElement) == null || (object = object.getValueArguments()) == null) {
                            object = arguments = CollectionsKt.emptyList();
                        }
                        if (arguments.isEmpty()) {
                            Boolean isConditional;
                            if ((returnValue instanceof UPolyadicExpression || returnValue instanceof UCallExpression || returnValue instanceof UQualifiedReferenceExpression) && (isConditional = this.isNameCheckConditional((UElement)returnValue, and, null, null)) != null) {
                                return isConditional;
                            }
                        } else if (arguments.size() == 1 && (ok = this.isNameCheckConditional((UElement)returnValue, and, null, lookup2 = new NameLookup((List<? extends UExpression>)arguments))) != null) {
                            return ok;
                        }
                    }
                }
            }
            return null;
        }

        private final boolean isOredWithConditional(UElement element, UElement before) {
            if (element instanceof UBinaryExpression) {
                UExpression left;
                if (((UBinaryExpression)element).getOperator() == UastBinaryOperator.LOGICAL_OR && before != (left = ((UBinaryExpression)element).getLeftOperand())) {
                    Boolean ok = this.isNameCheckConditional((UElement)left, false, null, null);
                    if (ok != null) {
                        return ok;
                    }
                    UExpression right = ((UBinaryExpression)element).getRightOperand();
                    ok = this.isNameCheckConditional((UElement)right, false, null, null);
                    if (ok != null) {
                        return ok;
                    }
                }
                return false;
            }
            if (element instanceof UCallExpression) {
                Boolean value = this.isValidFeatureCheckCall(false, (UCallExpression)element, null);
                return value != null && value != false;
            }
            if (element instanceof UPolyadicExpression && ((UPolyadicExpression)element).getOperator() == UastBinaryOperator.LOGICAL_OR) {
                UExpression operand;
                Iterator iterator = ((UPolyadicExpression)element).getOperands().iterator();
                while (iterator.hasNext() && !Intrinsics.areEqual((Object)(operand = (UExpression)iterator.next()), (Object)before)) {
                    if (!this.isOredWithConditional((UElement)operand, before)) continue;
                    return true;
                }
            }
            return false;
        }

        private final boolean isAndedWithConditional(UElement element, UElement before) {
            if (element instanceof UBinaryExpression) {
                UExpression left;
                if (((UBinaryExpression)element).getOperator() == UastBinaryOperator.LOGICAL_AND && before != (left = ((UBinaryExpression)element).getLeftOperand())) {
                    Boolean ok = this.isNameCheckConditional((UElement)left, true, null, null);
                    if (ok != null) {
                        return ok;
                    }
                    UExpression right = ((UBinaryExpression)element).getRightOperand();
                    ok = this.isNameCheckConditional((UElement)right, true, null, null);
                    if (ok != null) {
                        return ok;
                    }
                }
                return false;
            }
            if (element instanceof UCallExpression) {
                Boolean value = this.isValidFeatureCheckCall(true, (UCallExpression)element, null);
                return value != null && value != false;
            }
            if (element instanceof UPolyadicExpression && ((UPolyadicExpression)element).getOperator() == UastBinaryOperator.LOGICAL_AND) {
                UExpression operand;
                Iterator iterator = ((UPolyadicExpression)element).getOperands().iterator();
                while (iterator.hasNext() && !Intrinsics.areEqual((Object)(operand = (UExpression)iterator.next()), (Object)before)) {
                    if (!this.isAndedWithConditional((UElement)operand, before)) continue;
                    return true;
                }
            }
            return false;
        }

        public EnforcementChecker(@NotNull String featureName, @NotNull String enforcement) {
            int classEnd;
            Intrinsics.checkParameterIsNotNull((Object)featureName, (String)"featureName");
            Intrinsics.checkParameterIsNotNull((Object)enforcement, (String)RequiresFeatureDetector.ATTR_ENFORCEMENT);
            this.featureName = featureName;
            int paren = StringsKt.indexOf$default((CharSequence)enforcement, (char)'(', (int)0, (boolean)false, (int)6, null);
            int argBegin = paren != -1 ? paren : enforcement.length();
            int hash = StringsKt.indexOf$default((CharSequence)enforcement, (char)'#', (int)0, (boolean)false, (int)6, null);
            int n = classEnd = hash != -1 ? hash : StringsKt.lastIndexOf$default((CharSequence)enforcement, (char)'.', (int)argBegin, (boolean)false, (int)4, null);
            if (classEnd != -1) {
                String string;
                String string2 = enforcement;
                int n2 = 0;
                EnforcementChecker enforcementChecker = this;
                boolean bl = false;
                String string3 = string2.substring(n2, classEnd);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                enforcementChecker.className = string = string3;
                string2 = enforcement;
                n2 = classEnd + 1;
                enforcementChecker = this;
                bl = false;
                String string4 = string2.substring(n2, argBegin);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                enforcementChecker.methodName = string = string4;
            } else {
                String string;
                this.className = null;
                String string5 = enforcement;
                int n3 = 0;
                EnforcementChecker enforcementChecker = this;
                boolean bl = false;
                String string6 = string5.substring(n3, argBegin);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                enforcementChecker.methodName = string = string6;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/RequiresFeatureDetector$EnforcementChecker$FeatureCheckExitFinder;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "enforcement", "Lcom/android/tools/lint/checks/RequiresFeatureDetector$EnforcementChecker;", "endElement", "Lorg/jetbrains/uast/UElement;", "(Lcom/android/tools/lint/checks/RequiresFeatureDetector$EnforcementChecker;Lorg/jetbrains/uast/UElement;)V", "done", "", "found", "isUnconditionalReturn", "statement", "Lorg/jetbrains/uast/UExpression;", "visitElement", "node", "visitIfExpression", "Lorg/jetbrains/uast/UIfExpression;", "lint-checks"})
        private static final class FeatureCheckExitFinder
        extends AbstractUastVisitor {
            private boolean found;
            private boolean done;
            private final EnforcementChecker enforcement;
            private final UElement endElement;

            public boolean visitElement(@NotNull UElement node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (this.done) {
                    return true;
                }
                if (Intrinsics.areEqual((Object)node, (Object)this.endElement)) {
                    this.done = true;
                }
                return this.done;
            }

            public boolean visitIfExpression(@NotNull UIfExpression node) {
                Boolean level;
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (this.done) {
                    return true;
                }
                UExpression thenBranch = node.getThenExpression();
                UExpression elseBranch = node.getElseExpression();
                if (thenBranch != null && (level = this.enforcement.isNameCheckConditional((UElement)node.getCondition(), false, null, null)) != null && level.booleanValue() && this.isUnconditionalReturn(thenBranch)) {
                    this.found = true;
                    this.done = true;
                }
                if (elseBranch != null && (level = this.enforcement.isNameCheckConditional((UElement)node.getCondition(), true, null, null)) != null && level.booleanValue() && this.isUnconditionalReturn(elseBranch)) {
                    this.found = true;
                    this.done = true;
                }
                return true;
            }

            private final boolean isUnconditionalReturn(UExpression statement) {
                List expressions;
                if (statement instanceof UBlockExpression && (expressions = ((UBlockExpression)statement).getExpressions()).size() == 1 && expressions.get(0) instanceof UReturnExpression) {
                    return true;
                }
                return statement instanceof UReturnExpression;
            }

            public final boolean found() {
                return this.found;
            }

            public FeatureCheckExitFinder(@NotNull EnforcementChecker enforcement, @NotNull UElement endElement) {
                Intrinsics.checkParameterIsNotNull((Object)enforcement, (String)RequiresFeatureDetector.ATTR_ENFORCEMENT);
                Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
                this.enforcement = enforcement;
                this.endElement = endElement;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/RequiresFeatureDetector$Companion;", "", "()V", "ATTR_ENFORCEMENT", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "REQUIRES_FEATURE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

