/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.AndroidPatternMatcher;
import com.android.tools.lint.checks.AppLinksValidDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.CharSequences;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 72\u00020\u00012\u00020\u0002:\u000278B\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002JB\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\fH\u0002J$\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b2\u0006\u0010\u0018\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ \u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u001a\u0010\"\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020\u0006H\u0002J(\u0010$\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0006H\u0002J4\u0010*\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00062\n\b\u0002\u0010+\u001a\u0004\u0018\u00010,H\u0002J$\u0010-\u001a\u00020 2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\u0006H\u0002J\u001e\u00101\u001a\u0004\u0018\u00010\u00062\u0006\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bJ0\u00105\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0006H\u0002J\u0018\u00106\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\fH\u0016\u00a8\u00069"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "addAttribute", "", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "attributeName", "existing", "data", "Lorg/w3c/dom/Element;", "addMatcher", "Lcom/android/tools/lint/checks/AndroidPatternMatcher;", "type", "", "matcher", "checkActivity", "", "element", "checkIntent", "Lcom/android/tools/lint/checks/AppLinksValidDetector$UriInfo;", "intent", "activity", "checkIntentFilter", "createUriInfos", "", "ensureExported", "getApplicableElements", "", "hasActionView", "", "isBrowsable", "replaceUrlWithValue", "str", "reportTestUrlFailure", "node", "Lorg/w3c/dom/Node;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "reportUrlError", "quickfixData", "Lcom/android/tools/lint/detector/api/LintFix;", "requireNonEmpty", "attribute", "Lorg/w3c/dom/Attr;", "value", "testElement", "testUrl", "Ljava/net/URL;", "infos", "validateAttribute", "visitElement", "Companion", "UriInfo", "lint-checks"})
public final class AppLinksValidDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(AppLinksValidDetector.class, Scope.MANIFEST_SCOPE);
    @JvmField
    @NotNull
    public static final Issue TEST_URL = Issue.Companion.create("TestAppLink", "Unmatched URLs", "\n                Using one or more `tools:validation testUrl=\"some url\"/>` elements in your manifest allows \\\n                the link attributes in your intent filter to be checked for matches.\n                ", Category.CORRECTNESS, 5, Severity.FATAL, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue VALIDATION;
    @NotNull
    private static final Issue _OLD_ISSUE_URL;
    @JvmField
    @NotNull
    public static final Issue INTENT_FILTER_UNIQUE_DATA_ATTRIBUTES;
    @NotNull
    private static final String TAG_VALIDATION = "validation";
    @NotNull
    private static final List<String> INTENT_FILTER_DATA_SORT_REFERENCE;

    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"activity", "activity-alias", "intent-filter"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String tag = element.getTagName();
        if (tag != null) {
            int n = -1;
            switch (tag.hashCode()) {
                case -1655966961: {
                    if (!tag.equals("activity")) break;
                    n = 1;
                    break;
                }
                case -1029793847: {
                    if (!tag.equals("intent-filter")) break;
                    n = 2;
                    break;
                }
                case 790287890: {
                    if (!tag.equals("activity-alias")) break;
                    n = 1;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    this.checkIntentFilter(context, element);
                    return;
                }
                case 1: {
                    this.checkActivity(context, element);
                    return;
                }
            }
        }
        String string = Intrinsics.stringPlus((String)"Unhandled tag ", (Object)tag);
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkIntentFilter(XmlContext context, Element element) {
        dataTag = null;
        var4_4 = XmlUtils.getFirstSubTagByName((Node)element, (String)"data");
        if (var4_4 == null) {
            return;
        }
        dataTag = var4_4;
        if (XmlUtils.getNextTagByName((Node)dataTag, (String)"data") == null) {
            return;
        }
        var5_5 = false;
        incidents = new ArrayList<E>();
        dataTagCount = 0;
        do {
            block32: {
                block31: {
                    block35: {
                        var6_6 = dataTagCount;
                        dataTagCount = var6_6 + 1;
                        v0 = dataTag;
                        Intrinsics.checkNotNull((Object)v0);
                        length = v0.getAttributes().getLength();
                        var8_10 = 0;
                        attributes = new ArrayList<E>();
                        var8_10 = 0;
                        if (var8_10 < length) {
                            do {
                                attributeIndex = var8_10++;
                                var10_16 = attributes;
                                var11_22 = dataTag.getAttributes().item(attributeIndex);
                                var12_28 = false;
                                var10_16.add(var11_22);
                            } while (var8_10 < length);
                        }
                        $this$any$iv = attributes;
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block35;
                        v1 = false;
                        break block31;
                    }
                    for (E element$iv : $this$any$iv) {
                        it = (Node)element$iv;
                        $i$a$-any-AppLinksValidDetector$checkIntentFilter$hasNonPath$1 = false;
                        if (!Intrinsics.areEqual((Object)it.getNamespaceURI(), (Object)"http://schemas.android.com/apk/res/android")) ** GOTO lbl-1000
                        var15_38 = it.getLocalName();
                        Intrinsics.checkNotNullExpressionValue((Object)var15_38, (String)"it.localName");
                        if (!StringsKt.startsWith$default((String)var15_38, (String)"path", (boolean)false, (int)2, null)) lbl-1000:
                        // 2 sources

                        {
                            v2 = true;
                        } else {
                            v2 = false;
                        }
                        if (!v2) continue;
                        v1 = true;
                        break block31;
                    }
                    v1 = hasNonPath = false;
                }
                if (!hasNonPath) ** GOTO lbl-1000
                $this$all$iv = attributes;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v3 = true;
                } else {
                    for (T element$iv : $this$all$iv) {
                        it = (Node)element$iv;
                        $i$a$-all-AppLinksValidDetector$checkIntentFilter$hasOnlyHostAndPort$1 = false;
                        if (Intrinsics.areEqual((Object)it.getNamespaceURI(), (Object)"http://schemas.android.com/apk/res/android") && (Intrinsics.areEqual((Object)it.getLocalName(), (Object)"host") || Intrinsics.areEqual((Object)it.getLocalName(), (Object)"port"))) continue;
                        v3 = false;
                        break block32;
                    }
                    v3 = true;
                }
            }
            if (v3) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = hasOnlyHostAndPort = false;
            }
            if (!hasNonPath || hasOnlyHostAndPort) {
                $this$all$iv = dataTagCount;
                dataTagCount = $this$all$iv + -1;
            } else if (length > 1) {
                block34: {
                    block33: {
                        $this$sortBy$iv = attributes;
                        $i$f$sortBy = false;
                        if ($this$sortBy$iv.size() > 1) {
                            element$iv = false;
                            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                                public final int compare(T a, T b) {
                                    boolean bl = false;
                                    Node it = (Node)a;
                                    boolean bl2 = false;
                                    Integer n = AppLinksValidDetector.access$getINTENT_FILTER_DATA_SORT_REFERENCE$cp().indexOf(it.getLocalName());
                                    boolean bl3 = false;
                                    boolean bl4 = false;
                                    int it2 = ((Number)n).intValue();
                                    boolean bl5 = false;
                                    Integer n2 = it2 >= 0 ? n : null;
                                    it = (Node)b;
                                    Comparable comparable = Integer.valueOf(n2 == null ? Integer.MAX_VALUE : n2);
                                    bl2 = false;
                                    n = AppLinksValidDetector.access$getINTENT_FILTER_DATA_SORT_REFERENCE$cp().indexOf(it.getLocalName());
                                    bl3 = false;
                                    bl4 = false;
                                    it2 = ((Number)n).intValue();
                                    bl5 = false;
                                    n2 = it2 >= 0 ? n : null;
                                    Integer n3 = n2 == null ? Integer.MAX_VALUE : n2;
                                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n3);
                                }
                            });
                        }
                        $i$f$sortBy = element.lookupNamespaceURI("http://schemas.android.com/apk/res/android");
                        namespace = $i$f$sortBy == null ? "android" : $i$f$sortBy;
                        $this$indexOfFirst$iv = attributes;
                        $i$f$indexOfFirst = false;
                        index$iv = 0;
                        for (Object item$iv : $this$indexOfFirst$iv) {
                            it = (Node)item$iv;
                            $i$a$-indexOfFirst-AppLinksValidDetector$checkIntentFilter$hostIndex$1 = false;
                            if (Intrinsics.areEqual((Object)it.getLocalName(), (Object)"host")) {
                                v5 = index$iv;
                                break block33;
                            }
                            ++index$iv;
                        }
                        v5 = -1;
                    }
                    hostIndex = v5;
                    $this$indexOfFirst$iv = attributes;
                    $i$f$indexOfFirst = false;
                    index$iv = 0;
                    for (E item$iv : $this$indexOfFirst$iv) {
                        it = (Node)item$iv /* !! */ ;
                        $i$a$-indexOfFirst-AppLinksValidDetector$checkIntentFilter$portIndex$1 = false;
                        if (Intrinsics.areEqual((Object)it.getLocalName(), (Object)"port")) {
                            v6 = index$iv;
                            break block34;
                        }
                        ++index$iv;
                    }
                    v6 = portIndex = -1;
                }
                if (hostIndex >= 0 && portIndex >= 0) {
                    host = null;
                    port = null;
                    if (hostIndex > portIndex) {
                        host = (Node)attributes.remove(hostIndex);
                        port = (Node)attributes.remove(portIndex);
                    } else {
                        port = (Node)attributes.remove(portIndex);
                        host = (Node)attributes.remove(hostIndex);
                    }
                    v7 = "<data " + namespace + ':' + host.getLocalName() + "=\"" + host.getNodeValue() + "\" " + namespace + ':' + port.getLocalName() + "=\"" + port.getNodeValue() + "\"/>\n";
                } else {
                    v7 = null;
                }
                firstLine = v7;
                location = context.getLocation(dataTag);
                item$iv = location.getStart();
                indent = CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)(item$iv == null ? 4 : (item$iv = item$iv.getColumn())))), (CharSequence)"", null, null, (int)0, null, (Function1)checkIntentFilter.indent.1.INSTANCE, (int)30, null);
                item$iv /* !! */  = firstLine;
                it = false;
                v8 /* !! */  = item$iv /* !! */ ;
                if (v8 /* !! */  == null) {
                    v8 /* !! */  = "";
                }
                item$iv /* !! */  = attributes;
                var36_70 /* !! */  = v8 /* !! */ ;
                $i$f$mapIndexed = false;
                $i$a$-indexOfFirst-AppLinksValidDetector$checkIntentFilter$portIndex$1 = $this$mapIndexed$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                $i$f$mapIndexedTo = false;
                index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    var25_59 = index$iv$iv++;
                    var26_60 = false;
                    if (var25_59 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    var27_61 = (Node)item$iv$iv;
                    var28_62 = var25_59;
                    var37_71 = destination$iv$iv;
                    $i$a$-mapIndexed-AppLinksValidDetector$checkIntentFilter$newText$1 = false;
                    var30_64 = indent;
                    var31_65 = false;
                    var32_66 = false;
                    it = var30_64;
                    $i$a$-takeIf-AppLinksValidDetector$checkIntentFilter$newText$1$lineIndent$1 = false;
                    var30_64 = (index > 0 || firstLine != null) != false ? var30_64 : null;
                    var31_65 = false;
                    v9 = var30_64;
                    if (v9 == null) {
                        v9 = "";
                    }
                    lineIndent = v9;
                    var38_72 = lineIndent + "<data " + namespace + ':' + it.getLocalName() + "=\"" + it.getNodeValue() + "\"/>";
                    var37_71.add(var38_72);
                }
                var37_71 = (List)destination$iv$iv;
                newText = Intrinsics.stringPlus(var36_70 /* !! */ , (Object)CollectionsKt.joinToString$default((Iterable)var37_71, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                var17_44 = incidents;
                var18_51 = new Incident(AppLinksValidDetector.INTENT_FILTER_UNIQUE_DATA_ATTRIBUTES, "Consider splitting data tag into multiple tags with individual attributes to avoid confusion", location, (Object)dataTag, LintFix.Companion.create().replace().with(newText).autoFix().build());
                var19_52 = false;
                var17_44.add(var18_51);
            }
            var17_44 = this;
            var18_47 = false;
            var19_52 = false;
            $this$checkIntentFilter_u24lambda_u2d8 = var17_44;
            $i$a$-run-AppLinksValidDetector$checkIntentFilter$2 = false;
        } while ((dataTag = XmlUtils.getNextTagByName((Node)dataTag, (String)"data")) != null);
        if (dataTagCount > 1) {
            $this$forEach$iv = incidents;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                p0 = (Incident)element$iv;
                $i$a$-forEach-AppLinksValidDetector$checkIntentFilter$3 = false;
                context.report(p0);
            }
        }
    }

    private final void checkActivity(XmlContext context, Element element) {
        List<UriInfo> infos = this.createUriInfos(element, context);
        Element current = XmlUtils.getFirstSubTagByName((Node)element, (String)TAG_VALIDATION);
        while (current != null) {
            if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)current.getNamespaceURI())) {
                Attr testUrlAttr = current.getAttributeNode("testUrl");
                if (testUrlAttr == null) {
                    String message2 = "Expected `testUrl` attribute";
                    Element element2 = current;
                    Node node = element2;
                    element2 = current;
                    AppLinksValidDetector.reportUrlError$default(this, context, node, context.getLocation((Node)element2), message2, null, 16, null);
                } else {
                    String testUrlString = testUrlAttr.getValue();
                    try {
                        URL testUrl = new URL(testUrlString);
                        String reason = this.testElement(testUrl, infos);
                        if (reason != null) {
                            this.reportTestUrlFailure(context, testUrlAttr, context.getValueLocation(testUrlAttr), reason);
                        }
                    }
                    catch (MalformedURLException e) {
                        String message3 = Intrinsics.stringPlus((String)"Invalid test URL: ", (Object)e.getLocalizedMessage());
                        this.reportTestUrlFailure(context, testUrlAttr, context.getValueLocation(testUrlAttr), message3);
                    }
                }
            } else {
                Element element3 = current;
                Node node = element3;
                element3 = current;
                this.reportTestUrlFailure(context, node, context.getNameLocation((Node)element3), "Validation nodes should be in the `tools:` namespace to ensure they are removed from the manifest at build time");
            }
            current = XmlUtils.getNextTagByName((Node)current, (String)TAG_VALIDATION);
        }
    }

    private final void reportUrlError(XmlContext context, Node node, Location location, String message2, LintFix quickfixData) {
        if (context.getDriver().isSuppressed(context, _OLD_ISSUE_URL, node)) {
            return;
        }
        context.report(VALIDATION, node, location, message2, quickfixData);
    }

    static /* synthetic */ void reportUrlError$default(AppLinksValidDetector appLinksValidDetector, XmlContext xmlContext, Node node, Location location, String string, LintFix lintFix, int n, Object object) {
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        appLinksValidDetector.reportUrlError(xmlContext, node, location, string, lintFix);
    }

    private final void reportTestUrlFailure(XmlContext context, Node node, Location location, String message2) {
        XmlContext.report$default((XmlContext)context, (Issue)TEST_URL, (Node)node, (Location)location, (String)message2, null, (int)16, null);
    }

    @NotNull
    public final List<UriInfo> createUriInfos(@NotNull Element activity, @Nullable XmlContext context) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Element intent = XmlUtils.getFirstSubTagByName((Node)activity, (String)"intent-filter");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList()");
        List infos = arrayList;
        while (intent != null) {
            Element element = intent;
            UriInfo uriInfo = this.checkIntent(context, element, activity);
            if (uriInfo != null) {
                infos.add(uriInfo);
            }
            intent = XmlUtils.getNextTagByName((Node)intent, (String)"intent-filter");
        }
        return infos;
    }

    @Nullable
    public final String testElement(@NotNull URL testUrl, @NotNull List<UriInfo> infos) {
        Intrinsics.checkNotNullParameter((Object)testUrl, (String)"testUrl");
        Intrinsics.checkNotNullParameter(infos, (String)"infos");
        boolean bl = false;
        List reasons = new ArrayList();
        for (UriInfo info : infos) {
            String string = info.match(testUrl);
            if (string == null) {
                return null;
            }
            String reason = string;
            if (reasons.contains(reason)) continue;
            reasons.add(reason);
        }
        Collection collection = reasons;
        boolean bl2 = false;
        return !collection.isEmpty() ? Intrinsics.stringPlus((String)"Test URL ", (Object)Joiner.on((String)" or ").join((Iterable)reasons)) : (String)null;
    }

    private final UriInfo checkIntent(XmlContext context, Element intent, Element activity) {
        List<AndroidPatternMatcher> paths2;
        List<String> ports;
        List<String> hosts;
        List<String> schemes;
        block19: {
            LintFix fix;
            boolean hasScheme;
            boolean implicitSchemes;
            boolean isHttp;
            boolean browsable;
            boolean actionView;
            block20: {
                Element firstData;
                block21: {
                    block18: {
                        block17: {
                            firstData = XmlUtils.getFirstSubTagByName((Node)intent, (String)"data");
                            actionView = this.hasActionView(intent);
                            browsable = this.isBrowsable(intent);
                            if (actionView && context != null) {
                                this.ensureExported(context, activity, intent);
                            }
                            if (firstData == null) {
                                if (actionView && browsable && context != null) {
                                    AppLinksValidDetector.reportUrlError$default(this, context, intent, context.getLocation((Node)intent), "Missing data element", null, 16, null);
                                }
                                return null;
                            }
                            schemes = null;
                            hosts = null;
                            ports = null;
                            paths2 = null;
                            boolean hasMimeType = false;
                            Element data = firstData;
                            while (data != null) {
                                Object mimeTypeValue;
                                Attr mimeType = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "mimeType");
                                if (mimeType != null) {
                                    hasMimeType = true;
                                    if (context != null) {
                                        mimeTypeValue = mimeType.getValue();
                                        Project project = context.getProject();
                                        Intrinsics.checkNotNullExpressionValue((Object)mimeTypeValue, (String)"mimeTypeValue");
                                        String resolved = Lint.resolvePlaceHolders((Project)project, (String)mimeTypeValue, null, (String)"");
                                        if (CharSequences.containsUpperCase((CharSequence)resolved)) {
                                            String message2 = "Mime-type matching is case sensitive and should only use lower-case characters";
                                            if (!CharSequences.containsUpperCase((CharSequence)Lint.resolvePlaceHolders(null, (String)mimeTypeValue, null, (String)""))) {
                                                message2 = message2 + " (without placeholders, value is `" + resolved + "`)";
                                            }
                                            AppLinksValidDetector.reportUrlError$default(this, context, mimeType, context.getValueLocation(mimeType), message2, null, 16, null);
                                        }
                                    }
                                }
                                mimeTypeValue = data;
                                schemes = this.addAttribute(context, "scheme", schemes, (Element)mimeTypeValue);
                                mimeTypeValue = data;
                                hosts = this.addAttribute(context, "host", hosts, (Element)mimeTypeValue);
                                mimeTypeValue = data;
                                ports = this.addAttribute(context, "port", ports, (Element)mimeTypeValue);
                                mimeTypeValue = data;
                                paths2 = this.addMatcher(context, "path", 0, paths2, (Element)mimeTypeValue);
                                mimeTypeValue = data;
                                paths2 = this.addMatcher(context, "pathPrefix", 1, paths2, (Element)mimeTypeValue);
                                mimeTypeValue = data;
                                paths2 = this.addMatcher(context, "pathPattern", 2, paths2, (Element)mimeTypeValue);
                                data = XmlUtils.getNextTagByName((Node)data, (String)"data");
                            }
                            if (actionView && browsable && schemes == null && !hasMimeType && context != null) {
                                AppLinksValidDetector.reportUrlError$default(this, context, firstData, context.getLocation((Node)firstData), "Missing URL for the intent filter", null, 16, null);
                            }
                            isHttp = false;
                            implicitSchemes = false;
                            if (schemes != null) break block17;
                            if (!hasMimeType) break block18;
                            schemes = Lists.newArrayList();
                            ((ArrayList)schemes).add("content");
                            ((ArrayList)schemes).add("file");
                            implicitSchemes = true;
                            break block18;
                        }
                        for (String scheme : schemes) {
                            if (!Intrinsics.areEqual((Object)"http", (Object)scheme) && !Intrinsics.areEqual((Object)"https", (Object)scheme)) continue;
                            isHttp = true;
                            break;
                        }
                    }
                    if (context == null) break block19;
                    boolean bl = hasScheme = schemes != null;
                    if (!(hasScheme || hosts == null && paths2 == null && ports == null)) {
                        fix = LintFix.Companion.create().set("http://schemas.android.com/apk/res/android", "scheme", "http").build();
                        this.reportUrlError(context, firstData, context.getLocation((Node)firstData), "At least one `scheme` must be specified", fix);
                    }
                    if (hosts != null || paths2 == null && ports == null) break block20;
                    if (!hasScheme) break block21;
                    List<String> list = schemes;
                    Intrinsics.checkNotNull(list);
                    if (!list.contains("http") && !schemes.contains("https")) break block20;
                }
                fix = LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)LintFix.Companion.create().set(), (String)"http://schemas.android.com/apk/res/android", (String)"host", null, null, (int)12, null).build();
                this.reportUrlError(context, firstData, context.getLocation((Node)firstData), "At least one `host` must be specified", fix);
            }
            if (actionView && isHttp && !browsable) {
                AppLinksValidDetector.reportUrlError$default(this, context, intent, context.getLocation((Node)intent), "Activity supporting ACTION_VIEW is not set as BROWSABLE", null, 16, null);
            }
            if (actionView && (!hasScheme || implicitSchemes)) {
                fix = LintFix.Companion.create().set("http://schemas.android.com/apk/res/android", "scheme", "http").build();
                this.reportUrlError(context, intent, context.getLocation((Node)intent), "Missing URL", fix);
            }
        }
        return new UriInfo(schemes, hosts, ports, paths2);
    }

    private final void ensureExported(XmlContext context, Element activity, Element intent) {
        Attr attr = activity.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "exported");
        if (attr == null) {
            return;
        }
        Attr exported = attr;
        if (Intrinsics.areEqual((Object)"true", (Object)exported.getValue())) {
            return;
        }
        Element prevIntent = XmlUtils.getPreviousTagByName((Node)intent, (String)"intent-filter");
        while (prevIntent != null) {
            Element element = prevIntent;
            if (this.hasActionView(element)) {
                return;
            }
            prevIntent = XmlUtils.getNextTagByName((Node)prevIntent, (String)"intent-filter");
        }
        AppLinksValidDetector.reportUrlError$default(this, context, activity, context.getLocation((Node)activity), "Activity supporting ACTION_VIEW is not exported", null, 16, null);
    }

    private final boolean hasActionView(Element intent) {
        for (Element action : XmlUtils.getSubTagsByName((Node)intent, (String)"action")) {
            Attr attr;
            if (!action.hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !Intrinsics.areEqual((Object)(attr = action.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getValue(), (Object)"android.intent.action.VIEW")) continue;
            return true;
        }
        return false;
    }

    private final boolean isBrowsable(Element intent) {
        for (Element e : XmlUtils.getSubTagsByName((Node)intent, (String)"category")) {
            Attr attr;
            if (!e.hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !Intrinsics.areEqual((Object)(attr = e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getNodeValue(), (Object)"android.intent.category.BROWSABLE")) continue;
            return true;
        }
        return false;
    }

    private final List<String> addAttribute(XmlContext context, String attributeName, List<String> existing, Element data) {
        List current;
        block9: {
            String string;
            String value;
            Attr attribute;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            current = existing;
                            attribute = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
                            if (attribute == null) break block9;
                            value = attribute.getValue();
                            if (this.requireNonEmpty(context, attribute, value)) {
                                return current;
                            }
                            string = value;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
                            if (StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null)) break block10;
                            string = value;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
                            if (!StringsKt.startsWith$default((String)string, (String)"?", (boolean)false, (int)2, null)) break block11;
                        }
                        string = value;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
                        value = this.replaceUrlWithValue(context, string);
                    }
                    if (current == null) {
                        current = Lists.newArrayListWithCapacity((int)4);
                    }
                    List list = current;
                    Intrinsics.checkNotNull(list);
                    string = value;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
                    list.add(string);
                    string = value;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
                    if (AppLinksValidDetector.Companion.isSubstituted(string)) break block12;
                    string = value;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
                    if (StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null)) break block12;
                    string = value;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
                    if (!StringsKt.startsWith$default((String)string, (String)"?", (boolean)false, (int)2, null)) break block13;
                }
                return current;
            }
            if (context != null) {
                string = value;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
                this.validateAttribute(context, attributeName, data, attribute, string);
            }
        }
        return current;
    }

    private final void validateAttribute(XmlContext context, String attributeName, Element data, Attr attribute, String value) {
        switch (attributeName) {
            case "scheme": {
                if (StringsKt.endsWith$default((String)value, (String)":", (boolean)false, (int)2, null)) {
                    AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "Don't include trailing colon in the `scheme` declaration", null, 16, null);
                    break;
                }
                if (!CharSequences.containsUpperCase((CharSequence)value)) break;
                AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "Scheme matching is case sensitive and should only use lower-case characters", null, 16, null);
                break;
            }
            case "host": {
                if (StringsKt.lastIndexOf$default((CharSequence)value, (char)'*', (int)0, (boolean)false, (int)6, null) > 0) {
                    AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "The host wildcard (`*`) can only be the first character", null, 16, null);
                    break;
                }
                if (!CharSequences.containsUpperCase((CharSequence)value)) break;
                AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "Host matching is case sensitive and should only use lower-case characters", null, 16, null);
                break;
            }
            case "port": {
                try {
                    String string = value;
                    boolean bl = false;
                    int port = Integer.parseInt(string);
                    if (port < 1 || port > 65535) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "not a valid port number", null, 16, null);
                }
                if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "host")) break;
                AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "The port must be specified in the same `<data>` element as the `host`", null, 16, null);
            }
        }
    }

    private final List<AndroidPatternMatcher> addMatcher(XmlContext context, String attributeName, int type, List<AndroidPatternMatcher> matcher, Element data) {
        List current;
        block10: {
            String value;
            Attr attribute;
            block12: {
                String string;
                block11: {
                    current = matcher;
                    attribute = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
                    if (attribute == null) break block10;
                    value = attribute.getValue();
                    if (this.requireNonEmpty(context, attribute, value)) {
                        return current;
                    }
                    if (current == null) {
                        current = Lists.newArrayListWithCapacity((int)4);
                    }
                    string = value;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
                    if (StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null)) break block11;
                    string = value;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
                    if (!StringsKt.startsWith$default((String)string, (String)"?", (boolean)false, (int)2, null)) break block12;
                }
                string = value;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
                value = this.replaceUrlWithValue(context, string);
            }
            AndroidPatternMatcher currentMatcher = new AndroidPatternMatcher(value, type);
            Object object = current;
            if (object != null) {
                object.add(currentMatcher);
            }
            if (context != null) {
                object = value;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value");
                if (!StringsKt.startsWith$default((String)object, (String)"/", (boolean)false, (int)2, null)) {
                    object = value;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value");
                    if (!AppLinksValidDetector.Companion.isSubstituted((String)object)) {
                        object = value;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value");
                        if (!StringsKt.startsWith$default((String)object, (String)"@", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)attributeName, (Object)"pathPattern")) {
                            LintFix fix = LintFix.Companion.create().replace().text(attribute.getValue()).with(Intrinsics.stringPlus((String)"/", (Object)value)).build();
                            this.reportUrlError(context, attribute, context.getValueLocation(attribute), '`' + attribute.getName() + "` attribute should start with `/`, but it is `" + value + '`', fix);
                        }
                    }
                }
            }
        }
        return current;
    }

    private final boolean requireNonEmpty(XmlContext context, Attr attribute, String value) {
        block2: {
            block3: {
                if (context == null) break block2;
                if (value == null) break block3;
                CharSequence charSequence = value;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block2;
            }
            AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getLocation((Node)attribute), '`' + attribute.getName() + "` cannot be empty", null, 16, null);
            return true;
        }
        return false;
    }

    private final String replaceUrlWithValue(XmlContext context, String str) {
        String string;
        if (context == null) {
            return str;
        }
        LintClient client = context.getClient();
        ResourceUrl url = ResourceUrl.parse((String)str);
        if (url == null || url.isFramework()) {
            return str;
        }
        Project project = context.getProject();
        ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.ALL_DEPENDENCIES);
        List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.STRING, url.name);
        if (items.isEmpty()) {
            return str;
        }
        ResourceValue resourceValue = ((ResourceItem)items.get(0)).getResourceValue();
        if (resourceValue == null) {
            return str;
        }
        ResourceValue resourceValue2 = resourceValue;
        if (resourceValue2.getValue() == null) {
            string = str;
        } else {
            String string2 = resourceValue2.getValue();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        return string;
    }

    public static final /* synthetic */ List access$getINTENT_FILTER_DATA_SORT_REFERENCE$cp() {
        return INTENT_FILTER_DATA_SORT_REFERENCE;
    }

    static {
        Object[] objectArray = Issue.Companion;
        Category category = Category.USABILITY;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        VALIDATION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"AppLinkUrlError", (String)"URL not supported by app for Firebase App Indexing", (String)"\n                Ensure the URL is supported by your app, to get installs and traffic to your app from \\\n                Google Search.", (Implementation)implementation, (String)"https://g.co/AppIndexing/AndroidStudio", (Category)category, (int)5, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
        _OLD_ISSUE_URL = Issue.Companion.create("GoogleAppIndexingUrlError", "?", "?", Category.USABILITY, 5, Severity.ERROR, IMPLEMENTATION);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        INTENT_FILTER_UNIQUE_DATA_ATTRIBUTES = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"IntentFilterUniqueDataAttributes", (String)"Data tags should only declare unique attributes", (String)"\n                `<intent-filter>` `<data>` tags should only declare a single unique attribute \\\n                (i.e. scheme OR host, but not both). This better matches the runtime behavior of \\\n                intent filters, as they combine all of the declared data attributes into a single \\\n                matcher which is allowed to handle any combination across attribute types.\n\n                For example, the following two `<intent-filter>` declarations are the same:\n                ```xml\n                <intent-filter>\n                    <data android:scheme=\"http\" android:host=\"example.com\" />\n                    <data android:scheme=\"https\" android:host=\"example.org\" />\n                </intent-filter>\n                ```\n\n                ```xml\n                <intent-filter>\n                    <data android:scheme=\"http\"/>\n                    <data android:scheme=\"https\"/>\n                    <data android:host=\"example.com\" />\n                    <data android:host=\"example.org\" />\n                </intent-filter>\n                ```\n\n                They both handle all of the following:\n                * http://example.com\n                * https://example.com\n                * http://example.org\n                * https://example.org\n\n                The second one better communicates the combining behavior and is clearer to an \\\n                external reader that one should not rely on the scheme/host being self contained. \\\n                It is not obvious in the first that http://example.org is also matched, which can \\\n                lead to confusion (or incorrect behavior) with a more complex set of schemes/hosts.\n\n                Note that this does not apply to host + port, as those must be declared in the same \\\n                `<data>` tag and are only associated with each other.\n                ", (Implementation)implementation, (String)"https://developer.android.com/guide/components/intents-filters", (Category)category, (int)0, (Severity)severity, (boolean)false, null, null, null, (int)3904, null);
        objectArray = new String[]{"scheme", "host", "port", "path", "pathPrefix", "pathPattern", "mimeType"};
        INTENT_FILTER_DATA_SORT_REFERENCE = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BE\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003H\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$UriInfo;", "", "schemes", "", "", "hosts", "ports", "paths", "Lcom/android/tools/lint/checks/AndroidPatternMatcher;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "containsUpperCase", "", "matchers", "match", "testUrl", "Ljava/net/URL;", "matchesHost", "actualHost", "hostPattern", "lint-checks"})
    public static final class UriInfo {
        @Nullable
        private final List<String> schemes;
        @Nullable
        private final List<String> hosts;
        @Nullable
        private final List<String> ports;
        @Nullable
        private final List<AndroidPatternMatcher> paths;

        public UriInfo(@Nullable List<String> schemes, @Nullable List<String> hosts, @Nullable List<String> ports, @Nullable List<? extends AndroidPatternMatcher> paths2) {
            this.schemes = schemes;
            this.hosts = hosts;
            this.ports = ports;
            this.paths = paths2;
        }

        @Nullable
        public final String match(@NotNull URL testUrl) {
            boolean $i$f$any;
            Iterable $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)testUrl, (String)"testUrl");
            if (this.schemes != null) {
                boolean schemeOk;
                block25: {
                    boolean bl;
                    $this$any$iv = this.schemes;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String scheme = (String)element$iv;
                            boolean bl2 = false;
                            if (!(Intrinsics.areEqual((Object)scheme, (Object)testUrl.getProtocol()) || Companion.isSubstituted(scheme))) continue;
                            bl = true;
                            break block25;
                        }
                        bl = schemeOk = false;
                    }
                }
                if (!schemeOk) {
                    return Intrinsics.stringPlus((String)"did not match scheme ", (Object)Joiner.on((String)", ").join((Iterable)this.schemes));
                }
            }
            if (this.hosts != null) {
                boolean hostOk;
                block26: {
                    boolean bl;
                    $this$any$iv = this.hosts;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String host = (String)element$iv;
                            boolean bl3 = false;
                            String string = testUrl.getHost();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"testUrl.host");
                            if (!(this.matchesHost(string, host) || Companion.isSubstituted(host))) continue;
                            bl = true;
                            break block26;
                        }
                        bl = hostOk = false;
                    }
                }
                if (!hostOk) {
                    return Intrinsics.stringPlus((String)"did not match host ", (Object)Joiner.on((String)", ").join((Iterable)this.hosts));
                }
            }
            boolean portOk = false;
            if (testUrl.getPort() != -1) {
                String testPort = String.valueOf(testUrl.getPort());
                if (this.ports != null) {
                    boolean bl;
                    block27: {
                        Iterable $this$any$iv2 = this.ports;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv2) {
                                String port = (String)element$iv;
                                boolean bl4 = false;
                                if (!(Intrinsics.areEqual((Object)testPort, (Object)port) || Companion.isSubstituted(port))) continue;
                                bl = true;
                                break block27;
                            }
                            bl = false;
                        }
                    }
                    portOk = bl;
                }
            } else if (this.ports == null) {
                portOk = true;
            }
            if (!portOk) {
                String portList = this.ports == null ? "none" : Joiner.on((String)", ").join((Iterable)this.ports);
                return Intrinsics.stringPlus((String)"did not match port ", (Object)portList);
            }
            if (this.paths != null) {
                boolean pathOk;
                String testPath;
                block28: {
                    boolean bl;
                    testPath = testUrl.getPath();
                    Iterable $this$any$iv3 = this.paths;
                    boolean $i$f$any3 = false;
                    if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv3) {
                            AndroidPatternMatcher it = (AndroidPatternMatcher)element$iv;
                            boolean bl5 = false;
                            String string = it.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
                            if (!(Companion.isSubstituted(string) || it.match(testPath))) continue;
                            bl = true;
                            break block28;
                        }
                        bl = pathOk = false;
                    }
                }
                if (!pathOk) {
                    StringBuilder sb = new StringBuilder();
                    this.paths.forEach(new Consumer(sb){
                        final /* synthetic */ StringBuilder $sb;
                        {
                            this.$sb = $sb;
                        }

                        public final void accept(@NotNull AndroidPatternMatcher matcher) {
                            Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
                            this.$sb.append("path ").append(matcher.toString()).append(", ");
                        }
                    });
                    if (CharSequences.endsWith((CharSequence)sb, (CharSequence)", ", (boolean)true)) {
                        sb.setLength(sb.length() - 2);
                    }
                    String message2 = Intrinsics.stringPlus((String)"did not match ", (Object)sb);
                    if (this.containsUpperCase(this.paths) || CharSequences.containsUpperCase((CharSequence)testPath)) {
                        message2 = Intrinsics.stringPlus((String)message2, (Object)" Note that matching is case sensitive.");
                    }
                    return message2;
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean containsUpperCase(List<? extends AndroidPatternMatcher> matchers) {
            AndroidPatternMatcher it;
            if (matchers == null) return false;
            Iterable $this$any$iv = matchers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (AndroidPatternMatcher)element$iv;
                boolean bl = false;
            } while (!CharSequences.containsUpperCase((CharSequence)it.getPath()));
            return true;
        }

        private final boolean matchesHost(String actualHost, String hostPattern) {
            boolean bl;
            if (!StringsKt.startsWith$default((String)hostPattern, (String)"*", (boolean)false, (int)2, null)) {
                bl = Intrinsics.areEqual((Object)actualHost, (Object)hostPattern);
            } else {
                boolean bl2;
                try {
                    CharSequence charSequence = hostPattern;
                    int n = 1;
                    boolean bl3 = false;
                    String string = charSequence;
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = string.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    Regex pattern = new Regex(Intrinsics.stringPlus((String)".*", (Object)Pattern.quote(string2)));
                    charSequence = actualHost;
                    n = 0;
                    bl2 = pattern.matches(charSequence);
                }
                catch (Throwable ignore) {
                    bl2 = false;
                }
                bl = bl2;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "INTENT_FILTER_DATA_SORT_REFERENCE", "", "", "INTENT_FILTER_UNIQUE_DATA_ATTRIBUTES", "Lcom/android/tools/lint/detector/api/Issue;", "getINTENT_FILTER_UNIQUE_DATA_ATTRIBUTES$annotations", "TAG_VALIDATION", "TEST_URL", "VALIDATION", "_OLD_ISSUE_URL", "get_OLD_ISSUE_URL$annotations", "isSubstituted", "", "expression", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void get_OLD_ISSUE_URL$annotations() {
        }

        public static /* synthetic */ void getINTENT_FILTER_UNIQUE_DATA_ATTRIBUTES$annotations() {
        }

        private final boolean isSubstituted(String expression) {
            return Lint.isDataBindingExpression((String)expression) || Lint.isManifestPlaceHolderExpression((String)expression);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

