/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/ExtraTextDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "foundText", "", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "visitDocument", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "visitNode", "node", "Lorg/w3c/dom/Node;", "Issues", "lint-checks"})
public final class ExtraTextDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Issues Issues = new Issues(null);
    private boolean foundText;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.ANIM || folderType == ResourceFolderType.ANIMATOR || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.COLOR || folderType == ResourceFolderType.NAVIGATION;
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.foundText = false;
        this.visitNode(context, document);
    }

    private final void visitNode(XmlContext context, Node node) {
        int n;
        int i;
        short nodeType = node.getNodeType();
        if (nodeType == 3 && !this.foundText) {
            String text = node.getNodeValue();
            i = 0;
            n = text.length();
            while (i < n) {
                char c = text.charAt(i);
                if (!Character.isWhitespace(c)) {
                    Position start;
                    Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                    String $this$trim$iv = text;
                    boolean $i$f$trim3 = false;
                    CharSequence $this$trim$iv$iv2 = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv2.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    String snippet = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    int maxLength = 100;
                    if (snippet.length() > maxLength) {
                        String $i$f$trim3 = snippet;
                        int $this$trim$iv$iv2 = 0;
                        $i$f$trim2 = false;
                        String string = $i$f$trim3;
                        if (string == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string2 = string.substring($this$trim$iv$iv2, maxLength);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        snippet = Intrinsics.stringPlus((String)string2, (Object)"...");
                    }
                    Location location = context.getLocation(node);
                    if (i > 0 && (start = location.getStart()) != null) {
                        int line = start.getLine();
                        int column = start.getColumn();
                        int offset = start.getOffset();
                        int n2 = 0;
                        if (n2 < i) {
                            do {
                                int j = n2++;
                                int n3 = offset;
                                offset = n3 + 1;
                                if (text.charAt(j) == '\n') {
                                    if (line != -1) {
                                        n3 = line;
                                        line = n3 + 1;
                                    }
                                    if (column == -1) continue;
                                    column = 0;
                                    continue;
                                }
                                if (column == -1) continue;
                                n3 = column;
                                column = n3 + 1;
                            } while (n2 < i);
                        }
                        start = (Position)new DefaultPosition(line, column, offset);
                        location = Location.Companion.create(context.file, start, location.getEnd());
                    }
                    XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)location, (String)("Unexpected text found in layout file: \"" + snippet + '\"'), null, (int)16, null);
                    this.foundText = true;
                    break;
                }
                int n4 = i;
                i = n4 + 1;
            }
        }
        NodeList childNodes = node.getChildNodes();
        i = 0;
        n = childNodes.getLength();
        while (i < n) {
            Node child = childNodes.item(i);
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            this.visitNode(context, child);
            int n5 = i;
            i = n5 + 1;
        }
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.MANIFEST_SCOPE};
        ISSUE = Issue.Companion.create("ExtraText", "Extraneous text in resource files", "\n            Layout resource files should only contain elements and attributes. Any XML text content found \\\n            in the file is likely accidental (and potentially dangerous if the text resembles XML and the \\\n            developer believes the text to be functional)", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(ExtraTextDetector.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, enumSetArray));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/ExtraTextDetector$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

