/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0018\u0010\u000b\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\u0018\u00010\tH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/JavaScriptInterfaceDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableMethodNames", "", "", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "visitMethodCall", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public final class JavaScriptInterfaceDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String ADD_JAVASCRIPT_INTERFACE = "addJavascriptInterface";
    @NotNull
    private static final String JAVASCRIPT_INTERFACE_CLS = "android.webkit.JavascriptInterface";
    @NotNull
    private static final String WEB_VIEW_CLS = "android.webkit.WebView";

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)ADD_JAVASCRIPT_INTERFACE);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        List arguments = node.getValueArguments();
        if (arguments.size() != 2) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.isMemberInClass((PsiMember)method, WEB_VIEW_CLS)) {
            return;
        }
        UExpression first = (UExpression)arguments.get(0);
        PsiType evaluated = TypeEvaluator.evaluate((UElement)((UElement)first));
        if (evaluated instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)evaluated).resolve();
            if (psiClass == null) {
                return;
            }
            PsiClass psiClass2 = psiClass;
            PsiClass cls = psiClass2;
            if (JavaScriptInterfaceDetector.Companion.isJavaScriptAnnotated(cls)) {
                return;
            }
            Location location = context.getNameLocation((UElement)node);
            String message2 = "None of the methods in the added interface (" + cls.getName() + ") have been annotated with `@android.webkit.JavascriptInterface`; they will not be visible in API 17";
            Incident incident = new Incident(ISSUE, (Object)node, location, message2);
            context.report(incident, Constraints.targetSdkAtLeast((int)17));
        }
    }

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UDeclaration.class);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            public void visitDeclaration(@NotNull UDeclaration node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiModifierList psiModifierList = node.getModifierList();
                if (psiModifierList == null) {
                    return;
                }
                PsiModifierList psiModifierList2 = psiModifierList;
                Object modifierList = psiModifierList2;
                if (modifierList.hasModifierProperty("public")) {
                    return;
                }
                for (UAnnotation annotation : node.getUAnnotations()) {
                    if (!Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)"android.webkit.JavascriptInterface")) continue;
                    Incident incident = new Incident(JavaScriptInterfaceDetector.ISSUE, (Object)node, this.$context.getNameLocation(node), "Must be public when using `@JavascriptInterface`");
                    this.$context.report(incident, Constraints.isAndroidProject());
                }
            }
        };
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(JavaScriptInterfaceDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"JavascriptInterface", (String)"Missing @JavascriptInterface on methods", (String)"\n                As of API 17, you must annotate methods in objects registered with the \\\n                `addJavascriptInterface` method with a `@JavascriptInterface` annotation.\n                ", (Implementation)implementation, (String)"https://developer.android.com/reference/android/webkit/WebView.html#addJavascriptInterface(java.lang.Object, java.lang.String)", (Category)category, (int)8, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/JavaScriptInterfaceDetector$Companion;", "", "()V", "ADD_JAVASCRIPT_INTERFACE", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "JAVASCRIPT_INTERFACE_CLS", "WEB_VIEW_CLS", "isJavaScriptAnnotated", "", "clz", "Lcom/intellij/psi/PsiClass;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isJavaScriptAnnotated(PsiClass clz) {
            for (PsiClass current = clz; current != null; current = current.getSuperClass()) {
                PsiMethod[] modifierList = current.getModifierList();
                PsiMethod[] psiMethodArray = modifierList;
                if ((psiMethodArray == null ? null : psiMethodArray.findAnnotation(JavaScriptInterfaceDetector.JAVASCRIPT_INTERFACE_CLS)) != null) {
                    return true;
                }
                PsiMethod[] psiMethodArray2 = current.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray2, (String)"current.methods");
                for (PsiMethod method : psiMethodArray2) {
                    if (method.getModifierList().findAnnotation(JavaScriptInterfaceDetector.JAVASCRIPT_INTERFACE_CLS) == null) continue;
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

