/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/StartDestinationDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkId", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "target", "", "getApplicableElements", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Issues", "lint-checks"})
public final class StartDestinationDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("InvalidNavigation", "No start destination specified", "\n            All `<navigation>` elements must have a start destination specified, and it must \\\n            be a direct child of that `<navigation>`.\n            ", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(StartDestinationDetector.class, Scope.RESOURCE_FILE_SCOPE));

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.NAVIGATION;
    }

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"navigation");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        String destinationAttrValue;
        Object object;
        boolean bl;
        NodeList children;
        block15: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            children = element.getChildNodes();
            Iterable $this$none$iv = (Iterable)RangesKt.until((int)0, (int)children.getLength());
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                object = $this$none$iv.iterator();
                while (object.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)object).nextInt();
                    boolean bl2 = false;
                    if (!(children.item(it) instanceof Element)) continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        Attr destinationAttr = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "startDestination");
        object = destinationAttr;
        String string = destinationAttrValue = object == null ? null : object.getValue();
        if (destinationAttrValue == null || StringsKt.isBlank((CharSequence)destinationAttrValue)) {
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getNameLocation((Node)element), (String)"No start destination specified", null, (int)16, null);
        } else {
            ResourceUrl url = ResourceUrl.parse((String)destinationAttrValue);
            if (url == null || url.type != ResourceType.ID) {
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getNameLocation((Node)element), (String)"`startDestination` must be an id", null, (int)16, null);
                return;
            }
            int n = 0;
            int n2 = children.getLength();
            if (n < n2) {
                do {
                    ResourceUrl resourceUrl;
                    int i;
                    Node node;
                    Element element2;
                    Element element3 = element2 = (node = children.item(i = n++)) instanceof Element ? (Element)node : null;
                    if (element2 == null) continue;
                    Element child = element2;
                    if (Intrinsics.areEqual((Object)child.getTagName(), (Object)"include")) {
                        String includedGraph = child.getAttributeNS("http://schemas.android.com/apk/res-auto", "graph");
                        resourceUrl = ResourceUrl.parse((String)includedGraph);
                        if (resourceUrl == null) continue;
                        ResourceUrl includedUrl = resourceUrl;
                        LintClient client = context.getClient();
                        Project project = context.getProject();
                        ResourceRepository repository2 = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
                        List items = repository2.getResources(ResourceNamespace.TODO(), includedUrl.type, includedUrl.name);
                        for (ResourceItem item : items) {
                            PathString pathString = item.getSource();
                            if (pathString == null) continue;
                            PathString source = pathString;
                            try {
                                XmlPullParser parser = client.createXmlPullParser(source);
                                if (parser == null) continue;
                                String string2 = url.name;
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url.name");
                                if (!this.checkId(parser, string2)) continue;
                                return;
                            }
                            catch (XmlPullParserException xmlPullParserException) {
                            }
                            catch (IOException iOException) {
                            }
                        }
                    } else {
                        String childId = child.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
                        resourceUrl = ResourceUrl.parse((String)childId);
                        if (resourceUrl == null) continue;
                        ResourceUrl childUrl = resourceUrl;
                        if (!Intrinsics.areEqual((Object)url.name, (Object)childUrl.name)) continue;
                        return;
                    }
                } while (n < n2);
            }
            Node node = element;
            Intrinsics.checkNotNullExpressionValue((Object)destinationAttr, (String)"destinationAttr");
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)context.getValueLocation(destinationAttr), (String)Intrinsics.stringPlus((String)"Invalid start destination ", (Object)destinationAttrValue), null, (int)16, null);
        }
    }

    private final boolean checkId(XmlPullParser parser, String target2) {
        while (true) {
            int n = parser.next();
            switch (n) {
                case 2: {
                    return Intrinsics.areEqual((Object)Lint.stripIdPrefix((String)parser.getAttributeValue("http://schemas.android.com/apk/res/android", "id")), (Object)target2);
                }
                case 1: 
                case 3: {
                    return false;
                }
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/StartDestinationDetector$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

