/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.UastImplementationDetector;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UTypeReferenceExpression;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/UastImplementationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Companion", "lint-checks"})
public final class UastImplementationDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(UastImplementationDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String UAST_PREFIX = "org.jetbrains.uast.";
    @NotNull
    private static final String UAST_JAVA_PREFIX = "org.jetbrains.uast.java.";
    @NotNull
    private static final String UAST_KT_PREFIX = "org.jetbrains.uast.kotlin.";

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UClassLiteralExpression.class, UImportStatement.class, UTypeReferenceExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            public void visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
                String string;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiType psiType = node.getType();
                String string2 = string = psiType == null ? null : psiType.getCanonicalText();
                if (string == null) {
                    return;
                }
                String string3 = string;
                String fqName = string3;
                if (com.android.tools.lint.checks.UastImplementationDetector$Companion.access$isNotAllowedUastImplementation(UastImplementationDetector.Companion, fqName)) {
                    string = node.getType();
                    string3 = string instanceof PsiClassType ? (PsiClassType)string : null;
                    this.reportUastImplementation((UElement)node, fqName, string3 == null ? null : string3.resolve());
                }
            }

            public void visitImportStatement(@NotNull UImportStatement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.checkUastImplementation((UResolvable)node);
            }

            public void visitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.checkUastImplementation(node);
            }

            private final <T extends UResolvable & UElement> void checkUastImplementation(T uElement) {
                PsiElement resolvedElement = uElement.resolve();
                if (resolvedElement instanceof PsiClass) {
                    String string = ((PsiClass)resolvedElement).getQualifiedName();
                    if (string == null) {
                        return;
                    }
                    String string2 = string;
                    String fqName = string2;
                    if (com.android.tools.lint.checks.UastImplementationDetector$Companion.access$isNotAllowedUastImplementation(UastImplementationDetector.Companion, fqName)) {
                        this.reportUastImplementation(uElement, fqName, (PsiClass)resolvedElement);
                    }
                } else if (resolvedElement instanceof PsiMember) {
                    Object object = ((PsiMember)resolvedElement).getContainingClass();
                    if (object == null) {
                        return;
                    }
                    PsiClass psiClass = object;
                    PsiClass containingClass = psiClass;
                    String string = containingClass.getQualifiedName();
                    if (string == null) {
                        return;
                    }
                    object = string;
                    Object fqName = object;
                    if (com.android.tools.lint.checks.UastImplementationDetector$Companion.access$isNotAllowedUastImplementation(UastImplementationDetector.Companion, (String)fqName)) {
                        this.reportUastImplementation(uElement, (String)fqName, containingClass);
                    }
                }
            }

            private final void checkUastImplementation(UTypeReferenceExpression node) {
                String string = node.getQualifiedName();
                if (string == null) {
                    return;
                }
                String fqName = string;
                if (com.android.tools.lint.checks.UastImplementationDetector$Companion.access$isNotAllowedUastImplementation(UastImplementationDetector.Companion, fqName)) {
                    this.reportUastImplementation((UElement)node, fqName, PsiTypesUtil.getPsiClass((PsiType)node.getType()));
                }
            }

            private final void reportUastImplementation(UElement node, String fqName, PsiClass psiClass) {
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Object it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                LinkedHashSet linkedHashSet;
                Object object = psiClass;
                if (object == null) {
                    linkedHashSet = null;
                } else {
                    PsiClass psiClass2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiClass it2 = psiClass2;
                    boolean bl3 = false;
                    linkedHashSet = InheritanceUtil.getSuperClasses((PsiClass)it2);
                }
                LinkedHashSet linkedHashSet2 = linkedHashSet;
                Set superClasses = linkedHashSet2 == null ? SetsKt.emptySet() : (Set)linkedHashSet2;
                object = superClasses;
                boolean $i$f$filter = false;
                void var8_9 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (PsiClass)element$iv$iv;
                    boolean bl = false;
                    if (!it.isInterface()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (PsiClass)element$iv$iv;
                    boolean bl = false;
                    String string = it.getQualifiedName();
                    String string2 = string == null ? "" : string;
                    String qualified = string2;
                    if (!(StringsKt.startsWith$default((String)qualified, (String)"org.jetbrains.uast.", (boolean)false, (int)2, null) && !com.android.tools.lint.checks.UastImplementationDetector$Companion.access$isNotAllowedUastImplementation(UastImplementationDetector.Companion, qualified))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (PsiClass)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getName();
                    collection.add(string);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)"UElement") && !Intrinsics.areEqual((Object)it, (Object)"UMultiResolvable"))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                boolean bl = false;
                boolean bl4 = false;
                Iterable it3 = $this$filter$iv;
                boolean bl5 = false;
                String filtered2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.toList((Iterable)new LinkedHashSet<E>((Collection)it3)), (CharSequence)", ", null, null, (int)0, null, (Function1)createUastHandler.reportUastImplementation.filtered.6.INSTANCE, (int)30, null);
                CharSequence charSequence = filtered2;
                bl4 = false;
                String message2 = fqName + " is UAST implementation. Consider using one of its corresponding UAST interfaces" + (charSequence.length() == 0 ? "." : Intrinsics.stringPlus((String)": ", (Object)filtered2));
                JavaContext.report$default((JavaContext)this.$context, (Issue)UastImplementationDetector.ISSUE, (UElement)node, (Location)this.$context.getLocation(node), (String)message2, null, (int)16, null);
            }
        };
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CUSTOM_LINT_CHECKS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        EnumSet enumSet = Platform.JDK_SET;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"UastImplementation", (String)"Avoid using UAST implementation", (String)"\n                Use UAST interface whenever possible, and do not rely on UAST implementation, \\\n                which is subject to change. If language-specific information is needed, \\\n                the next option is to use PSI directly (though these APIs are less stable and \\\n                can depend on compiler internals, especially in the case of Kotlin).\n            ", (Implementation)implementation, null, (Category)category, (int)4, (Severity)severity, (boolean)false, null, (EnumSet)enumSet, null, (int)2832, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/UastImplementationDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "UAST_JAVA_PREFIX", "", "UAST_KT_PREFIX", "UAST_PREFIX", "isAllowedUastImplementation", "", "fqName", "isNotAllowedUastImplementation", "isUastImplementation", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isUastImplementation(String fqName) {
            return StringsKt.startsWith$default((String)fqName, (String)UastImplementationDetector.UAST_JAVA_PREFIX, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fqName, (String)UastImplementationDetector.UAST_KT_PREFIX, (boolean)false, (int)2, null);
        }

        private final boolean isNotAllowedUastImplementation(String fqName) {
            return this.isUastImplementation(fqName) && !this.isAllowedUastImplementation(fqName);
        }

        private final boolean isAllowedUastImplementation(String fqName) {
            boolean bl;
            switch (fqName) {
                case "org.jetbrains.uast.java.JavaUastLanguagePlugin": 
                case "org.jetbrains.uast.kotlin.KotlinUastResolveProviderService": 
                case "org.jetbrains.uast.kotlin.AbstractKotlinUVariable": 
                case "org.jetbrains.uast.kotlin.UnknownKotlinExpression": 
                case "org.jetbrains.uast.kotlin.KotlinBinaryOperators": 
                case "org.jetbrains.uast.kotlin.KotlinPostfixOperators": 
                case "org.jetbrains.uast.kotlin.kinds.KotlinSpecialExpressionKinds": 
                case "org.jetbrains.uast.kotlin.KotlinUField": 
                case "org.jetbrains.uast.kotlin.KotlinInternalUastUtilsKt": 
                case "org.jetbrains.uast.kotlin.KotlinQualifiedExpressionAccessTypes": 
                case "org.jetbrains.uast.java.UnknownJavaExpression": 
                case "org.jetbrains.uast.kotlin.KotlinUastLanguagePlugin": 
                case "org.jetbrains.uast.kotlin.KotlinBinaryExpressionWithTypeKinds": 
                case "org.jetbrains.uast.java.JavaUDeclarationsExpression": {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        public static final /* synthetic */ boolean access$isNotAllowedUastImplementation(Companion $this, String fqName) {
            return $this.isNotAllowedUastImplementation(fqName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

