/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/checks/MissingInflatedIdDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "definesId", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "file", "Lcom/android/ide/common/util/PathString;", "targetId", "", "findLayout", "Lcom/android/resources/ResourceUrl;", "call", "Lorg/jetbrains/uast/UCallExpression;", "getApplicableMethodNames", "", "getFirstArgAsResource", "setContentView", "visitMethodCall", "", "node", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public final class MissingInflatedIdDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"findViewById", "requireViewById"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        boolean bl;
        String id;
        ResourceUrl layoutUrl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            ResourceUrl resourceUrl = this.findLayout(context, node);
            if (resourceUrl == null) {
                return;
            }
            layoutUrl = resourceUrl;
            ResourceUrl resourceUrl2 = this.getFirstArgAsResource(node, context);
            if (resourceUrl2 == null) {
                return;
            }
            ResourceUrl idUrl = resourceUrl2;
            boolean full = context.isGlobalAnalysis();
            Project project = full ? context.getMainProject() : context.getProject();
            ResourceRepository resources = context.getClient().getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
            List items = resources.getResources(ResourceNamespace.TODO(), layoutUrl.type, layoutUrl.name);
            if (items.isEmpty()) {
                return;
            }
            id = idUrl.name;
            Intrinsics.checkNotNullExpressionValue((Object)items, (String)"items");
            Iterable $this$none$iv = items;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ResourceItem it = (ResourceItem)element$iv;
                    boolean bl2 = false;
                    PathString pathString = it.getSource();
                    Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                    if (!this.definesId(context, pathString, id)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            String message2 = "" + '`' + layoutUrl + "` does not contain a declaration with id `" + id + '`';
            UExpression idArgument = (UExpression)CollectionsKt.first((List)node.getValueArguments());
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)idArgument), (Location)context.getLocation((UElement)idArgument), (String)message2, null, (int)16, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ResourceUrl findLayout(JavaContext context, UCallExpression call) {
        void $this$getParentOfType$iv;
        UExpression receiver;
        UExpression uExpression = call.getReceiver();
        Object object = receiver = uExpression == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
        if (receiver != null) {
            PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)receiver));
            UElement uElement = psiElement == null ? null : UastContextKt.toUElement((PsiElement)psiElement);
            ULocalVariable uLocalVariable = uElement instanceof ULocalVariable ? (ULocalVariable)uElement : null;
            if (uLocalVariable == null) {
                return null;
            }
            ULocalVariable variable = uLocalVariable;
            UExpression uExpression2 = variable.getUastInitializer();
            UElement uElement2 = uExpression2 == null ? null : UastLintUtilsKt.findSelector((UElement)((UElement)uExpression2));
            UCallExpression uCallExpression = uElement2 instanceof UCallExpression ? (UCallExpression)uElement2 : null;
            if (uCallExpression == null) {
                return null;
            }
            UCallExpression inflation = uCallExpression;
            if (!Intrinsics.areEqual((Object)inflation.getMethodName(), (Object)"inflate")) {
                return null;
            }
            return this.getFirstArgAsResource(inflation, context);
        }
        UElement uElement = (UElement)call;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UBlockExpression uBlockExpression = (UBlockExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UBlockExpression.class, (boolean)strict$iv);
        if (uBlockExpression == null) {
            return null;
        }
        UBlockExpression block = uBlockExpression;
        for (UExpression expression : block.getExpressions()) {
            UCallExpression setContentView;
            UExpression uExpression3 = UastUtils.skipParenthesizedExprDown((UExpression)expression);
            if ((uExpression3 instanceof UCallExpression ? (UCallExpression)uExpression3 : null) == null) continue;
            setContentView = setContentView;
            UIdentifier uIdentifier = setContentView.getMethodIdentifier();
            if (!Intrinsics.areEqual((Object)(uIdentifier == null ? null : uIdentifier.getName()), (Object)"setContentView")) continue;
            return this.getFirstArgAsResource(setContentView, context);
        }
        return null;
    }

    private final ResourceUrl getFirstArgAsResource(UCallExpression setContentView, JavaContext context) {
        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)setContentView.getValueArguments());
        Object object = uExpression == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
        if (object == null) {
            return null;
        }
        UExpression resourceArgument = object;
        ResourceUrl resourceUrl = ResourceEvaluator.getResource((JavaEvaluator)context.getEvaluator(), (UElement)((UElement)resourceArgument));
        if (resourceUrl == null) {
            return null;
        }
        ResourceUrl url = resourceUrl;
        return !url.isFramework() ? url : null;
    }

    private final boolean definesId(JavaContext context, PathString file, String targetId) {
        XmlPullParser xmlPullParser;
        if (file == null) {
            return false;
        }
        try {
            XmlPullParser xmlPullParser2 = context.getClient().createXmlPullParser(file);
            if (xmlPullParser2 == null) {
                return false;
            }
            xmlPullParser = xmlPullParser2;
        }
        catch (IOException ignore) {
            return true;
        }
        XmlPullParser parser = xmlPullParser;
        try {
            block8: while (true) {
                int event = parser.next();
                switch (event) {
                    case 2: {
                        if (Intrinsics.areEqual((Object)parser.getName(), (Object)"include")) {
                            return true;
                        }
                        String id = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "id");
                        if (id == null || !StringsKt.endsWith$default((String)id, (String)targetId, (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)Lint.stripIdPrefix((String)id), (Object)targetId)) continue block8;
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                }
            }
        }
        catch (XmlPullParserException ignore) {
            return true;
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        Implementation implementation = new Implementation(MissingInflatedIdDetector.class, EnumSet.of((Enum)Scope.ALL_RESOURCE_FILES, (Enum)Scope.ALL_JAVA_FILES), enumSetArray);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"MissingInflatedId", (String)"ID not found in inflated resource", (String)"\n                Checks calls to layout inflation and makes sure that the referenced ids \\\n                are found in the corresponding layout (or at least one of them, if the \\\n                layout has multiple configurations.)\n                ", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/MissingInflatedIdDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

