/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001eH\u0016\u00a8\u0006("}, d2={"Lcom/android/tools/lint/checks/DeprecationDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableAttributes", "", "getApplicableConstructorTypes", "getApplicableElements", "getApplicableMethodNames", "visitAttribute", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "visitClass", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "visitConstructor", "node", "Lorg/jetbrains/uast/UCallExpression;", "constructor", "Lcom/intellij/psi/PsiMethod;", "visitDocument", "document", "Lorg/w3c/dom/Document;", "visitElement", "element", "Lorg/w3c/dom/Element;", "visitMethodCall", "method", "Companion", "lint-checks"})
public final class DeprecationDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String FIREBASE_JOB_DISPATCHER_CLASS = "com.firebase.jobdispatcher.FirebaseJobDispatcher";
    @NotNull
    private static final String GCM_NETWORK_MANAGER_CLASS = "com.google.android.gms.gcm.GcmNetworkManager";
    @NotNull
    private static final String CHOOSER_TARGET_SERVICE_CLASS = "android.service.chooser.ChooserTargetService";
    @NotNull
    private static final String CHOOSER_TARGET_SERVICE_PERM = "android.permission.BIND_CHOOSER_TARGET_SERVICE";
    @NotNull
    private static final String SHARE_API_URL = "https://developer.android.com/training/sharing/receive.html?source=studio#providing-direct-share-targets";
    @NotNull
    private static final String APP_ACTIONS = "com.google.android.actions";
    @NotNull
    private static final String APP_ACTIONS_MIGRATION_URL = "https://developers.google.com/assistant/app/legacy/migration-guide";
    @NotNull
    private static final String ATTR_USER_SHARED_ID = "sharedUserId";
    @NotNull
    private static final String ATTR_SHARED_USER_MAX_SDK_VERSION = "sharedUserMaxSdkVersion";
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.XML;
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (context.getResourceFolderType() == ResourceFolderType.XML) {
            Element rootElement = document.getDocumentElement();
            String tagName = rootElement.getTagName();
            Intrinsics.checkNotNullExpressionValue((Object)tagName, (String)"tagName");
            if (StringsKt.startsWith$default((String)tagName, (String)"android.preference.", (boolean)false, (int)2, null)) {
                Node node = rootElement;
                Intrinsics.checkNotNullExpressionValue((Object)rootElement, (String)"rootElement");
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)context.getNameLocation((Node)rootElement), (String)"The `android.preference` library is deprecated, it is recommended that you migrate to the AndroidX Preference library instead.", null, (int)16, null);
                return;
            }
            if (StringsKt.startsWith$default((String)tagName, (String)"androidx.preference.", (boolean)false, (int)2, null)) {
                return;
            }
            UastParser parser = context.getClient().getUastParser(context.getProject());
            JavaEvaluator javaEvaluator = parser.getEvaluator();
            String string = rootElement.getTagName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rootElement.tagName");
            PsiClass psiClass = javaEvaluator.findClass(string);
            if (psiClass == null) {
                return;
            }
            PsiClass tagClass = psiClass;
            if (parser.getEvaluator().inheritsFrom(tagClass, "android.preference.Preference", false)) {
                Node node = rootElement;
                Intrinsics.checkNotNullExpressionValue((Object)rootElement, (String)"rootElement");
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)context.getNameLocation((Node)rootElement), (String)("`" + tagName + "` inherits from `android.preference.Preference` which is now deprecated, it is recommended that you migrate to the AndroidX Preference library."), null, (int)16, null);
            }
        }
    }

    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"AbsoluteLayout", "uses-permission-sdk-m"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Collection<String> getApplicableAttributes() {
        Object[] objectArray = new String[]{ATTR_USER_SHARED_ID, "editable", "inputMethod", "autoText", "capitalize", "name", "numeric", "phoneNumber", "password", "permission"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String tagName = element.getTagName();
        String message2 = "`" + tagName + "` is deprecated";
        if (Intrinsics.areEqual((Object)"uses-permission-sdk-m", (Object)tagName)) {
            message2 = message2 + ": Use `uses-permission-sdk-23 instead";
        }
        XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getNameLocation((Node)element), (String)message2, null, (int)16, null);
    }

    /*
     * Unable to fully structure code
     */
    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (!Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)attribute.getNamespaceURI())) {
            return;
        }
        name = attribute.getLocalName();
        fix = null;
        minSdk = 1;
        var6_6 = name;
        if (var6_6 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var6_6.hashCode()) {
            case -984013045: {
                if (var6_6.equals("sharedUserId")) {
                    tmp = 1;
                }
                break;
            }
            case 1602416228: {
                if (var6_6.equals("editable")) {
                    tmp = 2;
                }
                break;
            }
            case 3373707: {
                if (var6_6.equals("name")) {
                    tmp = 3;
                }
                break;
            }
            case -517618225: {
                if (var6_6.equals("permission")) {
                    tmp = 4;
                }
                break;
            }
            case 913392732: {
                if (var6_6.equals("singleLine")) {
                    tmp = 5;
                }
                break;
            }
        }
        switch (tmp) {
            case 1: {
                if (!attribute.getOwnerElement().hasAttributeNS("http://schemas.android.com/apk/res/android", "sharedUserMaxSdkVersion")) {
                    fix = "Consider removing `sharedUserId` for new users by adding `android:sharedUserMaxSdkVersion=\"32\"` to your manifest. See https://developer.android.com/guide/topics/manifest/manifest-element for details.";
                    addFix = this.fix().set("http://schemas.android.com/apk/res/android", "sharedUserMaxSdkVersion", "32").build();
                    context.report(DeprecationDetector.ISSUE, (Node)attribute, context.getLocation((Node)attribute), fix, addFix);
                }
                return;
            }
            case 4: {
                if (Intrinsics.areEqual((Object)"service", (Object)attribute.getOwnerElement().getTagName()) && Intrinsics.areEqual((Object)"android.permission.BIND_CHOOSER_TARGET_SERVICE", (Object)attribute.getValue())) {
                    context.report(DeprecationDetector.ISSUE, (Node)attribute, context.getLocation((Node)attribute), "ChooserTargetService` is deprecated: Please see https://developer.android.com/training/sharing/receive.html?source=studio#providing-direct-share-targets", this.fix().url("https://developer.android.com/training/sharing/receive.html?source=studio#providing-direct-share-targets").build());
                }
                return;
            }
            case 3: {
                if (Intrinsics.areEqual((Object)"meta-data", (Object)attribute.getOwnerElement().getTagName()) && Intrinsics.areEqual((Object)"com.google.android.actions", (Object)attribute.getValue())) {
                    incident = new Incident(DeprecationDetector.ISSUE, (Object)attribute, context.getLocation((Node)attribute), "App actions via actions.xml is deprecated; Please migrate to shortcuts.xml. See https://developers.google.com/assistant/app/legacy/migration-guide.", this.fix().url("https://developers.google.com/assistant/app/legacy/migration-guide").build());
                    context.report(incident, Constraints.targetSdkAtLeast((int)21));
                }
                return;
            }
            case 2: {
                fix = Intrinsics.areEqual((Object)"EditText", (Object)attribute.getOwnerElement().getTagName()) == false ? "Use an `<EditText>` to make it editable" : (Intrinsics.areEqual((Object)"true", (Object)attribute.getValue()) != false ? "`<EditText>` is already editable" : "Use `inputType` instead");
                break;
            }
            case 5: {
                fix = Intrinsics.areEqual((Object)"false", (Object)attribute.getValue()) != false ? "False is the default, so just remove the attribute" : "Use `maxLines=\"1\"` instead";
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                fix = "Use `inputType` instead";
                minSdk = 3;
            }
        }
        incident = new Incident(DeprecationDetector.ISSUE, (Object)attribute, context.getLocation((Node)attribute), "`" + attribute.getName() + "` is deprecated: " + fix);
        context.report(incident, Constraints.minSdkAtLeast((int)minSdk));
    }

    @NotNull
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object)FIREBASE_JOB_DISPATCHER_CLASS);
    }

    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        String url = "https://developer.android.com/topic/libraries/architecture/workmanager/migrating-fb";
        context.report(ISSUE, (UElement)node, context.getCallLocation(node, false, false), "Job scheduling with `FirebaseJobDispatcher` is deprecated: Use AndroidX `WorkManager` instead", this.fix().url(url).build());
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"getInstance");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!context.getEvaluator().isMemberInClass((PsiMember)method, GCM_NETWORK_MANAGER_CLASS)) {
            return;
        }
        String url = "https://developer.android.com/topic/libraries/architecture/workmanager/migrating-gcm";
        context.report(ISSUE, (UElement)node, context.getCallLocation(node, false, false), "Job scheduling with `GcmNetworkManager` is deprecated: Use AndroidX `WorkManager` instead", this.fix().url(url).build());
    }

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)CHOOSER_TARGET_SERVICE_CLASS);
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Location location = context.getNameLocation(declaration);
        context.report(ISSUE, declaration, location, "`" + declaration.getName() + "` extends the deprecated `ChooserTargetService`: Use the Share API instead", this.fix().url(SHARE_API_URL).build());
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.JAVA_FILE_SCOPE};
        ISSUE = Issue.Companion.create("Deprecated", "Using deprecated resources", "\n                Deprecated views, attributes and so on are deprecated because there \\\n                is a better way to do something. Do it that new way. You've been warned.\n                ", Category.CORRECTNESS, 2, Severity.WARNING, new Implementation(DeprecationDetector.class, EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.RESOURCE_FILE, (Enum)Scope.JAVA_FILE), enumSetArray));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/DeprecationDetector$Companion;", "", "()V", "APP_ACTIONS", "", "APP_ACTIONS_MIGRATION_URL", "ATTR_SHARED_USER_MAX_SDK_VERSION", "ATTR_USER_SHARED_ID", "CHOOSER_TARGET_SERVICE_CLASS", "CHOOSER_TARGET_SERVICE_PERM", "FIREBASE_JOB_DISPATCHER_CLASS", "getFIREBASE_JOB_DISPATCHER_CLASS$annotations", "GCM_NETWORK_MANAGER_CLASS", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "SHARE_API_URL", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getFIREBASE_JOB_DISPATCHER_CLASS$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

