/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DuplicateResourceDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create((String)"DuplicateDefinition", (String)"Duplicate definitions of resources", (String)"You can define a resource multiple times in different resource folders; that's how string translations are done, for example. However, defining the same resource more than once in the same resource folder is likely an error, for example attempting to add a new resource without realizing that the name is already used, and so on.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)new Implementation(DuplicateResourceDetector.class, Scope.ALL_RESOURCES_SCOPE, new EnumSet[]{Scope.RESOURCE_FILE_SCOPE}));
    public static final Implementation IMPLEMENTATION_XML = new Implementation(DuplicateResourceDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue TYPE_MISMATCH = Issue.create((String)"ReferenceType", (String)"Incorrect reference types", (String)"When you generate a resource alias, the resource you are pointing to must be of the same type as the alias", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION_XML);
    private static final String PRODUCT = "product";
    private Map<ResourceType, Set<String>> mTypeMap;
    private Map<ResourceType, List<Pair<String, Location.Handle>>> mLocations;
    private File mParent;

    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("name");
    }

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    public void beforeCheckFile(Context context) {
        File parent = context.file.getParentFile();
        if (!parent.equals(this.mParent)) {
            this.mParent = parent;
            this.mTypeMap = Maps.newEnumMap(ResourceType.class);
            this.mLocations = Maps.newEnumMap(ResourceType.class);
        }
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        String name;
        String tag;
        Element element = attribute.getOwnerElement();
        if (element.hasAttribute(PRODUCT)) {
            return;
        }
        String typeString = tag = element.getTagName();
        String parentTag = element.getParentNode().getNodeName();
        if (tag.equals("item") && (typeString = element.getAttribute("type")).isEmpty()) {
            if (parentTag.equals(ResourceType.STYLE.getName()) && DuplicateResourceDetector.isFirstElementChild(element)) {
                DuplicateResourceDetector.checkUniqueNames(context, (Element)element.getParentNode());
            }
            return;
        }
        ResourceType type = ResourceType.fromXmlTag((Node)element);
        if (type == null) {
            return;
        }
        if (type == ResourceType.PUBLIC) {
            return;
        }
        if (type == ResourceType.ATTR && parentTag.equals("declare-styleable")) {
            if (DuplicateResourceDetector.isFirstElementChild(element)) {
                DuplicateResourceDetector.checkUniqueNames(context, (Element)element.getParentNode());
            }
            return;
        }
        if (!parentTag.equals("resources")) {
            return;
        }
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        block0: for (int i = 0; i < childCount; ++i) {
            Node child = children.item(i);
            short nodeType = child.getNodeType();
            if (nodeType != 3 && nodeType != 4) continue;
            String text = child.getNodeValue();
            int length = text.length();
            for (int j = 0; j < length; ++j) {
                char c = text.charAt(j);
                if (c == '@') {
                    ResourceUrl url;
                    if (text.regionMatches(false, j + 1, typeString, 0, typeString.length()) || !context.isEnabled(TYPE_MISMATCH) || (url = ResourceUrl.parse((String)text.trim())) == null || url.type == type || type == ResourceType.DRAWABLE && (url.type == ResourceType.COLOR || url.type == ResourceType.MIPMAP) || type == ResourceType.MACRO || url.type == ResourceType.MACRO) break block0;
                    LintFix fix = this.fix().replace().pattern("(@.*/)").with("@" + type + "/").build();
                    String message2 = "Unexpected resource reference type; expected value of type `@" + type + "/`";
                    context.report(TYPE_MISMATCH, (Node)element, context.getLocation(child), message2, fix);
                    break block0;
                }
                if (!Character.isWhitespace(c)) break block0;
            }
            break;
        }
        Set names = this.mTypeMap.computeIfAbsent(type, k -> Sets.newHashSetWithExpectedSize((int)40));
        String originalName = name = attribute.getValue();
        if (names.contains(name = ResourcesUtil.resourceNameToFieldName((String)name))) {
            Object message3 = String.format("`%1$s` has already been defined in this folder", name);
            if (!name.equals(originalName)) {
                message3 = (String)message3 + " (`" + name + "` is equivalent to `" + originalName + "`)";
            }
            Location location = context.getLocation((Node)attribute);
            List<Pair<String, Location.Handle>> list = this.mLocations.get(type);
            for (Pair<String, Location.Handle> pair : list) {
                if (!name.equals(pair.getFirst())) continue;
                Location secondary = ((Location.Handle)pair.getSecond()).resolve();
                secondary.setMessage("Previously defined here");
                location.setSecondary(secondary);
            }
            context.report(ISSUE, (Node)attribute, location, (String)message3);
        } else {
            names.add(name);
            List list = this.mLocations.computeIfAbsent(type, k -> Lists.newArrayList());
            Location.Handle handle = context.createLocationHandle((Node)attribute);
            list.add(Pair.of((Object)name, (Object)handle));
        }
    }

    private static void checkUniqueNames(XmlContext context, Element parent) {
        List items = Lint.getChildren((Node)parent);
        if (items.size() > 1) {
            HashSet names = Sets.newHashSet();
            for (Element item : items) {
                Attr nameNode = item.getAttributeNode("name");
                if (nameNode == null) continue;
                String name = nameNode.getValue();
                if (names.contains(name) && context.isEnabled(ISSUE)) {
                    Location location = context.getLocation((Node)nameNode);
                    for (Element prevItem : items) {
                        Attr attribute = prevItem.getAttributeNode("name");
                        if (attribute == null || !name.equals(attribute.getValue())) continue;
                        assert (prevItem != item);
                        Location prev = context.getLocation((Node)prevItem);
                        prev.setMessage("Previously defined here");
                        location.setSecondary(prev);
                        break;
                    }
                    String message2 = String.format("`%1$s` has already been defined in this `<%2$s>`", name, parent.getTagName());
                    context.report(ISSUE, (Node)nameNode, location, message2);
                }
                names.add(name);
            }
        }
    }

    private static boolean isFirstElementChild(Node node) {
        for (node = node.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return false;
        }
        return true;
    }
}

