/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.android.utils.BuildScriptUtil;
import com.android.utils.DomExtensions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 52\u00020\u00012\u00020\u00022\u00020\u0003:\u00015B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\bH\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J(\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\u001bH\u0002J\f\u0010\"\u001a\u00020#*\u00020$H\u0002J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0002J\u0014\u0010(\u001a\u0004\u0018\u00010)*\b\u0012\u0004\u0012\u00020*0\u0007H\u0002J\u0018\u0010%\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0017H\u0002J\u0010\u0010%\u001a\u00020#2\u0006\u0010+\u001a\u00020)H\u0002J\u0017\u0010,\u001a\u0004\u0018\u00010#2\u0006\u0010-\u001a\u00020.H\u0002\u00a2\u0006\u0002\u0010/J \u00100\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u001b2\u0006\u00101\u001a\u0002022\u0006\u0010 \u001a\u00020!H\u0016J\b\u00103\u001a\u000204H\u0002\u00a8\u00066"}, d2={"Lcom/android/tools/lint/checks/NotificationPermissionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/ClassScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "getWarningMessage", "getApplicableCallNames", "checkCall", "Lcom/android/tools/lint/detector/api/ClassContext;", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "Lorg/objectweb/asm/tree/MethodNode;", "call", "Lorg/objectweb/asm/tree/MethodInsnNode;", "afterCheckRootProject", "Lcom/android/tools/lint/detector/api/Context;", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "checkClassReference", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "hasExoPlayerDownloader", "", "Lorg/w3c/dom/Element;", "isHoldingPostNotificationsViaAnnotations", "scope", "Lorg/jetbrains/uast/UElement;", "getPermissionRequirement", "Lcom/android/tools/lint/checks/PermissionRequirement;", "Lorg/objectweb/asm/tree/AnnotationNode;", "requirement", "isHoldingPostNotifications", "project", "Lcom/android/tools/lint/detector/api/Project;", "(Lcom/android/tools/lint/detector/api/Project;)Ljava/lang/Boolean;", "filterIncident", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "createFix", "Lcom/android/tools/lint/detector/api/LintFix;", "Issues", "lint-checks"})
public final class NotificationPermissionDetector
extends Detector
implements SourceCodeScanner,
ClassScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String KEY_SOURCE = "source";
    @NotNull
    private static final String KEY_CLASS = "class";
    @NotNull
    private static final String KEY_CLASS_NAME = "className";
    @NotNull
    public static final String POST_NOTIFICATIONS_PERMISSION = "android.permission.POST_NOTIFICATIONS";
    @NotNull
    private static final String NOTIFICATION_MANAGER = "android.app.NotificationManager";
    @NotNull
    private static final String NOTIFICATION_MANAGER_COMPAT = "androidx.core.app.NotificationManagerCompat";
    @NotNull
    private static final String ENABLED_CHECK_METHOD = "areNotificationsEnabled";
    @NotNull
    private static final String EXO_PLAYER_CLASS_NAME_PREFIX = "com/google/android/exoplayer2/";
    private static final int MIN_TARGET = 33;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"notify");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.isMemberInClass((PsiMember)method, NOTIFICATION_MANAGER) && !evaluator.isMemberInClass((PsiMember)method, NOTIFICATION_MANAGER_COMPAT)) {
            return;
        }
        if (Issues.isNotificationPermissionChecked((UElement)node)) {
            return;
        }
        if (context.isGlobalAnalysis()) {
            if (context.getMainProject().getTargetSdk() < 33 || this.isHoldingPostNotificationsViaAnnotations((UElement)node) || !Intrinsics.areEqual((Object)this.isHoldingPostNotifications(context.getMainProject()), (Object)false) || context.getMainProject().isLibrary()) {
                return;
            }
        } else {
            if (this.isHoldingPostNotificationsViaAnnotations((UElement)node)) {
                return;
            }
            LintMap map = context.getPartialResults(ISSUE).map();
            if (!map.containsKey(KEY_SOURCE)) {
                map.put(KEY_SOURCE, true);
            }
        }
        Incident incident = new Incident(ISSUE, (Object)node, context.getLocation((UElement)node), this.getWarningMessage(), this.createFix());
        if (context.isGlobalAnalysis()) {
            context.report(incident);
            if (context.getDriver().getScope().contains(Scope.JAVA_LIBRARIES)) {
                context.getPartialResults(ISSUE).map().put(KEY_SOURCE, true);
            }
        } else {
            context.report(incident, this.map());
        }
    }

    private final String getWarningMessage() {
        return "When targeting Android 13 or higher, posting a permission requires holding the `POST_NOTIFICATIONS` permission";
    }

    @NotNull
    public List<String> getApplicableCallNames() {
        return CollectionsKt.listOf((Object)"notify");
    }

    public void checkCall(@NotNull ClassContext context, @NotNull ClassNode classNode, @NotNull MethodNode method, @NotNull MethodInsnNode call) {
        block5: {
            LintMap map;
            String owner;
            block6: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                owner = classNode.name;
                Intrinsics.checkNotNull((Object)owner);
                if (StringsKt.startsWith$default((String)owner, (String)"android/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)owner, (String)"androidx/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)owner, (String)"com/google/android/gms/", (boolean)false, (int)2, null)) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)call.owner, (Object)"android/app/NotificationManager") && !Intrinsics.areEqual((Object)call.owner, (Object)"androidx/core/app/NotificationManagerCompat")) break block5;
                map = context.getPartialResults(ISSUE).map();
                if (!map.containsKey(KEY_CLASS)) break block6;
                String string = map.get(KEY_CLASS_NAME);
                boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)EXO_PLAYER_CLASS_NAME_PREFIX, (boolean)false, (int)2, null) : false;
                if (!bl) break block5;
            }
            if (this.isHoldingPostNotificationsViaAnnotations(classNode, method)) {
                return;
            }
            map.put(KEY_CLASS, context.getLocation((AbstractInsnNode)call));
            map.put(KEY_CLASS_NAME, owner);
        }
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isGlobalAnalysis() && context.getDriver().getScope().contains(Scope.JAVA_LIBRARIES) && !context.getMainProject().isLibrary()) {
            this.checkClassReference(context.getPartialResults(ISSUE).map(), context);
        }
    }

    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        boolean bl2 = bl = !context.isGlobalAnalysis();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (context.getProject() == context.getMainProject() && !context.getMainProject().isLibrary()) {
            LintMap map = partialResults.map();
            this.checkClassReference(map, context);
        }
    }

    private final void checkClassReference(LintMap map, Context context) {
        Location location;
        Element mergedManifest;
        if (context.getMainProject().getTargetSdk() < 33) {
            return;
        }
        if (Intrinsics.areEqual((Object)LintMap.getBoolean$default((LintMap)map, (String)KEY_SOURCE, null, (int)2, null), (Object)true)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)this.isHoldingPostNotifications(context.getMainProject()), (Object)false)) {
            return;
        }
        Document document = context.getMainProject().getMergedManifest();
        Element element = mergedManifest = document != null ? document.getDocumentElement() : null;
        if (mergedManifest != null && context.getDriver().isSuppressed(null, ISSUE, (Node)mergedManifest)) {
            return;
        }
        String string = map.get(KEY_CLASS_NAME);
        if (string == null) {
            return;
        }
        String owner = string;
        if (StringsKt.startsWith$default((String)owner, (String)EXO_PLAYER_CLASS_NAME_PREFIX, (boolean)false, (int)2, null) && (mergedManifest == null || !this.hasExoPlayerDownloader(mergedManifest))) {
            return;
        }
        List list = context.getMainProject().getManifestFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getManifestFiles(...)");
        File manifest = (File)CollectionsKt.firstOrNull((List)list);
        File file = context.getMainProject().getDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDir(...)");
        File gradleFile = BuildScriptUtil.findGradleBuildFile((File)file);
        File file2 = manifest;
        if (file2 != null) {
            location = Location.Companion.create(file2);
        } else if (gradleFile.isFile()) {
            location = Location.Companion.create(gradleFile);
        } else {
            location = map.getLocation(KEY_CLASS);
            if (location == null) {
                return;
            }
        }
        Location location2 = location;
        String message2 = this.getWarningMessage() + " (usage from " + ClassContext.Companion.getFqcn(owner) + ")";
        context.report(ISSUE, location2, message2, this.createFix());
    }

    private final boolean hasExoPlayerDownloader(Element $this$hasExoPlayerDownloader) {
        Element element = DomExtensions.subtag((Element)$this$hasExoPlayerDownloader, (String)"application");
        if (element == null) {
            return false;
        }
        Element application = element;
        Iterator iterator = DomExtensions.subtags((Element)application, (String)"service");
        while (iterator.hasNext()) {
            Element service = (Element)iterator.next();
            Iterator iterator2 = DomExtensions.subtags((Element)service, (String)"intent-filter");
            while (iterator2.hasNext()) {
                Element intentFilter = (Element)iterator2.next();
                Iterator iterator3 = DomExtensions.subtags((Element)intentFilter, (String)"action");
                while (iterator3.hasNext()) {
                    Element action = (Element)iterator3.next();
                    String name = action.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    if (!Intrinsics.areEqual((Object)name, (Object)"com.google.android.exoplayer.downloadService.action.RESTART")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean isHoldingPostNotificationsViaAnnotations(UElement scope) {
        for (UElement currentScope = scope; currentScope != null; currentScope = currentScope.getUastParent()) {
            if (currentScope instanceof UAnnotated) {
                List annotations = ((UAnnotated)currentScope).getUAnnotations();
                for (UAnnotation annotation : annotations) {
                    PermissionRequirement requirement;
                    String fqcn = annotation.getQualifiedName();
                    if (!AnnotationDetectorKt.PERMISSION_ANNOTATION.isEquals(fqcn)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)PermissionRequirement.create(annotation), (String)"create(...)");
                    if (!this.isHoldingPostNotificationsViaAnnotations(requirement)) continue;
                    return true;
                }
            }
            if (!(currentScope instanceof UFile)) continue;
            return false;
        }
        return false;
    }

    private final PermissionRequirement getPermissionRequirement(List<? extends AnnotationNode> $this$getPermissionRequirement) {
        for (AnnotationNode annotationNode : $this$getPermissionRequirement) {
            if (!Intrinsics.areEqual((Object)annotationNode.desc, (Object)"Landroidx/annotation/RequiresPermission;")) continue;
            return PermissionRequirement.create(annotationNode);
        }
        return null;
    }

    private final boolean isHoldingPostNotificationsViaAnnotations(ClassNode classNode, MethodNode method) {
        Object object = method.invisibleAnnotations;
        if (object == null || (object = this.getPermissionRequirement((List<? extends AnnotationNode>)object)) == null) {
            List list = classNode.invisibleAnnotations;
            object = list != null ? this.getPermissionRequirement(list) : null;
            if (object == null) {
                return false;
            }
        }
        Object requirement = object;
        return this.isHoldingPostNotificationsViaAnnotations((PermissionRequirement)requirement);
    }

    private final boolean isHoldingPostNotificationsViaAnnotations(PermissionRequirement requirement) {
        return requirement.getMissingPermissions(PermissionHolder.NONE).contains(POST_NOTIFICATIONS_PERMISSION);
    }

    private final Boolean isHoldingPostNotifications(Project project) {
        Document document = project.getMergedManifest();
        if (document == null) {
            return null;
        }
        Document mergedManifest = document;
        Node node = mergedManifest.getDocumentElement();
        if (node == null || (node = node.getFirstChild()) == null) {
            return null;
        }
        Node curr = node;
        Element element;
        String permission;
        while (curr.getNodeType() != 1 || !Intrinsics.areEqual((Object)curr.getNodeName(), (Object)"uses-permission") || !Intrinsics.areEqual((Object)(permission = (element = (Element)curr).getAttributeNS("http://schemas.android.com/apk/res/android", "name")), (Object)POST_NOTIFICATIONS_PERMISSION)) {
            if (curr.getNextSibling() != null) continue;
            return false;
        }
        return true;
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Project project = context.getMainProject();
        if (project.getTargetSdk() >= 33 && !project.isLibrary() && Intrinsics.areEqual((Object)this.isHoldingPostNotifications(project), (Object)false)) {
            map.put(KEY_SOURCE, true);
            return true;
        }
        return false;
    }

    private final LintFix createFix() {
        Object[] objectArray = new Object[]{"missing", CollectionsKt.listOf((Object)POST_NOTIFICATIONS_PERMISSION)};
        return this.fix().data(objectArray);
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(NotificationPermissionDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.JAVA_LIBRARIES), enumSetArray);
        enumSetArray = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)enumSetArray, (String)"NotificationPermission", (String)"Notifications Without Permission", (String)"\n                When targeting Android 13 and higher, posting permissions requires holding the runtime permission \\\n                `android.permission.POST_NOTIFICATIONS`.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/NotificationPermissionDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_SOURCE", "", "KEY_CLASS", "KEY_CLASS_NAME", "POST_NOTIFICATIONS_PERMISSION", "NOTIFICATION_MANAGER", "NOTIFICATION_MANAGER_COMPAT", "ENABLED_CHECK_METHOD", "EXO_PLAYER_CLASS_NAME_PREFIX", "MIN_TARGET", "", "isNotificationPermissionChecked", "", "element", "Lorg/jetbrains/uast/UElement;", "isNotificationPermissionCheck", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nNotificationPermissionDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationPermissionDetector.kt\ncom/android/tools/lint/checks/NotificationPermissionDetector$Issues\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,501:1\n1761#2,3:502\n*S KotlinDebug\n*F\n+ 1 NotificationPermissionDetector.kt\ncom/android/tools/lint/checks/NotificationPermissionDetector$Issues\n*L\n152#1:502,3\n*E\n"})
    public static final class Issues {
        private Issues() {
        }

        public final boolean isNotificationPermissionChecked(@NotNull UElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            UElement uElement = element.getUastParent();
            if (uElement == null) {
                return false;
            }
            UElement curr = uElement;
            UElement prev = element;
            while (!(curr instanceof UFile)) {
                UExpression condition;
                UExpression first;
                UExpression body;
                if (curr instanceof UIfExpression) {
                    UExpression condition2 = ((UIfExpression)curr).getCondition();
                    if (prev != condition2) {
                        boolean fromThen = Intrinsics.areEqual((Object)prev, (Object)((UIfExpression)curr).getThenExpression());
                        if (fromThen) {
                            if (this.isNotificationPermissionCheck((UElement)condition2)) {
                                return true;
                            }
                        } else {
                            UExpression op = UastUtils.skipParenthesizedExprDown((UExpression)condition2);
                            if (op instanceof UUnaryExpression && Intrinsics.areEqual((Object)((UUnaryExpression)op).getOperator(), (Object)UastPrefixOperator.LOGICAL_NOT) && this.isNotificationPermissionCheck((UElement)((UUnaryExpression)op).getOperand())) {
                                return true;
                            }
                            if (op instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)op).getOperator(), (Object)UastBinaryOperator.LOGICAL_OR)) {
                                boolean bl;
                                block16: {
                                    Iterable $this$any$iv = ((UPolyadicExpression)op).getOperands();
                                    boolean $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        bl = false;
                                    } else {
                                        for (Object element$iv : $this$any$iv) {
                                            UExpression it = (UExpression)element$iv;
                                            boolean bl2 = false;
                                            UExpression nested = UastUtils.skipParenthesizedExprDown((UExpression)it);
                                            if (!(nested instanceof UUnaryExpression && Intrinsics.areEqual((Object)((UUnaryExpression)nested).getOperator(), (Object)UastPrefixOperator.LOGICAL_NOT) && Issues.isNotificationPermissionCheck((UElement)((UUnaryExpression)nested).getOperand()))) continue;
                                            bl = true;
                                            break block16;
                                        }
                                        bl = false;
                                    }
                                }
                                if (bl) {
                                    return true;
                                }
                            }
                        }
                    }
                } else if (curr instanceof UMethod && (body = ((UMethod)curr).getUastBody()) instanceof UBlockExpression && ((UBlockExpression)body).getExpressions().size() > 1 && (first = (UExpression)((UBlockExpression)body).getExpressions().get(0)) instanceof UIfExpression && (condition = UastUtils.skipParenthesizedExprDown((UExpression)((UIfExpression)first).getCondition())) instanceof UUnaryExpression && Intrinsics.areEqual((Object)((UUnaryExpression)condition).getOperator(), (Object)UastPrefixOperator.LOGICAL_NOT) && this.isNotificationPermissionCheck((UElement)((UUnaryExpression)condition).getOperand())) {
                    UExpression then;
                    UExpression uExpression = ((UIfExpression)first).getThenExpression();
                    Object object = then = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
                    if (then != null && UastLintUtilsKt.isUnconditionalReturn((UExpression)then)) {
                        return true;
                    }
                }
                prev = curr;
                if (curr.getUastParent() == null) break;
            }
            return false;
        }

        private final boolean isNotificationPermissionCheck(UElement element) {
            if (element instanceof UUnaryExpression && Intrinsics.areEqual((Object)((UUnaryExpression)element).getOperator(), (Object)UastPrefixOperator.LOGICAL_NOT)) {
                return !this.isNotificationPermissionCheck((UElement)((UUnaryExpression)element).getOperand());
            }
            if (element instanceof UReferenceExpression || element instanceof UCallExpression) {
                UExpression initializer;
                PsiElement resolved = UastUtils.tryResolve((UElement)element);
                if (resolved instanceof PsiMethod) {
                    if (Intrinsics.areEqual((Object)((PsiMethod)resolved).getName(), (Object)NotificationPermissionDetector.ENABLED_CHECK_METHOD)) {
                        String cls;
                        PsiClass psiClass = ((PsiMethod)resolved).getContainingClass();
                        String string = cls = psiClass != null ? psiClass.getQualifiedName() : null;
                        if (Intrinsics.areEqual((Object)cls, (Object)NotificationPermissionDetector.NOTIFICATION_MANAGER) || Intrinsics.areEqual((Object)cls, (Object)NotificationPermissionDetector.NOTIFICATION_MANAGER_COMPAT)) {
                            return true;
                        }
                    }
                } else if (resolved instanceof PsiField && (initializer = UastFacade.INSTANCE.getInitializerBody((PsiVariable)resolved)) != null) {
                    return this.isNotificationPermissionCheck((UElement)initializer);
                }
            } else {
                if (element instanceof UParenthesizedExpression) {
                    return this.isNotificationPermissionCheck((UElement)((UParenthesizedExpression)element).getExpression());
                }
                if (element instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)element).getOperator(), (Object)UastBinaryOperator.LOGICAL_AND)) {
                    for (UExpression operand : ((UPolyadicExpression)element).getOperands()) {
                        if (!this.isNotificationPermissionCheck((UElement)operand)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

