/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.RemoteViewDetector;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J:\u0010\u0017\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J \u0010\u001b\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u001e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#H\u0002\u00a8\u0006%"}, d2={"Lcom/android/tools/lint/checks/RemoteViewDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableConstructorTypes", "", "", "visitConstructor", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "constructor", "Lcom/intellij/psi/PsiMethod;", "filterIncident", "", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "checkLayouts", "layoutName", "layouts", "Lcom/android/ide/common/resources/ResourceItem;", "createIncident", "message", "createErrorMessage", "sorted", "Ljava/util/SortedSet;", "isSupportedTag", "tag", "min", "", "Issues", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nRemoteViewDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteViewDetector.kt\ncom/android/tools/lint/checks/RemoteViewDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1#2:220\n*E\n"})
public final class RemoteViewDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(RemoteViewDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String KEY_LAYOUT = "layout";

    @NotNull
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object)"android.widget.RemoteViews");
    }

    /*
     * WARNING - void declaration
     */
    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        List arguments = node.getValueArguments();
        if (arguments.size() != 2) {
            return;
        }
        UExpression argument = (UExpression)arguments.get(1);
        ResourceReference resourceReference = ResourceReference.Companion.get((UElement)argument);
        if (resourceReference == null) {
            return;
        }
        ResourceReference resource = resourceReference;
        if (Intrinsics.areEqual((Object)resource.getPackage(), (Object)"android") || resource.getType() != ResourceType.LAYOUT) {
            return;
        }
        LintClient client = context.getClient();
        boolean globalAnalysis = context.isGlobalAnalysis();
        ResourceRepository resources = globalAnalysis ? client.getResources(context.getMainProject(), ResourceRepositoryScope.LOCAL_DEPENDENCIES) : client.getResources(context.getProject(), ResourceRepositoryScope.PROJECT_ONLY);
        String layout = resource.getName();
        List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.LAYOUT, layout);
        Intrinsics.checkNotNull((Object)items);
        if (!((Collection)items).isEmpty()) {
            this.checkLayouts((Context)context, layout, items, node, null);
        } else if (!globalAnalysis && !context.getDriver().isSuppressed(context, ISSUE, (UElement)node)) {
            void $this$visitConstructor_u24lambda_u240;
            LintMap lintMap;
            LintMap lintMap2 = lintMap = this.map();
            Incident incident = this.createIncident((Context)context, node, "");
            JavaContext javaContext = context;
            boolean bl = false;
            $this$visitConstructor_u24lambda_u240.put(KEY_LAYOUT, layout);
            Unit unit = Unit.INSTANCE;
            javaContext.report(incident, lintMap);
        }
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        String string = map.get(KEY_LAYOUT);
        if (string == null) {
            return false;
        }
        String layout = string;
        LintClient client = context.getClient();
        ResourceRepository resources = client.getResources(context.getProject(), ResourceRepositoryScope.LOCAL_DEPENDENCIES);
        List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.LAYOUT, layout);
        Intrinsics.checkNotNull((Object)items);
        return !((Collection)items).isEmpty() && this.checkLayouts(context, layout, items, null, incident);
    }

    private final boolean checkLayouts(Context context, String layoutName, List<? extends ResourceItem> layouts, UCallExpression node, Incident incident) {
        SortedSet sorted;
        HashSet tags = null;
        Set paths2 = SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)layouts), (Function1)checkLayouts.paths.1.INSTANCE));
        block7: for (PathString path : paths2) {
            int min = Math.max(context.getProject().getMinSdk(), RtlDetector.getFolderVersion(path.getRawPath()));
            try {
                if (context.getClient().createXmlPullParser(path) == null) continue;
                block8: while (true) {
                    XmlPullParser parser;
                    int event = parser.next();
                    switch (event) {
                        case 2: {
                            String tag;
                            if (parser.getName() == null || this.isSupportedTag(tag, min)) continue block8;
                            Set set = tags;
                            if (set == null) {
                                HashSet hashSet;
                                HashSet it = hashSet = new HashSet();
                                boolean bl = false;
                                tags = it;
                                set = hashSet;
                            }
                            set.add(tag);
                            continue block8;
                        }
                        case 1: {
                            continue block7;
                        }
                    }
                }
            }
            catch (XmlPullParserException xmlPullParserException) {
            }
            catch (IOException iOException) {
            }
        }
        Set set = tags;
        SortedSet sortedSet = sorted = set != null ? CollectionsKt.toSortedSet((Iterable)set) : null;
        if (sorted != null) {
            if (incident != null) {
                incident.setMessage(this.createErrorMessage(layoutName, sorted));
            } else if (node != null) {
                String message2 = this.createErrorMessage(layoutName, sorted);
                context.report(this.createIncident(context, node, message2));
            }
            return true;
        }
        return false;
    }

    private final Incident createIncident(Context context, UCallExpression node, String message2) {
        return new Incident(ISSUE, (Object)node, Context.getLocation$default((Context)context, (Object)node, null, (int)2, null), message2);
    }

    private final String createErrorMessage(String layoutName, SortedSet<String> sorted) {
        return "`@layout/" + layoutName + "` includes views not allowed in a `RemoteView`: " + CollectionsKt.joinToString$default((Iterable)sorted, null, null, null, (int)0, null, null, (int)63, null);
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSupportedTag(String tag, int min) {
        if (StringsKt.startsWith$default((String)tag, (String)"android.view.", (boolean)false, (int)2, null)) return this.isSupportedTag(StringsKt.substringAfterLast$default((String)tag, (char)'.', null, (int)2, null), min);
        if (StringsKt.startsWith$default((String)tag, (String)"android.widget.", (boolean)false, (int)2, null)) {
            return this.isSupportedTag(StringsKt.substringAfterLast$default((String)tag, (char)'.', null, (int)2, null), min);
        }
        String string = tag;
        switch (string.hashCode()) {
            case 1280029577: {
                if (string.equals("requestFocus")) return true;
                return false;
            }
            case 1969230692: {
                if (string.equals("RadioGroup")) break;
                return false;
            }
            case 940309185: {
                if (string.equals("TextClock")) return true;
                return false;
            }
            case 886763275: {
                if (string.equals("ViewFlipper")) return true;
                return false;
            }
            case -1822277072: {
                if (string.equals("GridLayout")) return true;
                return false;
            }
            case -937446323: {
                if (string.equals("ImageButton")) return true;
                return false;
            }
            case 1410352259: {
                if (string.equals("ListView")) return true;
                return false;
            }
            case 2001146706: {
                if (string.equals("Button")) return true;
                return false;
            }
            case 103785528: {
                if (string.equals("merge")) return true;
                return false;
            }
            case 1778827486: {
                if (string.equals("AnalogClock")) return true;
                return false;
            }
            case -938935918: {
                if (string.equals("TextView")) return true;
                return false;
            }
            case 1125864064: {
                if (string.equals("ImageView")) return true;
                return false;
            }
            case -563016403: {
                if (string.equals("StackView")) return true;
                return false;
            }
            case -1495589242: {
                if (string.equals("ProgressBar")) return true;
                return false;
            }
            case 1942574248: {
                if (string.equals("include")) return true;
                return false;
            }
            case 776382189: {
                if (string.equals("RadioButton")) break;
                return false;
            }
            case 1204826236: {
                if (string.equals("AdapterViewFlipper")) return true;
                return false;
            }
            case -170947679: {
                if (string.equals("AbsoluteLayout")) return true;
                return false;
            }
            case 1260470547: {
                if (string.equals("ViewStub")) return true;
                return false;
            }
            case -1805606060: {
                if (string.equals("Switch")) break;
                return false;
            }
            case -984371546: {
                if (string.equals("Chronometer")) return true;
                return false;
            }
            case 1601505219: {
                if (string.equals("CheckBox")) break;
                return false;
            }
            case 1310765783: {
                if (string.equals("FrameLayout")) return true;
                return false;
            }
            case -443652810: {
                if (string.equals("RelativeLayout")) return true;
                return false;
            }
            case 382765867: {
                if (string.equals("GridView")) return true;
                return false;
            }
            case 1127291599: {
                if (!string.equals("LinearLayout")) return false;
                return true;
            }
        }
        if (min < 31) return false;
        return true;
        return false;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"RemoteViewLayout", (String)"Unsupported View in RemoteView", (String)"\n            In a `RemoteView`, only some layouts and views are allowed.\n            ", (Implementation)implementation, (String)"https://developer.android.com/reference/android/widget/RemoteViews", (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/RemoteViewDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_LAYOUT", "", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

