/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.BroadcastReceiverUtils;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastLiteralUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/RegisterReceiverFlagDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "filterIncident", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApplicableMethodNames", "", "", "visitMethodCall", "", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nRegisterReceiverFlagDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegisterReceiverFlagDetector.kt\ncom/android/tools/lint/checks/RegisterReceiverFlagDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1#2:209\n*E\n"})
public final class RegisterReceiverFlagDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int RECEIVER_EXPORTED = 2;
    private static final int RECEIVER_NOT_EXPORTED = 4;
    private static final int RECEIVER_EXPORTED_FLAG_PRESENT_MASK = 6;
    @NotNull
    private static final String FLAG_EXPORTED_STR = "android.content.Context.RECEIVER_EXPORTED";
    @NotNull
    private static final String FLAG_NOT_EXPORTED_STR = "android.content.Context.RECEIVER_NOT_EXPORTED";
    private static final int VERSION_CODE_U = 34;
    @NotNull
    private static final String HAS_UNPROTECTED_KEY = "hasUnprotected";
    @NotNull
    private static final String EXPLANATION = "\n      In Android U, all receivers registering for non-system broadcasts are required \\\n      to include a flag indicating the receiver's exported state. Apps registering for non-system \\\n      broadcasts should use the `ContextCompat#registerReceiver` APIs with flags set to either \\\n      `RECEIVER_EXPORTED` or `RECEIVER_NOT_EXPORTED`.\n\n      If you are not expecting broadcasts from other apps on the device, \\\n      register your receiver with `RECEIVER_NOT_EXPORTED` to protect your receiver on all platform releases.\n      ";
    @JvmField
    @NotNull
    public static final Issue RECEIVER_EXPORTED_FLAG;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return BroadcastReceiverUtils.INSTANCE.getBROADCAST_RECEIVER_METHOD_NAMES();
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)context.getEvaluator(), (PsiMember)((PsiMember)method), (String)"android.content.Context", (boolean)false, (int)4, null)) {
            return;
        }
        UExpression uExpression = UastLintUtils.Companion.findArgument(node, "android.content.BroadcastReceiver");
        if (uExpression == null) {
            return;
        }
        UExpression receiverArg = uExpression;
        if (UastLiteralUtils.isNullLiteral((UElement)((UElement)receiverArg))) {
            return;
        }
        UExpression uExpression2 = UastLintUtils.Companion.findArgument(node, "android.content.IntentFilter");
        if (uExpression2 == null) {
            return;
        }
        UExpression filterArg = uExpression2;
        UExpression flagsArg = UastLintUtils.Companion.findArgument(node, "int");
        ConstantEvaluator evaluator = new ConstantEvaluator().allowFieldInitializers();
        Pair<Boolean, List<String>> pair = BroadcastReceiverUtils.checkIsProtectedReceiverAndReturnUnprotectedActions(filterArg, node, context.getEvaluator());
        boolean isProtected2 = (Boolean)pair.component1();
        List unprotectedActionsList2 = (List)pair.component2();
        if (!isProtected2) {
            CharSequence charSequence;
            Object object = evaluator.evaluate((UElement)flagsArg);
            Integer flags = object instanceof Integer ? (Integer)object : null;
            String actionsList = CollectionsKt.joinToString$default((Iterable)unprotectedActionsList2, (CharSequence)", ", (CharSequence)"", (CharSequence)"", (int)-1, (CharSequence)"", null, (int)32, null);
            CharSequence charSequence2 = actionsList;
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = "an IntentFilter that cannot be inspected by lint";
            } else {
                charSequence = charSequence2;
            }
            String registeredFor = (String)charSequence;
            PsiElement psiElement = receiverArg.getSourcePsi();
            String string = psiElement != null ? psiElement.getText() : null;
            if (string == null) {
                string = receiverArg.asSourceString();
            }
            String message2 = StringsKt.trimMargin$default((String)("`" + string + "` \\\n                |is missing `RECEIVER_EXPORTED` or `RECEIVER_NOT_EXPORTED` flag for unprotected \\\n                |broadcasts registered for " + registeredFor), null, (int)1, null);
            LintMap lintMap = this.map().put(HAS_UNPROTECTED_KEY, !((Collection)unprotectedActionsList2).isEmpty());
            if (flagsArg == null) {
                context.report(new Incident(RECEIVER_EXPORTED_FLAG, (Object)node, context.getLocation((UElement)node), message2, RegisterReceiverFlagDetector.Companion.buildAlternativesFix(context, filterArg, false)), lintMap);
            } else if (flags != null && (flags & 6) == 0) {
                context.report(new Incident(RECEIVER_EXPORTED_FLAG, (Object)node, context.getLocation((UElement)flagsArg), message2, RegisterReceiverFlagDetector.Companion.buildAlternativesFix(context, flagsArg, true)), lintMap);
            }
        }
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        if (context.getMainProject().getTargetSdk() < 34 || !Intrinsics.areEqual((Object)LintMap.getBoolean$default((LintMap)map, (String)HAS_UNPROTECTED_KEY, null, (int)2, null), (Object)true)) {
            incident.overrideSeverity(Severity.WARNING);
        }
        return true;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(RegisterReceiverFlagDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES));
        RECEIVER_EXPORTED_FLAG = Issue.Companion.create$default((Issue.Companion)companion, (String)"UnspecifiedRegisterReceiverFlag", (String)"Missing `registerReceiver()` exported flag", (String)EXPLANATION, (Implementation)implementation, (String)"https://developer.android.com/reference/androidx/core/content/ContextCompat#registerReceiver(android.content.Context,android.content.BroadcastReceiver,android.content.IntentFilter,int)", (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J*\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/checks/RegisterReceiverFlagDetector$Companion;", "", "()V", "EXPLANATION", "", "FLAG_EXPORTED_STR", "FLAG_NOT_EXPORTED_STR", "HAS_UNPROTECTED_KEY", "RECEIVER_EXPORTED", "", "RECEIVER_EXPORTED_FLAG", "Lcom/android/tools/lint/detector/api/Issue;", "RECEIVER_EXPORTED_FLAG_PRESENT_MASK", "RECEIVER_NOT_EXPORTED", "VERSION_CODE_U", "buildAlternativesFix", "Lcom/android/tools/lint/detector/api/LintFix;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "arg", "Lorg/jetbrains/uast/UExpression;", "isFlagsArg", "", "buildFlagFix", "exported", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final LintFix buildAlternativesFix(JavaContext context, UExpression arg, boolean isFlagsArg) {
            LintFix[] lintFixArray = new LintFix[]{com.android.tools.lint.checks.RegisterReceiverFlagDetector$Companion.buildFlagFix$default(this, context, arg, isFlagsArg, false, 8, null), this.buildFlagFix(context, arg, isFlagsArg, true)};
            return LintFix.Companion.create().alternatives(lintFixArray);
        }

        private final LintFix buildFlagFix(JavaContext context, UExpression arg, boolean isFlagsArg, boolean exported) {
            String addFlagText = exported ? RegisterReceiverFlagDetector.FLAG_EXPORTED_STR : RegisterReceiverFlagDetector.FLAG_NOT_EXPORTED_STR;
            String name = exported ? "Add RECEIVER_EXPORTED" : "Add RECEIVER_NOT_EXPORTED (preferred)";
            UFile uFile = context.getUastFile();
            boolean isKotlin = Intrinsics.areEqual((Object)(uFile != null ? uFile.getLang() : null), (Object)KotlinLanguage.INSTANCE);
            String originalArgString = arg.asSourceString();
            String fixText = !isFlagsArg ? ", " + addFlagText : (Intrinsics.areEqual((Object)originalArgString, (Object)"0") ? addFlagText : (isKotlin ? originalArgString + " or " + addFlagText : originalArgString + " | " + addFlagText));
            LintFix.ReplaceStringBuilder fix = LintFix.Companion.create().name(name).replace().reformat(true).shortenNames().range(context.getLocation((UElement)arg)).with(fixText);
            if (!isFlagsArg) {
                fix.end();
            }
            return fix.build();
        }

        static /* synthetic */ LintFix buildFlagFix$default(Companion companion, JavaContext javaContext, UExpression uExpression, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 8) != 0) {
                bl2 = false;
            }
            return companion.buildFlagFix(javaContext, uExpression, bl, bl2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

