/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.ide.common.gradle.Component;
import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.RichVersion;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.AgpVersion;
import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.MavenRepositories;
import com.android.ide.common.repository.NetworkCache;
import com.android.io.CancellableFileIo;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.BlockedDependencies;
import com.android.tools.lint.checks.GooglePlaySdkIndex;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.GradleDetectorKt;
import com.android.tools.lint.checks.Lint;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.checks.TargetSdkCheckKt;
import com.android.tools.lint.checks.TargetSdkCheckResult;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintTomlDocument;
import com.android.tools.lint.client.api.LintTomlMapValue;
import com.android.tools.lint.client.api.LintTomlValue;
import com.android.tools.lint.client.api.TomlContext;
import com.android.tools.lint.client.api.TomlScanner;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelArtifact;
import com.android.tools.lint.model.LintModelArtifactType;
import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.DomExtensions;
import com.android.utils.StringHelper;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 \u00a5\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\b\u00a4\u0001\u00a5\u0001\u00a6\u0001\u00a7\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010'\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J(\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010$\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u00100\u001a\u00020\fH\u0002J,\u00101\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u00102\u001a\u0004\u0018\u00010.2\u0006\u00103\u001a\u00020*2\b\u00104\u001a\u0004\u0018\u00010*H\u0002J\u001a\u00105\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u00102\u001a\u0004\u0018\u00010.H\u0002J$\u00106\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u00102\u001a\u0004\u0018\u00010.2\b\u00107\u001a\u0004\u0018\u00010.H\u0002J \u00108\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u00109\u001a\u00020.2\u0006\u00107\u001a\u00020.H\u0002J0\u0010:\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00172\u0006\u00102\u001a\u00020.2\u0006\u00107\u001a\u00020.H\u0002J \u0010=\u001a\u00020#2\u0006\u0010)\u001a\u00020*2\u0006\u0010$\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002JJ\u0010>\u001a\u00020#2\u0006\u0010$\u001a\u00020,2\u0006\u0010?\u001a\u00020*2\u0006\u0010@\u001a\u00020*2\u0006\u0010A\u001a\u00020*2\b\u0010B\u001a\u0004\u0018\u00010*2\u0006\u0010-\u001a\u00020.2\u0006\u00109\u001a\u00020.2\u0006\u00107\u001a\u00020.H\u0016J0\u0010C\u001a\u00020#2\u0006\u0010?\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010@\u001a\u00020*2\u0006\u0010$\u001a\u00020,2\u0006\u00109\u001a\u00020.H\u0002J \u0010D\u001a\u00020#2\u0006\u0010$\u001a\u00020,2\u0006\u00109\u001a\u00020.2\u0006\u0010@\u001a\u00020*H\u0002J0\u0010E\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u00103\u001a\u00020*2\u0006\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u00020H2\u0006\u00102\u001a\u00020.H\u0002J \u0010I\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020;2\u0006\u00102\u001a\u00020.H\u0002J(\u0010J\u001a\u00020#2\u0006\u0010$\u001a\u00020,2\u0006\u0010@\u001a\u00020*2\u0006\u00102\u001a\u00020.2\u0006\u00109\u001a\u00020.H\u0002J*\u0010K\u001a\u00020#2\u0006\u0010+\u001a\u00020*2\b\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010$\u001a\u00020,2\u0006\u00107\u001a\u00020.H\u0002J\u0010\u0010N\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010O\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016JV\u0010P\u001a\u00020#2\u0006\u0010$\u001a\u00020,2\u0006\u0010Q\u001a\u00020*2\b\u0010A\u001a\u0004\u0018\u00010*2\b\u0010B\u001a\u0004\u0018\u00010*2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020*0S2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020*0U2\u0006\u00102\u001a\u00020.H\u0016J \u0010V\u001a\u00020#2\u0006\u0010$\u001a\u00020,2\u0006\u0010G\u001a\u00020W2\u0006\u00109\u001a\u00020.H\u0002J \u0010X\u001a\u00020#2\u0006\u0010$\u001a\u00020,2\u0006\u0010@\u001a\u00020*2\u0006\u00102\u001a\u00020.H\u0002J0\u0010Y\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020;2\u0006\u0010G\u001a\u00020H2\u0006\u00102\u001a\u00020.2\u0006\u00107\u001a\u00020.H\u0002J \u0010Z\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^H\u0016J\"\u0010_\u001a\u0004\u0018\u00010H2\u0006\u0010+\u001a\u00020;2\u000e\u0010`\u001a\n\u0012\u0004\u0012\u00020H\u0018\u00010aH\u0002J\u0016\u0010b\u001a\u00020c2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020c0eH\u0002J\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00020g0U2\u0006\u00100\u001a\u00020\fH\u0002J\u0010\u0010h\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010eH\u0016J\b\u0010i\u001a\u00020\tH\u0004J\u0016\u0010j\u001a\u00020*2\f\u0010k\u001a\b\u0012\u0004\u0012\u00020l0UH\u0002J*\u0010m\u001a\u0004\u0018\u00010H2\u0006\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020;2\u000e\u0010`\u001a\n\u0012\u0004\u0012\u00020H\u0018\u00010aH\u0002J\u000e\u0010n\u001a\u00020\u00102\u0006\u0010o\u001a\u00020pJ\u0010\u0010q\u001a\u00020\u00122\u0006\u0010o\u001a\u00020pH\u0002J2\u0010r\u001a\n\u0012\u0004\u0012\u00020H\u0018\u00010a2\u0006\u0010$\u001a\u00020%2\u0006\u00103\u001a\u00020*2\u0006\u0010F\u001a\u00020*2\b\u0010s\u001a\u0004\u0018\u00010\u0012H\u0002J\"\u0010t\u001a\u0004\u0018\u00010H2\u0006\u0010u\u001a\u00020H2\u0006\u0010v\u001a\u00020W2\u0006\u0010w\u001a\u00020WH\u0002J*\u0010t\u001a\u0004\u0018\u00010H2\u0006\u0010u\u001a\u00020H2\u0006\u0010v\u001a\u00020W2\u0006\u0010w\u001a\u00020W2\u0006\u0010x\u001a\u00020WH\u0002J\"\u0010y\u001a\u00020*2\u0006\u0010+\u001a\u00020;2\u0006\u0010G\u001a\u00020*2\b\u0010z\u001a\u0004\u0018\u00010HH\u0002J\u0018\u0010{\u001a\u00020W2\u0006\u0010@\u001a\u00020*2\u0006\u00109\u001a\u00020.H\u0002J0\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020*2\u0006\u0010\u007f\u001a\u00020*2\t\b\u0002\u0010\u0080\u0001\u001a\u00020\u00172\u000b\b\u0002\u0010\u0081\u0001\u001a\u0004\u0018\u00010HH\u0002J1\u0010\u0082\u0001\u001a\n\u0012\u0004\u0012\u00020H\u0018\u00010a2\u0006\u0010$\u001a\u00020%2\u0006\u00103\u001a\u00020*2\u0006\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u00020HH\u0002J\u0013\u0010\u0083\u0001\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020*H\u0002J\u0011\u0010\u0084\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J`\u0010\u0085\u0001\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u00102\u001a\u00020.2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0007\u0010\u0088\u0001\u001a\u00020*2\u000b\b\u0002\u0010\u0089\u0001\u001a\u0004\u0018\u00010}2\t\b\u0002\u0010\u008a\u0001\u001a\u00020\u00172\f\b\u0002\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u00012\f\b\u0002\u0010\u008d\u0001\u001a\u0005\u0018\u00010\u008e\u0001H\u0002J$\u0010\u008f\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\u0007\u0010\u0088\u0001\u001a\u00020*H\u0002J\"\u0010\u008f\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u00102\u001a\u00020.2\u0007\u0010\u0088\u0001\u001a\u00020*H\u0002J-\u0010\u008f\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u00102\u001a\u00020.2\u0007\u0010\u0088\u0001\u001a\u00020*2\t\u0010\u0089\u0001\u001a\u0004\u0018\u00010}H\u0002J$\u0010\u0092\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\u0007\u0010\u0088\u0001\u001a\u00020*H\u0002J/\u0010\u0092\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u00102\u001a\u00020.2\u0007\u0010\u0088\u0001\u001a\u00020*2\u000b\b\u0002\u0010\u0093\u0001\u001a\u0004\u0018\u00010}H\u0002J#\u0010\u0094\u0001\u001a\u0004\u0018\u00010;2\u0006\u0010$\u001a\u00020,2\u0006\u0010?\u001a\u00020*2\u0006\u0010+\u001a\u00020;H\u0002J\u001b\u0010\u0095\u0001\u001a\u00020}2\u0007\u0010\u0096\u0001\u001a\u00020W2\u0007\u0010\u0097\u0001\u001a\u00020WH\u0002J\u0011\u0010\u0098\u0001\u001a\u00020\u00172\u0006\u00100\u001a\u00020\fH\u0002J\u001c\u0010\u0099\u0001\u001a\u00020#2\u0007\u0010$\u001a\u00030\u009a\u00012\b\u0010\u009b\u0001\u001a\u00030\u009c\u0001H\u0016J\u001c\u0010\u009d\u0001\u001a\u00020#2\u0007\u0010$\u001a\u00030\u009e\u00012\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001H\u0016J\r\u0010\u00a1\u0001\u001a\u00020**\u00020;H\u0002J\r\u0010\u00a2\u0001\u001a\u00020\u0017*\u00020;H\u0002J\r\u0010\u00a3\u0001\u001a\u00020\u0017*\u00020HH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a8\u0001"}, d2={"Lcom/android/tools/lint/checks/GradleDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/GradleScanner;", "Lcom/android/tools/lint/client/api/TomlScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "agpVersionCheckInfo", "Lcom/android/tools/lint/checks/GradleDetector$AgpVersionCheckInfo;", "artifactCacheHome", "Ljava/io/File;", "blockedDependencies", "Ljava/util/HashMap;", "Lcom/android/tools/lint/detector/api/Project;", "Lcom/android/tools/lint/checks/BlockedDependencies;", "Lkotlin/collections/HashMap;", "googleMavenRepository", "Lcom/android/ide/common/repository/GoogleMavenRepository;", "googlePlaySdkIndex", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex;", "gradleUserHome", "getGradleUserHome", "()Ljava/io/File;", "mAppliedJavaPlugin", "", "mAppliedKotlinAndroidPlugin", "mAppliedKotlinKaptPlugin", "mAppliedKspPlugin", "mCheckedGms", "mCheckedWearableLibs", "mDeclaredGoogleMavenRepository", "mDeclaredSourceCompatibility", "mDeclaredTargetCompatibility", "mJavaPluginInfo", "Lcom/android/tools/lint/checks/GradleDetector$JavaPluginInfo;", "afterCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "afterCheckRootProject", "beforeCheckRootProject", "checkAnnotationProcessorOnCompilePath", "configuration", "", "dependency", "Lcom/android/tools/lint/detector/api/GradleContext;", "propertyCookie", "", "checkBlockedDependencies", "project", "checkConsistentLibraries", "cookie", "groupId", "groupId2", "checkConsistentPlayServices", "checkConsistentWearableLibraries", "statementCookie", "checkCredentialDependency", "valueCookie", "checkDependency", "Lcom/android/ide/common/gradle/Dependency;", "isResolved", "checkDeprecatedConfigurations", "checkDslPropertyAssignment", "property", "value", "parent", "parentParent", "checkForBomUsageWithoutPlatform", "checkForChromeOSAbiSplits", "checkForKtxExtension", "artifactId", "version", "Lcom/android/ide/common/gradle/Version;", "checkGradlePluginDependency", "checkIntegerAsString", "checkKaptUsage", "libTomlValue", "Lcom/android/tools/lint/client/api/LintTomlValue;", "checkLibraryConsistency", "checkMergedProject", "checkMethodCall", "statement", "namedArguments", "", "unnamedArguments", "", "checkMinSdkVersion", "", "checkOctal", "checkPlayServices", "filterIncident", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "findCachedNewerVersion", "filter", "Ljava/util/function/Predicate;", "findFirst", "Lcom/android/tools/lint/model/LintModelMavenName;", "coordinates", "", "getAllLibraries", "Lcom/android/tools/lint/model/LintModelLibrary;", "getApplicableAttributes", "getArtifactCacheHome", "getBlockedDependencyMessage", "path", "Lcom/android/tools/lint/model/LintModelDependency;", "getGoogleMavenRepoVersion", "getGoogleMavenRepository", "client", "Lcom/android/tools/lint/client/api/LintClient;", "getGooglePlaySdkIndex", "getGooglePlaySdkIndexFilter", "sdkIndex", "getNewerVersion", "version1", "major", "minor", "micro", "getNewerVersionAvailableMessage", "stable", "getSdkVersion", "getUpdateDependencyFix", "Lcom/android/tools/lint/detector/api/LintFix;", "currentVersion", "suggestedVersion", "suggestedVersionIsSafe", "safeReplacement", "getUpgradeVersionFilter", "getVersionVariable", "maybeReportAgpVersionIssue", "report", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "message", "fix", "partial", "overrideSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "constraint", "Lcom/android/tools/lint/detector/api/Constraint;", "reportFatalCompatibilityIssue", "location", "Lcom/android/tools/lint/detector/api/Location;", "reportNonFatalCompatibilityIssue", "lintFix", "resolveCoordinate", "targetSdkLintFix", "current", "target", "usesLegacyHttpLibrary", "visitAttribute", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "visitTomlDocument", "Lcom/android/tools/lint/client/api/TomlContext;", "document", "Lcom/android/tools/lint/client/api/LintTomlDocument;", "id", "isGradlePlugin", "isOldApacheCommonsVersion", "AgpVersionCheckInfo", "Companion", "DeprecatedConfiguration", "JavaPluginInfo", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nGradleDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDetector.kt\ncom/android/tools/lint/checks/GradleDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,3994:1\n1#2:3995\n1747#3,3:3996\n800#3,11:4001\n800#3,11:4012\n1747#3,3:4023\n1360#3:4026\n1446#3,5:4027\n1064#4,2:3999\n*S KotlinDebug\n*F\n+ 1 GradleDetector.kt\ncom/android/tools/lint/checks/GradleDetector\n*L\n506#1:3996,3\n1632#1:4001,11\n1732#1:4012,11\n2055#1:4023,3\n3344#1:4026\n3344#1:4027,5\n708#1:3999,2\n*E\n"})
public class GradleDetector
extends Detector
implements GradleScanner,
TomlScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private File artifactCacheHome;
    private boolean mCheckedGms;
    private boolean mCheckedWearableLibs;
    private boolean mAppliedKotlinAndroidPlugin;
    private boolean mAppliedKotlinKaptPlugin;
    private boolean mAppliedKspPlugin;
    private boolean mAppliedJavaPlugin;
    @Nullable
    private JavaPluginInfo mJavaPluginInfo;
    private boolean mDeclaredSourceCompatibility;
    private boolean mDeclaredTargetCompatibility;
    private boolean mDeclaredGoogleMavenRepository;
    @Nullable
    private AgpVersionCheckInfo agpVersionCheckInfo;
    @NotNull
    private final HashMap<Project, BlockedDependencies> blockedDependencies = new HashMap();
    @Nullable
    private GoogleMavenRepository googleMavenRepository;
    @Nullable
    private GooglePlaySdkIndex googlePlaySdkIndex;
    private static int lastTargetSdkVersion;
    @Nullable
    private static File lastTargetSdkVersionFile;
    @Nullable
    private static Calendar calendar;
    @NotNull
    public static final String KEY_COORDINATE = "coordinate";
    @NotNull
    public static final String KEY_REVISION = "revision";
    @NotNull
    private static final String VC_LIBRARY_PREFIX = "libs.";
    @NotNull
    private static final String VC_PLUGIN_PREFIX = "libs.plugins.";
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @NotNull
    private static final Implementation IMPLEMENTATION_WITH_TOML;
    @NotNull
    private static final Implementation IMPLEMENTATION_WITH_MANIFEST;
    @JvmField
    @NotNull
    public static final Issue DEPENDENCY;
    @JvmField
    @NotNull
    public static final Issue CREDENTIAL_DEP;
    @JvmField
    @NotNull
    public static final Issue SWITCH_TO_TOML;
    @JvmField
    @NotNull
    public static final Issue AGP_DEPENDENCY;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED_CONFIGURATION;
    @JvmField
    @NotNull
    public static final Issue GRADLE_PLUGIN_COMPATIBILITY;
    @JvmField
    @NotNull
    public static final Issue PATH;
    @JvmField
    @NotNull
    public static final Issue IDE_SUPPORT;
    @JvmField
    @NotNull
    public static final Issue PLUS;
    @JvmField
    @NotNull
    public static final Issue GRADLE_GETTER;
    @JvmField
    @NotNull
    public static final Issue COMPATIBILITY;
    @JvmField
    @NotNull
    public static final Issue STRING_INTEGER;
    @JvmField
    @NotNull
    public static final Issue NOT_INTERPOLATED;
    @JvmField
    @NotNull
    public static final Issue REMOTE_VERSION;
    @JvmField
    @NotNull
    public static final Issue MIN_SDK_TOO_LOW;
    @JvmField
    @NotNull
    public static final Issue ACCIDENTAL_OCTAL;
    @JvmField
    @NotNull
    public static final Issue BUNDLED_GMS;
    @JvmField
    @NotNull
    public static final Issue HIGH_APP_VERSION_CODE;
    @JvmField
    @NotNull
    public static final Issue DEV_MODE_OBSOLETE;
    @JvmField
    @NotNull
    public static final Issue DUPLICATE_CLASSES;
    @Nullable
    private static Map<String, Set<String>> reservedQuickfixNames;
    @JvmField
    @NotNull
    public static final Issue EXPIRING_TARGET_SDK_VERSION;
    @JvmField
    @NotNull
    public static final Issue EXPIRED_TARGET_SDK_VERSION;
    @JvmField
    @NotNull
    public static final Issue TARGET_NEWER;
    @JvmField
    @NotNull
    public static final Issue EDITED_TARGET_SDK_VERSION;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED_LIBRARY;
    @JvmField
    @NotNull
    public static final Issue DATA_BINDING_WITHOUT_KAPT;
    @JvmField
    @NotNull
    public static final Issue LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8;
    @JvmField
    @NotNull
    public static final Issue RISKY_LIBRARY;
    @JvmField
    @NotNull
    public static final Issue ANNOTATION_PROCESSOR_ON_COMPILE_PATH;
    @JvmField
    @NotNull
    public static final Issue KTX_EXTENSION_AVAILABLE;
    @JvmField
    @NotNull
    public static final Issue KAPT_USAGE_INSTEAD_OF_KSP;
    @JvmField
    @NotNull
    public static final Issue BOM_WITHOUT_PLATFORM;
    @JvmField
    @NotNull
    public static final Issue JAVA_PLUGIN_LANGUAGE_LEVEL;
    @JvmField
    @NotNull
    public static final Issue JCENTER_REPOSITORY_OBSOLETE;
    @JvmField
    @NotNull
    public static final Issue PLAY_SDK_INDEX_NON_COMPLIANT;
    @JvmField
    @NotNull
    public static final Issue PLAY_SDK_INDEX_GENERIC_ISSUES;
    @JvmField
    @NotNull
    public static final Issue CHROMEOS_ABI_SUPPORT;
    @NotNull
    private static final List<String> JAVA_PLUGIN_IDS;
    @NotNull
    public static final String APP_PLUGIN_ID = "com.android.application";
    @NotNull
    public static final String LIB_PLUGIN_ID = "com.android.library";
    @NotNull
    public static final String OLD_APP_PLUGIN_ID = "android";
    @NotNull
    public static final String OLD_LIB_PLUGIN_ID = "android-library";
    @NotNull
    private static final Set<String> ALL_PLUGIN_IDS;
    @NotNull
    public static final String GMS_GROUP_ID = "com.google.android.gms";
    @NotNull
    public static final String FIREBASE_GROUP_ID = "com.google.firebase";
    @NotNull
    public static final String GOOGLE_SUPPORT_GROUP_ID = "com.google.android.support";
    @NotNull
    public static final String ANDROID_WEAR_GROUP_ID = "com.google.android.wearable";
    @NotNull
    private static final String WEARABLE_ARTIFACT_ID = "wearable";
    @NotNull
    private static final Component PLAY_SERVICES_V650;
    private static final int VERSION_CODE_HIGH_THRESHOLD = 2000000000;
    @NotNull
    private static final Set<String> commonAnnotationProcessors;
    @NotNull
    private static final Map<String, String> annotationProcessorsWithKspReplacements;
    @NotNull
    private static final Set<String> commonBoms;
    @NotNull
    private static Function2<? super Path, ? super LintClient, ? extends GooglePlaySdkIndex> playSdkIndexFactory;

    @NotNull
    protected File getGradleUserHome() {
        Object gradleUserHome = System.getProperty("gradle.user.home");
        if (gradleUserHome == null && (gradleUserHome = System.getenv("GRADLE_USER_HOME")) == null) {
            gradleUserHome = System.getProperty("user.home") + File.separator + ".gradle";
        }
        return new File((String)gradleUserHome);
    }

    @Nullable
    public Collection<String> getApplicableAttributes() {
        return CollectionsKt.listOf((Object)"targetSdkVersion");
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (!Intrinsics.areEqual((Object)attribute.getNamespaceURI(), (Object)"http://schemas.android.com/apk/res/android")) {
            return;
        }
        Element element = attribute.getOwnerElement();
        String target2 = attribute.getValue();
        try {
            Intrinsics.checkNotNullExpressionValue((Object)target2, (String)"target");
            int targetSdkVersion = Integer.parseInt(target2);
            Location location = context.getLocation((Node)attribute);
            Context context2 = (Context)context;
            Calendar calendar = ManifestDetector.Companion.getCalendar();
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"ManifestDetector.calenda\u2026?: Calendar.getInstance()");
            TargetSdkCheckResult tsdk = TargetSdkCheckKt.checkTargetSdk(context2, calendar, targetSdkVersion);
            if (tsdk instanceof TargetSdkCheckResult.Expired) {
                context.report(EXPIRED_TARGET_SDK_VERSION, (Node)element, location, ((TargetSdkCheckResult.Expired)tsdk).getMessage(), this.targetSdkLintFix(targetSdkVersion, ((TargetSdkCheckResult.Expired)tsdk).getRequiredVersion()));
            } else if (tsdk instanceof TargetSdkCheckResult.Expiring) {
                context.report(EXPIRING_TARGET_SDK_VERSION, (Node)element, location, ((TargetSdkCheckResult.Expiring)tsdk).getMessage(), this.targetSdkLintFix(targetSdkVersion, ((TargetSdkCheckResult.Expiring)tsdk).getRequiredVersion()));
            } else if (tsdk instanceof TargetSdkCheckResult.NotLatest) {
                if (context.isEnabled(TARGET_NEWER)) {
                    context.report(TARGET_NEWER, (Node)element, location, ((TargetSdkCheckResult.NotLatest)tsdk).getMessage(), this.targetSdkLintFix(targetSdkVersion, ((TargetSdkCheckResult.NotLatest)tsdk).getHighestVersion()));
                }
            } else if (tsdk instanceof TargetSdkCheckResult.NoIssue) {
                // empty if block
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private final LintFix targetSdkLintFix(int current, int target2) {
        LintFix lintFix;
        if (LintClient.Companion.isStudio()) {
            Object[] objectArray = new Object[]{"currentTargetSdkVersion", current};
            lintFix = this.fix().data(objectArray);
        } else {
            lintFix = this.fix().name("Update targetSdkVersion to " + target2).set("http://schemas.android.com/apk/res/android", "targetSdkVersion", String.valueOf(target2)).build();
        }
        return lintFix;
    }

    private final void checkOctal(GradleContext context, String value, Object cookie) {
        if (value.length() >= 2 && value.charAt(0) == '0' && (value.length() > 2 || Intrinsics.compare((int)value.charAt(1), (int)56) >= 0 && GradleContext.Companion.isNonNegativeInteger(value)) && context.isEnabled(ACCIDENTAL_OCTAL)) {
            Object object;
            String string;
            Object message2 = "The leading 0 turns this number into octal which is probably not what was intended";
            String string2 = message2;
            try {
                string = string2;
                Long numericValue = Long.decode(value);
                object = " (interpreted as " + numericValue + ")";
            }
            catch (NumberFormatException numberFormatException) {
                string = string2;
                object = " (and it is not a valid octal number)";
            }
            message2 = string + (String)object;
            GradleDetector.report$default(this, (Context)context, cookie, ACCIDENTAL_OCTAL, (String)message2, null, false, null, null, 240, null);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void checkDslPropertyAssignment(@NotNull GradleContext context, @NotNull String property, @NotNull String value, @NotNull String parent, @Nullable String parentParent, @NotNull Object propertyCookie, @NotNull Object valueCookie, @NotNull Object statementCookie) {
        block92: {
            block95: {
                block97: {
                    block98: {
                        block96: {
                            block94: {
                                block93: {
                                    block91: {
                                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                                        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                                        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                                        Intrinsics.checkNotNullParameter((Object)propertyCookie, (String)"propertyCookie");
                                        Intrinsics.checkNotNullParameter((Object)valueCookie, (String)"valueCookie");
                                        Intrinsics.checkNotNullParameter((Object)statementCookie, (String)"statementCookie");
                                        if (!Intrinsics.areEqual((Object)parent, (Object)"defaultConfig")) break block91;
                                        switch (property.hashCode()) {
                                            case -1312692432: {
                                                if (property.equals("minSdkVersion")) break;
                                                ** break;
                                            }
                                            case -1074060152: {
                                                if (property.equals("minSdk")) break;
                                                ** break;
                                            }
                                            case -815588119: {
                                                if (!property.equals("targetSdk")) {
                                                    ** break;
                                                }
                                                ** GOTO lbl22
                                            }
                                            case 1346695087: {
                                                if (!property.equals("targetSdkVersion")) ** break;
lbl22:
                                                // 2 sources

                                                if ((version = this.getSdkVersion(value, valueCookie)) > 0 && version < context.getClient().getHighestKnownApiLevel()) {
                                                    v0 = (Context)context;
                                                    v1 = GradleDetector.calendar;
                                                    if (v1 == null) {
                                                        v1 = Calendar.getInstance();
                                                    }
                                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"calendar ?: Calendar.getInstance()");
                                                    tsdk = TargetSdkCheckKt.checkTargetSdk(v0, v1, version);
                                                    if (tsdk instanceof TargetSdkCheckResult.Expired) {
                                                        v2 = alreadySuppressed = context.containsCommentSuppress() != false && context.isSuppressedWithComment(statementCookie, GradleDetector.EXPIRED_TARGET_SDK_VERSION) != false;
                                                        if (!alreadySuppressed) {
                                                            var12_36 = new Object[]{"currentTargetSdkVersion", version};
                                                            var13_42 = var12_36 = this.fix().data(var12_36);
                                                            var22_47 = ((TargetSdkCheckResult.Expired)tsdk).getMessage();
                                                            var21_49 = GradleDetector.EXPIRED_TARGET_SDK_VERSION;
                                                            var20_51 = statementCookie;
                                                            var19_53 = (Context)context;
                                                            var18_55 = this;
                                                            $i$a$-takeIf-GradleDetector$checkDslPropertyAssignment$1 = false;
                                                            var23_61 = LintClient.Companion.isStudio();
                                                            GradleDetector.report$default(var18_55, var19_53, var20_51, var21_49, var22_47, (LintFix)(var23_61 != false ? var12_36 : null), false, null, null, 224, null);
                                                        }
                                                    } else if (tsdk instanceof TargetSdkCheckResult.Expiring) {
                                                        alreadySuppressed = new Object[]{"currentTargetSdkVersion", version};
                                                        var12_37 = alreadySuppressed = this.fix().data(alreadySuppressed);
                                                        var22_48 = ((TargetSdkCheckResult.Expiring)tsdk).getMessage();
                                                        var21_50 = GradleDetector.EXPIRING_TARGET_SDK_VERSION;
                                                        var20_52 = statementCookie;
                                                        var19_54 = (Context)context;
                                                        var18_56 = this;
                                                        $i$a$-takeIf-GradleDetector$checkDslPropertyAssignment$2 = false;
                                                        var23_62 = LintClient.Companion.isStudio();
                                                        GradleDetector.report$default(var18_56, var19_54, var20_52, var21_50, var22_48, (LintFix)(var23_62 != false ? alreadySuppressed : null), false, null, null, 224, null);
                                                    } else if (tsdk instanceof TargetSdkCheckResult.NotLatest) {
                                                        highest = ((TargetSdkCheckResult.NotLatest)tsdk).getHighestVersion();
                                                        label = "Update targetSdkVersion to " + highest;
                                                        if (LintClient.Companion.isStudio()) {
                                                            $i$a$-takeIf-GradleDetector$checkDslPropertyAssignment$1 = new Object[]{"currentTargetSdkVersion", version};
                                                            v3 = this.fix().data($i$a$-takeIf-GradleDetector$checkDslPropertyAssignment$1);
                                                        } else {
                                                            v3 = this.fix().name(label).replace().text(value).with(String.valueOf(highest)).build();
                                                        }
                                                        fix = v3;
                                                        GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.TARGET_NEWER, ((TargetSdkCheckResult.NotLatest)tsdk).getMessage(), fix, false, null, null, 224, null);
                                                    } else if (tsdk instanceof TargetSdkCheckResult.NoIssue) {
                                                        // empty if block
                                                    }
                                                }
                                                if (version > 0) {
                                                    if (!LintClient.Companion.isStudio()) ** break;
                                                    if (GradleDetector.lastTargetSdkVersion == -1 || !Intrinsics.areEqual((Object)GradleDetector.lastTargetSdkVersionFile, (Object)context.file)) {
                                                        GradleDetector.lastTargetSdkVersion = version;
                                                        GradleDetector.lastTargetSdkVersionFile = context.file;
                                                        ** break;
                                                    }
                                                    if (version <= GradleDetector.lastTargetSdkVersion) ** break;
                                                    message = "It looks like you just edited the `targetSdkVersion` from " + GradleDetector.lastTargetSdkVersion + " to " + version + " in the editor. Be sure to consult the documentation on the behaviors that change as result of this. The Android SDK Upgrade Assistant can help with safely migrating.";
                                                    highest = new Object[]{"currentTargetSdkVersion", version};
                                                    GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.EDITED_TARGET_SDK_VERSION, (String)message, this.fix().data(highest), false, null, null, 224, null);
                                                    ** break;
                                                }
                                                this.checkIntegerAsString(context, value, statementCookie, valueCookie);
                                                ** break;
                                            }
                                        }
                                        if ((version = this.getSdkVersion(value, valueCookie)) > 0) {
                                            this.checkMinSdkVersion(context, version, statementCookie);
                                            ** break;
                                        }
                                        this.checkIntegerAsString(context, value, statementCookie, valueCookie);
lbl91:
                                        // 12 sources

                                        if (StringsKt.startsWith$default((String)value, (String)"0", (boolean)false, (int)2, null)) {
                                            this.checkOctal(context, value, valueCookie);
                                        }
                                        if (Intrinsics.areEqual((Object)property, (Object)"versionName") || Intrinsics.areEqual((Object)property, (Object)"versionCode") && !GradleContext.Companion.isNonNegativeInteger(value) || !GradleContext.Companion.isStringLiteral(value)) {
                                            if (Intrinsics.areEqual((Object)value, (Object)"getVersionCode") || Intrinsics.areEqual((Object)value, (Object)"getVersionName")) {
                                                message = "Bad method name: pick a unique method name which does not conflict with the implicit getters for the defaultConfig properties. For example, try using the prefix compute- instead of get-.";
                                                GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.GRADLE_GETTER, message, null, false, null, null, 240, null);
                                            }
                                        } else if (Intrinsics.areEqual((Object)property, (Object)"packageName")) {
                                            message = "Deprecated: Replace 'packageName' with 'applicationId'";
                                            fix = this.fix().name("Replace 'packageName' with 'applicationId'", true).replace().text("packageName").with("applicationId").autoFix().build();
                                            GradleDetector.report$default(this, (Context)context, propertyCookie, GradleDetector.DEPRECATED, message, fix, false, null, null, 224, null);
                                        }
                                        if (Intrinsics.areEqual((Object)property, (Object)"versionCode") && context.isEnabled(GradleDetector.HIGH_APP_VERSION_CODE) && GradleContext.Companion.isNonNegativeInteger(value) && (version = GradleContext.Companion.getIntLiteralValue(value, -1)) >= 2000000000) {
                                            message = "The 'versionCode' is very high and close to the max allowed value";
                                            GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.HIGH_APP_VERSION_CODE, (String)message, null, false, null, null, 240, null);
                                        }
                                        break block92;
                                    }
                                    if (!Intrinsics.areEqual((Object)property, (Object)"compileSdkVersion") && !Intrinsics.areEqual((Object)property, (Object)"compileSdk") || !Intrinsics.areEqual((Object)parent, (Object)"android")) break block93;
                                    version = -1;
                                    if (GradleContext.Companion.isStringLiteral(value)) {
                                        hash = GradleContext.Companion.getStringLiteralValue(value, valueCookie);
                                        if (hash != null && !com.android.tools.lint.detector.api.Lint.isNumberString((String)hash)) {
                                            if (Intrinsics.areEqual((Object)property, (Object)"compileSdk")) {
                                                message = "`compileSdk` does not support strings; did you mean `compileSdkPreview` ?";
                                                fix = this.fix().replace().text("compileSdk").with("compileSdkPreview").build();
                                                GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.STRING_INTEGER, message, fix, false, null, null, 224, null);
                                            }
                                            if ((platformVersion = AndroidTargetHash.getPlatformVersion((String)hash)) != null) {
                                                version = platformVersion.getFeatureLevel();
                                            }
                                        }
                                    } else {
                                        version = GradleContext.Companion.getIntLiteralValue(value, -1);
                                    }
                                    if (version <= 0) {
                                        this.checkIntegerAsString(context, value, statementCookie, valueCookie);
                                    } else if (version < 34) {
                                        message = "A newer version of `compileSdkVersion` than " + version + " is available: 34";
                                        fix = this.fix().name("Set compileSdkVersion to 34").replace().text(String.valueOf(version)).with("34").build();
                                        GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.DEPENDENCY, message, fix, false, null, null, 224, null);
                                    }
                                    break block92;
                                }
                                if (!Intrinsics.areEqual((Object)parent, (Object)"plugins")) break block94;
                                message = property;
                                message = plugin = Intrinsics.areEqual((Object)message, (Object)"id") ? GradleContext.Companion.getStringLiteralValue(value, valueCookie) : (Intrinsics.areEqual((Object)message, (Object)"alias") ? ((v4 = com.android.tools.lint.checks.GradleDetector$Companion.access$getPluginFromVersionCatalog(GradleDetector.Companion, value, context)) != null && (v4 = v4.getCoordinates()) != null ? StringsKt.substringBefore$default((String)v4, (char)':', null, (int)2, null) : null) : null);
                                if (message != null) {
                                    if (Intrinsics.areEqual((Object)message, (Object)"kotlin-android") != false ? true : Intrinsics.areEqual((Object)message, (Object)"org.jetbrains.kotlin.android")) {
                                        this.mAppliedKotlinAndroidPlugin = true;
                                    } else if (Intrinsics.areEqual((Object)message, (Object)"kotlin-kapt") != false ? true : Intrinsics.areEqual((Object)message, (Object)"org.jetbrains.kotlin.kapt")) {
                                        this.mAppliedKotlinKaptPlugin = true;
                                    } else if (Intrinsics.areEqual((Object)message, (Object)"com.google.devtools.ksp")) {
                                        this.mAppliedKspPlugin = true;
                                    } else if (GradleDetector.JAVA_PLUGIN_IDS.contains(message)) {
                                        this.mAppliedJavaPlugin = true;
                                        this.mJavaPluginInfo = new JavaPluginInfo(statementCookie);
                                    } else if (Intrinsics.areEqual((Object)message, (Object)"android") != false ? true : Intrinsics.areEqual((Object)message, (Object)"android-library")) {
                                        isOldAppPlugin = Intrinsics.areEqual((Object)"android", (Object)plugin);
                                        replaceWith = isOldAppPlugin != false ? "com.android.application" : "com.android.library";
                                        message = "'" + plugin + "' is deprecated; use '" + replaceWith + "' instead";
                                        fix = this.fix().sharedName("Replace plugin").replace().text(plugin).with(replaceWith).autoFix().build();
                                        GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.DEPRECATED, message, fix, false, null, null, 224, null);
                                    }
                                }
                                break block92;
                            }
                            if (!Intrinsics.areEqual((Object)parent, (Object)"dependencies")) break block95;
                            if (!StringsKt.startsWith$default((String)value, (String)"files", (boolean)false, (int)2, null) || !new Regex("^files\\(['\"].*[\"']\\)$").matches(plugin = (CharSequence)value)) break block96;
                            v5 = value.substring(7, value.length() - 2);
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"substring(...)");
                            path = v5;
                            if (StringsKt.contains$default((CharSequence)path, (CharSequence)"\\\\", (boolean)false, (int)2, null)) {
                                fix = this.fix().replace().text(path).with(StringsKt.replace$default((String)path, (String)"\\\\", (String)"/", (boolean)false, (int)4, null)).build();
                                message = "Do not use Windows file separators in .gradle files; use / instead";
                                GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.PATH, message, fix, false, null, null, 224, null);
                            } else if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) || new File(StringsKt.replace$default((String)path, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null)).isAbsolute()) {
                                message = "Avoid using absolute paths in .gradle files";
                                GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.PATH, message, null, false, null, null, 240, null);
                            }
                            break block92;
                        }
                        dependencyString = GradleContext.Companion.getStringLiteralValue(value, valueCookie);
                        if (dependencyString == null) {
                            block90: {
                                message = new String[]{"platform", "testFixtures", "enforcedPlatform"};
                                $this$any$iv = CollectionsKt.listOf((Object[])message);
                                $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    v6 = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        it = (Object[])element$iv;
                                        $i$a$-any-GradleDetector$checkDslPropertyAssignment$3 = false;
                                        if (!StringsKt.startsWith$default((String)value, (String)((String)it + "("), (boolean)false, (int)2, null)) continue;
                                        v6 = true;
                                        break block90;
                                    }
                                    v6 = false;
                                }
                            }
                            if (v6 && StringsKt.endsWith$default((String)value, (String)")", (boolean)false, (int)2, null)) {
                                v7 = value.substring(StringsKt.indexOf$default((CharSequence)value, (char)'(', (int)0, (boolean)false, (int)6, null) + 1, value.length() - 1);
                                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"substring(...)");
                                argumentString = v7;
                                v8 = dependencyString = valueCookie instanceof UCallExpression != false && ((UCallExpression)valueCookie).getValueArguments().size() == 1 ? GradleContext.Companion.getStringLiteralValue(argumentString, CollectionsKt.first((List)((UCallExpression)valueCookie).getValueArguments())) : GradleContext.Companion.getStringLiteralValue(argumentString, valueCookie);
                            }
                        }
                        if (dependencyString == null) {
                            dependencyString = GradleDetector.Companion.getNamedDependency(value);
                        }
                        if (dependencyString == null) break block97;
                        dependency = new Ref.ObjectRef();
                        dependency.element = Dependency.Companion.parse(dependencyString);
                        isResolved = new Ref.BooleanRef();
                        if (dependency.element == null) ** GOTO lbl-1000
                        v9 /* !! */  = ((Dependency)dependency.element).getVersion();
                        v10 = v9 /* !! */  != null && (v9 /* !! */  = v9 /* !! */ .toIdentifier()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)v9 /* !! */ ), (CharSequence)"$", (boolean)false, (int)2, null) : false;
                        if (v10) {
                            if (StringsKt.startsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) && context.isEnabled(GradleDetector.NOT_INTERPOLATED)) {
                                message = "It looks like you are trying to substitute a version variable, but using single quotes ('). For Groovy string interpolation you must use double quotes (\").";
                                v11 = this.fix().name("Replace single quotes with double quotes").replace().text(value);
                                v12 = value.substring(1, value.length() - 1);
                                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"substring(...)");
                                fix = v11.with("\"" + v12 + "\"").build();
                                GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.NOT_INTERPOLATED, (String)message, fix, false, null, null, 224, null);
                            }
                            dependency.element = this.resolveCoordinate(context, property, (Dependency)dependency.element);
                            isResolved.element = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            if ((v13 /* !! */  = (Dependency)dependency.element) != null && (v13 /* !! */  = v13 /* !! */ .getVersion()) != null && (v13 /* !! */  = v13 /* !! */ .toIdentifier()) != null) {
                                it /* !! */  = v13 /* !! */ ;
                                $i$a$-let-GradleDetector$checkDslPropertyAssignment$4 = false;
                                v14 = !StringsKt.contains$default((CharSequence)value, (CharSequence)((CharSequence)it /* !! */ ), (boolean)false, (int)2, null);
                                v15 = !v14;
                            } else {
                                v15 = false;
                            }
                            if (!v15) {
                                isResolved.element = true;
                            }
                        }
                        if (dependency.element == null) break block98;
                        v16 /* !! */  = ((Dependency)dependency.element).getVersion();
                        if (v16 /* !! */  == null) ** GOTO lbl-1000
                        $this$checkDslPropertyAssignment_u24lambda_u244 = v16 /* !! */ ;
                        $i$a$-run-GradleDetector$checkDslPropertyAssignment$5 = false;
                        v17 = $this$checkDslPropertyAssignment_u24lambda_u244.getRequire();
                        if (v17 == null) {
                            v17 = $this$checkDslPropertyAssignment_u24lambda_u244.getStrictly();
                        }
                        v16 /* !! */  = v17;
                        if (v17 != null && (v16 /* !! */  = v16 /* !! */ .toIdentifier()) != null) {
                            v18 = StringsKt.endsWith$default((String)v16 /* !! */ , (String)"+", (boolean)false, (int)2, null);
                        } else lbl-1000:
                        // 2 sources

                        {
                            v18 = false;
                        }
                        if (v18) {
                            message = "Avoid using + in version numbers; can lead to unpredictable and unrepeatable builds (" + dependencyString + ")";
                            it = new Object[4];
                            it[0] = "coordinate";
                            it[1] = ((Dependency)dependency.element).toString();
                            it[2] = "revision";
                            v19 = ((Dependency)dependency.element).getVersion();
                            it[3] = v19 != null ? v19.toIdentifier() : null;
                            fix = this.fix().data(it);
                            GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.PLUS, (String)message, fix, false, null, null, 224, null);
                        }
                        if ((tomlLibraries = GradleContext.getTomlValue$default((GradleContext)context, (String)"libraries", (boolean)false, (int)2, null)) != null) {
                            v20 = context.file.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"context.file.name");
                            if (!(StringsKt.startsWith$default((String)v20, (String)"settings.gradle", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)dependencyString, (CharSequence)"+", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)dependencyString, (CharSequence)"$", (boolean)false, (int)2, null) && !isResolved.element)) {
                                v21 = ((Dependency)dependency.element).getGroup();
                                v22 = v21 != null ? StringsKt.isBlank((CharSequence)v21) == false : false;
                                if (v22 && (result = Lint.createMoveToTomlFix(context, tomlLibraries, (Dependency)dependency.element, valueCookie, versionVar = this.getVersionVariable(value))) != null) {
                                    v23 = (String)result.getFirst();
                                    if (v23 == null) {
                                        v23 = "Use version catalog instead";
                                    }
                                    message = v23;
                                    fix = (LintFix)result.getSecond();
                                    GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.SWITCH_TO_TOML, message, fix, false, null, null, 224, null);
                                }
                            }
                        }
                        context.getDriver().runLaterOutsideReadAction(new Runnable(this, context, (Ref.ObjectRef<Dependency>)dependency, isResolved, valueCookie, statementCookie){
                            final /* synthetic */ GradleDetector this$0;
                            final /* synthetic */ GradleContext $context;
                            final /* synthetic */ Ref.ObjectRef<Dependency> $dependency;
                            final /* synthetic */ Ref.BooleanRef $isResolved;
                            final /* synthetic */ Object $valueCookie;
                            final /* synthetic */ Object $statementCookie;
                            {
                                this.this$0 = $receiver;
                                this.$context = $context;
                                this.$dependency = $dependency;
                                this.$isResolved = $isResolved;
                                this.$valueCookie = $valueCookie;
                                this.$statementCookie = $statementCookie;
                            }

                            public final void run() {
                                GradleDetector.access$checkDependency(this.this$0, (Context)this.$context, (Dependency)this.$dependency.element, this.$isResolved.element, this.$valueCookie, this.$statementCookie);
                            }
                        });
                    }
                    if (com.android.tools.lint.checks.GradleDetector$Companion.access$hasLifecycleAnnotationProcessor(GradleDetector.Companion, dependencyString) && com.android.tools.lint.checks.GradleDetector$Companion.access$targetJava8Plus(GradleDetector.Companion, context.getProject())) {
                        GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8, "Use the Lifecycle Java 8 API provided by the `lifecycle-common` library instead of Lifecycle annotations for faster incremental build.", null, false, null, null, 224, null);
                    }
                    this.checkAnnotationProcessorOnCompilePath(property, dependencyString, context, propertyCookie);
                }
                this.checkDeprecatedConfigurations(property, context, propertyCookie);
                libTomlValue = null;
                if (dependencyString == null && (dependencyFromVc = com.android.tools.lint.checks.GradleDetector$Companion.access$getDependencyFromVersionCatalog(GradleDetector.Companion, value, context)) != null) {
                    dependencyString = dependencyFromVc.getCoordinates();
                    libTomlValue = dependencyFromVc.getTomlValue();
                }
                if (dependencyString != null) {
                    if (Intrinsics.areEqual((Object)property, (Object)"kapt")) {
                        this.checkKaptUsage(dependencyString, libTomlValue, context, statementCookie);
                    }
                    this.checkForBomUsageWithoutPlatform(property, dependencyString, value, context, valueCookie);
                }
                break block92;
            }
            if (Intrinsics.areEqual((Object)property, (Object)"packageNameSuffix")) {
                message = "Deprecated: Replace 'packageNameSuffix' with 'applicationIdSuffix'";
                fix = this.fix().name("Replace 'packageNameSuffix' with 'applicationIdSuffix'", true).replace().text("packageNameSuffix").with("applicationIdSuffix").autoFix().build();
                GradleDetector.report$default(this, (Context)context, propertyCookie, GradleDetector.DEPRECATED, message, fix, false, null, null, 224, null);
            } else if (Intrinsics.areEqual((Object)property, (Object)"applicationIdSuffix")) {
                suffix = GradleContext.Companion.getStringLiteralValue(value, valueCookie);
                if (suffix != null && !StringsKt.startsWith$default((String)suffix, (String)".", (boolean)false, (int)2, null)) {
                    message = "Application ID suffix should probably start with a \".\"";
                    GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.PATH, message, null, false, null, null, 240, null);
                }
            } else if ((Intrinsics.areEqual((Object)property, (Object)"minSdkVersion") || Intrinsics.areEqual((Object)property, (Object)"minSdk")) && Intrinsics.areEqual((Object)parent, (Object)"dev") && Intrinsics.areEqual((Object)"21", (Object)value) && !Intrinsics.areEqual((Object)"gradle", (Object)LintClient.Companion.getClientName())) {
                GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.DEV_MODE_OBSOLETE, "You no longer need a `dev` mode to enable multi-dexing during development, and this can break API version checks", null, false, null, null, 240, null);
            } else if (Intrinsics.areEqual((Object)parent, (Object)"dataBinding") && (Intrinsics.areEqual((Object)property, (Object)"enabled") || Intrinsics.areEqual((Object)property, (Object)"isEnabled")) || Intrinsics.areEqual((Object)parent, (Object)"buildFeatures") && Intrinsics.areEqual((Object)property, (Object)"dataBinding")) {
                if (Intrinsics.areEqual((Object)value, (Object)"true") && this.mAppliedKotlinAndroidPlugin && !this.mAppliedKotlinKaptPlugin) {
                    message = "If you plan to use data binding in a Kotlin project, you should apply the kotlin-kapt plugin.";
                    GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.DATA_BINDING_WITHOUT_KAPT, message, null, false, null, null, 224, null);
                }
            } else if ((Intrinsics.areEqual((Object)parent, (Object)"") || Intrinsics.areEqual((Object)parent, (Object)"java")) && Intrinsics.areEqual((Object)property, (Object)"sourceCompatibility")) {
                this.mDeclaredSourceCompatibility = true;
            } else if ((Intrinsics.areEqual((Object)parent, (Object)"") || Intrinsics.areEqual((Object)parent, (Object)"java")) && Intrinsics.areEqual((Object)property, (Object)"targetCompatibility")) {
                this.mDeclaredTargetCompatibility = true;
            } else if (Intrinsics.areEqual((Object)property, (Object)"include") && Intrinsics.areEqual((Object)parent, (Object)"abi") || Intrinsics.areEqual((Object)property, (Object)"abiFilters") && Intrinsics.areEqual((Object)parent, (Object)"ndk")) {
                this.checkForChromeOSAbiSplits(context, valueCookie, value);
            } else if (Intrinsics.areEqual((Object)parent, (Object)"toolchain") && Intrinsics.areEqual((Object)property, (Object)"languageVersion")) {
                this.mDeclaredSourceCompatibility = true;
                this.mDeclaredTargetCompatibility = true;
            }
        }
    }

    private final String getVersionVariable(String dependency) {
        boolean bl;
        String value;
        block8: {
            if (!StringsKt.contains$default((CharSequence)dependency, (CharSequence)"$", (boolean)false, (int)2, null)) {
                return null;
            }
            value = StringsKt.substringAfterLast$default((String)StringsKt.removeSurrounding((String)StringsKt.removeSurrounding((String)dependency, (CharSequence)"'"), (CharSequence)"\""), (char)':', null, (int)2, null);
            if (StringsKt.startsWith$default((String)value, (String)"$", (boolean)false, (int)2, null)) {
                if (StringsKt.startsWith$default((String)value, (String)"${", (boolean)false, (int)2, null)) {
                    int end = StringsKt.indexOf$default((CharSequence)value, (char)'}', (int)0, (boolean)false, (int)6, null);
                    if (end == -1 || end < value.length() - 1 && value.charAt(end + 1) != '@') {
                        return null;
                    }
                    value = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)value, (CharSequence)"${"), (CharSequence)"}");
                } else {
                    value = StringsKt.removePrefix((String)value, (CharSequence)"$");
                }
            } else {
                return null;
            }
            CharSequence $this$all$iv = value;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (Character.isLetter(it)) continue;
                bl = false;
                break block8;
            }
            bl = true;
        }
        if (bl) {
            return value;
        }
        return null;
    }

    private final void checkForChromeOSAbiSplits(GradleContext context, Object valueCookie, String value) {
        block1: {
            String message2;
            char[] cArray = new char[]{','};
            List abis = StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean hasX8664 = false;
            int n = abis.size();
            for (int i = 0; i < n; ++i) {
                if (!StringsKt.contains$default((CharSequence)((CharSequence)abis.get(i)), (CharSequence)"\"x86_64\"", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)((CharSequence)abis.get(i)), (CharSequence)"'x86_64'", (boolean)false, (int)2, null)) continue;
                hasX8664 = true;
            }
            String string = message2 = !hasX8664 ? "Missing x86_64 ABI support for ChromeOS" : null;
            if (string == null) break block1;
            String m = string;
            boolean bl = false;
            GradleDetector.report$default(this, (Context)context, valueCookie, CHROMEOS_ABI_SUPPORT, m, null, false, null, null, 240, null);
        }
    }

    private final void checkDeprecatedConfigurations(String configuration, GradleContext context, Object propertyCookie) {
        AgpVersion agpVersion = context.getProject().getGradleModelVersion();
        boolean bl = agpVersion != null ? !agpVersion.isAtLeastIncludingPreviews(3, 0, 0) : false;
        if (bl) {
            return;
        }
        for (DeprecatedConfiguration deprecatedConfiguration : DeprecatedConfiguration.values()) {
            if (!deprecatedConfiguration.matches(configuration)) continue;
            if (deprecatedConfiguration == DeprecatedConfiguration.COMPILE && GradleDetector.Companion.suggestApiConfigurationUse(context.getProject(), configuration)) {
                Object implementation = null;
                Object api2 = null;
                if (Intrinsics.areEqual((Object)configuration, (Object)"compile")) {
                    implementation = "implementation";
                    api2 = "api";
                } else {
                    String prefix = StringsKt.removeSuffix((String)configuration, (CharSequence)"Compile");
                    implementation = prefix + "Implementation";
                    api2 = prefix + "Api";
                }
                String message2 = "`" + configuration + "` is deprecated; replace with either `" + (String)api2 + "` to maintain current behavior, or `" + (String)implementation + "` to improve build performance by not sharing this dependency transitively.";
                LintFix apiFix = this.fix().name("Replace '" + configuration + "' with '" + (String)api2 + "'").family("Replace compile with api").replace().text(configuration).with((String)api2).autoFix().build();
                LintFix implementationFix = this.fix().name("Replace '" + configuration + "' with '" + (String)implementation + "'").family("Replace compile with implementation").replace().text(configuration).with((String)implementation).autoFix().build();
                LintFix fixes = this.fix().alternatives().name("Replace '" + configuration + "' with '" + (String)api2 + "' or '" + (String)implementation + "'").add(apiFix).add(implementationFix).build();
                GradleDetector.report$default(this, (Context)context, propertyCookie, DEPRECATED_CONFIGURATION, message2, fixes, false, null, null, 224, null);
                continue;
            }
            String replacement = deprecatedConfiguration.replacement(configuration);
            String message3 = "`" + configuration + "` is deprecated; replace with `" + replacement + "`";
            LintFix fix = this.fix().name("Replace '" + configuration + "' with '" + replacement + "'").family("Replace deprecated configurations").replace().text(configuration).with(replacement).autoFix().build();
            GradleDetector.report$default(this, (Context)context, propertyCookie, DEPRECATED_CONFIGURATION, message3, fix, false, null, null, 224, null);
        }
    }

    private final void checkAnnotationProcessorOnCompilePath(String configuration, String dependency, GradleContext context, Object propertyCookie) {
        for (Companion.CompileConfiguration compileConfiguration : Companion.CompileConfiguration.values()) {
            if (!compileConfiguration.matches(configuration) || !GradleDetector.Companion.isCommonAnnotationProcessor(dependency)) continue;
            String replacement = compileConfiguration.replacement(configuration);
            LintFix fix = this.fix().name("Replace " + configuration + " with " + replacement).family("Replace compile classpath with annotationProcessor").replace().text(configuration).with(replacement).autoFix().build();
            String message2 = "Add annotation processor to processor path using `" + replacement + "` instead of `" + configuration + "`";
            GradleDetector.report$default(this, (Context)context, propertyCookie, ANNOTATION_PROCESSOR_ON_COMPILE_PATH, message2, fix, false, null, null, 224, null);
        }
    }

    private final void checkMinSdkVersion(GradleContext context, int version, Object valueCookie) {
        boolean bl = 1 <= version ? version < 16 : false;
        if (bl) {
            String message2 = "The value of minSdkVersion is too low. It can be incremented without noticeably reducing the number of supported devices.";
            String label = "Update minSdkVersion to 16";
            LintFix fix = this.fix().name(label).replace().text(String.valueOf(version)).with("16").build();
            GradleDetector.report$default(this, (Context)context, valueCookie, MIN_SDK_TOO_LOW, message2, fix, false, null, null, 224, null);
        }
    }

    private final void checkIntegerAsString(GradleContext context, String value, Object cookie, Object valueCookie) {
        String string = GradleContext.Companion.getStringLiteralValue(value, valueCookie);
        if (com.android.tools.lint.detector.api.Lint.isNumberString((String)string)) {
            String message2 = "Use an integer rather than a string here (replace " + value + " with just " + string + ")";
            LintFix fix = this.fix().name("Replace with integer", true).replace().text(value).with(string).build();
            GradleDetector.report$default(this, (Context)context, cookie, STRING_INTEGER, message2, fix, false, null, null, 224, null);
        }
    }

    public void checkMethodCall(@NotNull GradleContext context, @NotNull String statement, @Nullable String parent, @Nullable String parentParent, @NotNull Map<String, String> namedArguments, @NotNull List<String> unnamedArguments, @NotNull Object cookie) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter(namedArguments, (String)"namedArguments");
        Intrinsics.checkNotNullParameter(unnamedArguments, (String)"unnamedArguments");
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        String plugin = namedArguments.get("plugin");
        if (Intrinsics.areEqual((Object)statement, (Object)"apply") && parent == null) {
            boolean isOldAppPlugin = Intrinsics.areEqual((Object)OLD_APP_PLUGIN_ID, (Object)plugin);
            if (isOldAppPlugin || Intrinsics.areEqual((Object)OLD_LIB_PLUGIN_ID, (Object)plugin)) {
                String replaceWith = isOldAppPlugin ? APP_PLUGIN_ID : LIB_PLUGIN_ID;
                String message2 = "'" + plugin + "' is deprecated; use '" + replaceWith + "' instead";
                LintFix fix = this.fix().sharedName("Replace plugin").replace().text(plugin).with(replaceWith).autoFix().build();
                GradleDetector.report$default(this, (Context)context, cookie, DEPRECATED, message2, fix, false, null, null, 224, null);
            }
            if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-android")) {
                this.mAppliedKotlinAndroidPlugin = true;
            }
            if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-kapt")) {
                this.mAppliedKotlinKaptPlugin = true;
            }
            if (Intrinsics.areEqual((Object)plugin, (Object)"com.google.devtools.ksp")) {
                this.mAppliedKspPlugin = true;
            }
            if (CollectionsKt.contains((Iterable)JAVA_PLUGIN_IDS, (Object)plugin)) {
                this.mAppliedJavaPlugin = true;
                this.mJavaPluginInfo = new JavaPluginInfo(cookie);
            }
        }
        if (Intrinsics.areEqual((Object)statement, (Object)"google") && Intrinsics.areEqual((Object)parent, (Object)"repositories") && Intrinsics.areEqual((Object)parentParent, (Object)"buildscript")) {
            this.mDeclaredGoogleMavenRepository = true;
            this.maybeReportAgpVersionIssue((Context)context);
        }
        if (Intrinsics.areEqual((Object)statement, (Object)"jcenter") && Intrinsics.areEqual((Object)parent, (Object)"repositories")) {
            String message3 = "JCenter Maven repository is no longer receiving updates: newer library versions may be available elsewhere";
            LintFix replaceFix = this.fix().name("Replace with mavenCentral").replace().text("jcenter").with("mavenCentral").build();
            LintFix deleteFix = this.fix().name("Delete this repository declaration").replace().all().with("").build();
            LintFix[] lintFixArray = new LintFix[]{replaceFix, deleteFix};
            GradleDetector.report$default(this, (Context)context, cookie, JCENTER_REPOSITORY_OBSOLETE, message3, this.fix().alternatives(lintFixArray), false, null, null, 224, null);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkDependency(Context context, Dependency dependency, boolean isResolved, Object cookie, Object statementCookie) {
        block86: {
            block84: {
                block85: {
                    block79: {
                        block83: {
                            block80: {
                                block77: {
                                    block78: {
                                        block82: {
                                            block81: {
                                                block76: {
                                                    v0 = dependency.getVersion();
                                                    if (v0 == null || (v0 = v0.getLowerBound()) == null) {
                                                        return;
                                                    }
                                                    version = v0;
                                                    v1 = dependency.getGroup();
                                                    if (v1 == null) {
                                                        return;
                                                    }
                                                    groupId = v1;
                                                    artifactId = dependency.getName();
                                                    v2 /* !! */  = dependency.getVersion();
                                                    if (v2 /* !! */  == null || (v2 /* !! */  = v2 /* !! */ .toIdentifier()) == null) {
                                                        return;
                                                    }
                                                    richVersionIdentifier /* !! */  = v2 /* !! */ ;
                                                    safeReplacement = null;
                                                    newerVersion = new Ref.ObjectRef();
                                                    sdkIndex = this.getGooglePlaySdkIndex(context.getClient());
                                                    versionFilter = this.getUpgradeVersionFilter(context, groupId, artifactId, (Version)version);
                                                    sdkIndexFilter = this.getGooglePlaySdkIndexFilter(context, groupId, artifactId, sdkIndex);
                                                    filter = GradleDetector.checkDependency$and(versionFilter, sdkIndexFilter);
                                                    var16_16 = groupId;
                                                    switch (var16_16.hashCode()) {
                                                        case -557449116: {
                                                            if (!var16_16.equals("com.android.application")) {
                                                                ** break;
                                                            }
                                                            break block76;
                                                        }
                                                        case 432891823: {
                                                            if (!var16_16.equals("com.android.tools.build")) {
                                                                ** break;
                                                            }
                                                            break block76;
                                                        }
                                                        case -1893440090: {
                                                            if (!var16_16.equals("com.squareup.okhttp3")) {
                                                                ** break;
                                                            }
                                                            break block77;
                                                        }
                                                        case -1228224049: {
                                                            if (!var16_16.equals("com.android.library")) {
                                                                ** break;
                                                            }
                                                            break block76;
                                                        }
                                                        case -491662668: {
                                                            if (!var16_16.equals("org.apache.httpcomponents")) {
                                                                ** break;
                                                            }
                                                            break block78;
                                                        }
                                                        case 1502450888: {
                                                            if (!var16_16.equals("com.bugsnag")) {
                                                                ** break;
                                                            }
                                                            break block79;
                                                        }
                                                        case -1810210692: {
                                                            if (!var16_16.equals("com.android.dynamic-feature")) {
                                                                ** break;
                                                            }
                                                            break block76;
                                                        }
                                                        case 95303497: {
                                                            if (!var16_16.equals("com.android.instant-app")) {
                                                                ** break;
                                                            }
                                                            break block76;
                                                        }
                                                        case -1266275135: {
                                                            if (!var16_16.equals("com.github.bumptech.glide")) {
                                                                ** break;
                                                            }
                                                            break block80;
                                                        }
                                                        case 2042560118: {
                                                            if (!var16_16.equals("com.google.guava")) {
                                                                ** break;
                                                            }
                                                            break block81;
                                                        }
                                                        case -88614914: {
                                                            if (!var16_16.equals("com.android.test")) {
                                                                ** break;
                                                            }
                                                            break block76;
                                                        }
                                                        case 325967270: {
                                                            if (!var16_16.equals("com.google.android.gms")) {
                                                                ** break;
                                                            }
                                                            ** GOTO lbl111
                                                        }
                                                        case 726153860: {
                                                            if (!var16_16.equals("com.google.code.gson")) {
                                                                ** break;
                                                            }
                                                            break block82;
                                                        }
                                                        case -57025417: {
                                                            if (var16_16.equals("androidx.credentials")) break;
                                                            ** break;
                                                        }
                                                        case 288657178: {
                                                            if (!var16_16.equals("io.fabric.tools")) {
                                                                ** break;
                                                            }
                                                            break block83;
                                                        }
                                                        case 1921327114: {
                                                            if (!var16_16.equals("com.android.feature")) {
                                                                ** break;
                                                            }
                                                            break block76;
                                                        }
                                                        case -89155011: {
                                                            if (!var16_16.equals("com.android.base")) {
                                                                ** break;
                                                            }
                                                            break block76;
                                                        }
                                                        case 26640288: {
                                                            if (!var16_16.equals("com.google.android.wearable")) {
                                                                ** break;
                                                            }
                                                            ** GOTO lbl111
                                                        }
                                                        case -1030005853: {
                                                            if (!var16_16.equals("org.jetbrains.kotlin")) {
                                                                ** break;
                                                            }
                                                            break block84;
                                                        }
                                                        case -225004625: {
                                                            if (!var16_16.equals("com.google.firebase")) {
                                                                ** break;
                                                            }
                                                            ** GOTO lbl111
                                                        }
                                                        case 1156888975: {
                                                            if (!var16_16.equals("com.android.settings")) {
                                                                ** break;
                                                            }
                                                            break block76;
                                                        }
                                                        case -315438450: {
                                                            if (!var16_16.equals("org.robolectric")) {
                                                                ** break;
                                                            }
                                                            break block85;
                                                        }
                                                        case 1356232872: {
                                                            if (!var16_16.equals("com.google.android.support")) ** break;
lbl111:
                                                            // 4 sources

                                                            this.checkPlayServices(context, dependency, (Version)version, cookie, statementCookie);
                                                            ** break;
                                                        }
                                                    }
                                                    if (!Intrinsics.areEqual((Object)artifactId, (Object)"credentials")) ** break;
                                                    this.checkCredentialDependency(context, cookie, statementCookie);
                                                    ** break;
                                                }
                                                if (Intrinsics.areEqual((Object)"gradle", (Object)artifactId) || Intrinsics.areEqual((Object)(groupId + ".gradle.plugin"), (Object)artifactId)) {
                                                    if (this.checkGradlePluginDependency(context, dependency, statementCookie)) {
                                                        return;
                                                    }
                                                    newerVersion.element = GradleDetectorKt.access$maxAgpOrNull((Version)newerVersion.element, this.getGoogleMavenRepoVersion(context, dependency, filter));
                                                    if (!LintClient.Companion.isGradle()) {
                                                        newerVersion.element = GradleDetectorKt.access$maxAgpOrNull((Version)newerVersion.element, this.findCachedNewerVersion(dependency, filter));
                                                    }
                                                    newerVersion.element = GradleDetectorKt.access$maxAgpOrNull((Version)newerVersion.element, context.getClient().getHighestKnownVersion(dependency, filter));
                                                    if (!(newerVersion.element == null || version.isPreview() || Intrinsics.areEqual((Object)newerVersion.element, (Object)version) || Intrinsics.areEqual((Object)version.getMajor(), (Object)((Version)newerVersion.element).getMajor()) && Intrinsics.areEqual((Object)version.getMinor(), (Object)((Version)newerVersion.element).getMinor()))) {
                                                        safeReplacement = this.getGoogleMavenRepoVersion(context, dependency, new Predicate((Version)version, (Ref.ObjectRef<Version>)newerVersion){
                                                            final /* synthetic */ Version $version;
                                                            final /* synthetic */ Ref.ObjectRef<Version> $newerVersion;
                                                            {
                                                                this.$version = $version;
                                                                this.$newerVersion = $newerVersion;
                                                            }

                                                            /*
                                                             * Enabled force condition propagation
                                                             * Lifted jumps to return sites
                                                             */
                                                            public final boolean test(@NotNull Version filterVersion) {
                                                                Boolean bl;
                                                                Intrinsics.checkNotNullParameter((Object)filterVersion, (String)"filterVersion");
                                                                if (filterVersion.getMajor() == null) return false;
                                                                if (!Intrinsics.areEqual((Object)filterVersion.getMajor(), (Object)this.$version.getMajor())) return false;
                                                                if (filterVersion.getMinor() == null) return false;
                                                                if (!Intrinsics.areEqual((Object)filterVersion.getMinor(), (Object)this.$version.getMinor())) return false;
                                                                Integer n = filterVersion.getMicro();
                                                                if (n == null) return false;
                                                                Integer n2 = n;
                                                                Version version = this.$version;
                                                                int m = ((Number)n2).intValue();
                                                                boolean bl2 = false;
                                                                Integer n3 = version.getMicro();
                                                                if (n3 != null) {
                                                                    int it = ((Number)n3).intValue();
                                                                    boolean bl3 = false;
                                                                    bl = m > it;
                                                                } else {
                                                                    bl = null;
                                                                }
                                                                boolean bl4 = Intrinsics.areEqual(bl, (Object)true);
                                                                if (!bl4) return false;
                                                                if (filterVersion.isPreview()) return false;
                                                                Object object = this.$newerVersion.element;
                                                                Intrinsics.checkNotNull((Object)object);
                                                                if (filterVersion.compareTo((Version)object) >= 0) return false;
                                                                if (filterVersion.isSnapshot()) return false;
                                                                return true;
                                                            }
                                                        });
                                                    }
                                                    if (newerVersion.element != null && GradleDetectorKt.access$isAgpNewerThan((Version)newerVersion.element, dependency)) {
                                                        this.agpVersionCheckInfo = new AgpVersionCheckInfo((Version)newerVersion.element, Intrinsics.areEqual((Object)((Version)newerVersion.element).getMajor(), (Object)version.getMajor()) != false && Intrinsics.areEqual((Object)((Version)newerVersion.element).getMinor(), (Object)version.getMinor()) != false, safeReplacement, dependency, isResolved, cookie);
                                                        this.maybeReportAgpVersionIssue(context);
                                                    }
                                                    return;
                                                }
                                                break block86;
                                            }
                                            if (!Intrinsics.areEqual((Object)"guava", (Object)artifactId)) ** break;
                                            newerVersion.element = this.getNewerVersion((Version)version, 21, 0);
                                            ** break;
                                        }
                                        if (!Intrinsics.areEqual((Object)"gson", (Object)artifactId)) ** break;
                                        newerVersion.element = this.getNewerVersion((Version)version, 2, 8, 2);
                                        ** break;
                                    }
                                    if (!Intrinsics.areEqual((Object)"httpclient", (Object)artifactId)) ** break;
                                    newerVersion.element = this.getNewerVersion((Version)version, 4, 5, 5);
                                    ** break;
                                }
                                if (!Intrinsics.areEqual((Object)"okhttp", (Object)artifactId)) ** break;
                                newerVersion.element = this.getNewerVersion((Version)version, 3, 10, 0);
                                ** break;
                            }
                            if (!Intrinsics.areEqual((Object)"glide", (Object)artifactId)) ** break;
                            newerVersion.element = this.getNewerVersion((Version)version, 3, 7, 0);
                            ** break;
                        }
                        if (!Intrinsics.areEqual((Object)"gradle", (Object)artifactId)) ** break;
                        if (GradleDetectorKt.access$isNewerThan(Version.Companion.parse("1.21.6"), dependency)) {
                            fix = GradleDetector.getUpdateDependencyFix$default(this, (String)richVersionIdentifier /* !! */ , "1.22.1", false, null, 12, null);
                            GradleDetector.report$default(this, context, statementCookie, GradleDetector.DEPENDENCY, "Use Fabric Gradle plugin version 1.21.6 or later to improve Instant Run performance (was " + (String)richVersionIdentifier /* !! */  + ")", fix, false, null, null, 224, null);
                            ** break;
                        }
                        newerVersion.element = this.getNewerVersion((Version)version, 1, 25, 1);
                        ** break;
                    }
                    if (!Intrinsics.areEqual((Object)"bugsnag-android-gradle-plugin", (Object)artifactId)) ** break;
                    if (version.compareTo(Version.Companion.parse("2.1.2")) < 0) {
                        fix = GradleDetector.getUpdateDependencyFix$default(this, (String)richVersionIdentifier /* !! */ , "2.4.1", false, null, 12, null);
                        GradleDetector.report$default(this, context, statementCookie, GradleDetector.DEPENDENCY, "Use BugSnag Gradle plugin version 2.1.2 or later to improve Instant Run performance (was " + (String)richVersionIdentifier /* !! */  + ")", fix, false, null, null, 224, null);
                        ** break;
                    }
                    newerVersion.element = this.getNewerVersion((Version)version, 3, 2, 5);
                    ** break;
                }
                if (Intrinsics.areEqual((Object)"robolectric", (Object)artifactId) && SdkConstants.currentPlatform() == 2 && version.compareTo(Version.Companion.parse("4.2.1")) < 0) {
                    fix = GradleDetector.getUpdateDependencyFix$default(this, (String)richVersionIdentifier /* !! */ , "4.2.1", false, null, 12, null);
                    GradleDetector.report$default(this, context, cookie, GradleDetector.DEPENDENCY, "Use robolectric version 4.2.1 or later to fix issues with parsing of Windows paths", fix, false, null, null, 224, null);
                    ** break;
                }
                break block86;
            }
            if (!Intrinsics.areEqual((Object)artifactId, (Object)"kotlin-gradle-plugin")) ** break;
            return;
        }
        this.checkForKtxExtension(context, groupId, artifactId, (Version)version, cookie);
        blockedDependencies = this.blockedDependencies.get(context.getProject());
        if (blockedDependencies != null && (path = blockedDependencies.checkDependency(groupId, artifactId, true)) != null) {
            message = this.getBlockedDependencyMessage(path);
            fix = this.fix().name("Delete dependency").replace().all().build();
            GradleDetector.report$default(this, context, statementCookie, GradleDetector.DUPLICATE_CLASSES, message, fix, true, null, null, 192, null);
        }
        hasSdkIndexIssues = false;
        if (sdkIndex.isReady()) {
            versionString = version.toString();
            buildFile = context.file;
            isBlocking = sdkIndex.hasLibraryBlockingIssues(groupId, artifactId, versionString);
            severity = isBlocking != false ? Severity.ERROR : Severity.WARNING;
            fix /* !! */  = null;
            if (sdkIndex.isLibraryNonCompliant(groupId, artifactId, versionString, buildFile)) {
                fix /* !! */  = sdkIndex.generateSdkLinkLintFix(groupId, artifactId, versionString, buildFile);
                messages = isBlocking != false ? sdkIndex.generateBlockingPolicyMessages(groupId, artifactId, versionString) : sdkIndex.generatePolicyMessages(groupId, artifactId, versionString);
                for (String message : messages) {
                    hasSdkIndexIssues = GradleDetector.report$default(this, context, cookie, GradleDetector.PLAY_SDK_INDEX_NON_COMPLIANT, message, fix /* !! */ , false, severity, null, 160, null) != false || hasSdkIndexIssues != false;
                }
            }
            if (isBlocking && sdkIndex.hasLibraryCriticalIssues(groupId, artifactId, versionString, buildFile)) {
                if (fix /* !! */  == null) {
                    fix /* !! */  = sdkIndex.generateSdkLinkLintFix(groupId, artifactId, versionString, buildFile);
                }
                v3 = hasSdkIndexIssues = GradleDetector.report$default(this, context, cookie, GradleDetector.RISKY_LIBRARY, message = sdkIndex.generateBlockingCriticalMessage(groupId, artifactId, versionString), fix /* !! */ , false, severity, null, 160, null) != false || hasSdkIndexIssues != false;
            }
            if (sdkIndex.isLibraryOutdated(groupId, artifactId, versionString, buildFile)) {
                if (fix /* !! */  == null) {
                    fix /* !! */  = sdkIndex.generateSdkLinkLintFix(groupId, artifactId, versionString, buildFile);
                }
                message = isBlocking != false ? sdkIndex.generateBlockingOutdatedMessage(groupId, artifactId, versionString) : sdkIndex.generateOutdatedMessage(groupId, artifactId, versionString);
                hasSdkIndexIssues = GradleDetector.report$default(this, context, cookie, GradleDetector.DEPRECATED_LIBRARY, message, fix /* !! */ , false, severity, null, 160, null) != false || hasSdkIndexIssues != false;
            }
        }
        issue = GradleDetector.DEPENDENCY;
        if (!Scope.Companion.checkSingleFile(context.getScope()) && context.isEnabled(GradleDetector.REMOTE_VERSION) && !this.getGoogleMavenRepository(context.getClient()).hasGroupId(groupId)) {
            latest = GradleDetector.Companion.getLatestVersionFromRemoteRepo(context.getClient(), dependency, filter, (v4 = dependency.getVersion()) != null && (v4 = v4.getLowerBound()) != null ? v4.isPreview() : true);
            if (latest != null && version.compareTo(latest) < 0) {
                newerVersion.element = latest;
                issue = GradleDetector.REMOTE_VERSION;
            }
            if ((group = dependency.getGroup()) != null && this.isGradlePlugin(dependency) && (pluginVersion = GradleDetector.Companion.getLatestVersionFromGradlePluginPortal(context.getClient(), group, filter, (v5 = dependency.getVersion()) != null && (v5 = v5.getLowerBound()) != null ? v5.isPreview() : true)) != null && version.compareTo(pluginVersion) < 0) {
                newerVersion.element = pluginVersion;
                issue = GradleDetector.REMOTE_VERSION;
            }
        }
        newerVersion.element = GradleDetectorKt.access$maxOrNull((Comparable)newerVersion.element, (Comparable)this.findCachedNewerVersion(dependency, filter));
        newerVersion.element = GradleDetectorKt.access$maxOrNull((Comparable)newerVersion.element, (Comparable)context.getClient().getHighestKnownVersion(dependency, filter));
        newerVersion.element = GradleDetectorKt.access$maxOrNull((Comparable)newerVersion.element, (Comparable)this.getGoogleMavenRepoVersion(context, dependency, filter));
        if (newerVersion.element != null && version.compareTo(Version.Companion.prefixInfimum("0")) > 0 && GradleDetectorKt.access$isNewerThan((Version)newerVersion.element, dependency)) {
            versionString = ((Version)newerVersion.element).toString();
            isCustomMessage = false;
            isCustomMessage = true;
            if (Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"androidx.slidingpanelayout") && Intrinsics.areEqual((Object)dependency.getName(), (Object)"slidingpanelayout")) {
                v6 = "Upgrade `androidx.slidingpanelayout` for keyboard and mouse support";
            } else if (Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"androidx.compose.foundation") && Intrinsics.areEqual((Object)dependency.getName(), (Object)"foundation")) {
                v6 = "Upgrade `androidx.compose.foundation` for keyboard and mouse support";
            } else {
                it /* !! */  = fix /* !! */  = this.getNewerVersionAvailableMessage(dependency, versionString, null);
                $i$a$-also-GradleDetector$checkDependency$message$1 = false;
                isCustomMessage = false;
                v6 = message = fix /* !! */ ;
            }
            if (Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"com.google.android.gms") && Intrinsics.areEqual((Object)dependency.getName(), (Object)"play-services-maps")) {
                it /* !! */  = Version.Companion.parse("18.2.0");
                $i$a$-let-GradleDetector$checkDependency$2 = false;
                v7 = version.compareTo((Version)it /* !! */ ) < 0 && ((Version)newerVersion.element).compareTo((Version)it /* !! */ ) >= 0;
                if (v7) {
                    message = (String)message + ". Upgrading to at least 18.2.0 is highly recommended to take advantage of the new renderer, which supports customization options like map styling, 3D tiles, and is more reliable, with better support going forward.";
                    isCustomMessage = true;
                }
            }
            if (isCustomMessage || !hasSdkIndexIssues) {
                fix /* !! */  = isResolved == false ? GradleDetector.getUpdateDependencyFix$default(this, (String)richVersionIdentifier /* !! */ , versionString, false, null, 12, null) : null;
                GradleDetector.report$default(this, context, cookie, issue, (String)message, fix /* !! */ , false, null, null, 224, null);
            }
        }
    }

    private final Predicate<Version> getGooglePlaySdkIndexFilter(Context context, String groupId, String artifactId, GooglePlaySdkIndex sdkIndex) {
        Predicate predicate;
        GooglePlaySdkIndex googlePlaySdkIndex = sdkIndex;
        if (googlePlaySdkIndex != null) {
            GooglePlaySdkIndex it = googlePlaySdkIndex;
            boolean bl = false;
            predicate = new Predicate(it, groupId, artifactId){
                final /* synthetic */ GooglePlaySdkIndex $it;
                final /* synthetic */ String $groupId;
                final /* synthetic */ String $artifactId;
                {
                    this.$it = $it;
                    this.$groupId = $groupId;
                    this.$artifactId = $artifactId;
                }

                public final boolean test(@NotNull Version v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return this.$it.isReady() && !this.$it.hasLibraryErrorOrWarning(this.$groupId, this.$artifactId, v.toString());
                }
            };
        } else {
            predicate = null;
        }
        return predicate;
    }

    private final Predicate<Version> getUpgradeVersionFilter(Context context, String groupId, String artifactId, Version version) {
        if ((Intrinsics.areEqual((Object)groupId, (Object)"com.android.tools.build") || ALL_PLUGIN_IDS.contains(groupId)) && LintClient.Companion.isStudio()) {
            String string = context.getClient().getClientRevision();
            if (string == null) {
                return null;
            }
            String clientRevision = string;
            Version ideVersion = Version.Companion.parse(clientRevision);
            return new Predicate(ideVersion, version){
                final /* synthetic */ Version $ideVersion;
                final /* synthetic */ Version $version;
                {
                    this.$ideVersion = $ideVersion;
                    this.$version = $version;
                }

                public final boolean test(@NotNull Version v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return Intrinsics.areEqual((Object)v.getMajor(), (Object)this.$ideVersion.getMajor()) && Intrinsics.areEqual((Object)v.getMinor(), (Object)this.$ideVersion.getMinor()) || Intrinsics.areEqual((Object)v.getMajor(), (Object)this.$version.getMajor()) && Intrinsics.areEqual((Object)v.getMinor(), (Object)this.$version.getMinor());
                }
            };
        }
        if (Intrinsics.areEqual((Object)groupId, (Object)"com.google.guava")) {
            String suffix = version.toString();
            Predicate jre2 = getUpgradeVersionFilter.jre.1.INSTANCE;
            Predicate android2 = getUpgradeVersionFilter.android.1.INSTANCE;
            Predicate neither2 = getUpgradeVersionFilter.neither.1.INSTANCE;
            return StringsKt.endsWith$default((String)suffix, (String)"-jre", (boolean)false, (int)2, null) ? jre2 : (StringsKt.endsWith$default((String)suffix, (String)"-android", (boolean)false, (int)2, null) ? android2 : neither2);
        }
        if (Intrinsics.areEqual((Object)artifactId, (Object)"kotlinx-coroutines-core")) {
            String suffix = version.toString();
            return StringsKt.contains$default((CharSequence)suffix, (CharSequence)"-native-mt-2", (boolean)false, (int)2, null) ? (Predicate)getUpgradeVersionFilter.2.INSTANCE : (StringsKt.contains$default((CharSequence)suffix, (CharSequence)"-native-mt", (boolean)false, (int)2, null) ? (Predicate)getUpgradeVersionFilter.3.INSTANCE : (Predicate)getUpgradeVersionFilter.4.INSTANCE);
        }
        if (version.getMajor() != null) {
            Version infimum = version.getPreviewInfimum();
            Version supremum = version.getPreviewSupremum();
            if (infimum != null && supremum != null) {
                return new Predicate(infimum, supremum){
                    final /* synthetic */ Version $infimum;
                    final /* synthetic */ Version $supremum;
                    {
                        this.$infimum = $infimum;
                        this.$supremum = $supremum;
                    }

                    public final boolean test(@NotNull Version v) {
                        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                        return v.isPreview() ? this.$infimum.compareTo(v) < 0 && v.compareTo(this.$supremum) < 0 : true;
                    }
                };
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final File getArtifactCacheHome() {
        File file = this.artifactCacheHome;
        if (file == null) {
            void var3_3;
            File home;
            GradleDetector $this$getArtifactCacheHome_u24lambda_u2410 = this;
            boolean bl = false;
            $this$getArtifactCacheHome_u24lambda_u2410.artifactCacheHome = home = new File($this$getArtifactCacheHome_u24lambda_u2410.getGradleUserHome(), "caches" + File.separator + "modules-2" + File.separator + "files-2.1");
            file = var3_3;
        }
        return file;
    }

    /*
     * Unable to fully structure code
     */
    private final Version findCachedNewerVersion(Dependency dependency, Predicate<Version> filter) {
        v0 = dependency.getGroup();
        if (v0 == null) {
            return null;
        }
        group = v0;
        versionDir = this.getArtifactCacheHome().toPath().resolve(group + File.separator + dependency.getName());
        v1 = dependency.getGroup();
        v2 = v1 != null ? StringsKt.startsWith$default((String)v1, (String)"commons-", (boolean)false, (int)2, null) : false;
        if (!v2) ** GOTO lbl-1000
        v3 = dependency.getName();
        v4 = v3 != null ? StringsKt.startsWith$default((String)v3, (String)"commons-", (boolean)false, (int)2, null) : false;
        if (v4 && Intrinsics.areEqual((Object)dependency.getName(), (Object)dependency.getGroup())) {
            commonsFilter = new Predicate(this){
                final /* synthetic */ GradleDetector this$0;
                {
                    this.this$0 = $receiver;
                }

                public final boolean test(@NotNull Version v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return !GradleDetector.access$isOldApacheCommonsVersion(this.this$0, v);
                }
            };
            v5 = filter;
            v6 = v5 != null ? v5.and(commonsFilter) : null;
            if (v6 == null) {
                v6 = commonsFilter;
            }
        } else lbl-1000:
        // 2 sources

        {
            v6 = filter;
        }
        f = v6;
        noSnapshotFilter = (Function1)new Function1<Version, Boolean>(f){
            final /* synthetic */ Predicate<Version> $f;
            {
                this.$f = $f;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Version candidate) {
                Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
                return !candidate.isSnapshot() && (this.$f == null || this.$f.test(candidate));
            }
        };
        if (CancellableFileIo.exists((Path)versionDir, (LinkOption[])new LinkOption[0])) {
            name = dependency.getName();
            richVersion = dependency.getVersion();
            allowPreview = richVersion == null ? true : (Intrinsics.areEqual((Object)group, (Object)"com.google.guava") != false || Intrinsics.areEqual((Object)name, (Object)"kotlinx-coroutines-core") != false ? true : MavenRepositories.isPreview((Component)new Component(group, name, richVersion.getLowerBound())));
            v7 = MavenRepositories.getHighestVersion((Path)versionDir, (Predicate)new Predicate(noSnapshotFilter){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ boolean test(Object p0) {
                    return (Boolean)this.function.invoke(p0);
                }
            }, (boolean)allowPreview);
        } else {
            v7 = null;
        }
        return v7;
    }

    private final boolean isOldApacheCommonsVersion(Version $this$isOldApacheCommonsVersion) {
        Object object = $this$isOldApacheCommonsVersion.getMajor();
        return object != null && (object = ((Integer)object).toString()) != null ? ((String)object).length() == 8 : false;
    }

    private final boolean checkGradlePluginDependency(Context context, Dependency dependency, Object cookie) {
        block5: {
            Object object;
            block7: {
                Version recommended;
                block6: {
                    Version version;
                    Version minimum = Version.Companion.parse("3.2.0");
                    RichVersion richVersion = dependency.getVersion();
                    if (richVersion == null) {
                        return false;
                    }
                    RichVersion dependencyVersion = richVersion;
                    if (dependencyVersion.getLowerBound().compareTo(minimum) >= 0) {
                        return false;
                    }
                    if (dependencyVersion.contains(minimum)) break block5;
                    Dependency query = new Dependency("com.android.tools.build", "gradle", RichVersion.Companion.require(minimum), null, null, 24, null);
                    recommended = Version.Companion.parse("7.0.3");
                    boolean bl = false;
                    object = this.getGoogleMavenRepoVersion(context, query, null);
                    if (object == null) break block6;
                    Version it = version = object;
                    boolean bl2 = false;
                    object = it.compareTo(recommended) > 0 ? version : null;
                    if (object != null) break block7;
                }
                object = recommended;
            }
            Version recommended = object;
            String message2 = "You must use a newer version of the Android Gradle plugin. The minimum supported version is 3.2.0 and the recommended version is " + recommended;
            GradleDetector.report$default(this, context, cookie, GRADLE_PLUGIN_COMPATIBILITY, message2, null, false, null, null, 240, null);
            return true;
        }
        return false;
    }

    private final void checkCredentialDependency(Context context, Object valueCookie, Object statementCookie) {
        if (Intrinsics.areEqual((Object)context.getProject().dependsOn("androidx.credentials:credentials-play-services-auth"), (Object)true)) {
            return;
        }
        String string = context.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.file.path");
        Object cookie = StringsKt.endsWith$default((String)string, (String)".toml", (boolean)false, (int)2, null) ? statementCookie : valueCookie;
        GradleDetector.report$default(this, context, cookie, CREDENTIAL_DEP, "In Android 13 or lower, `credentials-play-services-auth` is required when using `androidx.credentials:credentials`", null, false, null, Constraints.minSdkLessThan((int)34), 112, null);
    }

    private final void checkPlayServices(Context context, Dependency dependency, Version version, Object cookie, Object statementCookie) {
        Object message2;
        LintFix fix;
        String richVersionIdentifier;
        RichVersion richVersion;
        String artifactId;
        String groupId;
        block15: {
            Object object;
            block17: {
                Version v;
                block16: {
                    Version version2;
                    String string = dependency.getGroup();
                    if (string == null) {
                        return;
                    }
                    groupId = string;
                    artifactId = dependency.getName();
                    RichVersion richVersion2 = dependency.getVersion();
                    if (richVersion2 == null) {
                        return;
                    }
                    richVersion = richVersion2;
                    String string2 = richVersion.toIdentifier();
                    if (string2 == null) {
                        return;
                    }
                    richVersionIdentifier = string2;
                    if (!Intrinsics.areEqual((Object)Version.Companion.parse("5.2.08"), (Object)version) || !context.isEnabled(COMPATIBILITY)) break block15;
                    v = Version.Companion.parse("10.2.1");
                    boolean bl = false;
                    object = this.getGoogleMavenRepoVersion(context, dependency, null);
                    if (object == null) break block16;
                    Version it = version2 = object;
                    boolean bl2 = false;
                    object = it.compareTo(v) > 0 ? version2 : null;
                    if (object != null) break block17;
                }
                object = v;
            }
            Version maxVersion = object;
            fix = GradleDetector.getUpdateDependencyFix$default(this, richVersionIdentifier, maxVersion.toString(), false, null, 12, null);
            String message3 = "Version `5.2.08` should not be used; the app can not be published with this version. Use version `" + maxVersion + "` instead.";
            this.reportFatalCompatibilityIssue(context, cookie, message3, fix);
        }
        if (context.isEnabled(BUNDLED_GMS) && Intrinsics.areEqual((Object)PLAY_SERVICES_V650.getGroup(), (Object)dependency.getGroup()) && Intrinsics.areEqual((Object)PLAY_SERVICES_V650.getName(), (Object)dependency.getName()) && (richVersion.getLowerBound().compareTo(PLAY_SERVICES_V650.getVersion()) >= 0 || richVersion.contains(PLAY_SERVICES_V650.getVersion()))) {
            message2 = "Avoid using bundled version of Google Play services SDK.";
            GradleDetector.report$default(this, context, cookie, BUNDLED_GMS, (String)message2, null, false, null, null, 240, null);
        }
        if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)"play-services-appindexing", (Object)artifactId)) {
            message2 = "Deprecated: Replace 'com.google.android.gms:play-services-appindexing:" + richVersionIdentifier + "' with 'com.google.firebase:firebase-appindexing:10.0.0' or above. More info: http://firebase.google.com/docs/app-indexing/android/migrate";
            fix = this.fix().name("Replace with Firebase").replace().text("com.google.android.gms:play-services-appindexing:" + richVersionIdentifier).with("com.google.firebase:firebase-appindexing:10.2.1").build();
            GradleDetector.report$default(this, context, cookie, DEPRECATED, (String)message2, fix, false, null, null, 224, null);
        }
        if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) || Intrinsics.areEqual((Object)FIREBASE_GROUP_ID, (Object)groupId)) {
            if (!this.mCheckedGms) {
                this.mCheckedGms = true;
                if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES) && context.isGlobalAnalysis()) {
                    this.checkConsistentPlayServices(context, cookie);
                }
            }
        } else if (!this.mCheckedWearableLibs) {
            this.mCheckedWearableLibs = true;
            if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES) && context.isGlobalAnalysis()) {
                this.checkConsistentWearableLibraries(context, cookie, statementCookie);
            }
        }
    }

    private final void checkConsistentPlayServices(Context context, Object cookie) {
        this.checkConsistentLibraries(context, cookie, GMS_GROUP_ID, FIREBASE_GROUP_ID);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConsistentWearableLibraries(Context context, Object cookie, Object statementCookie) {
        void $this$filterIsInstanceTo$iv$iv;
        Project project = context.getMainProject();
        if (!project.isGradleProject()) {
            return;
        }
        HashSet<String> supportVersions = new HashSet<String>();
        HashSet<String> wearableVersions = new HashSet<String>();
        Iterable $this$filterIsInstance$iv = this.getAllLibraries(project);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LintModelExternalLibrary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (LintModelExternalLibrary library : (List)destination$iv$iv) {
            LintModelMavenName coordinates = library.getResolvedCoordinates();
            if (Intrinsics.areEqual((Object)WEARABLE_ARTIFACT_ID, (Object)coordinates.getArtifactId()) && Intrinsics.areEqual((Object)GOOGLE_SUPPORT_GROUP_ID, (Object)coordinates.getGroupId())) {
                supportVersions.add(coordinates.getVersion());
            }
            if (!Intrinsics.areEqual((Object)WEARABLE_ARTIFACT_ID, (Object)coordinates.getArtifactId()) || !Intrinsics.areEqual((Object)ANDROID_WEAR_GROUP_ID, (Object)coordinates.getGroupId())) continue;
            if (!library.getProvided()) {
                String message2 = "This dependency should be marked as `compileOnly`, not `compile`";
                if (statementCookie != null) {
                    this.reportFatalCompatibilityIssue(context, statementCookie, message2);
                } else {
                    Location location = Companion.getDependencyLocation(context, coordinates);
                    if (location.getStart() == null) {
                        message2 = "The com.google.android.wearable:wearable dependency should be marked as `compileOnly`, not `compile`";
                    }
                    this.reportFatalCompatibilityIssue(context, location, message2);
                }
            }
            wearableVersions.add(coordinates.getVersion());
        }
        if (!((Collection)supportVersions).isEmpty()) {
            Location location;
            if (wearableVersions.isEmpty()) {
                ArrayList list = new ArrayList(supportVersions);
                String first = (String)Collections.min(list);
                String message3 = "Project depends on com.google.android.support:wearable:" + first + ", so it must also depend (as a provided dependency) on com.google.android.wearable:wearable:" + first;
                if (cookie != null) {
                    this.reportFatalCompatibilityIssue(context, cookie, message3);
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)first, (String)"first");
                    location = Companion.getDependencyLocation(context, GOOGLE_SUPPORT_GROUP_ID, WEARABLE_ARTIFACT_ID, first);
                    this.reportFatalCompatibilityIssue(context, location, message3);
                }
            } else if (!Intrinsics.areEqual(supportVersions, wearableVersions)) {
                ArrayList sortedSupportVersions = new ArrayList(supportVersions);
                CollectionsKt.sort((List)sortedSupportVersions);
                ArrayList supportedWearableVersions = new ArrayList(wearableVersions);
                CollectionsKt.sort((List)supportedWearableVersions);
                String string = "The wearable libraries for %1$s and %2$s must use **exactly** the same versions; found %3$s and %4$s";
                Object[] objectArray = new Object[]{GOOGLE_SUPPORT_GROUP_ID, ANDROID_WEAR_GROUP_ID, sortedSupportVersions.size() == 1 ? (String)sortedSupportVersions.get(0) : sortedSupportVersions.toString(), supportedWearableVersions.size() == 1 ? (String)supportedWearableVersions.get(0) : supportedWearableVersions.toString()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                String message4 = string2;
                if (cookie != null) {
                    this.reportFatalCompatibilityIssue(context, cookie, message4);
                } else {
                    Object e = sortedSupportVersions.get(0);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"sortedSupportVersions[0]");
                    String string3 = (String)e;
                    Object e2 = supportedWearableVersions.get(0);
                    Intrinsics.checkNotNullExpressionValue(e2, (String)"supportedWearableVersions[0]");
                    location = com.android.tools.lint.checks.GradleDetector$Companion.getDependencyLocation$default(Companion, context, GOOGLE_SUPPORT_GROUP_ID, WEARABLE_ARTIFACT_ID, string3, ANDROID_WEAR_GROUP_ID, WEARABLE_ARTIFACT_ID, (String)e2, null, 128, null);
                    this.reportFatalCompatibilityIssue(context, location, message4);
                }
            }
        }
    }

    private final List<LintModelLibrary> getAllLibraries(Project project) {
        Object object = project.getBuildVariant();
        if (object == null || (object = object.getMainArtifact()) == null || (object = object.getDependencies()) == null || (object = object.getAll()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConsistentLibraries(Context context, Object cookie, String groupId, String groupId2) {
        void $this$filterIsInstanceTo$iv$iv;
        Project project = context.getMainProject();
        ArrayListMultimap versionToCoordinate = ArrayListMultimap.create();
        Iterable $this$filterIsInstance$iv = this.getAllLibraries(project);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LintModelExternalLibrary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allLibraries = (List)destination$iv$iv;
        for (LintModelExternalLibrary library : allLibraries) {
            LintModelMavenName coordinates = library.getResolvedCoordinates();
            if (!Intrinsics.areEqual((Object)coordinates.getGroupId(), (Object)groupId) && !Intrinsics.areEqual((Object)coordinates.getGroupId(), (Object)groupId2) || StringsKt.startsWith$default((String)coordinates.getArtifactId(), (String)"multidex", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)coordinates.getArtifactId(), (String)"renderscript", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)coordinates.getArtifactId(), (String)"firebase-jobdispatcher", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)coordinates.getArtifactId(), (Object)"support-annotations")) continue;
            versionToCoordinate.put((Object)coordinates.getVersion(), (Object)coordinates);
        }
        Set versions = versionToCoordinate.keySet();
        if (versions.size() > 1) {
            ArrayList sortedVersions = new ArrayList(versions);
            List list = sortedVersions;
            Comparator comparator = Collections.reverseOrder();
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"reverseOrder()");
            CollectionsKt.sortWith((List)list, comparator);
            List list2 = versionToCoordinate.get(sortedVersions.get(0));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"versionToCoordinate.get(sortedVersions[0])");
            LintModelMavenName c1 = this.findFirst(list2);
            List list3 = versionToCoordinate.get(sortedVersions.get(1));
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"versionToCoordinate.get(sortedVersions[1])");
            LintModelMavenName c2 = this.findFirst(list3);
            if (Intrinsics.areEqual((Object)groupId, (Object)GMS_GROUP_ID) || Intrinsics.areEqual((Object)groupId, (Object)FIREBASE_GROUP_ID)) {
                boolean bl;
                Version version = Version.Companion.parse(c2.getVersion());
                Integer n = version.getMajor();
                if (n != null) {
                    int it = ((Number)n).intValue();
                    boolean bl2 = false;
                    boolean bl3 = it >= 14;
                    bl = !bl3;
                } else {
                    bl = false;
                }
                if (!bl) {
                    return;
                }
            }
            String example1 = c1.getGroupId() + ":" + c1.getArtifactId() + ":" + c1.getVersion();
            String example2 = c2.getGroupId() + ":" + c2.getArtifactId() + ":" + c2.getVersion();
            String groupDesc = Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) ? "gms/firebase" : groupId;
            String message2 = "All " + groupDesc + " libraries must use the exact same version specification (mixing versions can lead to runtime crashes). Found versions " + Joiner.on((String)", ").join((Iterable)sortedVersions) + ". Examples include `" + example1 + "` and `" + example2 + "`";
            if (cookie != null) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, context, cookie, message2, null, 8, null);
            } else {
                Location location = Companion.getDependencyLocation(context, c1, c2);
                this.reportNonFatalCompatibilityIssue(context, location, message2);
            }
        }
    }

    public void beforeCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        ((Map)this.blockedDependencies).put(project, new BlockedDependencies(project));
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        this.checkBlockedDependencies(context, project);
        if (!LintClient.Companion.isGradle()) {
            reservedQuickfixNames = null;
        }
    }

    private final void checkLibraryConsistency(Context context) {
        this.checkConsistentPlayServices(context, null);
        this.checkConsistentWearableLibraries(context, null, null);
    }

    public void visitTomlDocument(@NotNull TomlContext context, @NotNull LintTomlDocument document) {
        LintTomlMapValue plugins;
        Object object;
        LintTomlMapValue libraries;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        LintTomlValue lintTomlValue = document.getValue("libraries");
        LintTomlMapValue lintTomlMapValue = libraries = lintTomlValue instanceof LintTomlMapValue ? (LintTomlMapValue)lintTomlValue : null;
        if (libraries != null) {
            object = document.getValue("versions");
            LintTomlMapValue versions = object instanceof LintTomlMapValue ? (LintTomlMapValue)object : null;
            object = libraries.getMappedValues().entrySet().iterator();
            while (object.hasNext()) {
                Dependency dependency;
                Pair<String, LintTomlValue> pair;
                LintTomlValue library = (LintTomlValue)((Map.Entry)object.next()).getValue();
                if (Lint.getLibraryFromTomlEntry(versions, library) == null) continue;
                String coordinate = (String)pair.component1();
                LintTomlValue versionNode = (LintTomlValue)pair.component2();
                if (Dependency.Companion.parse(coordinate) == null) {
                    return;
                }
                context.getDriver().runLaterOutsideReadAction(new Runnable(this, context, dependency, versionNode, library){
                    final /* synthetic */ GradleDetector this$0;
                    final /* synthetic */ TomlContext $context;
                    final /* synthetic */ Dependency $dependency;
                    final /* synthetic */ LintTomlValue $versionNode;
                    final /* synthetic */ LintTomlValue $library;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        this.$dependency = $dependency;
                        this.$versionNode = $versionNode;
                        this.$library = $library;
                    }

                    public final void run() {
                        GradleDetector.access$checkDependency(this.this$0, (Context)this.$context, this.$dependency, false, this.$versionNode, this.$library);
                    }
                });
            }
        }
        LintTomlMapValue lintTomlMapValue2 = plugins = (object = document.getValue("plugins")) instanceof LintTomlMapValue ? (LintTomlMapValue)object : null;
        if (plugins != null) {
            Object object2 = document.getValue("versions");
            LintTomlMapValue versions = object2 instanceof LintTomlMapValue ? (LintTomlMapValue)object2 : null;
            object2 = plugins.getMappedValues().entrySet().iterator();
            while (object2.hasNext()) {
                Pair<String, LintTomlValue> pair;
                LintTomlValue plugin = (LintTomlValue)((Map.Entry)object2.next()).getValue();
                if (Lint.getPluginFromTomlEntry(versions, plugin) == null) continue;
                String coordinate = (String)pair.component1();
                LintTomlValue versionNode = (LintTomlValue)pair.component2();
                String group = StringsKt.substringBefore$default((String)coordinate, (char)':', null, (int)2, null);
                String gradleCoordinate = group + ":" + group + ".gradle.plugin:" + StringsKt.substringAfterLast$default((String)coordinate, (char)':', null, (int)2, null);
                Dependency dependency = Dependency.Companion.parse(gradleCoordinate);
                context.getDriver().runLaterOutsideReadAction(new Runnable(this, context, dependency, versionNode, plugin){
                    final /* synthetic */ GradleDetector this$0;
                    final /* synthetic */ TomlContext $context;
                    final /* synthetic */ Dependency $dependency;
                    final /* synthetic */ LintTomlValue $versionNode;
                    final /* synthetic */ LintTomlValue $plugin;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        this.$dependency = $dependency;
                        this.$versionNode = $versionNode;
                        this.$plugin = $plugin;
                    }

                    public final void run() {
                        GradleDetector.access$checkDependency(this.this$0, (Context)this.$context, this.$dependency, false, this.$versionNode, this.$plugin);
                    }
                });
            }
        }
    }

    public void afterCheckFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(!this.mAppliedJavaPlugin || this.mDeclaredSourceCompatibility && this.mDeclaredTargetCompatibility)) {
            File file = context.file;
            String contents = ((Object)context.getClient().readFile(file)).toString();
            String message2 = this.mDeclaredTargetCompatibility ? "no Java sourceCompatibility directive" : (this.mDeclaredSourceCompatibility ? "no Java targetCompatibility directive" : "no Java language level directives");
            String fixDisplayName = this.mDeclaredTargetCompatibility ? "Insert sourceCompatibility directive for JDK8" : (this.mDeclaredSourceCompatibility ? "Insert targetCompatibility directive for JDK8" : "Insert JDK8 language level directives");
            String insertion = this.mDeclaredTargetCompatibility ? "\njava.sourceCompatibility = JavaVersion.VERSION_1_8" : (this.mDeclaredSourceCompatibility ? "\njava.targetCompatibility = JavaVersion.VERSION_1_8" : "\njava {\n    sourceCompatibility = JavaVersion.VERSION_1_8\n    targetCompatibility = JavaVersion.VERSION_1_8\n}");
            LintFix fix = this.fix().replace().name(fixDisplayName).range(Location.Companion.create(context.file, (CharSequence)contents, 0, contents.length())).end().with(insertion).build();
            JavaPluginInfo javaPluginInfo = this.mJavaPluginInfo;
            Intrinsics.checkNotNull((Object)javaPluginInfo);
            GradleDetector.report$default(this, context, javaPluginInfo.getCookie(), JAVA_PLUGIN_LANGUAGE_LEVEL, message2, fix, false, null, null, 224, null);
        }
    }

    private final void maybeReportAgpVersionIssue(Context context) {
        block1: {
            if (!this.mDeclaredGoogleMavenRepository && !(context instanceof TomlContext)) break block1;
            AgpVersionCheckInfo agpVersionCheckInfo = this.agpVersionCheckInfo;
            if (agpVersionCheckInfo != null) {
                AgpVersionCheckInfo it = agpVersionCheckInfo;
                boolean bl = false;
                String versionString = it.getNewerVersion().toString();
                RichVersion richVersion = it.getDependency().getVersion();
                String currentIdentifier = richVersion != null ? richVersion.toIdentifier() : null;
                String message2 = this.getNewerVersionAvailableMessage(it.getDependency(), versionString, it.getSafeReplacement());
                LintFix fix = it.isResolved() ? null : (currentIdentifier == null ? null : this.getUpdateDependencyFix(currentIdentifier, versionString, it.getNewerVersionIsSafe(), it.getSafeReplacement()));
                GradleDetector.report$default(this, context, it.getCookie(), AGP_DEPENDENCY, message2, fix, false, null, null, 224, null);
            }
        }
    }

    private final void checkKaptUsage(String dependency, LintTomlValue libTomlValue, GradleContext context, Object statementCookie) {
        LintFix lintFix;
        String module = StringsKt.substringBeforeLast$default((String)dependency, (char)':', null, (int)2, null);
        String string = annotationProcessorsWithKspReplacements.get(module);
        if (string == null) {
            return;
        }
        String replacement = string;
        if (!this.mAppliedKspPlugin) {
            lintFix = this.fix().name("Learn about how to enable KSP and use the KSP processor for this dependency instead").url("https://developer.android.com/studio/build/migrate-to-ksp").build();
        } else if (libTomlValue != null) {
            LintFix lintFix2;
            String[] stringArray;
            boolean declaredWithGroupAndName;
            LintTomlMapValue lintTomlMapValue = libTomlValue instanceof LintTomlMapValue ? (LintTomlMapValue)libTomlValue : null;
            boolean bl = declaredWithGroupAndName = (lintTomlMapValue != null ? lintTomlMapValue.get("group") : null) != null;
            if (declaredWithGroupAndName) {
                stringArray = new String[]{":"};
                List list = StringsKt.split$default((CharSequence)module, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String oldGroup = (String)list.get(0);
                String oldName = (String)list.get(1);
                String[] stringArray2 = new String[]{":"};
                List list2 = StringsKt.split$default((CharSequence)replacement, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                String newGroup = (String)list2.get(0);
                String newName = (String)list2.get(1);
                lintFix2 = this.fix().replace().range(libTomlValue.getLocation()).pattern("((.*)" + oldGroup + "(.*)" + oldName + "(.*))").with("\\k<2>" + newGroup + "\\k<3>" + newName + "\\k<4>").build();
            } else {
                lintFix2 = this.fix().replace().range(libTomlValue.getLocation()).text(module).with(replacement).build();
            }
            LintFix catalogFix = lintFix2;
            LintFix usageFix = this.fix().replace().text("kapt").with("ksp").build();
            stringArray = new LintFix[]{catalogFix, usageFix};
            lintFix = this.fix().name("Replace usage of kapt with KSP").composite((LintFix[])stringArray);
        } else {
            lintFix = this.fix().name("Replace usage of kapt with KSP").replace().pattern("((.*)kapt(.*)" + module + "(.*))").with("\\k<2>ksp\\k<3>" + replacement + "\\k<4>").build();
        }
        LintFix fix = lintFix;
        GradleDetector.report$default(this, (Context)context, statementCookie, KAPT_USAGE_INSTEAD_OF_KSP, "This library supports using KSP instead of kapt, which greatly improves performance. Learn more: https://developer.android.com/studio/build/migrate-to-ksp", fix, false, null, null, 224, null);
    }

    private final void checkForKtxExtension(Context context, String groupId, String artifactId, Version version, Object cookie) {
        if (!this.mAppliedKotlinAndroidPlugin) {
            return;
        }
        if (StringsKt.endsWith$default((String)artifactId, (String)"-ktx", (boolean)false, (int)2, null)) {
            return;
        }
        if (cookie instanceof LintTomlValue) {
            return;
        }
        String mavenName = groupId + ":" + artifactId;
        if (!GradleDetector.Companion.libraryHasKtxExtension(mavenName)) {
            return;
        }
        LintModelVariant lintModelVariant = context.getProject().getBuildVariant();
        if (lintModelVariant == null || (lintModelVariant = lintModelVariant.getArtifact()) == null) {
            return;
        }
        LintModelVariant artifact = lintModelVariant;
        if (artifact.getType() != LintModelArtifactType.MAIN) {
            return;
        }
        if (artifact.findCompileDependency("org.jetbrains.kotlin:kotlin-stdlib") == null) {
            return;
        }
        GoogleMavenRepository repository2 = this.getGoogleMavenRepository(context.getClient());
        if (repository2.findVersion(groupId, artifactId + "-ktx", (Function1)new Function1<Version, Boolean>(version){
            final /* synthetic */ Version $version;
            {
                this.$version = $version;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Version it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)this.$version);
            }
        }, true) == null) {
            return;
        }
        String msg = "Add suffix `-ktx` to enable the Kotlin extensions for this library";
        LintFix fix = this.fix().name("Replace with KTX dependency").replace().text(mavenName).with(mavenName + "-ktx").build();
        GradleDetector.report$default(this, context, cookie, KTX_EXTENSION_AVAILABLE, msg, fix, false, null, null, 224, null);
    }

    private final void checkForBomUsageWithoutPlatform(String property, String dependency, String value, GradleContext context, Object valueCookie) {
        boolean bl;
        block5: {
            Object[] objectArray = new String[]{"platform", "enforcedPlatform"};
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)value, (String)(it + "("), (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        if (commonBoms.contains(StringsKt.substringBeforeLast$default((String)dependency, (char)':', null, (int)2, null)) && (Companion.CompileConfiguration.IMPLEMENTATION.matches(property) || Companion.CompileConfiguration.API.matches(property))) {
            String message2 = "BOM should be added with a call to platform()";
            LintFix fix = this.fix().name("Add platform() to BOM declaration", true).replace().text(value).with("platform(" + value + ")").build();
            GradleDetector.report$default(this, (Context)context, valueCookie, BOM_WITHOUT_PLATFORM, message2, fix, false, null, null, 224, null);
        }
    }

    private final void checkBlockedDependencies(Context context, Project project) {
        BlockedDependencies blockedDependencies = this.blockedDependencies.get(project);
        if (blockedDependencies == null) {
            return;
        }
        BlockedDependencies blockedDependencies2 = blockedDependencies;
        List<List<LintModelDependency>> dependencies = blockedDependencies2.getForbiddenDependencies();
        if (!((Collection)dependencies).isEmpty()) {
            for (List<LintModelDependency> path : dependencies) {
                Location location;
                LintModelMavenName gc;
                LintModelMavenName lintModelMavenName;
                String message2 = this.getBlockedDependencyMessage(path);
                File projectDir = context.getProject().getDir();
                if (path.get(0).findLibrary() != null) {
                    LintModelLibrary it;
                    boolean bl = false;
                    lintModelMavenName = it instanceof LintModelExternalLibrary ? ((LintModelExternalLibrary)it).getResolvedCoordinates() : null;
                } else {
                    lintModelMavenName = gc = null;
                }
                if (gc != null) {
                    location = Companion.getDependencyLocation(context, gc.getGroupId(), gc.getArtifactId(), gc.getVersion());
                } else {
                    String mavenName = path.get(0).getArtifactName();
                    LintClient lintClient = context.getClient();
                    Intrinsics.checkNotNullExpressionValue((Object)projectDir, (String)"projectDir");
                    location = com.android.tools.lint.detector.api.Lint.guessGradleLocation((LintClient)lintClient, (File)projectDir, (String)mavenName);
                }
                Location location2 = location;
                context.report(new Incident(DUPLICATE_CLASSES, location2, message2), this.map());
            }
        }
        this.blockedDependencies.remove(project);
    }

    private final boolean report(Context context, Object cookie, Issue issue, String message2, LintFix fix, boolean partial, Severity overrideSeverity, Constraint constraint) {
        Ref.BooleanRef reportCreated = new Ref.BooleanRef();
        context.getClient().runReadAction(new Runnable(context, issue, cookie, message2, fix, overrideSeverity, constraint, partial, this, reportCreated){
            final /* synthetic */ Context $context;
            final /* synthetic */ Issue $issue;
            final /* synthetic */ Object $cookie;
            final /* synthetic */ String $message;
            final /* synthetic */ LintFix $fix;
            final /* synthetic */ Severity $overrideSeverity;
            final /* synthetic */ Constraint $constraint;
            final /* synthetic */ boolean $partial;
            final /* synthetic */ GradleDetector this$0;
            final /* synthetic */ Ref.BooleanRef $reportCreated;
            {
                this.$context = $context;
                this.$issue = $issue;
                this.$cookie = $cookie;
                this.$message = $message;
                this.$fix = $fix;
                this.$overrideSeverity = $overrideSeverity;
                this.$constraint = $constraint;
                this.$partial = $partial;
                this.this$0 = $receiver;
                this.$reportCreated = $reportCreated;
            }

            public final void run() {
                boolean enabled = this.$context.isEnabled(this.$issue);
                if (enabled && this.$context instanceof GradleContext) {
                    Location location = ((GradleContext)this.$context).getLocation(this.$cookie);
                    Incident incident = new Incident(this.$issue, this.$cookie, location, this.$message, this.$fix);
                    Severity severity = this.$overrideSeverity;
                    if (severity != null) {
                        Severity it = severity;
                        boolean bl = false;
                        incident.overrideSeverity(it);
                    }
                    if (this.$constraint != null) {
                        this.$context.report(incident, this.$constraint);
                    } else if (this.$partial) {
                        this.$context.report(incident, GradleDetector.access$map(this.this$0));
                    } else {
                        this.$context.report(incident);
                    }
                    this.$reportCreated.element = true;
                } else if (enabled && this.$context instanceof TomlContext) {
                    Location location = Context.getLocation$default((Context)this.$context, (Object)this.$cookie, null, (int)2, null);
                    Position position = location.getStart();
                    int start = position != null ? position.getOffset() : 0;
                    boolean checkComments = this.$context.containsCommentSuppress();
                    if (checkComments && this.$context.isSuppressedWithComment(start, this.$issue)) {
                        return;
                    }
                    Incident incident = new Incident(this.$issue, location, this.$message, this.$fix);
                    Severity severity = this.$overrideSeverity;
                    if (severity != null) {
                        Severity it = severity;
                        boolean bl = false;
                        incident.overrideSeverity(it);
                    }
                    if (this.$constraint != null) {
                        this.$context.report(incident, this.$constraint);
                    } else if (this.$partial) {
                        this.$context.report(incident, GradleDetector.access$map(this.this$0));
                    } else {
                        this.$context.report(incident);
                    }
                    this.$reportCreated.element = true;
                }
            }
        });
        return reportCreated.element;
    }

    static /* synthetic */ boolean report$default(GradleDetector gradleDetector, Context context, Object object, Issue issue, String string, LintFix lintFix, boolean bl, Severity severity, Constraint constraint, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            severity = null;
        }
        if ((n & 0x80) != 0) {
            constraint = null;
        }
        return gradleDetector.report(context, object, issue, string, lintFix, bl, severity, constraint);
    }

    private final void reportFatalCompatibilityIssue(Context context, Object cookie, String message2) {
        GradleDetector.report$default(this, context, cookie, COMPATIBILITY, message2, null, false, null, null, 240, null);
    }

    private final void reportFatalCompatibilityIssue(Context context, Object cookie, String message2, LintFix fix) {
        GradleDetector.report$default(this, context, cookie, COMPATIBILITY, message2, fix, false, null, null, 224, null);
    }

    private final void reportNonFatalCompatibilityIssue(Context context, Object cookie, String message2, LintFix lintFix) {
        if (context.getDriver().getFatalOnlyMode()) {
            return;
        }
        GradleDetector.report$default(this, context, cookie, COMPATIBILITY, message2, lintFix, false, null, null, 224, null);
    }

    static /* synthetic */ void reportNonFatalCompatibilityIssue$default(GradleDetector gradleDetector, Context context, Object object, String string, LintFix lintFix, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportNonFatalCompatibilityIssue");
        }
        if ((n & 8) != 0) {
            lintFix = null;
        }
        gradleDetector.reportNonFatalCompatibilityIssue(context, object, string, lintFix);
    }

    private final void reportFatalCompatibilityIssue(Context context, Location location, String message2) {
        context.getClient().runReadAction(new Runnable(context, location, message2){
            final /* synthetic */ Context $context;
            final /* synthetic */ Location $location;
            final /* synthetic */ String $message;
            {
                this.$context = $context;
                this.$location = $location;
                this.$message = $message;
            }

            public final void run() {
                Context.report$default((Context)this.$context, (Issue)GradleDetector.COMPATIBILITY, (Location)this.$location, (String)this.$message, null, (int)8, null);
            }
        });
    }

    private final void reportNonFatalCompatibilityIssue(Context context, Location location, String message2) {
        if (context.getDriver().getFatalOnlyMode()) {
            return;
        }
        context.getClient().runReadAction(new Runnable(context, location, message2){
            final /* synthetic */ Context $context;
            final /* synthetic */ Location $location;
            final /* synthetic */ String $message;
            {
                this.$context = $context;
                this.$location = $location;
                this.$message = $message;
            }

            public final void run() {
                Context.report$default((Context)this.$context, (Issue)GradleDetector.COMPATIBILITY, (Location)this.$location, (String)this.$message, null, (int)8, null);
            }
        });
    }

    private final int getSdkVersion(String value, Object valueCookie) {
        int version = 0;
        if (GradleContext.Companion.isStringLiteral(value)) {
            String codeName = GradleContext.Companion.getStringLiteralValue(value, valueCookie);
            if (codeName != null) {
                if (com.android.tools.lint.detector.api.Lint.isNumberString((String)codeName)) {
                    return -1;
                }
                AndroidVersion androidVersion = SdkVersionInfo.getVersion((String)codeName, null);
                if (androidVersion != null) {
                    version = androidVersion.getFeatureLevel();
                }
            }
        } else {
            version = GradleContext.Companion.getIntLiteralValue(value, -1);
        }
        return version;
    }

    private final Dependency resolveCoordinate(GradleContext context, String property, Dependency dependency) {
        boolean bl;
        Object object = dependency.getVersion();
        boolean bl2 = object != null && (object = object.toIdentifier()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"$", (boolean)false, (int)2, null) : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-GradleDetector$resolveCoordinate$22 = false;
            String $i$a$-assert-GradleDetector$resolveCoordinate$22 = String.valueOf(dependency.getVersion());
            throw new AssertionError((Object)$i$a$-assert-GradleDetector$resolveCoordinate$22);
        }
        Project project = context.getProject();
        LintModelVariant variant = project.getBuildVariant();
        if (variant != null) {
            LintModelArtifact lintModelArtifact = StringsKt.startsWith$default((String)property, (String)"androidTest", (boolean)false, (int)2, null) ? (LintModelArtifact)variant.getAndroidTestArtifact() : (StringsKt.startsWith$default((String)property, (String)"testFixtures", (boolean)false, (int)2, null) ? (LintModelArtifact)variant.getTestFixturesArtifact() : (StringsKt.startsWith$default((String)property, (String)"test", (boolean)false, (int)2, null) ? (LintModelArtifact)variant.getTestArtifact() : (LintModelArtifact)variant.getMainArtifact()));
            if (lintModelArtifact == null) {
                return null;
            }
            LintModelArtifact artifact = lintModelArtifact;
            for (LintModelLibrary library : artifact.getDependencies().getAll()) {
                LintModelMavenName mc;
                if (!(library instanceof LintModelExternalLibrary) || !Intrinsics.areEqual((Object)(mc = ((LintModelExternalLibrary)library).getResolvedCoordinates()).getGroupId(), (Object)dependency.getGroup()) || !Intrinsics.areEqual((Object)mc.getArtifactId(), (Object)dependency.getName())) continue;
                Version version = Version.Companion.parse(mc.getVersion());
                return GradleDetector.resolveCoordinate$toDependency(new Component(mc.getGroupId(), mc.getArtifactId(), version));
            }
        }
        return null;
    }

    private final boolean usesLegacyHttpLibrary(Project project) {
        LintModelModule lintModelModule = project.getBuildModule();
        if (lintModelModule == null) {
            return false;
        }
        LintModelModule model2 = lintModelModule;
        for (File file : model2.getBootClassPath()) {
            if (!FilesKt.endsWith((File)file, (String)"org.apache.http.legacy.jar")) continue;
            return true;
        }
        return false;
    }

    private final LintFix getUpdateDependencyFix(String currentVersion, String suggestedVersion, boolean suggestedVersionIsSafe, Version safeReplacement) {
        LintFix lintFix;
        LintFix fix = this.fix().name("Change to " + suggestedVersion).sharedName("Update versions").replace().text(currentVersion).with(suggestedVersion).autoFix(suggestedVersionIsSafe, suggestedVersionIsSafe).build();
        if (safeReplacement != null) {
            String stableVersion = safeReplacement.toString();
            LintFix stableFix = this.fix().name("Change to " + stableVersion).sharedName("Update versions").replace().text(currentVersion).with(stableVersion).autoFix().build();
            LintFix[] lintFixArray = new LintFix[]{fix, stableFix};
            lintFix = this.fix().alternatives(lintFixArray);
        } else {
            lintFix = fix;
        }
        return lintFix;
    }

    static /* synthetic */ LintFix getUpdateDependencyFix$default(GradleDetector gradleDetector, String string, String string2, boolean bl, Version version, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUpdateDependencyFix");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            version = null;
        }
        return gradleDetector.getUpdateDependencyFix(string, string2, bl, version);
    }

    private final String id(Dependency $this$id) {
        Object object;
        if (this.isGradlePlugin($this$id)) {
            String string = $this$id.getGroup();
            object = string;
            Intrinsics.checkNotNull((Object)string);
        } else {
            object = $this$id.getGroup() + ":" + $this$id.getName();
        }
        return object;
    }

    private final boolean isGradlePlugin(Dependency $this$isGradlePlugin) {
        return $this$isGradlePlugin.getGroup() != null && StringsKt.endsWith$default((String)$this$isGradlePlugin.getName(), (String)".gradle.plugin", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)$this$isGradlePlugin.getName(), (Object)($this$isGradlePlugin.getGroup() + ".gradle.plugin"));
    }

    private final String getNewerVersionAvailableMessage(Dependency dependency, String version, Version stable) {
        StringBuilder message2;
        StringBuilder $this$getNewerVersionAvailableMessage_u24lambda_u2420 = message2 = new StringBuilder();
        boolean bl = false;
        $this$getNewerVersionAvailableMessage_u24lambda_u2420.append("A newer version of ");
        $this$getNewerVersionAvailableMessage_u24lambda_u2420.append(this.id(dependency));
        $this$getNewerVersionAvailableMessage_u24lambda_u2420.append(" than ");
        $this$getNewerVersionAvailableMessage_u24lambda_u2420.append(String.valueOf(dependency.getVersion()));
        $this$getNewerVersionAvailableMessage_u24lambda_u2420.append(" is available: ");
        $this$getNewerVersionAvailableMessage_u24lambda_u2420.append(version);
        if (stable != null) {
            $this$getNewerVersionAvailableMessage_u24lambda_u2420.append(". (There is also a newer version of ");
            $this$getNewerVersionAvailableMessage_u24lambda_u2420.append(String.valueOf(stable.getMajor()));
            $this$getNewerVersionAvailableMessage_u24lambda_u2420.append(".");
            $this$getNewerVersionAvailableMessage_u24lambda_u2420.append(String.valueOf(stable.getMinor()));
            $this$getNewerVersionAvailableMessage_u24lambda_u2420.append(".\ud835\udc65 available, if upgrading to ");
            $this$getNewerVersionAvailableMessage_u24lambda_u2420.append(version);
            $this$getNewerVersionAvailableMessage_u24lambda_u2420.append(" is difficult: ");
            $this$getNewerVersionAvailableMessage_u24lambda_u2420.append(stable.toString());
            $this$getNewerVersionAvailableMessage_u24lambda_u2420.append(")");
        }
        String string = message2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.toString()");
        return string;
    }

    private final LintModelMavenName findFirst(Collection<? extends LintModelMavenName> coordinates) {
        LintModelMavenName lintModelMavenName = Collections.min(coordinates, findFirst.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)lintModelMavenName, (String)"min(coordinates) { o1, o\u2026ompareTo(o2.toString()) }");
        return lintModelMavenName;
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Issue issue = incident.getIssue();
        if (issue == DUPLICATE_CLASSES) {
            return context.getMainProject().getMinSdk() < 23 || this.usesLegacyHttpLibrary(context.getMainProject());
        }
        throw new IllegalStateException(issue.getId().toString());
    }

    public void checkMergedProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isGlobalAnalysis() && context.getDriver().isIsolated()) {
            return;
        }
        this.checkLibraryConsistency(context);
    }

    private final String getBlockedDependencyMessage(List<? extends LintModelDependency> path) {
        boolean direct = path.size() == 1;
        String message2 = null;
        String resolution = "Solutions include finding newer versions or alternative libraries that don't have the same problem (for example, for `httpclient` use `HttpUrlConnection` or `okhttp` instead), or repackaging the library using something like `jarjar`.";
        if (direct) {
            message2 = "`" + path.get(0).getArtifactId() + "` defines classes that conflict with classes now provided by Android. " + resolution;
        } else {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (LintModelDependency lintModelDependency : path) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" \u2192 ");
                }
                String coordinates = lintModelDependency.getArtifactName();
                sb.append(coordinates);
            }
            sb.append(") ");
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            String chain = string;
            message2 = "`" + path.get(0).getArtifactId() + "` depends on a library (" + path.get(path.size() - 1).getArtifactName() + ") which defines classes that conflict with classes now provided by Android. " + resolution + " Dependency chain: " + chain;
        }
        return message2;
    }

    private final Version getNewerVersion(Version version1, int major, int minor, int micro) {
        Version version;
        Version it = version = Version.Companion.parse(major + "." + minor + "." + micro);
        boolean bl = false;
        return version1.compareTo(Version.Companion.prefixInfimum("0")) > 0 && version1.compareTo(it) < 0 ? version : null;
    }

    private final Version getNewerVersion(Version version1, int major, int minor) {
        Version version;
        Version it = version = Version.Companion.parse(major + "." + minor);
        boolean bl = false;
        return version1.compareTo(Version.Companion.prefixInfimum("0")) > 0 && version1.compareTo(it) < 0 ? version : null;
    }

    private final Version getGoogleMavenRepoVersion(Context context, Dependency dependency, Predicate<Version> filter) {
        GoogleMavenRepository repository2 = this.getGoogleMavenRepository(context.getClient());
        return repository2.findVersion(dependency, filter, dependency.getExplicitlyIncludesPreview());
    }

    @NotNull
    public final GoogleMavenRepository getGoogleMavenRepository(@NotNull LintClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        GoogleMavenRepository googleMavenRepository = this.googleMavenRepository;
        if (googleMavenRepository == null) {
            File cacheDir;
            GradleDetector $this$getGoogleMavenRepository_u24lambda_u2423 = this;
            boolean bl = false;
            File file = cacheDir = client.getCacheDir("maven.google", true);
            Path path = file != null ? file.toPath() : null;
            GoogleMavenRepository repository2 = new GoogleMavenRepository(client, path){
                final /* synthetic */ LintClient $client;
                {
                    this.$client = $client;
                    super($super_call_param$1, 0, 0, false, 14, null);
                }

                @NotNull
                public NetworkCache.ReadUrlDataResult readUrlData(@NotNull String url, int timeout, long lastModified) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    return com.android.tools.lint.detector.api.Lint.readUrlData((LintClient)this.$client, (String)url, (int)timeout, (long)lastModified);
                }

                public void error(@NotNull Throwable throwable, @Nullable String message2) {
                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                    this.$client.log(throwable, message2, new Object[0]);
                }
            };
            $this$getGoogleMavenRepository_u24lambda_u2423.googleMavenRepository = repository2;
            googleMavenRepository = repository2;
        }
        return googleMavenRepository;
    }

    private final GooglePlaySdkIndex getGooglePlaySdkIndex(LintClient client) {
        GooglePlaySdkIndex googlePlaySdkIndex = this.googlePlaySdkIndex;
        if (googlePlaySdkIndex == null) {
            GooglePlaySdkIndex repository2;
            File cacheDir;
            GradleDetector $this$getGooglePlaySdkIndex_u24lambda_u2424 = this;
            boolean bl = false;
            File file = cacheDir = client.getCacheDir("sdk_index", true);
            $this$getGooglePlaySdkIndex_u24lambda_u2424.googlePlaySdkIndex = repository2 = (GooglePlaySdkIndex)((Object)playSdkIndexFactory.invoke((Object)(file != null ? file.toPath() : null), (Object)client));
            googlePlaySdkIndex = repository2;
        }
        return googlePlaySdkIndex;
    }

    private static final Predicate<Version> checkDependency$and(Predicate<Version> $this$checkDependency_u24and, Predicate<Version> other) {
        Predicate<Version> predicate;
        if ($this$checkDependency_u24and != null && other != null) {
            predicate = $this$checkDependency_u24and.and(other);
        } else {
            predicate = $this$checkDependency_u24and;
            if (predicate == null) {
                predicate = other;
            }
        }
        return predicate;
    }

    private static final Dependency resolveCoordinate$toDependency(Component $this$resolveCoordinate_u24toDependency) {
        return new Dependency($this$resolveCoordinate_u24toDependency.getGroup(), $this$resolveCoordinate_u24toDependency.getName(), RichVersion.Companion.require($this$resolveCoordinate_u24toDependency.getVersion()), null, null, 24, null);
    }

    @JvmStatic
    @Nullable
    public static final Version getLatestVersionFromRemoteRepo(@NotNull LintClient client, @NotNull Dependency dependency, @Nullable Predicate<Version> filter, boolean allowPreview) {
        return Companion.getLatestVersionFromRemoteRepo(client, dependency, filter, allowPreview);
    }

    @JvmStatic
    @Nullable
    public static final String getNamedDependency(@NotNull String expression) {
        return Companion.getNamedDependency(expression);
    }

    @NotNull
    public static final Function2<Path, LintClient, GooglePlaySdkIndex> getPlaySdkIndexFactory() {
        return Companion.getPlaySdkIndexFactory();
    }

    public static final void setPlaySdkIndexFactory(@NotNull Function2<? super Path, ? super LintClient, ? extends GooglePlaySdkIndex> function2) {
        Companion.setPlaySdkIndexFactory(function2);
    }

    public static final /* synthetic */ void access$checkDependency(GradleDetector $this, Context context, Dependency dependency, boolean isResolved, Object cookie, Object statementCookie) {
        $this.checkDependency(context, dependency, isResolved, cookie, statementCookie);
    }

    public static final /* synthetic */ boolean access$isOldApacheCommonsVersion(GradleDetector $this, Version $receiver) {
        return $this.isOldApacheCommonsVersion($receiver);
    }

    public static final /* synthetic */ LintMap access$map(GradleDetector $this) {
        return $this.map();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$flatMapTo$iv$iv;
        Companion = new Companion(null);
        lastTargetSdkVersion = -1;
        IMPLEMENTATION = new Implementation(GradleDetector.class, Scope.GRADLE_SCOPE);
        Object[] objectArray = new EnumSet[]{Scope.GRADLE_SCOPE, Scope.TOML_SCOPE};
        IMPLEMENTATION_WITH_TOML = new Implementation(GradleDetector.class, Scope.GRADLE_AND_TOML_SCOPE, (EnumSet[])objectArray);
        objectArray = new EnumSet[]{Scope.GRADLE_SCOPE, Scope.MANIFEST_SCOPE};
        IMPLEMENTATION_WITH_MANIFEST = new Implementation(GradleDetector.class, EnumSet.of((Enum)Scope.GRADLE_FILE, (Enum)Scope.MANIFEST), (EnumSet[])objectArray);
        DEPENDENCY = Issue.Companion.create("GradleDependency", "Obsolete Gradle Dependency", "\n                This detector looks for usages of libraries where the version you are using \\\n                is not the current stable release. Using older versions is fine, and there \\\n                are cases where you deliberately want to stick with an older version. \\\n                However, you may simply not be aware that a more recent version is \\\n                available, and that is what this lint check helps find.", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION_WITH_TOML);
        objectArray = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Object object = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION_WITH_TOML;
        CREDENTIAL_DEP = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"CredentialDependency", (String)"`credentials-play-services-auth` is Required", (String)"\n          The dependency `androidx.credentials:credentials-play-services-auth` is required \\\n          to get support from Play services for the  Credential Manager API to work. \\\n          For Android 14 or higher, this is optional. Please check release notes for the \\\n          latest version.\n          ", (Implementation)implementation, (String)"https://developer.android.com/jetpack/androidx/releases/credentials", (Category)category, (int)5, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        SWITCH_TO_TOML = Issue.Companion.create("UseTomlInstead", "Use TOML Version Catalog Instead", "\n                If your project is using a `libs.versions.toml` file, you should place \\\n                all Gradle dependencies in the TOML file. This lint check looks for \\\n                version declarations outside of the TOML file and suggests moving them \\\n                (and in the IDE, provides a quickfix to performing the operation automatically).\n                ", Category.PRODUCTIVITY, 4, Severity.WARNING, IMPLEMENTATION_WITH_TOML);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION_WITH_TOML;
        AGP_DEPENDENCY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"AndroidGradlePluginVersion", (String)"Obsolete Android Gradle Plugin Version", (String)"\n                This detector looks for usage of the Android Gradle Plugin where the version \\\n                you are using is not the current stable release. Using older versions is fine, \\\n                and there are cases where you deliberately want to stick with an older version. \\\n                However, you may simply not be aware that a more recent version is available, \\\n                and that is what this lint check helps find.", (Implementation)implementation, null, (Category)category, (int)4, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DEPRECATED = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"GradleDeprecated", (String)"Deprecated Gradle Construct", (String)"\n                This detector looks for deprecated Gradle constructs which currently work \\\n                but will likely stop working in a future update.", (Implementation)implementation, null, (Category)category, (int)6, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DEPRECATED_CONFIGURATION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"GradleDeprecatedConfiguration", (String)"Deprecated Gradle Configuration", (String)"\n                Some Gradle configurations have been deprecated since Android Gradle Plugin 3.0.0 \\\n                and will be removed in a future version of the Android Gradle Plugin.\n             ", (Implementation)implementation, (String)"https://d.android.com/r/tools/update-dependency-configurations", (Category)category, (int)6, (Severity)object, (boolean)false, null, null, null, (int)3840, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        GRADLE_PLUGIN_COMPATIBILITY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"GradlePluginVersion", (String)"Incompatible Android Gradle Plugin", (String)"\n                Not all versions of the Android Gradle plugin are compatible with all \\\n                versions of the SDK. If you update your tools, or if you are trying to \\\n                open a project that was built with an old version of the tools, you may \\\n                need to update your plugin version number.", (Implementation)implementation, null, (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        PATH = Issue.Companion.create("GradlePath", "Gradle Path Issues", "\n                Gradle build scripts are meant to be cross platform, so file paths use \\\n                Unix-style path separators (a forward slash) rather than Windows path \\\n                separators (a backslash). Similarly, to keep projects portable and \\\n                repeatable, avoid using absolute paths on the system; keep files within \\\n                the project instead. To share code between projects, consider creating \\\n                an android-library and an AAR dependency", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        IDE_SUPPORT = Issue.Companion.create("GradleIdeError", "Gradle IDE Support Issues", "\n                Gradle is highly flexible, and there are things you can do in Gradle \\\n                files which can make it hard or impossible for IDEs to properly handle \\\n                the project. This lint check looks for constructs that potentially \\\n                break IDE support.", Category.CORRECTNESS, 4, Severity.ERROR, IMPLEMENTATION);
        PLUS = Issue.Companion.create("GradleDynamicVersion", "Gradle Dynamic Version", "\n                Using `+` in dependencies lets you automatically pick up the latest \\\n                available version rather than a specific, named version. However, \\\n                this is not recommended; your builds are not repeatable; you may have \\\n                tested with a slightly different version than what the build server \\\n                used. (Using a dynamic version as the major version number is more \\\n                problematic than using it in the minor version position.)", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        GRADLE_GETTER = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"GradleGetter", (String)"Gradle Implicit Getter Call", (String)"\n                Gradle will let you replace specific constants in your build scripts \\\n                with method calls, so you can for example dynamically compute a version \\\n                string based on your current version control revision number, rather \\\n                than hardcoding a number.\n\n                When computing a version name, it's tempting to for example call the \\\n                method to do that `getVersionName`. However, when you put that method \\\n                call inside the `defaultConfig` block, you will actually be calling the \\\n                Groovy getter for the `versionName` property instead. Therefore, you \\\n                need to name your method something which does not conflict with the \\\n                existing implicit getters. Consider using `compute` as a prefix instead \\\n                of `get`.", (Implementation)implementation, null, (Category)category, (int)6, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.FATAL;
        implementation = IMPLEMENTATION;
        COMPATIBILITY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"GradleCompatible", (String)"Incompatible Gradle Versions", (String)"\n                There are some combinations of libraries, or tools and libraries, that \\\n                are incompatible, or can lead to bugs. One such incompatibility is \\\n                compiling with a version of the Android support libraries that is not \\\n                the latest version (or in particular, a version lower than your \\\n                `targetSdkVersion`).", (Implementation)implementation, null, (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        STRING_INTEGER = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"StringShouldBeInt", (String)"String should be int", (String)"\n                The properties `compileSdkVersion`, `minSdkVersion` and `targetSdkVersion` \\\n                are usually numbers, but can be strings when you are using an add-on (in \\\n                the case of `compileSdkVersion`) or a preview platform (for the other two \\\n                properties).\n\n                However, you can not use a number as a string (e.g. \"19\" instead of 19); \\\n                that will result in a platform not found error message at build/sync \\\n                time.", (Implementation)implementation, null, (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        NOT_INTERPOLATED = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"NotInterpolated", (String)"Incorrect Interpolation", (String)"\n                To insert the value of a variable, you can use `${variable}` inside a \\\n                string literal, but **only** if you are using double quotes!", (Implementation)implementation, (String)"https://www.groovy-lang.org/syntax.html#_string_interpolation", (Category)category, (int)8, (Severity)object, (boolean)false, null, null, null, (int)3840, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION_WITH_TOML;
        REMOTE_VERSION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"NewerVersionAvailable", (String)"Newer Library Versions Available", (String)"\n                This detector checks with a central repository to see if there are newer \\\n                versions available for the dependencies used by this project. This is \\\n                similar to the `GradleDependency` check, which checks for newer versions \\\n                available in the Android SDK tools and libraries, but this works with any \\\n                MavenCentral dependency, and connects to the library every time, which \\\n                makes it more flexible but also **much** slower.", (Implementation)implementation, null, (Category)category, (int)4, (Severity)object, (boolean)false, null, null, null, (int)3600, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        MIN_SDK_TOO_LOW = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"MinSdkTooLow", (String)"API Version Too Low", (String)"\n                The value of the `minSdkVersion` property is too low and can be \\\n                incremented without noticeably reducing the number of supported \\\n                devices.", (Implementation)implementation, null, (Category)category, (int)4, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3088, null);
        ACCIDENTAL_OCTAL = Issue.Companion.create("AccidentalOctal", "Accidental Octal", "\n                In Groovy, an integer literal that starts with a leading 0 will be \\\n                interpreted as an octal number. That is usually (always?) an accident \\\n                and can lead to subtle bugs, for example when used in the `versionCode` \\\n                of an app.", Category.CORRECTNESS, 2, Severity.ERROR, IMPLEMENTATION);
        objectArray = Issue.Companion;
        category = Category.PERFORMANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        BUNDLED_GMS = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"UseOfBundledGooglePlayServices", (String)"Use of bundled version of Google Play services", (String)"\n                Google Play services SDK's can be selectively included, which enables a \\\n                smaller APK size. Consider declaring dependencies on individual Google \\\n                Play services SDK's. If you are using Firebase API's \\\n                (https://firebase.google.com/docs/android/setup), Android Studio's \\\n                Tools \u2192 Firebase assistant window can automatically add just the \\\n                dependencies needed for each feature.", (Implementation)implementation, (String)"https://developers.google.com/android/guides/setup#split", (Category)category, (int)4, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        HIGH_APP_VERSION_CODE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"HighAppVersionCode", (String)"VersionCode too high", (String)"\n                The declared `versionCode` is an Integer. Ensure that the version number is \\\n                not close to the limit. It is recommended to monotonically increase this \\\n                number each minor or major release of the app. Note that updating an app \\\n                with a versionCode over `Integer.MAX_VALUE` is not possible.", (Implementation)implementation, (String)"https://developer.android.com/studio/publish/versioning.html", (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.PERFORMANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DEV_MODE_OBSOLETE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"DevModeObsolete", (String)"Dev Mode Obsolete", (String)"\n                In the past, our documentation recommended creating a `dev` product flavor \\\n                with has a minSdkVersion of 21, in order to enable multidexing to speed up \\\n                builds significantly during development.\n\n                That workaround is no longer necessary, and it has some serious downsides, \\\n                such as breaking API access checking (since the true `minSdkVersion` is no \\\n                longer known).\n\n                In recent versions of the IDE and the Gradle plugin, the IDE automatically \\\n                passes the API level of the connected device used for deployment, and if \\\n                that device is at least API 21, then multidexing is automatically turned \\\n                on, meaning that you get the same speed benefits as the `dev` product \\\n                flavor but without the downsides.", (Implementation)implementation, null, (Category)category, (int)2, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.FATAL;
        implementation = IMPLEMENTATION;
        DUPLICATE_CLASSES = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"DuplicatePlatformClasses", (String)"Duplicate Platform Classes", (String)"\n                There are a number of libraries that duplicate not just functionality \\\n                of the Android platform but using the exact same class names as the ones \\\n                provided in Android -- for example the apache http classes. This can \\\n                lead to unexpected crashes.\n\n                To solve this, you need to either find a newer version of the library \\\n                which no longer has this problem, or to repackage the library (and all \\\n                of its dependencies) using something like the `jarjar` tool, or finally, \\\n                rewriting the code to use different APIs (for example, for http code, \\\n                consider using `HttpUrlConnection` or a library like `okhttp`).", (Implementation)implementation, null, (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.COMPLIANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION_WITH_MANIFEST;
        EXPIRING_TARGET_SDK_VERSION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"ExpiringTargetSdkVersion", (String)"TargetSdkVersion Soon Expiring", (String)"\n                Configuring your app to target a recent API level ensures that users benefit \\\n                from significant security and performance improvements, while still allowing \\\n                your app to run on older Android versions (down to the `minSdkVersion`).\n\n                To update your `targetSdkVersion`, follow the steps from \\\n                \"Meeting Google Play requirements for target API level\", \\\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ", (Implementation)implementation, null, (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null).addMoreInfo("https://support.google.com/googleplay/android-developer/answer/113469#targetsdk").addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html");
        objectArray = Issue.Companion;
        category = Category.COMPLIANCE;
        object = Severity.FATAL;
        implementation = IMPLEMENTATION_WITH_MANIFEST;
        EXPIRED_TARGET_SDK_VERSION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"ExpiredTargetSdkVersion", (String)"TargetSdkVersion No Longer Supported", (String)"\n                Configuring your app to target a recent API level ensures that users benefit \\\n                from significant security and performance improvements, while still allowing \\\n                your app to run on older Android versions (down to the `minSdkVersion`).\n\n                To update your `targetSdkVersion`, follow the steps from \\\n                \"Meeting Google Play requirements for target API level\", \\\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ", (Implementation)implementation, (String)"https://support.google.com/googleplay/android-developer/answer/113469#targetsdk", (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null).addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html");
        TARGET_NEWER = Issue.Companion.create("OldTargetApi", "Target SDK attribute is not targeting latest version", "\n                When your application runs on a version of Android that is more recent than your \\\n                `targetSdkVersion` specifies that it has been tested with, various compatibility modes \\\n                kick in. This ensures that your application continues to work, but it may look out of \\\n                place. For example, if the `targetSdkVersion` is less than 14, your app may get an \\\n                option button in the UI.\n\n                To fix this issue, set the `targetSdkVersion` to the highest available value. Then test \\\n                your app to make sure everything works correctly. You may want to consult the \\\n                compatibility notes to see what changes apply to each version you are adding support \\\n                for: https://developer.android.com/reference/android/os/Build.VERSION_CODES.html as well \\\n                as follow this guide:\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION_WITH_MANIFEST).addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html").addMoreInfo("https://developer.android.com/reference/android/os/Build.VERSION_CODES.html");
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        EDITED_TARGET_SDK_VERSION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"EditedTargetSdkVersion", (String)"Manually Edited TargetSdkVersion", (String)"\n        Updating the `targetSdkVersion` of an app is seemingly easy: just increment the \\\n        `targetSdkVersion` number in the manifest file!\n\n        But that's not actually safe. The `targetSdkVersion` controls a wide range of \\\n        behaviors that change from release to release, and to update, you should carefully \\\n        consult the documentation to see what has changed, how your app may need to adjust, \\\n        and then of course, carefully test everything.\n\n        In new versions of Android Studio, there is a special migration assistant, available \\\n        from the tools menu (and as a quickfix from this lint warning) which analyzes your \\\n        specific app and filters the set of applicable migration steps to those needed for \\\n        your app.\n\n        This lint check does something very simple: it just detects whether it looks like \\\n        you've manually edited the targetSdkVersion field in a build.gradle file. Obviously, \\\n        as part of doing the above careful steps, you may end up editing the value, which \\\n        would trigger the check -- and it's safe to ignore it; this lint check *only* runs \\\n        in the IDE, not from the command line; it's sole purpose to bring *awareness* to the \\\n        (many) developers who haven't been aware of this issue and have just bumped the \\\n        targetSdkVersion, recompiled, and uploaded their updated app to the Google Play Store, \\\n        sometimes leading to crashes or other problems on newer devices.\n        ", (Implementation)implementation, null, (Category)category, (int)2, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.COMPLIANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION_WITH_TOML;
        DEPRECATED_LIBRARY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"OutdatedLibrary", (String)"Outdated Library", (String)"\n                Your app is using an outdated version of a library. This may cause violations \\\n                of Google Play policies (see https://play.google.com/about/monetization-ads/ads/) \\\n                and/or may affect your app\u2019s visibility on the Play Store.\n\n                Please try updating your app with an updated version of this library, or remove \\\n                it from your app.\n                ", (Implementation)implementation, (String)"https://developer.android.com/distribute/sdk-index", (Category)category, (int)5, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DATA_BINDING_WITHOUT_KAPT = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"DataBindingWithoutKapt", (String)"Data Binding without Annotation Processing", (String)"\n                Apps that use Kotlin and data binding should also apply the kotlin-kapt plugin.\n                ", (Implementation)implementation, (String)"https://kotlinlang.org/docs/reference/kapt.html", (Category)category, (int)1, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.PERFORMANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8 = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"LifecycleAnnotationProcessorWithJava8", (String)"Lifecycle Annotation Processor with Java 8 Compile Option", (String)"\n                For faster incremental build, switch to the Lifecycle Java 8 API with these steps:\n\n                First replace\n                ```gradle\n                annotationProcessor \"androidx.lifecycle:lifecycle-compiler:*version*\"\n                kapt \"androidx.lifecycle:lifecycle-compiler:*version*\"\n                ```\n                with\n                ```gradle\n                implementation \"androidx.lifecycle:lifecycle-common-java8:*version*\"\n                ```\n                Then remove any `OnLifecycleEvent` annotations from `Observer` classes \\\n                and make them implement the `DefaultLifecycleObserver` interface.\n                ", (Implementation)implementation, (String)"https://d.android.com/r/studio-ui/lifecycle-release-notes", (Category)category, (int)6, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.SECURITY;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION_WITH_TOML;
        RISKY_LIBRARY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"RiskyLibrary", (String)"Libraries with Privacy or Security Risks", (String)"\n                Your app is using a version of a library that has been identified by \\\n                the library developer as a potential source of privacy and/or security risks. \\\n                This may be a violation of Google Play policies (see \\\n                https://play.google.com/about/monetization-ads/ads/) and/or affect your app\u2019s \\\n                visibility on the Play Store.\n\n                When available, the individual error messages from lint will include details \\\n                about the reasons for this advisory.\n\n                Please try updating your app with an updated version of this library, or remove \\\n                it from your app.\n            ", (Implementation)implementation, (String)"https://developer.android.com/distribute/sdk-index", (Category)category, (int)4, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null).addMoreInfo("https://goo.gle/RiskyLibrary");
        objectArray = Issue.Companion;
        category = Category.PERFORMANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        ANNOTATION_PROCESSOR_ON_COMPILE_PATH = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"AnnotationProcessorOnCompilePath", (String)"Annotation Processor on Compile Classpath", (String)"\n               This dependency is identified as an annotation processor. Consider adding it to the \\\n               processor path using `annotationProcessor` instead of including it to the \\\n               compile path.\n            ", (Implementation)implementation, null, (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        category = Category.PRODUCTIVITY;
        object = Severity.INFORMATIONAL;
        implementation = IMPLEMENTATION;
        KTX_EXTENSION_AVAILABLE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"KtxExtensionAvailable", (String)"KTX Extension Available", (String)"\n                Android KTX extensions augment some libraries with support for modern Kotlin \\\n                language features like extension functions, extension properties, lambdas, named \\\n                parameters, coroutines, and more.\n\n                In Kotlin projects, use the KTX version of a library by replacing the \\\n                dependency in your `build.gradle` file. For example, you can replace \\\n                `androidx.fragment:fragment` with `androidx.fragment:fragment-ktx`.\n            ", (Implementation)implementation, (String)"https://developer.android.com/kotlin/ktx", (Category)category, (int)4, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.PERFORMANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        KAPT_USAGE_INSTEAD_OF_KSP = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"KaptUsageInsteadOfKsp", (String)"Kapt usage should be replaced with KSP", (String)"\n                KSP is a more efficient replacement for kapt. For libraries that support both, \\\n                KSP should be used to improve build times.\n            ", (Implementation)implementation, (String)"https://developer.android.com/studio/build/migrate-to-ksp", (Category)category, (int)4, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION_WITH_TOML;
        BOM_WITHOUT_PLATFORM = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"BomWithoutPlatform", (String)"Using a BOM without platform call", (String)"\n          When including a BOM, the dependency's coordinates must be wrapped \\\n          in a call to `platform()` for Gradle to interpret it correctly.\n          ", (Implementation)implementation, (String)"https://developer.android.com/r/tools/gradle-bom-docs", (Category)category, (int)4, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        JAVA_PLUGIN_LANGUAGE_LEVEL = Issue.Companion.create("JavaPluginLanguageLevel", "No Explicit Java Language Level Given", "\n                In modules using plugins deriving from the Gradle `java` plugin (e.g. \\\n                `java-library` or `application`), the java source and target compatibility \\\n                default to the version of the JDK being used to run Gradle, which may cause \\\n                compatibility problems with Android (or other) modules.\n\n                You can specify an explicit sourceCompatibility and targetCompatibility in this \\\n                module to maintain compatibility no matter which JDK is used to run Gradle.\n            ", Category.INTEROPERABILITY, 6, Severity.WARNING, IMPLEMENTATION);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        JCENTER_REPOSITORY_OBSOLETE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"JcenterRepositoryObsolete", (String)"JCenter Maven repository is read-only", (String)"\n                The JCenter Maven repository is no longer accepting submissions of Maven \\\n                artifacts since 31st March 2021.  Ensure that the project is configured \\\n                to search in repositories with the latest versions of its dependencies.\n            ", (Implementation)implementation, (String)"https://developer.android.com/r/tools/jcenter-end-of-service", (Category)category, (int)8, (Severity)object, (boolean)false, null, null, null, (int)3840, null);
        objectArray = Issue.Companion;
        category = Category.COMPLIANCE;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION_WITH_TOML;
        PLAY_SDK_INDEX_NON_COMPLIANT = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"PlaySdkIndexNonCompliant", (String)"Library has policy issues in SDK Index", (String)"This library version has policy issues that will block publishing in the Google Play Store.", (Implementation)implementation, (String)"https://developer.android.com/distribute/sdk-index", (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.COMPLIANCE;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION_WITH_TOML;
        PLAY_SDK_INDEX_GENERIC_ISSUES = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"PlaySdkIndexGenericIssues", (String)"Library has issues in SDK Index", (String)"This library version has issues that could block publishing in the Google Play Store.", (Implementation)implementation, (String)"https://developer.android.com/distribute/sdk-index", (Category)category, (int)8, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.CHROME_OS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        CHROMEOS_ABI_SUPPORT = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"ChromeOsAbiSupport", (String)"Missing ABI Support for ChromeOS", (String)"\n                To properly support ChromeOS, your Android application should have an x86 and/or x86_64 binary \\\n                as part of the build configuration. To fix the issue, ensure your files are properly optimized \\\n                for ARM; the binary translator will then ensure compatibility with x86. Alternatively, add an \\\n                `abiSplit` for x86 within your `build.gradle` file and create the required x86 dependencies.\n            ", (Implementation)implementation, (String)"https://developer.android.com/ndk/guides/abis", (Category)category, (int)4, (Severity)object, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = new String[]{"java", "java-library", "application"};
        Iterable $this$flatMap$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$flatMap = false;
        object = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Object[] objectArray2 = new String[]{it, "org.gradle." + it};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        JAVA_PLUGIN_IDS = (List)implementation;
        objectArray = new String[]{"com.android.base", APP_PLUGIN_ID, LIB_PLUGIN_ID, "com.android.test", "com.android.instant-app", "com.android.feature", "com.android.dynamic-feature", "com.android.settings"};
        ALL_PLUGIN_IDS = SetsKt.setOf((Object[])objectArray);
        PLAY_SERVICES_V650 = Component.Companion.parse("com.google.android.gms:play-services:6.5.0");
        objectArray = new String[]{"com.jakewharton:butterknife-compiler", "com.github.bumptech.glide:compiler", "androidx.databinding:databinding-compiler", "com.google.dagger:dagger-compiler", "com.google.auto.service:auto-service", "android.arch.persistence.room:compiler", "android.arch.lifecycle:compiler", "io.realm:realm-annotations-processor", "com.google.dagger:dagger-android-processor", "androidx.room:room-compiler", "com.android.databinding:compiler", "androidx.lifecycle:lifecycle-compiler", "org.projectlombok:lombok", "com.google.auto.value:auto-value", "org.parceler:parceler", "com.github.hotchemi:permissionsdispatcher-processor", "com.alibaba:arouter-compiler", "org.androidannotations:androidannotations", "com.github.Raizlabs.DBFlow:dbflow-processor", "frankiesardo:icepick-processor", "org.greenrobot:eventbus-annotation-processor", "com.ryanharter.auto.value:auto-value-gson", "io.objectbox:objectbox-processor", "com.arello-mobile:moxy-compiler", "com.squareup.dagger:dagger-compiler", "io.realm:realm-android", "com.bluelinelabs:logansquare-compiler", "com.tencent.tinker:tinker-android-anno", "com.raizlabs.android:DBFlow-Compiler", "com.google.auto.factory:auto-factory", "com.airbnb:deeplinkdispatch-processor", "com.alipay.android.tools:androidannotations", "org.permissionsdispatcher:permissionsdispatcher-processor", "com.airbnb.android:epoxy-processor", "org.immutables:value", "com.github.stephanenicolas.toothpick:toothpick-compiler", "com.mindorks.android:placeholderview-compiler", "com.github.frankiesardo:auto-parcel-processor", "com.hannesdorfmann.fragmentargs:processor", "com.evernote:android-state-processor", "org.mapstruct:mapstruct-processor", "com.iqiyi.component.router:qyrouter-compiler", "com.iqiyi.component.mm:mm-compiler", "dk.ilios:realmfieldnameshelper", "com.lianjia.common.android.router2:compiler", "com.smile.gifshow.annotation:invoker_processor", "com.f2prateek.dart:dart-processor", "com.sankuai.waimai.router:compiler", "org.qiyi.card:card-action-compiler", "com.iqiyi.video:eventbus-annotation-processor", "ly.img.android.pesdk:build-processor", "org.apache.logging.log4j:log4j-core", "com.github.jokermonn:permissions4m", "com.arialyy.aria:aria-compiler", "com.smile.gifshow.annotation:provide_processor", "com.smile.gifshow.annotation:preference_processor", "com.smile.gifshow.annotation:plugin_processor", "org.inferred:freebuilder", "com.smile.gifshow.annotation:router_processor"};
        commonAnnotationProcessors = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"com.github.bumptech.glide:compiler", (Object)"com.github.bumptech.glide:ksp"), TuplesKt.to((Object)"androidx.room:room-compiler", (Object)"androidx.room:room-compiler"), TuplesKt.to((Object)"com.squareup.moshi:moshi-kotlin-codegen", (Object)"com.squareup.moshi:moshi-kotlin-codegen"), TuplesKt.to((Object)"com.github.liujingxing.rxhttp:rxhttp-compiler", (Object)"com.github.liujingxing.rxhttp:rxhttp-compiler"), TuplesKt.to((Object)"se.ansman.kotshi:compiler", (Object)"se.ansman.kotshi:compiler"), TuplesKt.to((Object)"com.linecorp.lich:savedstate-compiler", (Object)"com.linecorp.lich:savedstate-compiler"), TuplesKt.to((Object)"io.github.amrdeveloper:easyadapter-compiler", (Object)"io.github.amrdeveloper:easyadapter-compiler"), TuplesKt.to((Object)"com.airbnb:deeplinkdispatch-processor", (Object)"com.airbnb:deeplinkdispatch-processor"), TuplesKt.to((Object)"com.airbnb.android:epoxy-processor", (Object)"com.airbnb.android:epoxy-processor"), TuplesKt.to((Object)"com.airbnb.android:paris-processor", (Object)"com.airbnb.android:paris-processor")};
        annotationProcessorsWithKspReplacements = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"androidx.compose:compose-bom", "com.google.firebase:firebase-bom", "org.jetbrains.kotlin:kotlin-bom", "org.jetbrains.kotlinx:kotlinx-coroutines-bom", "io.ktor:ktor-bom", "com.squareup.okio:okio-bom", "com.squareup.okhttp3:okhttp-bom", "com.squareup.wire:wire-bom", "com.fasterxml.jackson:jackson-bom", "io.grpc:grpc-bom", "org.http4k:http4k-bom", "org.http4k:http4k-connect-bom", "org.junit:junit-bom", "io.kotest:kotest-bom", "io.cucumber:cucumber-bom", "io.arrow-kt:arrow-stack", "io.sentry:sentry-bom", "dev.chrisbanes.compose:compose-bom", "org.ow2.asm:asm-bom", "software.amazon.awssdk:bom", "com.walletconnect:android-bom"};
        commonBoms = SetsKt.setOf((Object[])objectArray);
        playSdkIndexFactory = Companion.playSdkIndexFactory.1.INSTANCE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0001H\u00c6\u0003JG\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/GradleDetector$AgpVersionCheckInfo;", "", "newerVersion", "Lcom/android/ide/common/gradle/Version;", "newerVersionIsSafe", "", "safeReplacement", "dependency", "Lcom/android/ide/common/gradle/Dependency;", "isResolved", "cookie", "(Lcom/android/ide/common/gradle/Version;ZLcom/android/ide/common/gradle/Version;Lcom/android/ide/common/gradle/Dependency;ZLjava/lang/Object;)V", "getCookie", "()Ljava/lang/Object;", "getDependency", "()Lcom/android/ide/common/gradle/Dependency;", "()Z", "getNewerVersion", "()Lcom/android/ide/common/gradle/Version;", "getNewerVersionIsSafe", "getSafeReplacement", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "", "lint-checks"})
    public static final class AgpVersionCheckInfo {
        @NotNull
        private final Version newerVersion;
        private final boolean newerVersionIsSafe;
        @Nullable
        private final Version safeReplacement;
        @NotNull
        private final Dependency dependency;
        private final boolean isResolved;
        @NotNull
        private final Object cookie;

        public AgpVersionCheckInfo(@NotNull Version newerVersion, boolean newerVersionIsSafe, @Nullable Version safeReplacement, @NotNull Dependency dependency, boolean isResolved, @NotNull Object cookie) {
            Intrinsics.checkNotNullParameter((Object)newerVersion, (String)"newerVersion");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
            this.newerVersion = newerVersion;
            this.newerVersionIsSafe = newerVersionIsSafe;
            this.safeReplacement = safeReplacement;
            this.dependency = dependency;
            this.isResolved = isResolved;
            this.cookie = cookie;
        }

        @NotNull
        public final Version getNewerVersion() {
            return this.newerVersion;
        }

        public final boolean getNewerVersionIsSafe() {
            return this.newerVersionIsSafe;
        }

        @Nullable
        public final Version getSafeReplacement() {
            return this.safeReplacement;
        }

        @NotNull
        public final Dependency getDependency() {
            return this.dependency;
        }

        public final boolean isResolved() {
            return this.isResolved;
        }

        @NotNull
        public final Object getCookie() {
            return this.cookie;
        }

        @NotNull
        public final Version component1() {
            return this.newerVersion;
        }

        public final boolean component2() {
            return this.newerVersionIsSafe;
        }

        @Nullable
        public final Version component3() {
            return this.safeReplacement;
        }

        @NotNull
        public final Dependency component4() {
            return this.dependency;
        }

        public final boolean component5() {
            return this.isResolved;
        }

        @NotNull
        public final Object component6() {
            return this.cookie;
        }

        @NotNull
        public final AgpVersionCheckInfo copy(@NotNull Version newerVersion, boolean newerVersionIsSafe, @Nullable Version safeReplacement, @NotNull Dependency dependency, boolean isResolved, @NotNull Object cookie) {
            Intrinsics.checkNotNullParameter((Object)newerVersion, (String)"newerVersion");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
            return new AgpVersionCheckInfo(newerVersion, newerVersionIsSafe, safeReplacement, dependency, isResolved, cookie);
        }

        public static /* synthetic */ AgpVersionCheckInfo copy$default(AgpVersionCheckInfo agpVersionCheckInfo, Version version, boolean bl, Version version2, Dependency dependency, boolean bl2, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                version = agpVersionCheckInfo.newerVersion;
            }
            if ((n & 2) != 0) {
                bl = agpVersionCheckInfo.newerVersionIsSafe;
            }
            if ((n & 4) != 0) {
                version2 = agpVersionCheckInfo.safeReplacement;
            }
            if ((n & 8) != 0) {
                dependency = agpVersionCheckInfo.dependency;
            }
            if ((n & 0x10) != 0) {
                bl2 = agpVersionCheckInfo.isResolved;
            }
            if ((n & 0x20) != 0) {
                object = agpVersionCheckInfo.cookie;
            }
            return agpVersionCheckInfo.copy(version, bl, version2, dependency, bl2, object);
        }

        @NotNull
        public String toString() {
            return "AgpVersionCheckInfo(newerVersion=" + this.newerVersion + ", newerVersionIsSafe=" + this.newerVersionIsSafe + ", safeReplacement=" + this.safeReplacement + ", dependency=" + this.dependency + ", isResolved=" + this.isResolved + ", cookie=" + this.cookie + ")";
        }

        public int hashCode() {
            int result = this.newerVersion.hashCode();
            result = result * 31 + Boolean.hashCode(this.newerVersionIsSafe);
            result = result * 31 + (this.safeReplacement == null ? 0 : this.safeReplacement.hashCode());
            result = result * 31 + this.dependency.hashCode();
            result = result * 31 + Boolean.hashCode(this.isResolved);
            result = result * 31 + this.cookie.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AgpVersionCheckInfo)) {
                return false;
            }
            AgpVersionCheckInfo agpVersionCheckInfo = (AgpVersionCheckInfo)other;
            if (!Intrinsics.areEqual((Object)this.newerVersion, (Object)agpVersionCheckInfo.newerVersion)) {
                return false;
            }
            if (this.newerVersionIsSafe != agpVersionCheckInfo.newerVersionIsSafe) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.safeReplacement, (Object)agpVersionCheckInfo.safeReplacement)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dependency, (Object)agpVersionCheckInfo.dependency)) {
                return false;
            }
            if (this.isResolved != agpVersionCheckInfo.isResolved) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cookie, (Object)agpVersionCheckInfo.cookie);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0004\u0094\u0001\u0095\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010f\u001a\u0004\u0018\u00010g2\u0006\u0010h\u001a\u00020\b2\u0006\u0010i\u001a\u00020jH\u0002J\u0016\u0010k\u001a\u00020l2\u0006\u0010i\u001a\u00020m2\u0006\u0010n\u001a\u00020oJ\u001e\u0010k\u001a\u00020l2\u0006\u0010i\u001a\u00020m2\u0006\u0010p\u001a\u00020o2\u0006\u0010q\u001a\u00020oJ&\u0010k\u001a\u00020l2\u0006\u0010i\u001a\u00020m2\u0006\u0010r\u001a\u00020\b2\u0006\u0010s\u001a\u00020\b2\u0006\u0010t\u001a\u00020\bJJ\u0010k\u001a\u00020l2\u0006\u0010i\u001a\u00020m2\u0006\u0010u\u001a\u00020\b2\u0006\u0010v\u001a\u00020\b2\u0006\u0010w\u001a\u00020\b2\u0006\u0010x\u001a\u00020\b2\u0006\u0010y\u001a\u00020\b2\u0006\u0010z\u001a\u00020\b2\n\b\u0002\u0010{\u001a\u0004\u0018\u00010\bJ4\u0010|\u001a\u0004\u0018\u00010}2\u0006\u0010~\u001a\u00020X2\u0006\u0010\u007f\u001a\u00020\b2\u0010\u0010\u0080\u0001\u001a\u000b\u0012\u0004\u0012\u00020}\u0018\u00010\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J9\u0010\u0084\u0001\u001a\u0004\u0018\u00010}2\u0006\u0010~\u001a\u00020X2\b\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0010\u0010\u0080\u0001\u001a\u000b\u0012\u0004\u0012\u00020}\u0018\u00010\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0007J\u0013\u0010\u0087\u0001\u001a\u0004\u0018\u00010\b2\u0006\u0010h\u001a\u00020\bH\u0007J\u001b\u0010\u0088\u0001\u001a\u0004\u0018\u00010g2\u0006\u0010h\u001a\u00020\b2\u0006\u0010i\u001a\u00020jH\u0002J\u0013\u0010\u0089\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0085\u0001\u001a\u00020\bH\u0002J\u0013\u0010\u008a\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0085\u0001\u001a\u00020\bH\u0002J\u0013\u0010\u008b\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u008c\u0001\u001a\u00020\bH\u0002J\b\u0010\u008d\u0001\u001a\u00030\u008e\u0001J\u001d\u0010\u008f\u0001\u001a\u00030\u0083\u00012\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\u0007\u0010\u0092\u0001\u001a\u00020\bH\u0002J\u0014\u0010\u0093\u0001\u001a\u00030\u0083\u00012\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0010\u0010,\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010>\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010@\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020FX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010J\u001a\u0004\u0018\u00010KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u0014\u0010P\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010Q\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020FX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010S\u001a\u0004\u0018\u00010TX\u0082\u000e\u00a2\u0006\u0002\n\u0000R8\u0010U\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010W\u0012\u0004\u0012\u00020X\u0012\u0004\u0012\u00020Y0V8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bZ\u0010\u0002\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^R.\u0010_\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0a\u0018\u00010`X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010c\"\u0004\bd\u0010e\u00a8\u0006\u0096\u0001"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$Companion;", "", "()V", "ACCIDENTAL_OCTAL", "Lcom/android/tools/lint/detector/api/Issue;", "AGP_DEPENDENCY", "ALL_PLUGIN_IDS", "", "", "getALL_PLUGIN_IDS", "()Ljava/util/Set;", "ANDROID_WEAR_GROUP_ID", "ANNOTATION_PROCESSOR_ON_COMPILE_PATH", "APP_PLUGIN_ID", "BOM_WITHOUT_PLATFORM", "BUNDLED_GMS", "CHROMEOS_ABI_SUPPORT", "COMPATIBILITY", "CREDENTIAL_DEP", "DATA_BINDING_WITHOUT_KAPT", "DEPENDENCY", "DEPRECATED", "DEPRECATED_CONFIGURATION", "DEPRECATED_LIBRARY", "DEV_MODE_OBSOLETE", "DUPLICATE_CLASSES", "EDITED_TARGET_SDK_VERSION", "EXPIRED_TARGET_SDK_VERSION", "EXPIRING_TARGET_SDK_VERSION", "FIREBASE_GROUP_ID", "GMS_GROUP_ID", "GOOGLE_SUPPORT_GROUP_ID", "GRADLE_GETTER", "GRADLE_PLUGIN_COMPATIBILITY", "HIGH_APP_VERSION_CODE", "IDE_SUPPORT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "IMPLEMENTATION_WITH_MANIFEST", "IMPLEMENTATION_WITH_TOML", "JAVA_PLUGIN_IDS", "", "getJAVA_PLUGIN_IDS", "()Ljava/util/List;", "JAVA_PLUGIN_LANGUAGE_LEVEL", "JCENTER_REPOSITORY_OBSOLETE", "KAPT_USAGE_INSTEAD_OF_KSP", "KEY_COORDINATE", "KEY_REVISION", "KTX_EXTENSION_AVAILABLE", "LIB_PLUGIN_ID", "LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8", "MIN_SDK_TOO_LOW", "NOT_INTERPOLATED", "OLD_APP_PLUGIN_ID", "OLD_LIB_PLUGIN_ID", "PATH", "PLAY_SDK_INDEX_GENERIC_ISSUES", "PLAY_SDK_INDEX_NON_COMPLIANT", "PLAY_SERVICES_V650", "Lcom/android/ide/common/gradle/Component;", "PLUS", "REMOTE_VERSION", "RISKY_LIBRARY", "STRING_INTEGER", "SWITCH_TO_TOML", "TARGET_NEWER", "VC_LIBRARY_PREFIX", "VC_PLUGIN_PREFIX", "VERSION_CODE_HIGH_THRESHOLD", "", "WEARABLE_ARTIFACT_ID", "annotationProcessorsWithKspReplacements", "", "calendar", "Ljava/util/Calendar;", "getCalendar", "()Ljava/util/Calendar;", "setCalendar", "(Ljava/util/Calendar;)V", "commonAnnotationProcessors", "commonBoms", "lastTargetSdkVersion", "lastTargetSdkVersionFile", "Ljava/io/File;", "playSdkIndexFactory", "Lkotlin/Function2;", "Ljava/nio/file/Path;", "Lcom/android/tools/lint/client/api/LintClient;", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex;", "getPlaySdkIndexFactory$annotations", "getPlaySdkIndexFactory", "()Lkotlin/jvm/functions/Function2;", "setPlaySdkIndexFactory", "(Lkotlin/jvm/functions/Function2;)V", "reservedQuickfixNames", "", "", "getReservedQuickfixNames", "()Ljava/util/Map;", "setReservedQuickfixNames", "(Ljava/util/Map;)V", "getDependencyFromVersionCatalog", "Lcom/android/tools/lint/checks/GradleDetector$Companion$VersionCatalogDependency;", "expression", "context", "Lcom/android/tools/lint/detector/api/GradleContext;", "getDependencyLocation", "Lcom/android/tools/lint/detector/api/Location;", "Lcom/android/tools/lint/detector/api/Context;", "c", "Lcom/android/tools/lint/model/LintModelMavenName;", "address1", "address2", "groupId", "artifactId", "version", "groupId1", "artifactId1", "version1", "groupId2", "artifactId2", "version2", "message", "getLatestVersionFromGradlePluginPortal", "Lcom/android/ide/common/gradle/Version;", "client", "pluginId", "filter", "Ljava/util/function/Predicate;", "allowPreview", "", "getLatestVersionFromRemoteRepo", "dependency", "Lcom/android/ide/common/gradle/Dependency;", "getNamedDependency", "getPluginFromVersionCatalog", "hasLifecycleAnnotationProcessor", "isCommonAnnotationProcessor", "libraryHasKtxExtension", "mavenName", "stopFlaggingTargetSdkEdits", "", "suggestApiConfigurationUse", "project", "Lcom/android/tools/lint/detector/api/Project;", "configuration", "targetJava8Plus", "CompileConfiguration", "VersionCatalogDependency", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nGradleDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDetector.kt\ncom/android/tools/lint/checks/GradleDetector$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,3994:1\n1#2:3995\n766#3:3996\n857#3,2:3997\n766#3:3999\n857#3,2:4000\n766#3:4002\n857#3,2:4003\n766#3:4005\n857#3,2:4006\n*S KotlinDebug\n*F\n+ 1 GradleDetector.kt\ncom/android/tools/lint/checks/GradleDetector$Companion\n*L\n3501#1:3996\n3501#1:3997,2\n3502#1:3999\n3502#1:4000,2\n3611#1:4002\n3611#1:4003,2\n3612#1:4005\n3612#1:4006,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void stopFlaggingTargetSdkEdits() {
            lastTargetSdkVersion = Integer.MAX_VALUE;
            lastTargetSdkVersionFile = null;
        }

        @Nullable
        public final Calendar getCalendar() {
            return calendar;
        }

        public final void setCalendar(@Nullable Calendar calendar) {
            GradleDetector.calendar = calendar;
        }

        @Nullable
        public final Map<String, Set<String>> getReservedQuickfixNames() {
            return reservedQuickfixNames;
        }

        public final void setReservedQuickfixNames(@Nullable Map<String, Set<String>> map) {
            reservedQuickfixNames = map;
        }

        @NotNull
        public final List<String> getJAVA_PLUGIN_IDS() {
            return JAVA_PLUGIN_IDS;
        }

        @NotNull
        public final Set<String> getALL_PLUGIN_IDS() {
            return ALL_PLUGIN_IDS;
        }

        @NotNull
        public final Location getDependencyLocation(@NotNull Context context, @NotNull LintModelMavenName c) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return this.getDependencyLocation(context, c.getGroupId(), c.getArtifactId(), c.getVersion());
        }

        @NotNull
        public final Location getDependencyLocation(@NotNull Context context, @NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            LintClient client = context.getClient();
            File projectDir = context.getProject().getDir();
            String withoutQuotes = groupId + ":" + artifactId + ":" + version;
            Intrinsics.checkNotNullExpressionValue((Object)projectDir, (String)"projectDir");
            Location location = com.android.tools.lint.detector.api.Lint.guessGradleLocation((LintClient)client, (File)projectDir, (String)withoutQuotes);
            if (location.getStart() != null) {
                return location;
            }
            location = com.android.tools.lint.detector.api.Lint.guessGradleLocation((LintClient)client, (File)projectDir, (String)(groupId + ":" + artifactId + ":"));
            if (location.getStart() != null) {
                return location;
            }
            location = com.android.tools.lint.detector.api.Lint.guessGradleLocation((LintClient)client, (File)projectDir, (String)artifactId);
            if (location.getStart() != null) {
                return location;
            }
            location = com.android.tools.lint.detector.api.Lint.guessGradleLocation((LintClient)client, (File)projectDir, (String)groupId);
            return location;
        }

        @NotNull
        public final Location getDependencyLocation(@NotNull Context context, @NotNull LintModelMavenName address1, @NotNull LintModelMavenName address2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)address1, (String)"address1");
            Intrinsics.checkNotNullParameter((Object)address2, (String)"address2");
            return com.android.tools.lint.checks.GradleDetector$Companion.getDependencyLocation$default(this, context, address1.getGroupId(), address1.getArtifactId(), address1.getVersion(), address2.getGroupId(), address2.getArtifactId(), address2.getVersion(), null, 128, null);
        }

        @NotNull
        public final Location getDependencyLocation(@NotNull Context context, @NotNull String groupId1, @NotNull String artifactId1, @NotNull String version1, @NotNull String groupId2, @NotNull String artifactId2, @NotNull String version2, @Nullable String message2) {
            Location location1;
            block1: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)groupId1, (String)"groupId1");
                Intrinsics.checkNotNullParameter((Object)artifactId1, (String)"artifactId1");
                Intrinsics.checkNotNullParameter((Object)version1, (String)"version1");
                Intrinsics.checkNotNullParameter((Object)groupId2, (String)"groupId2");
                Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId2");
                Intrinsics.checkNotNullParameter((Object)version2, (String)"version2");
                location1 = this.getDependencyLocation(context, groupId1, artifactId1, version1);
                Location location2 = this.getDependencyLocation(context, groupId2, artifactId2, version2);
                if (location2.getStart() == null && Intrinsics.areEqual((Object)location1.getFile(), (Object)location2.getFile())) break block1;
                location1.setSecondary(location2);
                String string = message2;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    location2.setMessage(it);
                }
            }
            return location1;
        }

        public static /* synthetic */ Location getDependencyLocation$default(Companion companion, Context context, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, Object object) {
            if ((n & 0x80) != 0) {
                string7 = null;
            }
            return companion.getDependencyLocation(context, string, string2, string3, string4, string5, string6, string7);
        }

        @Nullable
        public final Version getLatestVersionFromGradlePluginPortal(@NotNull LintClient client, @NotNull String pluginId, @Nullable Predicate<Version> filter, boolean allowPreview) {
            Document document;
            String string;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            String pluginPath = StringsKt.replace$default((String)pluginId, (String)".", (String)"/", (boolean)false, (int)4, null);
            String url = "https://plugins.gradle.org/m2/" + pluginPath + "/" + pluginId + ".gradle.plugin/maven-metadata.xml";
            try {
                string = com.android.tools.lint.detector.api.Lint.readUrlDataAsString((LintClient)client, (String)url, (int)20000);
            }
            catch (IOException e) {
                Object[] objectArray = new Object[]{url, pluginId};
                client.log(null, "Could not connect to %1$s to get the latest available version for plugin %2$s", objectArray);
                string = null;
            }
            String updates = string;
            if (updates != null && !StringsKt.startsWith$default((String)updates, (String)"{", (boolean)false, (int)2, null) && (document = XmlUtils.parseDocumentSilently((String)updates, (boolean)false)) != null) {
                Version it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Element element;
                NodeList versionsList = document.getElementsByTagName("versions");
                List versions = new ArrayList();
                int n = versionsList.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node = versionsList.item(i);
                    Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                    element = (Element)node;
                    Iterator iterator = DomExtensions.iterator((Element)element);
                    while (iterator.hasNext()) {
                        Element child = (Element)iterator.next();
                        if (!Intrinsics.areEqual((Object)child.getTagName(), (Object)"version")) continue;
                        String s = child.getTextContent();
                        Intrinsics.checkNotNullExpressionValue((Object)s, (String)"s");
                        if (!(!StringsKt.isBlank((CharSequence)s))) continue;
                        Version revision = Version.Companion.parse(s);
                        versions.add(revision);
                    }
                }
                Iterable i = versions;
                boolean $i$f$filter = false;
                element = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Version)element$iv$iv;
                    boolean bl = false;
                    if (!(filter == null || filter.test(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Version)element$iv$iv;
                    boolean bl = false;
                    if (!(allowPreview || !it.isPreview())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (Version)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final Version getLatestVersionFromRemoteRepo(@NotNull LintClient client, @NotNull Dependency dependency, @Nullable Predicate<Version> filter, boolean allowPreview) {
            Version it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String substring;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            String string = dependency.getGroup();
            if (string == null) {
                return null;
            }
            String group = string;
            String name = dependency.getName();
            RichVersion richVersion = dependency.getVersion();
            if (richVersion == null) {
                return null;
            }
            RichVersion richVersion2 = richVersion;
            StringBuilder query = new StringBuilder();
            String encoding = Charsets.UTF_8.name();
            boolean allowPreview2 = false;
            allowPreview2 = allowPreview;
            try {
                query.append("https://search.maven.org/solrsearch/select?q=g:%22");
                query.append(URLEncoder.encode(group, encoding));
                query.append("%22+AND+a:%22");
                query.append(URLEncoder.encode(name, encoding));
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
            query.append("%22&core=gav");
            if (Intrinsics.areEqual((Object)group, (Object)"com.google.guava") || Intrinsics.areEqual((Object)name, (Object)"kotlinx-coroutines-core")) {
                allowPreview2 = true;
            } else if (filter == null && allowPreview2) {
                query.append("&rows=1");
            }
            query.append("&wt=json");
            String response = null;
            try {
                String string2 = query.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"query.toString()");
                response = com.android.tools.lint.detector.api.Lint.readUrlDataAsString((LintClient)client, (String)string2, (int)20000);
                if (response == null) {
                    return null;
                }
            }
            catch (IOException e) {
                Object[] objectArray = new Object[]{dependency};
                client.log(null, "Could not connect to maven central to look up the latest available version for %1$s", objectArray);
                return null;
            }
            int index2 = StringsKt.indexOf$default((CharSequence)response, (String)"\"response\"", (int)0, (boolean)false, (int)6, null);
            List versions = new ArrayList();
            while (index2 != -1) {
                if ((index2 = StringsKt.indexOf$default((CharSequence)response, (String)"\"v\":", (int)index2, (boolean)false, (int)4, null)) == -1) continue;
                int start = StringsKt.indexOf$default((CharSequence)response, (char)'\"', (int)(index2 += 4), (boolean)false, (int)4, null) + 1;
                int end = StringsKt.indexOf$default((CharSequence)response, (char)'\"', (int)(start + 1), (boolean)false, (int)4, null);
                boolean bl = 0 <= start ? start < end : false;
                if (!bl) continue;
                Intrinsics.checkNotNullExpressionValue((Object)response.substring(start, end), (String)"substring(...)");
                Version revision = Version.Companion.parse(substring);
                if (revision == null) continue;
                versions.add(revision);
            }
            Iterable start = versions;
            boolean $i$f$filter = false;
            substring = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Version)element$iv$iv;
                boolean bl = false;
                if (!(filter == null || filter.test(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Version)element$iv$iv;
                boolean bl = false;
                if (!(allowPreview2 || !it.isPreview())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (Version)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        }

        private final VersionCatalogDependency getDependencyFromVersionCatalog(String expression, GradleContext context) {
            LintTomlValue lintTomlValue;
            Object object;
            block8: {
                block7: {
                    Object v2;
                    block6: {
                        LintTomlMapValue lintTomlMapValue;
                        if (!StringsKt.startsWith$default((String)expression, (String)GradleDetector.VC_LIBRARY_PREFIX, (boolean)false, (int)2, null)) {
                            return null;
                        }
                        String string = expression.substring(5);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String libName = string;
                        object = GradleContext.getTomlValue$default((GradleContext)context, (String)"libraries", (boolean)false, (int)2, null);
                        LintTomlMapValue lintTomlMapValue2 = lintTomlMapValue = object instanceof LintTomlMapValue ? (LintTomlMapValue)object : null;
                        if (lintTomlMapValue == null || (object = lintTomlMapValue.getMappedValues()) == null) break block7;
                        Iterable iterable = object.entrySet();
                        if (iterable == null) break block7;
                        Iterable iterable2 = iterable;
                        for (Object t : iterable2) {
                            Map.Entry it = (Map.Entry)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)StringsKt.replace$default((String)StringsKt.replace$default((String)((String)it.getKey()), (char)'-', (char)'.', (boolean)false, (int)4, null), (char)'_', (char)'.', (boolean)false, (int)4, null), (Object)libName)) continue;
                            v2 = t;
                            break block6;
                        }
                        v2 = null;
                    }
                    Map.Entry entry = v2;
                    if (entry != null && (lintTomlValue = (LintTomlValue)entry.getValue()) != null) break block8;
                }
                return null;
            }
            LintTomlValue library = lintTomlValue;
            object = GradleContext.getTomlValue$default((GradleContext)context, (String)"versions", (boolean)false, (int)2, null);
            LintTomlMapValue versions = object instanceof LintTomlMapValue ? (LintTomlMapValue)object : null;
            Pair<String, LintTomlValue> pair = Lint.getLibraryFromTomlEntry(versions, library);
            if (pair == null) {
                return null;
            }
            String coordinate = (String)pair.component1();
            return new VersionCatalogDependency(coordinate, library);
        }

        private final VersionCatalogDependency getPluginFromVersionCatalog(String expression, GradleContext context) {
            LintTomlValue lintTomlValue;
            Object object;
            block8: {
                block7: {
                    Object v2;
                    block6: {
                        LintTomlMapValue lintTomlMapValue;
                        if (!StringsKt.startsWith$default((String)expression, (String)GradleDetector.VC_PLUGIN_PREFIX, (boolean)false, (int)2, null)) {
                            return null;
                        }
                        String string = expression.substring(13);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String pluginName = string;
                        object = GradleContext.getTomlValue$default((GradleContext)context, (String)"plugins", (boolean)false, (int)2, null);
                        LintTomlMapValue lintTomlMapValue2 = lintTomlMapValue = object instanceof LintTomlMapValue ? (LintTomlMapValue)object : null;
                        if (lintTomlMapValue == null || (object = lintTomlMapValue.getMappedValues()) == null) break block7;
                        Iterable iterable = object.entrySet();
                        if (iterable == null) break block7;
                        Iterable iterable2 = iterable;
                        for (Object t : iterable2) {
                            Map.Entry it = (Map.Entry)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)StringsKt.replace$default((String)StringsKt.replace$default((String)((String)it.getKey()), (char)'-', (char)'.', (boolean)false, (int)4, null), (char)'_', (char)'.', (boolean)false, (int)4, null), (Object)pluginName)) continue;
                            v2 = t;
                            break block6;
                        }
                        v2 = null;
                    }
                    Map.Entry entry = v2;
                    if (entry != null && (lintTomlValue = (LintTomlValue)entry.getValue()) != null) break block8;
                }
                return null;
            }
            LintTomlValue plugin = lintTomlValue;
            object = GradleContext.getTomlValue$default((GradleContext)context, (String)"versions", (boolean)false, (int)2, null);
            LintTomlMapValue versions = object instanceof LintTomlMapValue ? (LintTomlMapValue)object : null;
            Pair<String, LintTomlValue> pair = Lint.getPluginFromTomlEntry(versions, plugin);
            if (pair == null) {
                return null;
            }
            String coordinate = (String)pair.component1();
            return new VersionCatalogDependency(coordinate, plugin);
        }

        @JvmStatic
        @Nullable
        public final String getNamedDependency(@NotNull String expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (StringsKt.indexOf$default((CharSequence)expression, (char)',', (int)0, (boolean)false, (int)6, null) != -1 && StringsKt.contains$default((CharSequence)expression, (CharSequence)"version:", (boolean)false, (int)2, null)) {
                String artifact = null;
                String group = null;
                String version = null;
                Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
                for (String property : splitter.split((CharSequence)expression)) {
                    String value;
                    int valueEnd;
                    Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property");
                    int colon = StringsKt.indexOf$default((CharSequence)property, (char)':', (int)0, (boolean)false, (int)6, null);
                    if (colon == -1) {
                        return null;
                    }
                    char quote = '\'';
                    int valueStart = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(colon + 1), (boolean)false, (int)4, null);
                    if (valueStart == -1) {
                        quote = '\"';
                        valueStart = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(colon + 1), (boolean)false, (int)4, null);
                    }
                    if (valueStart == -1) continue;
                    if ((valueEnd = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(++valueStart), (boolean)false, (int)4, null)) == -1) {
                        return null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)property.substring(valueStart, valueEnd), (String)"substring(...)");
                    if (StringsKt.startsWith$default((String)property, (String)"group:", (boolean)false, (int)2, null)) {
                        group = value;
                        continue;
                    }
                    if (StringsKt.startsWith$default((String)property, (String)"name:", (boolean)false, (int)2, null)) {
                        artifact = value;
                        continue;
                    }
                    if (!StringsKt.startsWith$default((String)property, (String)"version:", (boolean)false, (int)2, null)) continue;
                    version = value;
                }
                if (artifact != null && group != null && version != null) {
                    return group + ":" + artifact + ":" + version;
                }
            }
            return null;
        }

        private final boolean suggestApiConfigurationUse(Project project, String configuration) {
            boolean bl;
            if (StringsKt.startsWith$default((String)configuration, (String)"test", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)configuration, (String)"androidTest", (boolean)false, (int)2, null)) {
                bl = false;
            } else {
                LintModelModuleType lintModelModuleType = project.getType();
                switch (lintModelModuleType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[lintModelModuleType.ordinal()]) {
                    case 1: {
                        bl = project.hasDynamicFeatures();
                        break;
                    }
                    case 2: {
                        bl = true;
                        break;
                    }
                    case 3: {
                        bl = true;
                        break;
                    }
                    case 4: 
                    case 5: {
                        bl = true;
                        break;
                    }
                    case 6: {
                        bl = false;
                        break;
                    }
                    case 7: {
                        bl = false;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            return bl;
        }

        private final boolean targetJava8Plus(Project project) {
            return com.android.tools.lint.detector.api.Lint.getLanguageLevel((Project)project, (LanguageLevel)LanguageLevel.JDK_1_7).isAtLeast(LanguageLevel.JDK_1_8);
        }

        private final boolean hasLifecycleAnnotationProcessor(String dependency) {
            return StringsKt.contains$default((CharSequence)dependency, (CharSequence)"android.arch.lifecycle:compiler", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)dependency, (CharSequence)"androidx.lifecycle:lifecycle-compiler", (boolean)false, (int)2, null);
        }

        private final boolean isCommonAnnotationProcessor(String dependency) {
            boolean bl;
            int index2 = StringsKt.lastIndexOf$default((CharSequence)dependency, (String)":", (int)0, (boolean)false, (int)6, null);
            if (index2 == -1) {
                bl = false;
            } else {
                Set set = commonAnnotationProcessors;
                String string = dependency.substring(0, index2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                bl = set.contains(string);
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean libraryHasKtxExtension(String mavenName) {
            String string = mavenName;
            switch (string.hashCode()) {
                case -2871177: {
                    if (string.equals("androidx.palette:palette")) return true;
                    return false;
                }
                case 143019008: {
                    if (string.equals("androidx.paging:paging-runtime")) return true;
                    return false;
                }
                case 2126822828: {
                    if (string.equals("androidx.lifecycle:lifecycle-viewmodel")) return true;
                    return false;
                }
                case 268228117: {
                    if (string.equals("androidx.dynamicanimation:dynamicanimation")) return true;
                    return false;
                }
                case -264025202: {
                    if (string.equals("androidx.lifecycle:lifecycle-livedata")) return true;
                    return false;
                }
                case -1586715678: {
                    if (string.equals("androidx.lifecycle:lifecycle-reactivestreams")) return true;
                    return false;
                }
                case -1128017812: {
                    if (string.equals("androidx.navigation:navigation-ui")) return true;
                    return false;
                }
                case 72318654: {
                    if (string.equals("com.google.android.play:core")) return true;
                    return false;
                }
                case -1307799938: {
                    if (string.equals("androidx.lifecycle:lifecycle-livedata-core")) return true;
                    return false;
                }
                case 291543125: {
                    if (string.equals("androidx.activity:activity")) return true;
                    return false;
                }
                case 1493179093: {
                    if (string.equals("androidx.core:core")) return true;
                    return false;
                }
                case 1496698848: {
                    if (string.equals("androidx.lifecycle:lifecycle-runtime")) return true;
                    return false;
                }
                case -378178304: {
                    if (string.equals("androidx.navigation:navigation-runtime")) return true;
                    return false;
                }
                case -568948541: {
                    if (string.equals("androidx.paging:paging-common")) return true;
                    return false;
                }
                case -1453117067: {
                    if (string.equals("androidx.fragment:fragment")) return true;
                    return false;
                }
                case 224658418: {
                    if (string.equals("androidx.paging:paging-rxjava2")) return true;
                    return false;
                }
                case 346279413: {
                    if (string.equals("androidx.sqlite:sqlite")) return true;
                    return false;
                }
                case 1039658464: {
                    if (string.equals("androidx.slice:slice-builders")) return true;
                    return false;
                }
                case -1324096984: {
                    if (string.equals("androidx.navigation:navigation-fragment")) return true;
                    return false;
                }
                case 2032872629: {
                    if (string.equals("androidx.collection:collection")) return true;
                    return false;
                }
                case -1825909611: {
                    if (!string.equals("androidx.preference:preference")) return false;
                    return true;
                }
            }
            return false;
        }

        @NotNull
        public final Function2<Path, LintClient, GooglePlaySdkIndex> getPlaySdkIndexFactory() {
            return playSdkIndexFactory;
        }

        public final void setPlaySdkIndexFactory(@NotNull Function2<? super Path, ? super LintClient, ? extends GooglePlaySdkIndex> function2) {
            Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
            playSdkIndexFactory = function2;
        }

        @JvmStatic
        public static /* synthetic */ void getPlaySdkIndexFactory$annotations() {
        }

        public static final /* synthetic */ VersionCatalogDependency access$getPluginFromVersionCatalog(Companion $this, String expression, GradleContext context) {
            return $this.getPluginFromVersionCatalog(expression, context);
        }

        public static final /* synthetic */ boolean access$hasLifecycleAnnotationProcessor(Companion $this, String dependency) {
            return $this.hasLifecycleAnnotationProcessor(dependency);
        }

        public static final /* synthetic */ boolean access$targetJava8Plus(Companion $this, Project project) {
            return $this.targetJava8Plus(project);
        }

        public static final /* synthetic */ VersionCatalogDependency access$getDependencyFromVersionCatalog(Companion $this, String expression, GradleContext context) {
            return $this.getDependencyFromVersionCatalog(expression, context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$Companion$CompileConfiguration;", "", "compileConfigName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "annotationProcessor", "compileConfigSuffix", "matches", "", "configurationName", "replacement", "API", "COMPILE", "IMPLEMENTATION", "COMPILE_ONLY", "lint-checks"})
        private static final class CompileConfiguration
        extends Enum<CompileConfiguration> {
            @NotNull
            private final String compileConfigName;
            @NotNull
            private final String annotationProcessor;
            @NotNull
            private final String compileConfigSuffix;
            public static final /* enum */ CompileConfiguration API = new CompileConfiguration("api");
            public static final /* enum */ CompileConfiguration COMPILE = new CompileConfiguration("compile");
            public static final /* enum */ CompileConfiguration IMPLEMENTATION = new CompileConfiguration("implementation");
            public static final /* enum */ CompileConfiguration COMPILE_ONLY = new CompileConfiguration("compileOnly");
            private static final /* synthetic */ CompileConfiguration[] $VALUES;

            private CompileConfiguration(String compileConfigName) {
                this.compileConfigName = compileConfigName;
                this.annotationProcessor = "annotationProcessor";
                this.compileConfigSuffix = StringHelper.usLocaleCapitalize((String)this.compileConfigName);
            }

            public final boolean matches(@NotNull String configurationName) {
                Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
                return Intrinsics.areEqual((Object)configurationName, (Object)this.compileConfigName) || StringsKt.endsWith$default((String)configurationName, (String)this.compileConfigSuffix, (boolean)false, (int)2, null);
            }

            @NotNull
            public final String replacement(@NotNull String configurationName) {
                Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
                return Intrinsics.areEqual((Object)configurationName, (Object)this.compileConfigName) ? this.annotationProcessor : StringHelper.appendCapitalized((String)StringsKt.removeSuffix((String)configurationName, (CharSequence)this.compileConfigSuffix), (String)this.annotationProcessor);
            }

            public static CompileConfiguration[] values() {
                return (CompileConfiguration[])$VALUES.clone();
            }

            public static CompileConfiguration valueOf(String value) {
                return Enum.valueOf(CompileConfiguration.class, value);
            }

            static {
                $VALUES = compileConfigurationArray = new CompileConfiguration[]{CompileConfiguration.API, CompileConfiguration.COMPILE, CompileConfiguration.IMPLEMENTATION, CompileConfiguration.COMPILE_ONLY};
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$Companion$VersionCatalogDependency;", "", "coordinates", "", "tomlValue", "Lcom/android/tools/lint/client/api/LintTomlValue;", "(Ljava/lang/String;Lcom/android/tools/lint/client/api/LintTomlValue;)V", "getCoordinates", "()Ljava/lang/String;", "getTomlValue", "()Lcom/android/tools/lint/client/api/LintTomlValue;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "lint-checks"})
        private static final class VersionCatalogDependency {
            @NotNull
            private final String coordinates;
            @NotNull
            private final LintTomlValue tomlValue;

            public VersionCatalogDependency(@NotNull String coordinates, @NotNull LintTomlValue tomlValue) {
                Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
                Intrinsics.checkNotNullParameter((Object)tomlValue, (String)"tomlValue");
                this.coordinates = coordinates;
                this.tomlValue = tomlValue;
            }

            @NotNull
            public final String getCoordinates() {
                return this.coordinates;
            }

            @NotNull
            public final LintTomlValue getTomlValue() {
                return this.tomlValue;
            }

            @NotNull
            public final String component1() {
                return this.coordinates;
            }

            @NotNull
            public final LintTomlValue component2() {
                return this.tomlValue;
            }

            @NotNull
            public final VersionCatalogDependency copy(@NotNull String coordinates, @NotNull LintTomlValue tomlValue) {
                Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
                Intrinsics.checkNotNullParameter((Object)tomlValue, (String)"tomlValue");
                return new VersionCatalogDependency(coordinates, tomlValue);
            }

            public static /* synthetic */ VersionCatalogDependency copy$default(VersionCatalogDependency versionCatalogDependency, String string, LintTomlValue lintTomlValue, int n, Object object) {
                if ((n & 1) != 0) {
                    string = versionCatalogDependency.coordinates;
                }
                if ((n & 2) != 0) {
                    lintTomlValue = versionCatalogDependency.tomlValue;
                }
                return versionCatalogDependency.copy(string, lintTomlValue);
            }

            @NotNull
            public String toString() {
                return "VersionCatalogDependency(coordinates=" + this.coordinates + ", tomlValue=" + this.tomlValue + ")";
            }

            public int hashCode() {
                int result = this.coordinates.hashCode();
                result = result * 31 + this.tomlValue.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof VersionCatalogDependency)) {
                    return false;
                }
                VersionCatalogDependency versionCatalogDependency = (VersionCatalogDependency)other;
                if (!Intrinsics.areEqual((Object)this.coordinates, (Object)versionCatalogDependency.coordinates)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.tomlValue, (Object)versionCatalogDependency.tomlValue);
            }
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LintModelModuleType.values().length];
                try {
                    nArray[LintModelModuleType.APP.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LintModelModuleType.LIBRARY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LintModelModuleType.JAVA_LIBRARY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LintModelModuleType.FEATURE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LintModelModuleType.DYNAMIC_FEATURE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LintModelModuleType.TEST.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LintModelModuleType.INSTANT_APP.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$DeprecatedConfiguration;", "", "deprecatedName", "", "replacementName", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "deprecatedSuffix", "replacementSuffix", "matches", "", "configurationName", "replacement", "COMPILE", "PROVIDED", "APK", "lint-checks"})
    private static final class DeprecatedConfiguration
    extends Enum<DeprecatedConfiguration> {
        @NotNull
        private final String deprecatedName;
        @NotNull
        private final String replacementName;
        @NotNull
        private final String deprecatedSuffix;
        @NotNull
        private final String replacementSuffix;
        public static final /* enum */ DeprecatedConfiguration COMPILE = new DeprecatedConfiguration("compile", "implementation");
        public static final /* enum */ DeprecatedConfiguration PROVIDED = new DeprecatedConfiguration("provided", "compileOnly");
        public static final /* enum */ DeprecatedConfiguration APK = new DeprecatedConfiguration("apk", "runtimeOnly");
        private static final /* synthetic */ DeprecatedConfiguration[] $VALUES;

        private DeprecatedConfiguration(String deprecatedName, String replacementName) {
            this.deprecatedName = deprecatedName;
            this.replacementName = replacementName;
            this.deprecatedSuffix = StringHelper.usLocaleCapitalize((String)this.deprecatedName);
            this.replacementSuffix = StringHelper.usLocaleCapitalize((String)this.replacementName);
        }

        public final boolean matches(@NotNull String configurationName) {
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            return Intrinsics.areEqual((Object)configurationName, (Object)this.deprecatedName) || StringsKt.endsWith$default((String)configurationName, (String)this.deprecatedSuffix, (boolean)false, (int)2, null);
        }

        @NotNull
        public final String replacement(@NotNull String configurationName) {
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            return Intrinsics.areEqual((Object)configurationName, (Object)this.deprecatedName) ? this.replacementName : StringsKt.removeSuffix((String)configurationName, (CharSequence)this.deprecatedSuffix) + this.replacementSuffix;
        }

        public static DeprecatedConfiguration[] values() {
            return (DeprecatedConfiguration[])$VALUES.clone();
        }

        public static DeprecatedConfiguration valueOf(String value) {
            return Enum.valueOf(DeprecatedConfiguration.class, value);
        }

        static {
            $VALUES = deprecatedConfigurationArray = new DeprecatedConfiguration[]{DeprecatedConfiguration.COMPILE, DeprecatedConfiguration.PROVIDED, DeprecatedConfiguration.APK};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\t\u0010\u0006\u001a\u00020\u0001H\u00c6\u0003J\u0013\u0010\u0007\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$JavaPluginInfo;", "", "cookie", "(Ljava/lang/Object;)V", "getCookie", "()Ljava/lang/Object;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "lint-checks"})
    public static final class JavaPluginInfo {
        @NotNull
        private final Object cookie;

        public JavaPluginInfo(@NotNull Object cookie) {
            Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
            this.cookie = cookie;
        }

        @NotNull
        public final Object getCookie() {
            return this.cookie;
        }

        @NotNull
        public final Object component1() {
            return this.cookie;
        }

        @NotNull
        public final JavaPluginInfo copy(@NotNull Object cookie) {
            Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
            return new JavaPluginInfo(cookie);
        }

        public static /* synthetic */ JavaPluginInfo copy$default(JavaPluginInfo javaPluginInfo, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = javaPluginInfo.cookie;
            }
            return javaPluginInfo.copy(object);
        }

        @NotNull
        public String toString() {
            return "JavaPluginInfo(cookie=" + this.cookie + ")";
        }

        public int hashCode() {
            return this.cookie.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JavaPluginInfo)) {
                return false;
            }
            JavaPluginInfo javaPluginInfo = (JavaPluginInfo)other;
            return Intrinsics.areEqual((Object)this.cookie, (Object)javaPluginInfo.cookie);
        }
    }
}

