/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\r*\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/CommunicationDeviceDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkMergedProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "getApplicableMethodNames", "", "", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "getFqName", "Lcom/intellij/psi/PsiElement;", "Companion", "lint-checks"})
public final class CommunicationDeviceDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(CommunicationDeviceDetector.class, EnumSet.of((Enum)Scope.ALL_JAVA_FILES));
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    public static final String FOUND_CLEAR_COMMUNICATION_DEVICE = "foundClearCommunicationDevice";
    public static final int MIN_TARGET_SDK_FOR_SET_COMMUNICATION_DEVICE = 31;

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"setCommunicationDevice", "clearCommunicationDevice"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        LintMap map = context.getPartialResults(ISSUE).map();
        if (Intrinsics.areEqual((Object)this.getFqName((PsiElement)method), (Object)"android.media.AudioManager.setCommunicationDevice")) {
            if (!context.getDriver().isSuppressed(context, ISSUE, (UElement)node)) {
                map.put(String.valueOf(map.getSize()), context.getLocation((UElement)node));
            }
        } else if (Intrinsics.areEqual((Object)this.getFqName((PsiElement)method), (Object)"android.media.AudioManager.clearCommunicationDevice")) {
            map.put(FOUND_CLEAR_COMMUNICATION_DEVICE, true);
        }
    }

    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        if (context.getMainProject().isLibrary()) {
            return;
        }
        if (context.getMainProject().getTargetSdk() < 31) {
            return;
        }
        for (LintMap perModuleLintMap : partialResults.maps()) {
            if (!perModuleLintMap.containsKey(FOUND_CLEAR_COMMUNICATION_DEVICE)) continue;
            return;
        }
        for (LintMap perModuleLintMap : partialResults.maps()) {
            for (String key : perModuleLintMap) {
                Incident incident = IncidentKt.Incident((Context)context).issue(ISSUE);
                Location location = perModuleLintMap.getLocation(key);
                Intrinsics.checkNotNull((Object)location);
                context.report(incident.location(location).message("Must call `clearCommunicationDevice()` after `setCommunicationDevice()`"));
            }
        }
    }

    public void checkMergedProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isGlobalAnalysis()) {
            this.checkPartialResults(context, context.getPartialResults(ISSUE));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getFqName(PsiElement $this$getFqName) {
        Object object;
        PsiNamedElement element = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)$this$getFqName);
        if (element instanceof PsiMember) {
            String string = element.getName();
            if (string != null) {
                void var3_3;
                String prefix;
                String name = string;
                boolean bl = false;
                PsiClass psiClass = ((PsiMember)element).getContainingClass();
                String string2 = prefix = psiClass != null ? psiClass.getQualifiedName() : null;
                object = string2 != null ? string2 + "." + name : var3_3;
            } else {
                object = null;
            }
        } else {
            object = element instanceof KtNamedDeclaration ? String.valueOf(((KtNamedDeclaration)element).getFqName()) : null;
        }
        return object;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"SetAndClearCommunicationDevice", (String)"Clearing communication device", (String)"\n                After selecting the audio device for communication use cases using \\\n                `setCommunicationDevice(AudioDeviceInfo device)`, the selection is active as long \\\n                as the requesting application process lives, until `clearCommunicationDevice()` \\\n                is called or until the device is disconnected. It is therefore important to clear \\\n                the request when a call ends or the requesting activity or service is stopped or \\\n                destroyed.\n                ", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/CommunicationDeviceDetector$Companion;", "", "()V", "FOUND_CLEAR_COMMUNICATION_DEVICE", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "MIN_TARGET_SDK_FOR_SET_COMMUNICATION_DEVICE", "", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

