/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.IntRangeConstraint;
import com.android.tools.lint.checks.RangeConstraint;
import com.android.tools.lint.detector.api.UastLintUtils;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B'\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0014\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0004J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006J/\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u001d\u001a\u00020\u0019H\u0007\u00a2\u0006\u0002\u0010\u001eJ \u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0019H\u0016J\u000e\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u0006J\u0012\u0010%\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0016J\b\u0010&\u001a\u00020\u0019H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006("}, d2={"Lcom/android/tools/lint/checks/FloatRangeConstraint;", "Lcom/android/tools/lint/checks/RangeConstraint;", "range", "Lcom/android/tools/lint/checks/IntRangeConstraint;", "(Lcom/android/tools/lint/checks/IntRangeConstraint;)V", "from", "", "to", "fromInclusive", "", "toInclusive", "(DDZZ)V", "getFrom", "()D", "getFromInclusive", "()Z", "infinite", "getInfinite", "getTo", "getToInclusive", "and", "other", "contains", "(Lcom/android/tools/lint/checks/RangeConstraint;)Ljava/lang/Boolean;", "describe", "", "argument", "Lorg/jetbrains/uast/UExpression;", "actualValue", "prefix", "(Lorg/jetbrains/uast/UExpression;Ljava/lang/Double;Ljava/lang/String;)Ljava/lang/String;", "describeDelta", "actual", "actualLabel", "allowedLabel", "isValid", "value", "remove", "toString", "Companion", "lint-checks"})
public final class FloatRangeConstraint
extends RangeConstraint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double from;
    private final double to;
    private final boolean fromInclusive;
    private final boolean toInclusive;

    private FloatRangeConstraint(double from, double to, boolean fromInclusive, boolean toInclusive) {
        this.from = from;
        this.to = to;
        this.fromInclusive = fromInclusive;
        this.toInclusive = toInclusive;
    }

    public final double getFrom() {
        return this.from;
    }

    public final double getTo() {
        return this.to;
    }

    public final boolean getFromInclusive() {
        return this.fromInclusive;
    }

    public final boolean getToInclusive() {
        return this.toInclusive;
    }

    public FloatRangeConstraint(@NotNull IntRangeConstraint range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(range.getFrom() == Long.MIN_VALUE ? Double.NEGATIVE_INFINITY : (double)range.getFrom(), range.getTo() == Long.MAX_VALUE ? Double.POSITIVE_INFINITY : (double)range.getTo(), true, true);
    }

    public final boolean isValid(double value) {
        return (this.fromInclusive && value >= this.from || !this.fromInclusive && value > this.from) && (this.toInclusive && value <= this.to || !this.toInclusive && value < this.to);
    }

    @Override
    public boolean getInfinite() {
        return this.from == Double.NEGATIVE_INFINITY || this.to == Double.POSITIVE_INFINITY;
    }

    @NotNull
    public final String describe(double argument) {
        return FloatRangeConstraint.describe$default(this, null, argument, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final String describe(@Nullable UExpression argument, @Nullable Double actualValue, @NotNull String prefix) {
        String valueString;
        String string;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        StringBuilder sb = new StringBuilder(20);
        sb.append(prefix);
        if (argument instanceof ULiteralExpression) {
            String str = argument.asSourceString();
            if (StringsKt.endsWith$default((String)str, (String)"f", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)str, (String)"F", (boolean)false, (int)2, null)) {
                String string2 = str.substring(0, str.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                str = string2;
            }
            string = str;
        } else {
            Double d = actualValue;
            string = valueString = d != null ? d.toString() : null;
        }
        if (actualValue != null && !this.isValid(actualValue)) {
            double value = actualValue;
            if (!(this.from == Double.NEGATIVE_INFINITY)) {
                if (!(this.to == Double.POSITIVE_INFINITY)) {
                    if (this.fromInclusive && value < this.from || !this.fromInclusive && value <= this.from) {
                        if (this.fromInclusive) {
                            sb.append('\u2265');
                        } else {
                            sb.append('>');
                        }
                        sb.append(' ');
                        sb.append(String.valueOf(this.from));
                    } else {
                        boolean bl;
                        boolean bl2 = bl = this.toInclusive && value > this.to || !this.toInclusive && value >= this.to;
                        if (_Assertions.ENABLED && !bl) {
                            String string3 = "Assertion failed";
                            throw new AssertionError((Object)string3);
                        }
                        if (this.toInclusive) {
                            sb.append('\u2264');
                        } else {
                            sb.append('<');
                        }
                        sb.append(' ');
                        sb.append(String.valueOf(this.to));
                    }
                } else {
                    if (this.fromInclusive) {
                        sb.append('\u2265');
                    } else {
                        sb.append('>');
                    }
                    sb.append(' ');
                    sb.append(String.valueOf(this.from));
                }
            } else if (!(this.to == Double.POSITIVE_INFINITY)) {
                if (this.toInclusive) {
                    sb.append('\u2264');
                } else {
                    sb.append('<');
                }
                sb.append(' ');
                sb.append(String.valueOf(this.to));
            }
            sb.append(" (was ").append(valueString).append(")");
            String string4 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            return string4;
        }
        if (!(this.from == Double.NEGATIVE_INFINITY)) {
            if (!(this.to == Double.POSITIVE_INFINITY)) {
                if (this.from == this.to && this.fromInclusive && this.toInclusive) {
                    sb.append(String.valueOf(this.from));
                } else {
                    if (this.fromInclusive) {
                        sb.append('\u2265');
                    } else {
                        sb.append('>');
                    }
                    sb.append(' ');
                    sb.append(String.valueOf(this.from));
                    sb.append(" and ");
                    if (this.toInclusive) {
                        sb.append('\u2264');
                    } else {
                        sb.append('<');
                    }
                    sb.append(' ');
                    sb.append(String.valueOf(this.to));
                }
                if (this.from > this.to || this.from == this.to && this.fromInclusive && !this.toInclusive) {
                    sb.append(" (not possible)");
                }
            } else {
                if (this.fromInclusive) {
                    sb.append('\u2265');
                } else {
                    sb.append('>');
                }
                sb.append(' ');
                sb.append(String.valueOf(this.from));
            }
        } else if (!(this.to == Double.POSITIVE_INFINITY)) {
            if (this.toInclusive) {
                sb.append('\u2264');
            } else {
                sb.append('<');
            }
            sb.append(' ');
            sb.append(String.valueOf(this.to));
        }
        if (valueString != null) {
            sb.append(" (is ").append(valueString).append(')');
        }
        String string5 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        return string5;
    }

    public static /* synthetic */ String describe$default(FloatRangeConstraint floatRangeConstraint, UExpression uExpression, Double d, String string, int n, Object object) {
        if ((n & 1) != 0) {
            uExpression = null;
        }
        if ((n & 2) != 0) {
            d = null;
        }
        if ((n & 4) != 0) {
            string = "Value must be ";
        }
        return floatRangeConstraint.describe(uExpression, d, string);
    }

    @Override
    @NotNull
    public String describeDelta(@NotNull RangeConstraint actual, @NotNull String actualLabel, @NotNull String allowedLabel) {
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)actualLabel, (String)"actualLabel");
        Intrinsics.checkNotNullParameter((Object)allowedLabel, (String)"allowedLabel");
        if (!(actual instanceof FloatRangeConstraint)) {
            return actual instanceof IntRangeConstraint ? this.describeDelta(new FloatRangeConstraint((IntRangeConstraint)actual), actualLabel, allowedLabel) : FloatRangeConstraint.describe$default(this, null, null, null, 7, null);
        }
        StringBuilder sb = new StringBuilder();
        if (((CharSequence)allowedLabel).length() > 0) {
            sb.append(this.describe(null, null, allowedLabel + " must be "));
        } else {
            sb.append(FloatRangeConstraint.describe$default(this, null, null, null, 6, null));
        }
        sb.append(" but ");
        if (((CharSequence)actualLabel).length() > 0) {
            sb.append(actualLabel).append(' ');
        }
        if (this.to <= ((FloatRangeConstraint)actual).from && !(((FloatRangeConstraint)actual).to == Double.POSITIVE_INFINITY) || this.from >= ((FloatRangeConstraint)actual).to && !(((FloatRangeConstraint)actual).from == Double.NEGATIVE_INFINITY)) {
            sb.append("can be " + ((FloatRangeConstraint)actual).describe(null, null, ""));
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        if (((FloatRangeConstraint)actual).from < this.from || ((FloatRangeConstraint)actual).from == this.from && !this.fromInclusive && ((FloatRangeConstraint)actual).fromInclusive) {
            if (((FloatRangeConstraint)actual).from == Double.NEGATIVE_INFINITY) {
                sb.append("can be < " + this.from);
            } else {
                sb.append("can be " + ((FloatRangeConstraint)actual).from);
            }
        } else if (((FloatRangeConstraint)actual).to > this.to || ((FloatRangeConstraint)actual).to == this.to && !this.toInclusive && ((FloatRangeConstraint)actual).toInclusive) {
            if (((FloatRangeConstraint)actual).to == Double.POSITIVE_INFINITY) {
                sb.append("can be > " + this.to);
            } else {
                sb.append("can be " + ((FloatRangeConstraint)actual).to);
            }
        } else {
            throw new IllegalStateException("There's no delta".toString());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public FloatRangeConstraint and(@Nullable RangeConstraint other) {
        FloatRangeConstraint floatRangeConstraint;
        if (other == null) {
            return this;
        }
        RangeConstraint rangeConstraint = other;
        if (rangeConstraint instanceof FloatRangeConstraint) {
            floatRangeConstraint = (FloatRangeConstraint)other;
        } else if (rangeConstraint instanceof IntRangeConstraint) {
            floatRangeConstraint = new FloatRangeConstraint((IntRangeConstraint)other);
        } else {
            String string = other.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = string;
            throw new IllegalStateException(string2.toString());
        }
        FloatRangeConstraint range = floatRangeConstraint;
        double start = 0.0;
        boolean startInclusive = false;
        double end = 0.0;
        boolean endInclusive = false;
        if (this.from == range.from) {
            start = this.from;
            startInclusive = this.fromInclusive && range.fromInclusive;
        } else if (this.from > range.from) {
            start = this.from;
            startInclusive = this.fromInclusive;
        } else {
            start = range.from;
            startInclusive = range.fromInclusive;
        }
        if (this.to == range.to) {
            end = this.to;
            endInclusive = this.toInclusive && range.toInclusive;
        } else if (this.to < range.to) {
            end = this.to;
            endInclusive = this.toInclusive;
        } else {
            end = range.to;
            endInclusive = range.toInclusive;
        }
        return new FloatRangeConstraint(start, end, startInclusive, endInclusive);
    }

    @Override
    @Nullable
    public RangeConstraint remove(@NotNull RangeConstraint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other instanceof FloatRangeConstraint) {
            if (this.from <= ((FloatRangeConstraint)other).to) {
                if (!(((FloatRangeConstraint)other).to == Double.POSITIVE_INFINITY) && this.to > ((FloatRangeConstraint)other).to + 1.0) {
                    return new FloatRangeConstraint(((FloatRangeConstraint)other).to, this.to, false, this.toInclusive);
                }
                if (!(((FloatRangeConstraint)other).from == Double.NEGATIVE_INFINITY) && this.from < ((FloatRangeConstraint)other).from - 1.0) {
                    return new FloatRangeConstraint(this.from, ((FloatRangeConstraint)other).from, this.fromInclusive, false);
                }
            }
        } else if (other instanceof IntRangeConstraint) {
            return this.remove(new FloatRangeConstraint((IntRangeConstraint)other));
        }
        return super.remove(other);
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull RangeConstraint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other instanceof FloatRangeConstraint) {
            return !(((FloatRangeConstraint)other).from < this.from || ((FloatRangeConstraint)other).to > this.to || !this.fromInclusive && ((FloatRangeConstraint)other).fromInclusive && ((FloatRangeConstraint)other).from == this.from || !this.toInclusive && ((FloatRangeConstraint)other).toInclusive && ((FloatRangeConstraint)other).to == this.to);
        }
        if (other instanceof IntRangeConstraint) {
            return !((double)((IntRangeConstraint)other).getFrom() < this.from || (double)((IntRangeConstraint)other).getTo() > this.to || !this.fromInclusive && (double)((IntRangeConstraint)other).getFrom() == this.from || !this.toInclusive && (double)((IntRangeConstraint)other).getTo() == this.to);
        }
        return null;
    }

    @NotNull
    public String toString() {
        return FloatRangeConstraint.describe$default(this, null, null, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final String describe(@Nullable UExpression argument, @Nullable Double actualValue) {
        return FloatRangeConstraint.describe$default(this, argument, actualValue, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final String describe(@Nullable UExpression argument) {
        return FloatRangeConstraint.describe$default(this, argument, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final String describe() {
        return FloatRangeConstraint.describe$default(this, null, null, null, 7, null);
    }

    @JvmStatic
    @NotNull
    public static final FloatRangeConstraint create(@NotNull UAnnotation annotation) {
        return Companion.create(annotation);
    }

    @JvmStatic
    @NotNull
    public static final FloatRangeConstraint range(double from, double to) {
        return Companion.range(from, to);
    }

    @JvmStatic
    @NotNull
    public static final FloatRangeConstraint range(double from, boolean fromInclusive, double to, boolean toInclusive) {
        return Companion.range(from, fromInclusive, to, toInclusive);
    }

    @JvmStatic
    @NotNull
    public static final FloatRangeConstraint atLeast(double from) {
        return Companion.atLeast(from);
    }

    @JvmStatic
    @NotNull
    public static final FloatRangeConstraint atMost(double to) {
        return Companion.atMost(to);
    }

    @JvmStatic
    @NotNull
    public static final FloatRangeConstraint greaterThan(double from) {
        return Companion.greaterThan(from);
    }

    @JvmStatic
    @NotNull
    public static final FloatRangeConstraint lessThan(double to) {
        return Companion.lessThan(to);
    }

    public /* synthetic */ FloatRangeConstraint(double from, double to, boolean fromInclusive, boolean toInclusive, DefaultConstructorMarker $constructor_marker) {
        this(from, to, fromInclusive, toInclusive);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0007J(\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0007J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/FloatRangeConstraint$Companion;", "", "()V", "atLeast", "Lcom/android/tools/lint/checks/FloatRangeConstraint;", "from", "", "atMost", "to", "create", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "greaterThan", "lessThan", "range", "fromInclusive", "", "toInclusive", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FloatRangeConstraint create(@NotNull UAnnotation annotation) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            boolean bl = AnnotationDetectorKt.FLOAT_RANGE_ANNOTATION.isEquals(annotation.getQualifiedName());
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            double from = UastLintUtils.Companion.getAnnotationDoubleValue(annotation, "from", Double.NEGATIVE_INFINITY);
            double to = UastLintUtils.Companion.getAnnotationDoubleValue(annotation, "to", Double.POSITIVE_INFINITY);
            boolean fromInclusive = UastLintUtils.Companion.getAnnotationBooleanValue(annotation, "fromInclusive", true);
            boolean toInclusive = UastLintUtils.Companion.getAnnotationBooleanValue(annotation, "toInclusive", true);
            return new FloatRangeConstraint(from, to, fromInclusive, toInclusive, null);
        }

        @JvmStatic
        @NotNull
        public final FloatRangeConstraint range(double from, double to) {
            return new FloatRangeConstraint(from, to, true, true, null);
        }

        @JvmStatic
        @NotNull
        public final FloatRangeConstraint range(double from, boolean fromInclusive, double to, boolean toInclusive) {
            return new FloatRangeConstraint(from, to, fromInclusive, toInclusive, null);
        }

        @JvmStatic
        @NotNull
        public final FloatRangeConstraint atLeast(double from) {
            return new FloatRangeConstraint(from, Double.POSITIVE_INFINITY, true, true, null);
        }

        @JvmStatic
        @NotNull
        public final FloatRangeConstraint atMost(double to) {
            return new FloatRangeConstraint(Double.NEGATIVE_INFINITY, to, true, true, null);
        }

        @JvmStatic
        @NotNull
        public final FloatRangeConstraint greaterThan(double from) {
            return new FloatRangeConstraint(from, Double.POSITIVE_INFINITY, false, true, null);
        }

        @JvmStatic
        @NotNull
        public final FloatRangeConstraint lessThan(double to) {
            return new FloatRangeConstraint(Double.NEGATIVE_INFINITY, to, true, false, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

