/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u00012\u00020\u0002:\u0003\u0011\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/UnsafeFilenameDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "isFirstArgDisplayName", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "visitMethodCall", "", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "DisplayNameDataFlowAnalyzer", "FilenameDataFlowAnalyzer", "lint-checks"})
public final class UnsafeFilenameDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String LITERAL_DISPLAY_NAME = "_display_name";
    @NotNull
    private static final String METHOD_GET_COLUMN_INDEX = "getColumnIndex";
    @NotNull
    private static final String METHOD_GET_COLUMN_INDEX_OR_THROW = "getColumnIndexOrThrow";
    @NotNull
    private static final String METHOD_GET_STRING = "getString";
    @NotNull
    private static final String CLASS_CURSOR = "android.database.Cursor";
    @NotNull
    private static final String CLASS_FILE = "java.io.File";

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{METHOD_GET_COLUMN_INDEX, METHOD_GET_COLUMN_INDEX_OR_THROW};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
        if (uMethod == null) {
            return;
        }
        UMethod parentMethod = uMethod;
        JavaEvaluator evaluator = context.getEvaluator();
        String[] stringArray = new String[]{"java.lang.String"};
        if (!evaluator.methodMatches(method, CLASS_CURSOR, true, stringArray)) {
            return;
        }
        if (!this.isFirstArgDisplayName(node, context)) {
            return;
        }
        parentMethod.accept((UastVisitor)new DisplayNameDataFlowAnalyzer((UElement)node, context, evaluator));
    }

    private final boolean isFirstArgDisplayName(UCallExpression node, JavaContext context) {
        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
        if (uExpression == null) {
            return false;
        }
        UExpression firstArg = uExpression;
        Object evaluatedConstant = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)firstArg));
        return evaluatedConstant instanceof String && Intrinsics.areEqual((Object)evaluatedConstant, (Object)LITERAL_DISPLAY_NAME);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(UnsafeFilenameDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"UnsanitizedFilenameFromContentProvider", (String)"Trusting ContentProvider filenames without any sanitization", (String)"\n            When communicating between applications with files, the server app can provide the \\\n          client app with a maliciously constructed filename. The client app should never trust \\\n          this filename and should either sanitize it or completely discard it.\n        ", (Implementation)implementation, (String)"https://developer.android.com/privacy-and-security/risks/untrustworthy-contentprovider-provided-filename", (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/UnsafeFilenameDetector$Companion;", "", "()V", "CLASS_CURSOR", "", "CLASS_FILE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "LITERAL_DISPLAY_NAME", "METHOD_GET_COLUMN_INDEX", "METHOD_GET_COLUMN_INDEX_OR_THROW", "METHOD_GET_STRING", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/UnsafeFilenameDetector$DisplayNameDataFlowAnalyzer;", "Lcom/android/tools/lint/checks/DataFlowAnalyzer;", "trackedNode", "Lorg/jetbrains/uast/UElement;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "(Lorg/jetbrains/uast/UElement;Lcom/android/tools/lint/detector/api/JavaContext;Lcom/android/tools/lint/client/api/JavaEvaluator;)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "getEvaluator", "()Lcom/android/tools/lint/client/api/JavaEvaluator;", "getTrackedNode", "()Lorg/jetbrains/uast/UElement;", "argument", "", "call", "Lorg/jetbrains/uast/UCallExpression;", "reference", "lint-checks"})
    private static final class DisplayNameDataFlowAnalyzer
    extends DataFlowAnalyzer {
        @NotNull
        private final UElement trackedNode;
        @NotNull
        private final JavaContext context;
        @NotNull
        private final JavaEvaluator evaluator;

        public DisplayNameDataFlowAnalyzer(@NotNull UElement trackedNode, @NotNull JavaContext context, @NotNull JavaEvaluator evaluator) {
            Intrinsics.checkNotNullParameter((Object)trackedNode, (String)"trackedNode");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            super(SetsKt.setOf((Object)trackedNode), null, 2, null);
            this.trackedNode = trackedNode;
            this.context = context;
            this.evaluator = evaluator;
        }

        @NotNull
        public final UElement getTrackedNode() {
            return this.trackedNode;
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        @NotNull
        public final JavaEvaluator getEvaluator() {
            return this.evaluator;
        }

        @Override
        public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                PsiMethod psiMethod = call.resolve();
                if (psiMethod == null) {
                    return;
                }
                PsiMethod psiMethod2 = psiMethod;
                if (!Intrinsics.areEqual((Object)call.getMethodName(), (Object)UnsafeFilenameDetector.METHOD_GET_STRING)) break block3;
                String[] stringArray = new String[]{"int"};
                if (this.evaluator.methodMatches(psiMethod2, UnsafeFilenameDetector.CLASS_CURSOR, true, stringArray)) {
                    UMethod parentMethod;
                    UMethod uMethod = parentMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)call), UMethod.class, (boolean)false, (int)2, null);
                    if (uMethod != null) {
                        uMethod.accept((UastVisitor)new FilenameDataFlowAnalyzer((UElement)call, this.evaluator, this.context));
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/UnsafeFilenameDetector$FilenameDataFlowAnalyzer;", "Lcom/android/tools/lint/checks/DataFlowAnalyzer;", "trackedFilename", "Lorg/jetbrains/uast/UElement;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lorg/jetbrains/uast/UElement;Lcom/android/tools/lint/client/api/JavaEvaluator;Lcom/android/tools/lint/detector/api/JavaContext;)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "getEvaluator", "()Lcom/android/tools/lint/client/api/JavaEvaluator;", "isPotentiallySanitized", "", "getTrackedFilename", "()Lorg/jetbrains/uast/UElement;", "argument", "", "call", "Lorg/jetbrains/uast/UCallExpression;", "reference", "receiver", "lint-checks"})
    private static final class FilenameDataFlowAnalyzer
    extends DataFlowAnalyzer {
        @NotNull
        private final UElement trackedFilename;
        @NotNull
        private final JavaEvaluator evaluator;
        @NotNull
        private final JavaContext context;
        private boolean isPotentiallySanitized;

        public FilenameDataFlowAnalyzer(@NotNull UElement trackedFilename, @NotNull JavaEvaluator evaluator, @NotNull JavaContext context) {
            Intrinsics.checkNotNullParameter((Object)trackedFilename, (String)"trackedFilename");
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(SetsKt.setOf((Object)trackedFilename), null, 2, null);
            this.trackedFilename = trackedFilename;
            this.evaluator = evaluator;
            this.context = context;
        }

        @NotNull
        public final UElement getTrackedFilename() {
            return this.trackedFilename;
        }

        @NotNull
        public final JavaEvaluator getEvaluator() {
            return this.evaluator;
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        @Override
        public void receiver(@NotNull UCallExpression call) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            this.isPotentiallySanitized = true;
        }

        @Override
        public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            PsiMethod psiMethod = call.resolve();
            if (psiMethod != null && psiMethod.isConstructor() && JavaEvaluator.extendsClass$default((JavaEvaluator)this.evaluator, (PsiClass)psiMethod.getContainingClass(), (String)UnsafeFilenameDetector.CLASS_FILE, (boolean)false, (int)4, null) && !this.isPotentiallySanitized) {
                PsiElement psiElement = reference.getSourcePsi();
                JavaContext.report$default((JavaContext)this.context, (Issue)ISSUE, (UElement)reference, (Location)this.context.getLocation(reference), (String)StringsKt.trimMargin$default((String)("\n              Using `" + (psiElement != null ? psiElement.getText() : null) + "` is unsafe as it is a filename obtained directly \\\n              from a `ContentProvider`. You should sanitize it before using it for creating a \\\n              `File`.\n          "), null, (int)1, null), null, (int)16, null);
            } else {
                this.isPotentiallySanitized = true;
            }
        }
    }
}

