/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ControlFlowGraph;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J^\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u00180\u001aj\u0002`\u001b2\u001c\u0010\u001c\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00180\u001fj\u0002` 0\u001e0\u001d2\u0016\u0010!\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00180\u001aj\u0002`\u001b0\u001dH\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001eH\u0016J \u0010$\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020&H\u0016J\f\u0010'\u001a\u00020\b*\u00020\u0013H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/lint/checks/WakelockDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/ClassScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "firstAcquireLocation", "Lcom/android/tools/lint/detector/api/Location;", "hasAcquireCall", "", "hasRelease", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkFlow", "Lcom/android/tools/lint/detector/api/JavaContext;", "method", "Lorg/jetbrains/uast/UMethod;", "acquire", "Lorg/jetbrains/uast/UCallExpression;", "dfs", "", "graph", "Lcom/android/tools/lint/checks/ControlFlowGraph;", "Lorg/jetbrains/uast/UElement;", "startNode", "Lcom/android/tools/lint/checks/ControlFlowGraph$Node;", "Lcom/android/tools/lint/checks/Node;", "exitPaths", "", "", "Lcom/android/tools/lint/checks/ControlFlowGraph$Edge;", "Lcom/android/tools/lint/checks/Edge;", "releaseNodes", "getApplicableMethodNames", "", "visitMethodCall", "node", "Lcom/intellij/psi/PsiMethod;", "isReleaseCall", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nWakelockDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WakelockDetector.kt\ncom/android/tools/lint/checks/WakelockDetector\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,423:1\n18#2:424\n18#2:425\n1611#3,9:426\n1863#3:435\n1864#3:437\n1620#3:438\n1863#3,2:439\n1#4:436\n*S KotlinDebug\n*F\n+ 1 WakelockDetector.kt\ncom/android/tools/lint/checks/WakelockDetector\n*L\n207#1:424\n220#1:425\n358#1:426,9\n358#1:435\n358#1:437\n358#1:438\n358#1:439,2\n358#1:436\n*E\n"})
public final class WakelockDetector
extends Detector
implements ClassScanner,
SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean hasAcquireCall;
    @Nullable
    private Location firstAcquireLocation;
    private boolean hasRelease;
    @NotNull
    public static final String ANDROID_APP_ACTIVITY = "android.app.Activity";
    private static final int PARTIAL_WAKE_LOCK = 1;
    private static final int ACQUIRE_CAUSES_WAKEUP = 0x10000000;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(WakelockDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @JvmField
    @NotNull
    public static final Issue TIMEOUT;
    @NotNull
    private static final String WAKELOCK_OWNER = "android.os.PowerManager.WakeLock";
    @NotNull
    private static final String POWER_MANAGER_OWNER = "android.os.PowerManager";
    @NotNull
    private static final String RELEASE_METHOD = "release";
    @NotNull
    private static final String ACQUIRE_METHOD = "acquire";
    @NotNull
    private static final String IS_HELD_METHOD = "isHeld";
    @NotNull
    private static final String NEW_WAKE_LOCK_METHOD = "newWakeLock";
    private static final int SEEN_EXCEPTION = 1;
    private static final int SEEN_EXIT = 2;

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.hasRelease && this.firstAcquireLocation != null) {
            Location location = this.firstAcquireLocation;
            Intrinsics.checkNotNull((Object)location);
            Context.report$default((Context)context, (Issue)ISSUE, (Location)location, (String)"Found a wakelock `acquire()` but no `release()` calls anywhere", null, (int)8, null);
        }
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{ACQUIRE_METHOD, RELEASE_METHOD, NEW_WAKE_LOCK_METHOD};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Object constant;
        block13: {
            PsiClass containingClass;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            String string = method.getName();
            switch (string.hashCode()) {
                case 1545258671: {
                    if (!string.equals(NEW_WAKE_LOCK_METHOD)) {
                        return;
                    }
                    break block13;
                }
                case 1090594823: {
                    if (string.equals(RELEASE_METHOD)) break;
                    return;
                }
                case -1164222250: {
                    PsiElement lockDeclaration;
                    UExpression uExpression;
                    if (!string.equals(ACQUIRE_METHOD)) return;
                    if (node.getValueArgumentCount() > 0) {
                        return;
                    }
                    if (!context.getEvaluator().isMemberInClass((PsiMember)method, WAKELOCK_OWNER)) {
                        return;
                    }
                    if (!(this.hasRelease || this.hasAcquireCall || this.firstAcquireLocation != null || context.getDriver().isIsolated() || context.getDriver().isSuppressed(context, ISSUE, (UElement)node))) {
                        this.firstAcquireLocation = context.getLocation((UElement)node);
                    }
                    this.hasAcquireCall = true;
                    if (context.isEnabled(TIMEOUT)) {
                        Location location = context.getLocation((UElement)node);
                        LintFix fix = this.fix().name("Set timeout to 10 minutes").replace().pattern("acquire\\s*\\(()\\s*\\)").with("10*60*1000L /*10 minutes*/").build();
                        context.report(TIMEOUT, (UElement)node, location, "Provide a timeout when requesting a wakelock with `PowerManager.Wakelock.acquire(long timeout)`. This will ensure the OS will cleanup any wakelocks that last longer than you intend, and will save your user's battery.", fix);
                    }
                    PsiElement psiElement = (uExpression = node.getReceiver()) != null && (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) != null ? UastUtils.tryResolve((UElement)((UElement)uExpression)) : (lockDeclaration = null);
                    if (lockDeclaration instanceof PsiField) {
                        return;
                    }
                    UElement $this$getParentOfType_u24default$iv = (UElement)node;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType = false;
                    UMethod containingMethod = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UMethod.class, (boolean)strict$iv);
                    if (containingMethod == null) return;
                    this.checkFlow(context, containingMethod, node);
                    return;
                }
            }
            if (!context.getEvaluator().isMemberInClass((PsiMember)method, WAKELOCK_OWNER)) {
                return;
            }
            this.hasRelease = true;
            UElement $this$getParentOfType_u24default$iv = (UElement)node;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            UMethod containingMethod = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UMethod.class, (boolean)strict$iv);
            if (containingMethod == null) return;
            if (!Intrinsics.areEqual((Object)containingMethod.getName(), (Object)"onDestroy") || (containingClass = containingMethod.getJavaPsi().getContainingClass()) == null || !JavaEvaluator.inheritsFrom$default((JavaEvaluator)context.getEvaluator(), (PsiClass)containingClass, (String)ANDROID_APP_ACTIVITY, (boolean)false, (int)4, null)) return;
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)"Wakelocks should be released in `onPause`, not `onDestroy`", null, (int)16, null);
            return;
        }
        if (!context.getEvaluator().isMemberInClass((PsiMember)method, POWER_MANAGER_OWNER)) {
            return;
        }
        List arguments = node.getValueArguments();
        if (arguments.size() != 2 || !((constant = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)CollectionsKt.first((List)arguments)))) instanceof Integer)) return;
        int both = 0x10000001;
        if ((((Number)constant).intValue() & both) != both) return;
        JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)CollectionsKt.first((List)arguments)), (String)"Should not set both `PARTIAL_WAKE_LOCK` and `ACQUIRE_CAUSES_WAKEUP`. If you do not want the screen to turn on, get rid of `ACQUIRE_CAUSES_WAKEUP`", null, (int)16, null);
    }

    private final boolean isReleaseCall(UCallExpression $this$isReleaseCall) {
        PsiMethod psiMethod;
        return Intrinsics.areEqual((Object)$this$isReleaseCall.getMethodName(), (Object)RELEASE_METHOD) && Intrinsics.areEqual((Object)((psiMethod = $this$isReleaseCall.resolve()) != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)WAKELOCK_OWNER);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFlow(JavaContext context, UMethod method, UCallExpression acquire) {
        CharSequence charSequence = context.getContents();
        if (charSequence == null) {
            return;
        }
        CharSequence contents = charSequence;
        PsiElement psiElement = method.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        int offset = psiElement.getTextOffset();
        if (StringsKt.indexOf$default((CharSequence)contents, (String)RELEASE_METHOD, (int)offset, (boolean)false, (int)4, null) == -1) {
            return;
        }
        List releaseCalls = new ArrayList();
        method.accept((UastVisitor)new AbstractUastVisitor(this, releaseCalls){
            final /* synthetic */ WakelockDetector this$0;
            final /* synthetic */ List<UCallExpression> $releaseCalls;
            {
                this.this$0 = $receiver;
                this.$releaseCalls = $releaseCalls;
            }

            public boolean visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (WakelockDetector.access$isReleaseCall(this.this$0, node)) {
                    this.$releaseCalls.add(node);
                }
                return super.visitCallExpression(node);
            }
        });
        if (releaseCalls.isEmpty()) {
            return;
        }
        ControlFlowGraph<UElement> graph2 = ControlFlowGraph.Companion.create(method, new ControlFlowGraph.Companion.Builder(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean canThrow(UElement reference, PsiMethod method) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                String string = method.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String name = string;
                switch (name.hashCode()) {
                    case 1090594823: {
                        if (name.equals("release")) return false;
                        return super.canThrow(reference, method);
                    }
                    case -1180456065: {
                        if (name.equals("isHeld")) return false;
                        return super.canThrow(reference, method);
                    }
                    case -1164222250: {
                        if (!name.equals("acquire")) return super.canThrow(reference, method);
                        return false;
                    }
                }
                return super.canThrow(reference, method);
            }

            public ControlFlowGraph.FollowBranch checkBranchPaths(UExpression conditional) {
                UastBinaryOperator condition;
                Intrinsics.checkNotNullParameter((Object)conditional, (String)"conditional");
                UElement selector = UastLintUtilsKt.findSelector((UElement)((UElement)conditional));
                if (selector instanceof UCallExpression) {
                    PsiMethod resolved;
                    PsiMethod psiMethod = resolved = ((UCallExpression)selector).resolve();
                    if (Intrinsics.areEqual((Object)(psiMethod != null ? psiMethod.getName() : null), (Object)"isHeld")) {
                        PsiClass psiClass = resolved.getContainingClass();
                        if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"android.os.PowerManager.WakeLock")) {
                            return ControlFlowGraph.FollowBranch.THEN;
                        }
                    }
                } else if (selector instanceof UBinaryExpression && (Intrinsics.areEqual((Object)(condition = ((UBinaryExpression)selector).getOperator()), (Object)UastBinaryOperator.NOT_EQUALS) || Intrinsics.areEqual((Object)condition, (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS)) && UastLiteralUtils.isNullLiteral((UElement)((UElement)((UBinaryExpression)selector).getRightOperand()))) {
                    return ControlFlowGraph.FollowBranch.THEN;
                }
                return super.checkBranchPaths(conditional);
            }
        });
        List exitPaths = new ArrayList();
        List releaseNodes = new ArrayList();
        ControlFlowGraph.Node<UElement> node = graph2.getNode((UElement)acquire);
        if (node == null) {
            return;
        }
        ControlFlowGraph.Node<UElement> acquireNode = node;
        int status = this.dfs(graph2, acquireNode, exitPaths, releaseNodes);
        if ((status & 2) != 0) {
            Location location;
            boolean viaException = (status & 1) != 0;
            String exitPath = ControlFlowGraph.Companion.describePath((List)CollectionsKt.first((List)exitPaths));
            StringBuilder message2 = new StringBuilder();
            message2.append("The `release()` call is not always reached");
            if (((CharSequence)exitPath).length() > 0 || viaException) {
                message2.append(" (");
                if (viaException) {
                    message2.append("because of a possible exception");
                    if (((CharSequence)exitPath).length() > 0) {
                        message2.append(" in the path ").append(exitPath);
                    }
                } else {
                    message2.append("can exit the method via path " + exitPath);
                }
                message2.append("; use try/finally to ensure `release` is always called)");
            }
            if (releaseNodes.isEmpty()) {
                void $this$forEach$iv;
                Iterator $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = releaseCalls;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ControlFlowGraph.Node<UElement> it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    UCallExpression it = (UCallExpression)element$iv$iv;
                    boolean bl2 = false;
                    if (graph2.getNode((UElement)it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    ControlFlowGraph.Node it = (ControlFlowGraph.Node)element$iv;
                    boolean bl = false;
                    releaseNodes.add(it);
                }
            }
            if (releaseNodes.size() == 0) {
                return;
            }
            UElement call = (UElement)((ControlFlowGraph.Node)CollectionsKt.first((List)releaseNodes)).getInstruction();
            Intrinsics.checkNotNull((Object)call, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
            Location last = location = context.getCallLocation((UCallExpression)call, false, false);
            int n = releaseNodes.size();
            for (int i = 1; i < n; ++i) {
                ControlFlowGraph.Node release = (ControlFlowGraph.Node)releaseNodes.get(i);
                UElement element = (UElement)release.getInstruction();
                Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                Location secondary = context.getCallLocation((UCallExpression)element, false, false);
                last.setSecondary(secondary);
                last = secondary;
            }
            UElement uElement = (UElement)acquire;
            String string = message2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)uElement, (Location)location, (String)string, null, (int)16, null);
        }
    }

    private final int dfs(ControlFlowGraph<UElement> graph2, ControlFlowGraph.Node<UElement> startNode, List<List<ControlFlowGraph.Edge<UElement>>> exitPaths, List<ControlFlowGraph.Node<UElement>> releaseNodes) {
        return ((Number)graph2.dfs(ControlFlowGraph.Companion.getIntBitsDomain(), (ControlFlowGraph.DfsRequest)new ControlFlowGraph.DfsRequest<UElement, Integer>(startNode, exitPaths, this, releaseNodes){
            final /* synthetic */ List<List<ControlFlowGraph.Edge<UElement>>> $exitPaths;
            final /* synthetic */ WakelockDetector this$0;
            final /* synthetic */ List<ControlFlowGraph.Node<UElement>> $releaseNodes;
            {
                this.$exitPaths = $exitPaths;
                this.this$0 = $receiver;
                this.$releaseNodes = $releaseNodes;
                super($startNode);
            }

            /*
             * WARNING - void declaration
             */
            public Integer visitNode(ControlFlowGraph.Node<UElement> node, List<ControlFlowGraph.Edge<UElement>> path, int status) {
                int n;
                Intrinsics.checkNotNullParameter(node, (String)"node");
                Intrinsics.checkNotNullParameter(path, (String)"path");
                if (node.isExit()) {
                    boolean bl;
                    int n2;
                    block5: {
                        void $this$any$iv;
                        this.$exitPaths.add(path);
                        Iterable iterable = path;
                        n2 = 2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                ControlFlowGraph.Edge it = (ControlFlowGraph.Edge)element$iv;
                                boolean bl2 = false;
                                if (!it.isException()) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    }
                    boolean bl3 = bl;
                    n = n2 | (bl3 ? 1 : 0);
                } else {
                    n = 0;
                }
                return n;
            }

            public boolean prune(ControlFlowGraph.Node<UElement> node, List<ControlFlowGraph.Edge<UElement>> path, int status) {
                boolean bl;
                Intrinsics.checkNotNullParameter(node, (String)"node");
                Intrinsics.checkNotNullParameter(path, (String)"path");
                UElement instruction = node.getInstruction();
                if (instruction instanceof UCallExpression && WakelockDetector.access$isReleaseCall(this.this$0, (UCallExpression)instruction)) {
                    this.$releaseNodes.add(node);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public boolean isDone(int status) {
                return (status & 2) != 0;
            }
        })).intValue();
    }

    public static final /* synthetic */ boolean access$isReleaseCall(WakelockDetector $this, UCallExpression $receiver) {
        return $this.isReleaseCall($receiver);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"Wakelock", (String)"Incorrect `WakeLock` usage", (String)"\n          Failing to release a wakelock properly can keep the Android device in a high power mode, \\\n          which reduces battery life. There are several causes of this, such as releasing the wake \\\n          lock in `onDestroy()` instead of in `onPause()`, failing to call `release()` in all \\\n          possible code paths after an `acquire()`, and so on.\n\n          NOTE: If you are using the lock just to keep the screen on, you should strongly consider \\\n          using `FLAG_KEEP_SCREEN_ON` instead. This window flag will be correctly managed by the \\\n          platform as the user moves between applications and doesn't require a special permission. \\\n          See https://developer.android.com/reference/android/view/WindowManager.LayoutParams.html#FLAG_KEEP_SCREEN_ON.\n          ", (Implementation)implementation, null, (Category)category, (int)9, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.PERFORMANCE;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        TIMEOUT = Issue.Companion.create$default((Issue.Companion)companion, (String)"WakelockTimeout", (String)"Using wakeLock without timeout", (String)"\n          Wakelocks have two acquire methods: one with a timeout, and one without. You should \\\n          generally always use the one with a timeout. A typical timeout is 10 minutes. If the task \\\n          takes longer than it is critical that it happens (i.e. can't use `JobScheduler`) then \\\n          maybe they should consider a foreground service instead (which is a stronger run guarantee \\\n          and lets the user know something long/important is happening).\n          ", (Implementation)implementation, null, (Category)category, (int)9, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/WakelockDetector$Companion;", "", "()V", "ACQUIRE_CAUSES_WAKEUP", "", "ACQUIRE_METHOD", "", "ANDROID_APP_ACTIVITY", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "IS_HELD_METHOD", "NEW_WAKE_LOCK_METHOD", "PARTIAL_WAKE_LOCK", "POWER_MANAGER_OWNER", "RELEASE_METHOD", "SEEN_EXCEPTION", "SEEN_EXIT", "TIMEOUT", "WAKELOCK_OWNER", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

