/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.repository.NetworkCache;
import com.android.tools.lint.checks.GooglePlaySdkIndex;
import com.android.tools.lint.checks.GooglePlaySdkIndexKt;
import com.android.tools.lint.checks.Index;
import com.android.tools.lint.checks.Library;
import com.android.tools.lint.checks.LibraryVersion;
import com.android.tools.lint.checks.LibraryVersionLabels;
import com.android.tools.lint.checks.LibraryVersionRange;
import com.android.tools.lint.checks.Sdk;
import com.android.tools.lint.detector.api.LintFix;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 a2\u00020\u0001:\u0005abcdeB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u001e\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bJ\u001e\u0010$\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bJ$\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0&2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bJ\u001e\u0010'\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bJ\u001e\u0010(\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bJ$\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0&2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bJ\"\u0010*\u001a\u00020\u000b2\u0010\u0010+\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010,\u0018\u00010&2\u0006\u0010-\u001a\u00020\u0006H\u0002J,\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\b\u00100\u001a\u0004\u0018\u000101H\u0016J$\u00102\u001a\b\u0012\u0004\u0012\u0002030&2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bJ\"\u00104\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bH\u0002J\b\u00105\u001a\u000206H\u0007J\u0018\u00107\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bJ\"\u00108\u001a\u0004\u0018\u0001092\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bH\u0002J \u0010:\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bH\u0002J \u0010;\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bH\u0002J\u0018\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000b0&2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J \u0010=\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bH\u0002J\u001a\u0010>\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0018\u0010?\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bJ\u0018\u0010@\u001a\b\u0012\u0004\u0012\u0002030&2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u001e\u0010A\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bJ(\u0010B\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\b\u00100\u001a\u0004\u0018\u000101J\u001e\u0010C\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bJ(\u0010D\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\b\u00100\u001a\u0004\u0018\u000101J\u0006\u0010E\u001a\u00020FJ\u0014\u0010E\u001a\u00020F2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010HH\u0007J(\u0010I\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\b\u00100\u001a\u0004\u0018\u000101J(\u0010J\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\b\u00100\u001a\u0004\u0018\u000101J\u0006\u0010K\u001a\u00020\u0006J\u0018\u0010L\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0018\u0010M\u001a\u00020F2\u0006\u0010N\u001a\u00020\b2\u0006\u0010O\u001a\u000206H\u0014J\u0010\u0010P\u001a\u00020F2\u0006\u0010N\u001a\u00020\bH\u0014J*\u0010Q\u001a\u00020F2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\b\u0010R\u001a\u0004\u0018\u000101H\u0014J\u0010\u0010S\u001a\u00020F2\u0006\u0010O\u001a\u000206H\u0014J*\u0010T\u001a\u00020F2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\b\u0010R\u001a\u0004\u0018\u000101H\u0014J*\u0010U\u001a\u00020F2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\b\u0010R\u001a\u0004\u0018\u000101H\u0014J*\u0010V\u001a\u00020F2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\b\u0010R\u001a\u0004\u0018\u000101H\u0014J\u0012\u0010W\u001a\u0004\u0018\u00010H2\u0006\u0010X\u001a\u00020\u000bH\u0014J\u0018\u0010Y\u001a\u00020\b2\u000e\u0010Z\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010H0[H\u0002J$\u0010\\\u001a\b\u0012\u0004\u0012\u00020,0]2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bJ\u0010\u0010^\u001a\u00020F2\u0006\u0010_\u001a\u00020`H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lcom/android/tools/lint/checks/GooglePlaySdkIndex;", "Lcom/android/ide/common/repository/NetworkCache;", "cacheDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "initialized", "", "lastReadResult", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataResult;", "libraryToSdk", "Ljava/util/HashMap;", "", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex$LibraryToSdk;", "Lkotlin/collections/HashMap;", "showNotesFromDeveloper", "getShowNotesFromDeveloper", "()Z", "setShowNotesFromDeveloper", "(Z)V", "showRecommendedVersions", "getShowRecommendedVersions", "setShowRecommendedVersions", "status", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex$GooglePlaySdkIndexStatus;", "createCoordinateString", "groupId", "artifactId", "extractPolicyViolations", "", "Lcom/android/tools/lint/checks/LibraryVersionLabels$PolicyIssuesInfo$SdkPolicy;", "labels", "Lcom/android/tools/lint/checks/LibraryVersionLabels;", "extractVulnerabilities", "Lcom/android/tools/lint/checks/LibraryVersionLabels$SecurityVulnerabilitiesInfo$SdkSecurityVulnerabilityType;", "generateBlockingCriticalMessage", "versionString", "generateBlockingOutdatedMessage", "generateBlockingPolicyMessages", "", "generateCriticalMessage", "generateOutdatedMessage", "generatePolicyMessages", "generateRecommendedList", "listOfVersions", "Lcom/android/tools/lint/checks/LibraryVersionRange;", "isThirdParty", "generateSdkLinkLintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "buildFile", "Ljava/io/File;", "generateVulnerabilityMessages", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex$Companion$VulnerabilityDescription;", "getLabels", "getLastReadSource", "Lcom/android/ide/common/repository/NetworkCache$DataSourceType;", "getLatestVersion", "getLibraryVersion", "Lcom/android/tools/lint/checks/LibraryVersion;", "getNoteFromDeveloper", "getOutdatedRecommendedVersions", "getPolicyLabels", "getPolicyRecommendedVersions", "getSdk", "getSdkUrl", "getVulnerabilityLabels", "hasLibraryBlockingIssues", "hasLibraryCriticalIssues", "hasLibraryErrorOrWarning", "hasLibraryVulnerabilityIssues", "initialize", "", "overriddenData", "Ljava/io/InputStream;", "isLibraryNonCompliant", "isLibraryOutdated", "isReady", "isThirdPartyLibrary", "logCachingError", "readResult", "dataSourceType", "logErrorInDefaultData", "logHasCriticalIssues", "file", "logIndexLoadedCorrectly", "logNonCompliant", "logOutdated", "logVulnerability", "readDefaultData", "relative", "readIndexData", "readFunction", "Lkotlin/Function0;", "recommendedVersions", "", "setMaps", "index", "Lcom/android/tools/lint/checks/Index;", "Companion", "GooglePlaySdkIndexStatus", "LibraryToSdk", "ReadDataErrorType", "ReadDataResult", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nGooglePlaySdkIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GooglePlaySdkIndex.kt\ncom/android/tools/lint/checks/GooglePlaySdkIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,881:1\n1557#2:882\n1628#2,3:883\n1557#2:886\n1628#2,3:887\n1557#2:890\n1628#2,3:891\n1863#2,2:894\n1863#2,2:896\n*S KotlinDebug\n*F\n+ 1 GooglePlaySdkIndex.kt\ncom/android/tools/lint/checks/GooglePlaySdkIndex\n*L\n584#1:882\n584#1:883,3\n596#1:886\n596#1:887,3\n642#1:890\n642#1:891,3\n663#1:894,2\n666#1:896,2\n*E\n"})
public abstract class GooglePlaySdkIndex
extends NetworkCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private ReadDataResult lastReadResult;
    private boolean initialized;
    @NotNull
    private GooglePlaySdkIndexStatus status;
    @NotNull
    private final HashMap<String, LibraryToSdk> libraryToSdk;
    private boolean showNotesFromDeveloper;
    private boolean showRecommendedVersions;
    @NotNull
    public static final String SDK_INDEX_SNAPSHOT_TEST_BASE_URL_ENV_VAR = "SDK_INDEX_TEST_BASE_URL";
    @NotNull
    private static final String DEFAULT_SDK_INDEX_SNAPSHOT_BASE_URL = "https://dl.google.com/play-sdk/index/";
    public static final boolean DEFAULT_SHOW_NOTES_FROM_DEVELOPER = true;
    public static final boolean DEFAULT_SHOW_RECOMMENDED_VERSIONS = true;
    @NotNull
    public static final String GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_FILE = "snapshot.gz";
    @NotNull
    public static final String GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_RESOURCE = "sdk-index-offline-snapshot.proto.gz";
    @NotNull
    private static final String GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_URL;
    @NotNull
    public static final String GOOGLE_PLAY_SDK_INDEX_KEY = "sdk_index";
    public static final long GOOGLE_PLAY_SDK_CACHE_EXPIRY_INTERVAL_DAYS = 7L;
    @NotNull
    public static final String GOOGLE_PLAY_SDK_INDEX_URL = "https://developer.android.com/distribute/sdk-index";
    @NotNull
    public static final String VIEW_DETAILS_MESSAGE = "View details in Google Play SDK Index";
    @NotNull
    private static final Map<LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy, String> POLICY_TYPE_TO_TEXT;
    @NotNull
    private static final Map<LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType, Companion.VulnerabilityDescription> SECURITY_VULNERABILITY_TYPE_TO_TEXT;

    public GooglePlaySdkIndex(@Nullable Path cacheDir) {
        super(GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_URL, GOOGLE_PLAY_SDK_INDEX_KEY, cacheDir, 0, (int)TimeUnit.DAYS.toHours(7L), false, 40, null);
        this.status = GooglePlaySdkIndexStatus.NOT_READY;
        this.libraryToSdk = new HashMap();
        this.showNotesFromDeveloper = true;
        this.showRecommendedVersions = true;
    }

    public /* synthetic */ GooglePlaySdkIndex(Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            path = null;
        }
        this(path);
    }

    public final boolean getShowNotesFromDeveloper() {
        return this.showNotesFromDeveloper;
    }

    public final void setShowNotesFromDeveloper(boolean bl) {
        this.showNotesFromDeveloper = bl;
    }

    public final boolean getShowRecommendedVersions() {
        return this.showRecommendedVersions;
    }

    public final void setShowRecommendedVersions(boolean bl) {
        this.showRecommendedVersions = bl;
    }

    public final void initialize() {
        this.initialize(null);
    }

    private final ReadDataResult readIndexData(Function0<? extends InputStream> readFunction) {
        ReadDataErrorType readDataErrorType = ReadDataErrorType.DATA_FUNCTION_EXCEPTION;
        try {
            InputStream rawData = (InputStream)readFunction.invoke();
            if (rawData != null) {
                readDataErrorType = ReadDataErrorType.GZIP_EXCEPTION;
                GZIPInputStream gzipData = new GZIPInputStream(rawData);
                readDataErrorType = ReadDataErrorType.INDEX_PARSE_EXCEPTION;
                Index index2 = Index.parseFrom((InputStream)gzipData);
                readDataErrorType = index2 != null ? ReadDataErrorType.NO_ERROR : ReadDataErrorType.INDEX_PARSE_NULL_ERROR;
                return new ReadDataResult(index2, readDataErrorType, null);
            }
        }
        catch (Exception exception) {
            return new ReadDataResult(null, readDataErrorType, exception);
        }
        return new ReadDataResult(null, ReadDataErrorType.DATA_FUNCTION_NULL_ERROR, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void initialize(@Nullable InputStream overriddenData) {
        GooglePlaySdkIndex googlePlaySdkIndex = this;
        synchronized (googlePlaySdkIndex) {
            boolean bl = false;
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            this.status = GooglePlaySdkIndexStatus.NOT_READY;
            Unit $i$a$-synchronized-GooglePlaySdkIndex$initialize$2 = Unit.INSTANCE;
        }
        Index index2 = null;
        NetworkCache.DataSourceType indexDataSource = null;
        if (overriddenData != null) {
            this.setLastReadSourceType(NetworkCache.DataSourceType.TEST_DATA);
            indexDataSource = this.getLastReadSourceType();
            index2 = Index.parseFrom((InputStream)overriddenData);
        } else {
            this.lastReadResult = this.readIndexData((Function0<? extends InputStream>)((Function0)new Function0<InputStream>(this){
                final /* synthetic */ GooglePlaySdkIndex this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final InputStream invoke() {
                    return NetworkCache.findData$default((NetworkCache)this.this$0, (String)"snapshot.gz", (boolean)false, (int)2, null);
                }
            }));
            ReadDataResult readDataResult = this.lastReadResult;
            if (readDataResult == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lastReadResult");
                readDataResult = null;
            }
            if (readDataResult.getIndex() != null) {
                indexDataSource = this.getLastReadSourceType();
                ReadDataResult readDataResult2 = this.lastReadResult;
                if (readDataResult2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lastReadResult");
                    readDataResult2 = null;
                }
                index2 = readDataResult2.getIndex();
            } else if (this.getLastReadSourceType() != NetworkCache.DataSourceType.DEFAULT_DATA) {
                this.setLastReadSourceType(NetworkCache.DataSourceType.UNKNOWN_SOURCE);
                ReadDataResult offlineResult2 = this.readIndexData((Function0<? extends InputStream>)((Function0)new Function0<InputStream>(this){
                    final /* synthetic */ GooglePlaySdkIndex this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final InputStream invoke() {
                        return this.this$0.readDefaultData("sdk-index-offline-snapshot.proto.gz");
                    }
                }));
                if (offlineResult2.getIndex() != null) {
                    indexDataSource = NetworkCache.DataSourceType.DEFAULT_DATA;
                    index2 = offlineResult2.getIndex();
                } else {
                    indexDataSource = NetworkCache.DataSourceType.UNKNOWN_SOURCE;
                    this.logErrorInDefaultData(offlineResult2);
                }
            } else {
                indexDataSource = NetworkCache.DataSourceType.UNKNOWN_SOURCE;
                ReadDataResult readDataResult3 = this.lastReadResult;
                if (readDataResult3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lastReadResult");
                    readDataResult3 = null;
                }
                this.logErrorInDefaultData(readDataResult3);
            }
        }
        if (index2 != null) {
            this.setMaps(index2);
            this.status = GooglePlaySdkIndexStatus.READY;
            this.logIndexLoadedCorrectly(indexDataSource);
        }
    }

    public static /* synthetic */ void initialize$default(GooglePlaySdkIndex googlePlaySdkIndex, InputStream inputStream, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initialize");
        }
        if ((n & 1) != 0) {
            inputStream = null;
        }
        googlePlaySdkIndex.initialize(inputStream);
    }

    public final boolean isReady() {
        return this.status == GooglePlaySdkIndexStatus.READY;
    }

    public final boolean isLibraryNonCompliant(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File buildFile) {
        boolean isNonCompliant;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        LibraryVersionLabels libraryVersionLabels = this.getLabels(groupId, artifactId, versionString);
        boolean bl = isNonCompliant = libraryVersionLabels != null ? libraryVersionLabels.hasPolicyIssuesInfo() : false;
        if (isNonCompliant) {
            this.logNonCompliant(groupId, artifactId, versionString, buildFile);
        }
        return isNonCompliant;
    }

    public final boolean isLibraryOutdated(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File buildFile) {
        boolean isOutdated;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        LibraryVersionLabels libraryVersionLabels = this.getLabels(groupId, artifactId, versionString);
        boolean bl = isOutdated = libraryVersionLabels != null ? libraryVersionLabels.hasOutdatedIssueInfo() : false;
        if (isOutdated) {
            this.logOutdated(groupId, artifactId, versionString, buildFile);
        }
        return isOutdated;
    }

    public final boolean hasLibraryCriticalIssues(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File buildFile) {
        boolean hasCriticalIssues;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        LibraryVersionLabels libraryVersionLabels = this.getLabels(groupId, artifactId, versionString);
        boolean bl = hasCriticalIssues = libraryVersionLabels != null ? libraryVersionLabels.hasCriticalIssueInfo() : false;
        if (hasCriticalIssues) {
            this.logHasCriticalIssues(groupId, artifactId, versionString, buildFile);
        }
        return hasCriticalIssues;
    }

    public final boolean hasLibraryVulnerabilityIssues(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File buildFile) {
        boolean hasVulnerabilities;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        LibraryVersionLabels libraryVersionLabels = this.getLabels(groupId, artifactId, versionString);
        boolean bl = hasVulnerabilities = libraryVersionLabels != null ? libraryVersionLabels.hasSecurityVulnerabilitiesInfo() : false;
        if (hasVulnerabilities) {
            this.logVulnerability(groupId, artifactId, versionString, buildFile);
        }
        return hasVulnerabilities;
    }

    public final boolean hasLibraryBlockingIssues(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        LibraryVersionLabels libraryVersionLabels = this.getLabels(groupId, artifactId, versionString);
        if (libraryVersionLabels == null) {
            return false;
        }
        LibraryVersionLabels labels = libraryVersionLabels;
        LibraryVersionLabels.Severity severity = labels.getSeverity();
        return severity == LibraryVersionLabels.Severity.BLOCKING_SEVERITY;
    }

    public final boolean hasLibraryErrorOrWarning(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        return GooglePlaySdkIndexKt.access$hasErrorOrWarning(this.getLabels(groupId, artifactId, versionString));
    }

    @Nullable
    public final String getSdkUrl(@NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        if (!this.isReady()) {
            return null;
        }
        LibraryToSdk libraryToSdk = this.getSdk(groupId, artifactId);
        if (libraryToSdk == null) {
            return null;
        }
        LibraryToSdk sdk = libraryToSdk;
        if (sdk.getSdk().getIndexAvailability() == Sdk.IndexAvailability.NOT_AVAILABLE) {
            return null;
        }
        return sdk.getSdk().getIndexUrl();
    }

    @Nullable
    public final String getLatestVersion(@NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        if (!this.isReady()) {
            return null;
        }
        LibraryToSdk libraryToSdk = this.getSdk(groupId, artifactId);
        return libraryToSdk != null ? libraryToSdk.getLatestVersion() : null;
    }

    private final LibraryVersionLabels getLabels(String groupId, String artifactId, String versionString) {
        if (!this.isReady()) {
            return null;
        }
        LibraryVersion libraryVersion = this.getLibraryVersion(groupId, artifactId, versionString);
        if (libraryVersion == null) {
            return null;
        }
        LibraryVersion libraryVersion2 = libraryVersion;
        return libraryVersion2.getVersionLabels();
    }

    private final LibraryVersion getLibraryVersion(String groupId, String artifactId, String versionString) {
        String coordinate = this.createCoordinateString(groupId, artifactId);
        LibraryToSdk libraryToSdk = this.libraryToSdk.get(coordinate);
        if (libraryToSdk == null) {
            return null;
        }
        LibraryToSdk sdk = libraryToSdk;
        return sdk.getVersion(versionString);
    }

    private final LibraryToSdk getSdk(String groupId, String artifactId) {
        String coordinate = this.createCoordinateString(groupId, artifactId);
        return this.libraryToSdk.get(coordinate);
    }

    private final void setMaps(Index index2) {
        this.libraryToSdk.clear();
        List sdkList = index2.getSdksList();
        for (Sdk sdk : sdkList) {
            for (Library library : sdk.getLibrariesList()) {
                String string = library.getLibraryId().getMavenId().getGroupId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroupId(...)");
                String string2 = library.getLibraryId().getMavenId().getArtifactId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getArtifactId(...)");
                String coordinate = this.createCoordinateString(string, string2);
                Intrinsics.checkNotNull((Object)sdk);
                LibraryToSdk currentLibrary = new LibraryToSdk(coordinate, sdk);
                for (LibraryVersion version : library.getVersionsList()) {
                    String string3 = version.getVersionString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersionString(...)");
                    Intrinsics.checkNotNull((Object)version);
                    currentLibrary.addLibraryVersion(string3, version);
                }
                ((Map)this.libraryToSdk).put(currentLibrary.getLibraryId(), currentLibrary);
            }
        }
    }

    private final String createCoordinateString(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    @Nullable
    protected InputStream readDefaultData(@NotNull String relative) {
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        if (this.getLastReadSourceType() != NetworkCache.DataSourceType.UNKNOWN_SOURCE) {
            ReadDataResult readDataResult = this.lastReadResult;
            if (readDataResult == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lastReadResult");
                readDataResult = null;
            }
            this.logCachingError(readDataResult, this.getLastReadSourceType());
        }
        return GooglePlaySdkIndex.class.getResourceAsStream("/sdk-index-offline-snapshot.proto.gz");
    }

    @Nullable
    public LintFix generateSdkLinkLintFix(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File buildFile) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        String url = this.getSdkUrl(groupId, artifactId);
        CharSequence charSequence = url;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : (LintFix)new LintFix.ShowUrl(VIEW_DETAILS_MESSAGE, null, url, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> generateBlockingPolicyMessages(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        String recommendedVersions = this.getPolicyRecommendedVersions(groupId, artifactId, versionString);
        Iterable $this$map$iv = this.getPolicyLabels(this.getLabels(groupId, artifactId, versionString));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void label;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("**[Prevents app release in Google Play Console]** " + groupId + ":" + artifactId + " version " + versionString + " has " + (String)label + " issues that will block publishing of your app to Play Console" + recommendedVersions);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> generatePolicyMessages(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        String recommendedVersions = this.getPolicyRecommendedVersions(groupId, artifactId, versionString);
        Iterable $this$map$iv = this.getPolicyLabels(this.getLabels(groupId, artifactId, versionString));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void label;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(groupId + ":" + artifactId + " version " + versionString + " has " + (String)label + " issues that will block publishing of your app to Play Console in the future" + recommendedVersions);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String generateBlockingCriticalMessage(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        String note = this.getNoteFromDeveloper(groupId, artifactId, versionString);
        return "**[Prevents app release in Google Play Console]** " + groupId + ":" + artifactId + " version " + versionString + " has been reported as problematic by its author and will block publishing of your app to Play Console" + note;
    }

    @NotNull
    public final String generateCriticalMessage(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        String note = this.getNoteFromDeveloper(groupId, artifactId, versionString);
        return groupId + ":" + artifactId + " version " + versionString + " has an associated message from its author" + note;
    }

    @NotNull
    public final String generateBlockingOutdatedMessage(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        String recommendedVersions = this.getOutdatedRecommendedVersions(groupId, artifactId, versionString);
        return "**[Prevents app release in Google Play Console]** " + groupId + ":" + artifactId + " version " + versionString + " has been reported as outdated by its author and will block publishing of your app to Play Console" + recommendedVersions;
    }

    @NotNull
    public final String generateOutdatedMessage(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        String recommendedVersions = this.getOutdatedRecommendedVersions(groupId, artifactId, versionString);
        return groupId + ":" + artifactId + " version " + versionString + " has been reported as outdated by its author" + recommendedVersions;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Companion.VulnerabilityDescription> generateVulnerabilityMessages(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        Iterable $this$map$iv = this.getVulnerabilityLabels(this.getLabels(groupId, artifactId, versionString));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void message2;
            Companion.VulnerabilityDescription vulnerabilityDescription = (Companion.VulnerabilityDescription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Companion.VulnerabilityDescription(message2.getName(), groupId + ":" + artifactId + " version " + versionString + " " + message2.getDescription() + ".", message2.getLink()));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Collection<LibraryVersionRange> recommendedVersions(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        LinkedHashSet<LibraryVersionRange> recommendations;
        block4: {
            List list;
            LibraryVersionRange it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
            recommendations = new LinkedHashSet<LibraryVersionRange>();
            LibraryVersionLabels labels = this.getLabels(groupId, artifactId, versionString);
            if (labels == null) break block4;
            List list2 = labels.getPolicyIssuesInfo().getRecommendedVersionsList();
            if (list2 != null && (list2 = CollectionsKt.filterNotNull((Iterable)list2)) != null) {
                $this$forEach$iv = list2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (LibraryVersionRange)element$iv;
                    boolean bl = false;
                    recommendations.add(it);
                }
            }
            if ((list = labels.getOutdatedIssueInfo().getRecommendedVersionsList()) != null && (list = CollectionsKt.filterNotNull((Iterable)list)) != null) {
                $this$forEach$iv = list;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (LibraryVersionRange)element$iv;
                    boolean bl = false;
                    recommendations.add(it);
                }
            }
        }
        return recommendations;
    }

    protected void logHasCriticalIssues(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
    }

    protected void logNonCompliant(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
    }

    protected void logOutdated(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
    }

    protected void logVulnerability(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
    }

    protected void logCachingError(@NotNull ReadDataResult readResult, @NotNull NetworkCache.DataSourceType dataSourceType) {
        Intrinsics.checkNotNullParameter((Object)readResult, (String)"readResult");
        Intrinsics.checkNotNullParameter((Object)dataSourceType, (String)"dataSourceType");
    }

    protected void logErrorInDefaultData(@NotNull ReadDataResult readResult) {
        Intrinsics.checkNotNullParameter((Object)readResult, (String)"readResult");
    }

    protected void logIndexLoadedCorrectly(@NotNull NetworkCache.DataSourceType dataSourceType) {
        Intrinsics.checkNotNullParameter((Object)dataSourceType, (String)"dataSourceType");
    }

    @VisibleForTesting
    @NotNull
    public final NetworkCache.DataSourceType getLastReadSource() {
        return this.getLastReadSourceType();
    }

    private final List<String> getPolicyLabels(LibraryVersionLabels labels) {
        String defaultLabel = "policy";
        Set<LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy> policyViolations = this.extractPolicyViolations(labels);
        List result = new ArrayList();
        boolean hasUnknown = false;
        for (LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy violation : policyViolations) {
            if (POLICY_TYPE_TO_TEXT.containsKey(violation)) {
                result.add(POLICY_TYPE_TO_TEXT.get(violation) + " policy");
                continue;
            }
            hasUnknown = true;
        }
        if (hasUnknown || result.isEmpty()) {
            result.add(defaultLabel);
        }
        return result;
    }

    private final Set<LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy> extractPolicyViolations(LibraryVersionLabels labels) {
        Set result = new LinkedHashSet();
        if (labels == null || !labels.hasPolicyIssuesInfo()) {
            return result;
        }
        List types = labels.getPolicyIssuesInfo().getViolatedSdkPoliciesList();
        if (types != null) {
            result.addAll(types);
        }
        return result;
    }

    private final String getNoteFromDeveloper(String groupId, String artifactId, String versionString) {
        if (!this.showNotesFromDeveloper) {
            return "";
        }
        LibraryVersionLabels libraryVersionLabels = this.getLabels(groupId, artifactId, versionString);
        if (libraryVersionLabels == null) {
            return "";
        }
        LibraryVersionLabels labels = libraryVersionLabels;
        LibraryVersionLabels.CriticalIssueInfo criticalIssueInfo = labels.getCriticalIssueInfo();
        if (criticalIssueInfo == null) {
            return "";
        }
        LibraryVersionLabels.CriticalIssueInfo criticalIssue = criticalIssueInfo;
        String message2 = criticalIssue.getDescription();
        CharSequence charSequence = message2;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return "";
        }
        return ".\n**Note:** " + message2;
    }

    private final String getOutdatedRecommendedVersions(String groupId, String artifactId, String versionString) {
        if (!this.showRecommendedVersions) {
            return "";
        }
        LibraryVersionLabels libraryVersionLabels = this.getLabels(groupId, artifactId, versionString);
        if (libraryVersionLabels == null) {
            return "";
        }
        LibraryVersionLabels labels = libraryVersionLabels;
        LibraryVersionLabels.OutdatedIssueInfo outdatedIssueInfo = labels.getOutdatedIssueInfo();
        if (outdatedIssueInfo == null) {
            return "";
        }
        LibraryVersionLabels.OutdatedIssueInfo outdatedIssue = outdatedIssueInfo;
        return this.generateRecommendedList(outdatedIssue.getRecommendedVersionsList(), this.isThirdPartyLibrary(groupId, artifactId));
    }

    private final String getPolicyRecommendedVersions(String groupId, String artifactId, String versionString) {
        if (!this.showRecommendedVersions) {
            return "";
        }
        LibraryVersionLabels libraryVersionLabels = this.getLabels(groupId, artifactId, versionString);
        if (libraryVersionLabels == null) {
            return "";
        }
        LibraryVersionLabels labels = libraryVersionLabels;
        LibraryVersionLabels.PolicyIssuesInfo policyIssuesInfo = labels.getPolicyIssuesInfo();
        if (policyIssuesInfo == null) {
            return "";
        }
        LibraryVersionLabels.PolicyIssuesInfo policyIssue = policyIssuesInfo;
        return this.generateRecommendedList(policyIssue.getRecommendedVersionsList(), this.isThirdPartyLibrary(groupId, artifactId));
    }

    private final boolean isThirdPartyLibrary(String groupId, String artifactId) {
        String coordinate = this.createCoordinateString(groupId, artifactId);
        LibraryToSdk sdk = this.libraryToSdk.get(coordinate);
        if (sdk != null) {
            return !sdk.getSdk().getIsGoogleOwned();
        }
        return true;
    }

    private final String generateRecommendedList(List<LibraryVersionRange> listOfVersions, boolean isThirdParty) {
        List<LibraryVersionRange> list = listOfVersions;
        if (list == null) {
            return "";
        }
        String ranges2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.filterNotNull((Iterable)list), (CharSequence)"\n", null, null, (int)0, null, (Function1)generateRecommendedList.ranges.1.INSTANCE, (int)30, null);
        if (((CharSequence)ranges2).length() == 0) {
            return "";
        }
        return ".\nThe library author recommends using versions:\n" + ranges2 + "\n" + (isThirdParty ? "These versions have not been reviewed by Google Play. They could contain vulnerabilities or policy violations. Carefully evaluate any third-party SDKs before integrating them into your app." : "");
    }

    private final List<Companion.VulnerabilityDescription> getVulnerabilityLabels(LibraryVersionLabels labels) {
        String defaultDetails = "has unspecified vulnerability issues";
        String defaultName = "unspecified vulnerability";
        Set<LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType> vulnerabilities = this.extractVulnerabilities(labels);
        List result = new ArrayList();
        boolean hasUnknown = false;
        for (LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType vulnerability : vulnerabilities) {
            Companion.VulnerabilityDescription details = SECURITY_VULNERABILITY_TYPE_TO_TEXT.getOrDefault(vulnerability, null);
            if (details != null) {
                result.add(details);
                continue;
            }
            hasUnknown = true;
        }
        if (hasUnknown || result.isEmpty()) {
            result.add(new Companion.VulnerabilityDescription(defaultName, defaultDetails, null));
        }
        return result;
    }

    private final Set<LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType> extractVulnerabilities(LibraryVersionLabels labels) {
        Set result = new LinkedHashSet();
        if (labels == null || !labels.hasSecurityVulnerabilitiesInfo()) {
            return result;
        }
        List types = labels.getSecurityVulnerabilitiesInfo().getVulnerabilitiesList();
        if (types != null) {
            result.addAll(types);
        }
        return result;
    }

    public GooglePlaySdkIndex() {
        this(null, 1, null);
    }

    static {
        String string = System.getenv(SDK_INDEX_SNAPSHOT_TEST_BASE_URL_ENV_VAR);
        if (string == null) {
            string = DEFAULT_SDK_INDEX_SNAPSHOT_BASE_URL;
        }
        GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_URL = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_UNKNOWN, (Object)"unknown"), TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_ADS, (Object)"Ads"), TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_DEVICE_AND_NETWORK_ABUSE, (Object)"Device and Network Abuse"), TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_DECEPTIVE_BEHAVIOR, (Object)"Deceptive Behavior"), TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_USER_DATA, (Object)"User Data"), TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_PERMISSIONS, (Object)"Permissions"), TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_MOBILE_UNWANTED_SOFTWARE, (Object)"Mobile Unwanted Software"), TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_MALWARE, (Object)"Malware")};
        POLICY_TYPE_TO_TEXT = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_UNSPECIFIED, (Object)new Companion.VulnerabilityDescription("unspecified", "contains unspecified vulnerability issues", null)), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_UNSAFE_TRUST_MANAGER, (Object)new Companion.VulnerabilityDescription("Unsafe TrustManager", "contains an unsafe implementation of the X509TrustManager interface", "https://support.google.com/googleplay/android-developer/answer/9888379")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_UNSAFE_HOSTNAME_VERIFIER, (Object)new Companion.VulnerabilityDescription("Unsafe HostnameVerifier", "contains an unsafe implementation of the interfaces HostnameVerifier or X509HostnameVerifier", "https://support.google.com/googleplay/android-developer/answer/9888379")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_UNSAFE_SSL_ERROR_HANDLER, (Object)new Companion.VulnerabilityDescription("Unsafe SSL Error Handler", "contains an unsafe implementation of the onReceivedSslError handler", "https://support.google.com/googleplay/android-developer/answer/9888379")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_ZIP_PATH_TRAVERSAL, (Object)new Companion.VulnerabilityDescription("Zip Path Traversal", "contains unsafe unzipping patterns", "https://support.google.com/faqs/answer/9294009")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_UNSAFE_WEBVIEW_OAUTH, (Object)new Companion.VulnerabilityDescription("Unsafe OAuth via WebView", "uses WebView for authentication, which is not recommended", "https://support.google.com/faqs/answer/12284343")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_UNSAFE_CIPHER_MODE, (Object)new Companion.VulnerabilityDescription("Unsafe Encryption Mode Usage", "contains encryption employing the less secure mode AES/ECB", "https://support.google.com/faqs/answer/10046138")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_UNSAFE_ENCRYPTION, (Object)new Companion.VulnerabilityDescription("Unsafe Cryptographic Encryption", "contains unsafe encryption patterns", "https://support.google.com/faqs/answer/9450925")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_IMPLICIT_PENDING_INTENT, (Object)new Companion.VulnerabilityDescription("Implicit PendingIntent", "contains an Implicit PendingIntent issue", "https://support.google.com/faqs/answer/10437428")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_IMPLICIT_INTERNAL_INTENT, (Object)new Companion.VulnerabilityDescription("Implicit Internal Intent", "contains an Implicit Internal Intent issue", "https://support.google.com/faqs/answer/10437428")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_CROSS_APP_SCRIPTING, (Object)new Companion.VulnerabilityDescription("Cross-App Scripting", "may be vulnerable to WebView Cross-App Scripting", "https://support.google.com/googleplay/android-developer/answer/9888379")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_FILE_BASED_XSS, (Object)new Companion.VulnerabilityDescription("File Based XSS", "may be vulnerable to File-based Cross-Site Scripting", "https://support.google.com/googleplay/android-developer/answer/9888379")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_INTENT_SCHEME_HIJACKING, (Object)new Companion.VulnerabilityDescription("Intent Scheme Hijacking", "may be vulnerable to Intent-Scheme Hijacking", "https://support.google.com/googleplay/android-developer/answer/9888379")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_JS_INTERFACE_INJECTION, (Object)new Companion.VulnerabilityDescription("JavaScript Interface Injection", "may be vulnerable to JavaScript Interface Injection", "https://support.google.com/googleplay/android-developer/answer/9888379")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_INTENT_REDIRECTION, (Object)new Companion.VulnerabilityDescription("Intent Redirection", "may be vulnerable to Intent Redirection", "https://support.google.com/googleplay/android-developer/answer/9888379")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_FRAGMENT_INJECTION, (Object)new Companion.VulnerabilityDescription("Fragment Injection", "contains an unsafe PreferenceActivity implementation that may be vulnerable to Fragment Injection", "https://support.google.com/googleplay/android-developer/answer/9888379")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_PATH_TRAVERSAL, (Object)new Companion.VulnerabilityDescription("ContentProvider Path Traversal", "may be vulnerable to ContentProvider Path Traversal", "https://support.google.com/googleplay/android-developer/answer/9888379")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_SQL_INJECTION, (Object)new Companion.VulnerabilityDescription("ContentProvider SQL Injection", "may be vulnerable to ContentProvider SQL Injection", "https://support.google.com/googleplay/android-developer/answer/9888379")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_LEAKED_GCP_KEYS, (Object)new Companion.VulnerabilityDescription("Leaked GCP keys", "contains exposed Google Cloud Platform (GCP) API key(s)", "https://support.google.com/faqs/answer/9287711")), TuplesKt.to((Object)LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType.SDK_SECURITY_VULNERABILITY_TYPE_VULNERABLE_LIBS, (Object)new Companion.VulnerabilityDescription("Known Vulnerable Library (JS)", "contains one or more JavaScript libraries with known security issues", "https://support.google.com/faqs/answer/9464300"))};
        SECURITY_VULNERABILITY_TYPE_TO_TEXT = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/GooglePlaySdkIndex$Companion;", "", "()V", "DEFAULT_SDK_INDEX_SNAPSHOT_BASE_URL", "", "DEFAULT_SHOW_NOTES_FROM_DEVELOPER", "", "DEFAULT_SHOW_RECOMMENDED_VERSIONS", "GOOGLE_PLAY_SDK_CACHE_EXPIRY_INTERVAL_DAYS", "", "GOOGLE_PLAY_SDK_INDEX_KEY", "GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_FILE", "GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_RESOURCE", "GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_URL", "getGOOGLE_PLAY_SDK_INDEX_SNAPSHOT_URL", "()Ljava/lang/String;", "GOOGLE_PLAY_SDK_INDEX_URL", "POLICY_TYPE_TO_TEXT", "", "Lcom/android/tools/lint/checks/LibraryVersionLabels$PolicyIssuesInfo$SdkPolicy;", "getPOLICY_TYPE_TO_TEXT", "()Ljava/util/Map;", "SDK_INDEX_SNAPSHOT_TEST_BASE_URL_ENV_VAR", "SECURITY_VULNERABILITY_TYPE_TO_TEXT", "Lcom/android/tools/lint/checks/LibraryVersionLabels$SecurityVulnerabilitiesInfo$SdkSecurityVulnerabilityType;", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex$Companion$VulnerabilityDescription;", "getSECURITY_VULNERABILITY_TYPE_TO_TEXT", "VIEW_DETAILS_MESSAGE", "VulnerabilityDescription", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getGOOGLE_PLAY_SDK_INDEX_SNAPSHOT_URL() {
            return GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_URL;
        }

        @NotNull
        public final Map<LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy, String> getPOLICY_TYPE_TO_TEXT() {
            return POLICY_TYPE_TO_TEXT;
        }

        @NotNull
        public final Map<LibraryVersionLabels.SecurityVulnerabilitiesInfo.SdkSecurityVulnerabilityType, VulnerabilityDescription> getSECURITY_VULNERABILITY_TYPE_TO_TEXT() {
            return SECURITY_VULNERABILITY_TYPE_TO_TEXT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/GooglePlaySdkIndex$Companion$VulnerabilityDescription;", "", "name", "", "description", "link", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "getLink", "getName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "lint-checks"})
        public static final class VulnerabilityDescription {
            @NotNull
            private final String name;
            @NotNull
            private final String description;
            @Nullable
            private final String link;

            public VulnerabilityDescription(@NotNull String name, @NotNull String description, @Nullable String link) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                this.name = name;
                this.description = description;
                this.link = link;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final String getDescription() {
                return this.description;
            }

            @Nullable
            public final String getLink() {
                return this.link;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final String component2() {
                return this.description;
            }

            @Nullable
            public final String component3() {
                return this.link;
            }

            @NotNull
            public final VulnerabilityDescription copy(@NotNull String name, @NotNull String description, @Nullable String link) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                return new VulnerabilityDescription(name, description, link);
            }

            public static /* synthetic */ VulnerabilityDescription copy$default(VulnerabilityDescription vulnerabilityDescription, String string, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = vulnerabilityDescription.name;
                }
                if ((n & 2) != 0) {
                    string2 = vulnerabilityDescription.description;
                }
                if ((n & 4) != 0) {
                    string3 = vulnerabilityDescription.link;
                }
                return vulnerabilityDescription.copy(string, string2, string3);
            }

            @NotNull
            public String toString() {
                return "VulnerabilityDescription(name=" + this.name + ", description=" + this.description + ", link=" + this.link + ")";
            }

            public int hashCode() {
                int result = this.name.hashCode();
                result = result * 31 + this.description.hashCode();
                result = result * 31 + (this.link == null ? 0 : this.link.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof VulnerabilityDescription)) {
                    return false;
                }
                VulnerabilityDescription vulnerabilityDescription = (VulnerabilityDescription)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)vulnerabilityDescription.name)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.description, (Object)vulnerabilityDescription.description)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.link, (Object)vulnerabilityDescription.link);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/GooglePlaySdkIndex$GooglePlaySdkIndexStatus;", "", "(Ljava/lang/String;I)V", "NOT_READY", "READY", "lint-checks"})
    private static final class GooglePlaySdkIndexStatus
    extends Enum<GooglePlaySdkIndexStatus> {
        public static final /* enum */ GooglePlaySdkIndexStatus NOT_READY = new GooglePlaySdkIndexStatus();
        public static final /* enum */ GooglePlaySdkIndexStatus READY = new GooglePlaySdkIndexStatus();
        private static final /* synthetic */ GooglePlaySdkIndexStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static GooglePlaySdkIndexStatus[] values() {
            return (GooglePlaySdkIndexStatus[])$VALUES.clone();
        }

        public static GooglePlaySdkIndexStatus valueOf(String value) {
            return Enum.valueOf(GooglePlaySdkIndexStatus.class, value);
        }

        @NotNull
        public static EnumEntries<GooglePlaySdkIndexStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = googlePlaySdkIndexStatusArray = new GooglePlaySdkIndexStatus[]{GooglePlaySdkIndexStatus.NOT_READY, GooglePlaySdkIndexStatus.READY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000eJ\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0003R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/GooglePlaySdkIndex$LibraryToSdk;", "", "libraryId", "", "sdk", "Lcom/android/tools/lint/checks/Sdk;", "(Ljava/lang/String;Lcom/android/tools/lint/checks/Sdk;)V", "latestVersion", "getLibraryId", "()Ljava/lang/String;", "getSdk", "()Lcom/android/tools/lint/checks/Sdk;", "versionToLibraryVersion", "Ljava/util/HashMap;", "Lcom/android/tools/lint/checks/LibraryVersion;", "Lkotlin/collections/HashMap;", "addLibraryVersion", "", "versionString", "libraryVersion", "getLatestVersion", "getVersion", "lint-checks"})
    private static final class LibraryToSdk {
        @NotNull
        private final String libraryId;
        @NotNull
        private final Sdk sdk;
        @NotNull
        private final HashMap<String, LibraryVersion> versionToLibraryVersion;
        @Nullable
        private String latestVersion;

        public LibraryToSdk(@NotNull String libraryId, @NotNull Sdk sdk) {
            Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
            Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
            this.libraryId = libraryId;
            this.sdk = sdk;
            this.versionToLibraryVersion = new HashMap();
        }

        @NotNull
        public final String getLibraryId() {
            return this.libraryId;
        }

        @NotNull
        public final Sdk getSdk() {
            return this.sdk;
        }

        public final void addLibraryVersion(@NotNull String versionString, @NotNull LibraryVersion libraryVersion) {
            Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
            Intrinsics.checkNotNullParameter((Object)libraryVersion, (String)"libraryVersion");
            ((Map)this.versionToLibraryVersion).put(versionString, libraryVersion);
            if (libraryVersion.getIsLatestVersion()) {
                this.latestVersion = versionString;
            }
        }

        @Nullable
        public final LibraryVersion getVersion(@NotNull String versionString) {
            Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
            return this.versionToLibraryVersion.get(versionString);
        }

        @Nullable
        public final String getLatestVersion() {
            return this.latestVersion;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataErrorType;", "", "(Ljava/lang/String;I)V", "NO_ERROR", "DATA_FUNCTION_EXCEPTION", "DATA_FUNCTION_NULL_ERROR", "GZIP_EXCEPTION", "INDEX_PARSE_EXCEPTION", "INDEX_PARSE_NULL_ERROR", "lint-checks"})
    protected static final class ReadDataErrorType
    extends Enum<ReadDataErrorType> {
        public static final /* enum */ ReadDataErrorType NO_ERROR = new ReadDataErrorType();
        public static final /* enum */ ReadDataErrorType DATA_FUNCTION_EXCEPTION = new ReadDataErrorType();
        public static final /* enum */ ReadDataErrorType DATA_FUNCTION_NULL_ERROR = new ReadDataErrorType();
        public static final /* enum */ ReadDataErrorType GZIP_EXCEPTION = new ReadDataErrorType();
        public static final /* enum */ ReadDataErrorType INDEX_PARSE_EXCEPTION = new ReadDataErrorType();
        public static final /* enum */ ReadDataErrorType INDEX_PARSE_NULL_ERROR = new ReadDataErrorType();
        private static final /* synthetic */ ReadDataErrorType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ReadDataErrorType[] values() {
            return (ReadDataErrorType[])$VALUES.clone();
        }

        public static ReadDataErrorType valueOf(String value) {
            return Enum.valueOf(ReadDataErrorType.class, value);
        }

        @NotNull
        public static EnumEntries<ReadDataErrorType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = readDataErrorTypeArray = new ReadDataErrorType[]{ReadDataErrorType.NO_ERROR, ReadDataErrorType.DATA_FUNCTION_EXCEPTION, ReadDataErrorType.DATA_FUNCTION_NULL_ERROR, ReadDataErrorType.GZIP_EXCEPTION, ReadDataErrorType.INDEX_PARSE_EXCEPTION, ReadDataErrorType.INDEX_PARSE_NULL_ERROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0004\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u00a2\u0006\u0002\u0010\tR\u0019\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataResult;", "", "index", "Lcom/android/tools/lint/checks/Index;", "readDataErrorType", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataErrorType;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Lcom/android/tools/lint/checks/Index;Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataErrorType;Ljava/lang/Exception;)V", "getException", "()Ljava/lang/Exception;", "getIndex", "()Lcom/android/tools/lint/checks/Index;", "getReadDataErrorType", "()Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataErrorType;", "lint-checks"})
    protected static final class ReadDataResult {
        @Nullable
        private final Index index;
        @NotNull
        private final ReadDataErrorType readDataErrorType;
        @Nullable
        private final Exception exception;

        public ReadDataResult(@Nullable Index index2, @NotNull ReadDataErrorType readDataErrorType, @Nullable Exception exception) {
            Intrinsics.checkNotNullParameter((Object)((Object)readDataErrorType), (String)"readDataErrorType");
            this.index = index2;
            this.readDataErrorType = readDataErrorType;
            this.exception = exception;
        }

        @Nullable
        public final Index getIndex() {
            return this.index;
        }

        @NotNull
        public final ReadDataErrorType getReadDataErrorType() {
            return this.readDataErrorType;
        }

        @Nullable
        public final Exception getException() {
            return this.exception;
        }
    }
}

