/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0016J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/BatteryDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "getApplicableReferenceNames", "", "visitReference", "Lcom/android/tools/lint/detector/api/JavaContext;", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "Issues", "lint-checks"})
public final class BatteryDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"action");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Incident incident;
        Object message2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean bl = Intrinsics.areEqual((Object)element.getTagName(), (Object)"action");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        if (attr == null) {
            return;
        }
        Attr attr2 = attr;
        String name = attr2.getValue();
        if (Intrinsics.areEqual((Object)"android.net.conn.CONNECTIVITY_CHANGE", (Object)name) && element.getParentNode() != null && element.getParentNode().getParentNode() != null && Intrinsics.areEqual((Object)"receiver", (Object)element.getParentNode().getParentNode().getNodeName()) && context.getProject().getTargetSdkVersion().getFeatureLevel() >= 24) {
            message2 = "Declaring a broadcastreceiver for `android.net.conn.CONNECTIVITY_CHANGE` is deprecated for apps targeting N and higher. In general, apps should not rely on this broadcast and instead use `WorkManager`.";
            incident = new Incident(ISSUE, (Object)element, context.getValueLocation(attr2), (String)message2);
            context.report(incident, Constraints.targetSdkAtLeast((int)24));
        }
        if (Intrinsics.areEqual((Object)"android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS", (Object)name) && context.getProject().getTargetSdkVersion().getFeatureLevel() >= 23) {
            Incident incident2 = new Incident(ISSUE, (Object)element, context.getValueLocation(attr2), "Use of `REQUEST_IGNORE_BATTERY_OPTIMIZATIONS` violates the Play Store Content Policy regarding acceptable use cases, as described in https://developer.android.com/training/monitoring-device-state/doze-standby.html");
            context.report(incident2, Constraints.targetSdkAtLeast((int)23));
        }
        if (Intrinsics.areEqual((Object)"android.hardware.action.NEW_PICTURE", (Object)name) || Intrinsics.areEqual((Object)"android.hardware.action.NEW_VIDEO", (Object)name) || Intrinsics.areEqual((Object)"com.android.camera.NEW_PICTURE", (Object)name)) {
            message2 = "Use of `" + name + "` is deprecated for all apps starting with the N release independent of the target SDK. Apps should not rely on these broadcasts and instead use `WorkManager`";
            incident = new Incident(ISSUE, (Object)element, context.getValueLocation(attr2), (String)message2);
            context.report(incident);
        }
    }

    @NotNull
    public List<String> getApplicableReferenceNames() {
        return CollectionsKt.listOf((Object)"ACTION_REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
    }

    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
        JavaEvaluator evaluator = context.getEvaluator();
        if (referenced instanceof PsiField && evaluator.isMemberInSubClassOf((PsiMember)referenced, "android.provider.Settings", false) && context.getProject().getTargetSdkVersion().getFeatureLevel() >= 23) {
            Incident incident = new Incident(ISSUE, (Object)reference, context.getNameLocation((UElement)reference), "Use of `REQUEST_IGNORE_BATTERY_OPTIMIZATIONS` violates the Play Store Content Policy regarding acceptable use cases, as described in https://developer.android.com/training/monitoring-device-state/doze-standby.html");
            context.report(incident, Constraints.targetSdkAtLeast((int)23));
        }
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(BatteryDetector.class, EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.JAVA_FILE), enumSetArray);
        enumSetArray = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)enumSetArray, (String)"BatteryLife", (String)"Battery Life Issues", (String)"\n            This issue flags code that either\n            * negatively affects battery life, or\n            * uses APIs that have recently changed behavior to prevent background tasks from \\\n            consuming memory and battery excessively.\n\n            Generally, you should be using `WorkManager` instead.\n\n            For more details on how to update your code, please see \\\n            https://developer.android.com/topic/performance/background-optimization\n            ", (Implementation)implementation, (String)"https://developer.android.com/topic/performance/background-optimization", (Category)category, (int)5, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/BatteryDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

