/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle;

import com.android.builder.model.LintOptions;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.base.Strings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Project;

public class SyncOptions {
    public static final String STDOUT = "stdout";
    public static final String STDERR = "stderr";

    public static void syncTo(LintOptions options, LintCliClient client, LintCliFlags flags, String variantName, Project project, File reportsDir, boolean report) {
        flags.getSuppressedIds().addAll(options.getDisable());
        flags.getEnabledIds().addAll(options.getEnable());
        Set check = options.getCheck();
        if (check != null && !check.isEmpty()) {
            flags.setExactCheckedIds(check);
        }
        flags.setSetExitCode(options.isAbortOnError());
        flags.setFullPath(options.isAbsolutePaths());
        flags.setShowSourceLines(!options.isNoLines());
        flags.setQuiet(options.isQuiet());
        flags.setCheckAllWarnings(options.isCheckAllWarnings());
        flags.setIgnoreWarnings(options.isIgnoreWarnings());
        flags.setWarningsAsErrors(options.isWarningsAsErrors());
        flags.setCheckTestSources(options.isCheckTestSources());
        flags.setCheckGeneratedSources(options.isCheckGeneratedSources());
        flags.setCheckDependencies(options.isCheckDependencies());
        flags.setShowEverything(options.isShowAll());
        flags.setDefaultConfiguration(options.getLintConfig());
        flags.setExplainIssues(options.isExplainIssues());
        flags.setBaselineFile(options.getBaselineFile());
        Map severityOverrides = options.getSeverityOverrides();
        if (severityOverrides != null) {
            HashMap<String, Severity> map = new HashMap<String, Severity>();
            BuiltinIssueRegistry registry = new BuiltinIssueRegistry();
            for (Map.Entry entry : severityOverrides.entrySet()) {
                String id = (String)entry.getKey();
                Integer severityInt = (Integer)entry.getValue();
                Issue issue = registry.getIssue(id);
                Severity severity = issue != null ? SyncOptions.getSeverity(issue, severityInt) : Severity.WARNING;
                map.put(id, severity);
            }
            flags.setSeverityOverrides(map);
        } else {
            flags.setSeverityOverrides(Collections.emptyMap());
        }
        if (report || flags.isFatalOnly() && options.isAbortOnError()) {
            File output;
            if (options.getTextReport() || flags.isFatalOnly()) {
                boolean closeWriter;
                Writer writer;
                output = options.getTextOutput();
                if (output == null) {
                    output = new File(flags.isFatalOnly() ? STDERR : STDOUT);
                } else if (!(output.isAbsolute() || SyncOptions.isStdOut(output) || SyncOptions.isStdErr(output) || project == null)) {
                    output = project.file((Object)output.getPath());
                }
                output = SyncOptions.validateOutputFile(output);
                File file = null;
                if (SyncOptions.isStdOut(output)) {
                    writer = new PrintWriter(System.out, true);
                    closeWriter = false;
                } else if (SyncOptions.isStdErr(output)) {
                    writer = new PrintWriter(System.err, true);
                    closeWriter = false;
                } else {
                    file = output;
                    try {
                        writer = new BufferedWriter(new FileWriter(output));
                    }
                    catch (IOException e) {
                        throw new GradleException("Text invalid argument.", (Throwable)e);
                    }
                    closeWriter = true;
                }
                flags.getReporters().add(Reporter.createTextReporter((LintCliClient)client, (LintCliFlags)flags, (File)file, (Writer)writer, (boolean)closeWriter));
            }
            if (options.getHtmlReport()) {
                output = options.getHtmlOutput();
                if (output == null || flags.isFatalOnly()) {
                    output = SyncOptions.createOutputPath(project, variantName, ".html", reportsDir, flags.isFatalOnly());
                } else if (!output.isAbsolute() && project != null) {
                    output = project.file((Object)output.getPath());
                }
                output = SyncOptions.validateOutputFile(output);
                try {
                    flags.getReporters().add(Reporter.createHtmlReporter((LintCliClient)client, (File)output, (LintCliFlags)flags));
                }
                catch (IOException e) {
                    throw new GradleException("HTML invalid argument.", (Throwable)e);
                }
            }
            if (options.getXmlReport()) {
                output = options.getXmlOutput();
                if (output == null || flags.isFatalOnly()) {
                    output = SyncOptions.createOutputPath(project, variantName, ".xml", reportsDir, flags.isFatalOnly());
                } else if (!output.isAbsolute() && project != null) {
                    output = project.file((Object)output.getPath());
                }
                output = SyncOptions.validateOutputFile(output);
                try {
                    flags.getReporters().add(Reporter.createXmlReporter((LintCliClient)client, (File)output, (boolean)false));
                }
                catch (IOException e) {
                    throw new GradleException("XML invalid argument.", (Throwable)e);
                }
            }
        }
    }

    static Severity getSeverity(Issue issue, Integer severityInt) {
        if (severityInt == 6) {
            return issue.getDefaultSeverity();
        }
        return Severity.fromLintOptionSeverity((int)severityInt);
    }

    private static boolean isStdOut(File output) {
        return STDOUT.equals(output.getPath());
    }

    private static boolean isStdErr(File output) {
        return STDERR.equals(output.getPath());
    }

    public static File validateOutputFile(File output) {
        boolean delete;
        boolean ok;
        if (SyncOptions.isStdOut(output) || SyncOptions.isStdErr(output)) {
            return output;
        }
        File parent = output.getParentFile();
        if (!parent.exists() && !(ok = parent.mkdirs())) {
            throw new GradleException("Could not create directory " + parent);
        }
        if ((output = output.getAbsoluteFile()).exists() && !(delete = output.delete())) {
            throw new GradleException("Could not delete old " + output);
        }
        if (output.getParentFile() != null && !output.getParentFile().canWrite()) {
            throw new GradleException("Cannot write output file " + output);
        }
        return output;
    }

    public static File createOutputPath(Project project, String variantName, String extension, File reportsDir, boolean fatalOnly) {
        StringBuilder base = new StringBuilder();
        base.append("lint-results");
        if (!Strings.isNullOrEmpty((String)variantName)) {
            base.append("-");
            base.append(variantName);
        }
        if (fatalOnly) {
            base.append("-fatal");
        }
        base.append(extension);
        if (reportsDir != null) {
            return new File(reportsDir, base.toString());
        }
        if (project == null) {
            return new File(base.toString());
        }
        File buildDir = project.getBuildDir();
        return new File(buildDir, "reports" + File.separator + base.toString());
    }
}

