/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle;

import com.android.repository.Revision;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Warning;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.DefaultConfiguration;
import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.gradle.GroovyGradleVisitor;
import com.android.tools.lint.gradle.KotlinSourceFoldersResolver;
import com.android.tools.lint.gradle.LintGradleClient;
import com.android.tools.lint.gradle.LintGradleClient$WhenMappings;
import com.android.tools.lint.gradle.ProjectSearch;
import com.android.tools.lint.gradle.api.VariantInputs;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelSeverity;
import com.android.utils.XmlUtils;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0014J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010&\u001a\u00020#H\u0014J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000bH\u0014J\u0012\u0010+\u001a\u0004\u0018\u00010\u000b2\u0006\u0010,\u001a\u00020\u0003H\u0016J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0.2\u0006\u0010/\u001a\u00020(H\u0016J\u0012\u00100\u001a\u0004\u0018\u00010\u00102\u0006\u0010/\u001a\u00020(H\u0016J\u001c\u00101\u001a\u0004\u0018\u00010\u000b2\b\u00102\u001a\u0004\u0018\u00010\u00032\u0006\u00103\u001a\u00020\u0014H\u0016J\n\u00104\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00105\u001a\u0002062\u0006\u0010/\u001a\u00020(2\b\u00107\u001a\u0004\u0018\u00010%H\u0016J\b\u00108\u001a\u000209H\u0016J\u001c\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000b0;2\u0006\u0010/\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0003J\u0012\u0010\u001a\u001a\u0004\u0018\u00010<2\u0006\u0010/\u001a\u00020(H\u0016J\n\u0010=\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010>\u001a\u00020\u0014H\u0002J\u0012\u0010?\u001a\u0004\u0018\u00010 2\u0006\u0010@\u001a\u00020AH\u0016J\u001a\u0010?\u001a\u0004\u0018\u00010 2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016JB\u0010D\u001a\u00020\u001d2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u00032\u0006\u0010N\u001a\u00020O2\b\u0010P\u001a\u0004\u0018\u00010QH\u0016J\"\u0010R\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0;\u0012\u0006\u0012\u0004\u0018\u00010U0S2\u0006\u0010\u0004\u001a\u00020\u0005J\f\u0010V\u001a\u00020J*\u00020WH\u0002R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcom/android/tools/lint/gradle/LintGradleClient;", "Lcom/android/tools/lint/LintCliClient;", "version", "", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "gradleProject", "Lorg/gradle/api/Project;", "sdkHome", "Ljava/io/File;", "variantName", "variantInputs", "Lcom/android/tools/lint/gradle/api/VariantInputs;", "buildToolInfoRevision", "Lcom/android/repository/Revision;", "resolver", "Lcom/android/tools/lint/gradle/KotlinSourceFoldersResolver;", "isAndroid", "", "baselineVariantName", "(Ljava/lang/String;Lcom/android/tools/lint/client/api/IssueRegistry;Lcom/android/tools/lint/LintCliFlags;Lorg/gradle/api/Project;Ljava/io/File;Ljava/lang/String;Lcom/android/tools/lint/gradle/api/VariantInputs;Lcom/android/repository/Revision;Lcom/android/tools/lint/gradle/KotlinSourceFoldersResolver;ZLjava/lang/String;)V", "getBaselineVariantName", "()Ljava/lang/String;", "mergedManifest", "getMergedManifest", "()Ljava/io/File;", "addProgressPrinter", "", "closeConnection", "connection", "Ljava/net/URLConnection;", "configureLintRequest", "lintRequest", "Lcom/android/tools/lint/client/api/LintRequest;", "createDriver", "Lcom/android/tools/lint/client/api/LintDriver;", "request", "createProject", "Lcom/android/tools/lint/detector/api/Project;", "dir", "referenceDir", "findResource", "relativePath", "findRuleJars", "", "project", "getBuildToolsRevision", "getCacheDir", "name", "create", "getClientRevision", "getConfiguration", "Lcom/android/tools/lint/client/api/Configuration;", "driver", "getGradleVisitor", "Lcom/android/tools/lint/client/api/GradleVisitor;", "getKotlinSourceFolders", "", "Lorg/w3c/dom/Document;", "getSdkHome", "isOffline", "openConnection", "url", "Ljava/net/URL;", "timeout", "", "report", "context", "Lcom/android/tools/lint/detector/api/Context;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "format", "Lcom/android/tools/lint/detector/api/TextFormat;", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "run", "Lkotlin/Pair;", "Lcom/android/tools/lint/Warning;", "Lcom/android/tools/lint/client/api/LintBaseline;", "toLintSeverity", "Lcom/android/tools/lint/model/LintModelSeverity;", "lint-gradle"})
public final class LintGradleClient
extends LintCliClient {
    private final String variantName;
    private final Revision buildToolInfoRevision;
    private final boolean isAndroid;
    private final KotlinSourceFoldersResolver resolver;
    private final String version;
    private final Project gradleProject;
    private final File sdkHome;
    private final VariantInputs variantInputs;
    @Nullable
    private final String baselineVariantName;

    @NotNull
    public final List<File> getKotlinSourceFolders(@NotNull Project project, @NotNull String variantName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        return this.resolver.getKotlinSourceFolders(variantName, project);
    }

    @Nullable
    public String getClientRevision() {
        return this.version;
    }

    @NotNull
    public Configuration getConfiguration(@NotNull com.android.tools.lint.detector.api.Project project, @Nullable LintDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        DefaultConfiguration overrideConfiguration = this.getOverrideConfiguration();
        if (overrideConfiguration != null) {
            return (Configuration)overrideConfiguration;
        }
        LintModelModule lintModelModule = project.getBuildModule();
        if (lintModelModule == null) {
            return super.getConfiguration(project, driver);
        }
        LintModelModule buildModel = lintModelModule;
        LintModelLintOptions lintOptions = buildModel.getLintOptions();
        File file = lintOptions.getLintConfig();
        if (file == null) {
            file = new File(project.getDir(), "lint.xml");
        }
        File lintXml = file;
        Map overrides = lintOptions.getSeverityOverrides();
        if (overrides == null || overrides.isEmpty()) {
            return super.getConfiguration(project, driver);
        }
        return (Configuration)new LintCliClient.CliConfiguration(this, overrides, lintXml, project, lintXml, this.getConfiguration(), project, this.getFlags().isFatalOnly()){
            final /* synthetic */ LintGradleClient this$0;
            final /* synthetic */ Map $overrides;
            final /* synthetic */ File $lintXml;
            final /* synthetic */ com.android.tools.lint.detector.api.Project $project;

            @NotNull
            public Severity getSeverity(@NotNull Issue issue) {
                Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
                if (issue.getSuppressNames() != null) {
                    return this.getDefaultSeverity(issue);
                }
                LintModelSeverity lintModelSeverity = (LintModelSeverity)this.$overrides.get(issue.getId());
                if (lintModelSeverity == null || (lintModelSeverity = LintGradleClient.access$toLintSeverity(this.this$0, lintModelSeverity)) == null) {
                    return super.getSeverity(issue);
                }
                LintModelSeverity severity = lintModelSeverity;
                return this.this$0.getFlags().isFatalOnly() && severity != Severity.FATAL ? Severity.IGNORE : severity;
            }
            {
                this.this$0 = $outer;
                this.$overrides = $captured_local_variable$1;
                this.$lintXml = $captured_local_variable$2;
                this.$project = $captured_local_variable$3;
                super((LintCliClient)$outer, $super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }

    private final Severity toLintSeverity(@NotNull LintModelSeverity $this$toLintSeverity) {
        Severity severity;
        switch (LintGradleClient$WhenMappings.$EnumSwitchMapping$0[$this$toLintSeverity.ordinal()]) {
            case 1: {
                severity = Severity.FATAL;
                break;
            }
            case 2: {
                severity = Severity.ERROR;
                break;
            }
            case 3: {
                severity = Severity.WARNING;
                break;
            }
            case 4: {
                severity = Severity.INFORMATIONAL;
                break;
            }
            case 5: {
                severity = Severity.IGNORE;
                break;
            }
            case 6: {
                severity = Severity.WARNING;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return severity;
    }

    @Nullable
    public File findResource(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return !this.isAndroid ? null : super.findResource(relativePath);
    }

    private final boolean isOffline() {
        Gradle gradle = this.gradleProject.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"gradleProject.gradle");
        StartParameter startParameter = gradle.getStartParameter();
        Intrinsics.checkExpressionValueIsNotNull((Object)startParameter, (String)"gradleProject.gradle.startParameter");
        return startParameter.isOffline();
    }

    @Nullable
    public URLConnection openConnection(@NotNull URL url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (this.isOffline()) {
            return null;
        }
        return super.openConnection(url);
    }

    @Nullable
    public URLConnection openConnection(@NotNull URL url, int timeout) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (this.isOffline()) {
            return null;
        }
        return super.openConnection(url, timeout);
    }

    public void closeConnection(@NotNull URLConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        if (this.isOffline()) {
            return;
        }
        super.closeConnection(connection);
    }

    @NotNull
    public Iterable<File> findRuleJars(@NotNull com.android.tools.lint.detector.api.Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        FileCollection fileCollection = this.variantInputs.getRuleJars().getAsFileTree().filter((Spec)findRuleJars.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"variantInputs.ruleJars.a\u2026obj: File -> obj.isFile }");
        Set set = fileCollection.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"variantInputs.ruleJars.a\u2026ile -> obj.isFile }.files");
        return set;
    }

    @NotNull
    protected com.android.tools.lint.detector.api.Project createProject(@NotNull File dir, @NotNull File referenceDir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)referenceDir, (String)"referenceDir");
        throw (Throwable)new IllegalStateException();
    }

    @Nullable
    public File getSdkHome() {
        File file = this.sdkHome;
        if (file == null) {
            file = super.getSdkHome();
        }
        return file;
    }

    @Nullable
    public File getCacheDir(@Nullable String name, boolean create) {
        String relative = "intermediates" + File.separator + "lint-cache";
        if (name != null) {
            relative = relative + File.separator + name;
        }
        Project project = this.gradleProject.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"gradleProject.rootProject");
        File dir = new File(project.getBuildDir(), relative);
        return dir.exists() || create && dir.mkdirs() ? dir : super.getCacheDir(name, create);
    }

    @NotNull
    public GradleVisitor getGradleVisitor() {
        return new GroovyGradleVisitor();
    }

    protected void configureLintRequest(@NotNull LintRequest lintRequest) {
        Intrinsics.checkParameterIsNotNull((Object)lintRequest, (String)"lintRequest");
        ProjectSearch search = new ProjectSearch();
        com.android.tools.lint.detector.api.Project project = search.getProject(this, this.gradleProject, this.variantName);
        if (project == null) {
            LintGradleClient lintGradleClient = this;
            boolean bl = false;
            boolean bl2 = false;
            LintGradleClient $this$run = lintGradleClient;
            boolean bl3 = false;
            lintRequest.setProjects((Collection)CollectionsKt.emptyList());
            return;
        }
        com.android.tools.lint.detector.api.Project project2 = project;
        LintModelModule buildModel = project2.getBuildModule();
        if (buildModel != null && !buildModel.getDynamicFeatures().isEmpty()) {
            for (String feature : buildModel.getDynamicFeatures()) {
                Project rootProject = this.gradleProject.getRootProject();
                Project featureProject = rootProject.findProject(feature);
                if (featureProject == null) continue;
                if (search.getProject(this, featureProject, this.variantName) != null) {
                    com.android.tools.lint.detector.api.Project project3;
                    boolean bl = false;
                    boolean bl4 = false;
                    com.android.tools.lint.detector.api.Project it = project3;
                    boolean bl5 = false;
                    project2.mergeFolders(it);
                }
            }
        }
        lintRequest.setProjects((Collection)CollectionsKt.listOf((Object)project2));
        File file = project2.getDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.dir");
        this.registerProject(file, project2);
        Iterator iterator = project2.getAllLibraries().iterator();
        while (iterator.hasNext()) {
            com.android.tools.lint.detector.api.Project dependency;
            com.android.tools.lint.detector.api.Project project4 = dependency = (com.android.tools.lint.detector.api.Project)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"dependency");
            File file2 = project4.getDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"dependency.dir");
            this.registerProject(file2, dependency);
        }
    }

    @NotNull
    protected LintDriver createDriver(@NotNull IssueRegistry registry, @NotNull LintRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        LintDriver driver = super.createDriver(registry, request);
        driver.setPlatforms(this.isAndroid ? Platform.ANDROID_SET : Platform.JDK_SET);
        return driver;
    }

    @NotNull
    public final Pair<List<Warning>, LintBaseline> run(@NotNull IssueRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        int exitCode = this.run(registry, CollectionsKt.emptyList());
        if (exitCode == 6) {
            if (LintCliClient.Companion.continueAfterBaseLineCreated()) {
                return new Pair((Object)CollectionsKt.emptyList(), (Object)this.getDriver().getBaseline());
            }
            throw (Throwable)new GradleException("Aborting build since new baseline file was created");
        }
        if (exitCode == 7) {
            throw (Throwable)new GradleException("Aborting build since sources were modified to apply quickfixes after compilation");
        }
        return new Pair((Object)this.getWarnings(), (Object)this.getDriver().getBaseline());
    }

    protected void addProgressPrinter() {
    }

    @Nullable
    public Revision getBuildToolsRevision(@NotNull com.android.tools.lint.detector.api.Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.buildToolInfoRevision;
    }

    public void report(@NotNull Context context, @NotNull Issue issue, @NotNull Severity severity, @NotNull Location location, @NotNull String message, @NotNull TextFormat format, @Nullable LintFix fix) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)severity, (String)"severity");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        if (issue == IssueRegistry.LINT_ERROR && StringsKt.startsWith$default((String)message, (String)"No `.class` files were found in project", (boolean)false, (int)2, null)) {
            return;
        }
        super.report(context, issue, severity, location, message, format, fix);
    }

    @Nullable
    public final File getMergedManifest() {
        return this.variantInputs.getMergedManifest();
    }

    @Nullable
    public Document getMergedManifest(@NotNull com.android.tools.lint.detector.api.Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        File file = this.variantInputs.getMergedManifest();
        if (file == null) {
            return null;
        }
        File manifest = file;
        try {
            String xml = Files.asCharSource((File)manifest, (Charset)Charsets.UTF_8).read();
            Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
            if (document != null) {
                File manifestMergeReport;
                File file2 = manifestMergeReport = this.variantInputs.getManifestMergeReport();
                if (file2 != null) {
                    File file3 = file2;
                    boolean bl = false;
                    boolean bl2 = false;
                    File it = file3;
                    boolean bl3 = false;
                    this.resolveMergeManifestSources(document, it);
                }
                return document;
            }
        }
        catch (IOException ioe) {
            this.log(ioe, "Could not read %1$s", new Object[]{manifest});
        }
        return super.getMergedManifest(project);
    }

    @Nullable
    protected String getBaselineVariantName() {
        return this.baselineVariantName;
    }

    public LintGradleClient(@NotNull String version, @NotNull IssueRegistry registry, @NotNull LintCliFlags flags, @NotNull Project gradleProject, @Nullable File sdkHome, @Nullable String variantName, @NotNull VariantInputs variantInputs, @Nullable Revision buildToolInfoRevision, @NotNull KotlinSourceFoldersResolver resolver, boolean isAndroid, @Nullable String baselineVariantName) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        Intrinsics.checkParameterIsNotNull((Object)flags, (String)"flags");
        Intrinsics.checkParameterIsNotNull((Object)gradleProject, (String)"gradleProject");
        Intrinsics.checkParameterIsNotNull((Object)variantInputs, (String)"variantInputs");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        super(flags, "gradle");
        this.version = version;
        this.gradleProject = gradleProject;
        this.sdkHome = sdkHome;
        this.variantInputs = variantInputs;
        this.baselineVariantName = baselineVariantName;
        this.setRegistry(registry);
        this.buildToolInfoRevision = buildToolInfoRevision;
        this.resolver = resolver;
        this.variantName = variantName;
        this.isAndroid = isAndroid;
    }

    public static final /* synthetic */ Severity access$toLintSeverity(LintGradleClient $this, LintModelSeverity $this$access_u24toLintSeverity) {
        return $this.toLintSeverity($this$access_u24toLintSeverity);
    }
}

