/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelSourceProvider;
import com.android.utils.XmlUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J$\u0010\u0016\u001a\u00020\u0013*\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0015H\u0004J\u001e\u0010\u001a\u001a\u00020\u0013*\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00020\u0015H\u0004J2\u0010\u001b\u001a\u00020\u0013*\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00152\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\rH\u0004J8\u0010\u001e\u001a\u00020\u0013*\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010 2\u0006\u0010\u0012\u001a\u00020\u00152\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\rH\u0004J4\u0010!\u001a\u00020\u0013*\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180 2\u0006\u0010\u0012\u001a\u00020\u00152\b\b\u0002\u0010#\u001a\u00020\u0018H\u0004J&\u0010$\u001a\u00020\u00132\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0015H\u0004J\"\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00152\b\b\u0002\u0010(\u001a\u00020\u0018H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/model/LintModelWriter;", "", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "printer", "Ljava/io/PrintWriter;", "<init>", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;Ljava/io/PrintWriter;)V", "getAdapter", "()Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "getPrinter", "()Ljava/io/PrintWriter;", "root", "Ljava/io/File;", "getRoot", "()Ljava/io/File;", "setRoot", "(Ljava/io/File;)V", "indent", "", "level", "", "printAttribute", "name", "", "value", "printName", "printFile", "file", "relativeTo", "printFiles", "path", "", "printStrings", "strings", "separator", "writeSourceProviders", "sourceProviders", "", "Lcom/android/tools/lint/model/LintModelSourceProvider;", "tag", "writeSourceProvider", "sourceProvider", "lint-model"})
class LintModelWriter {
    @NotNull
    private final LintModelSerialization.LintModelSerializationAdapter adapter;
    @NotNull
    private final PrintWriter printer;
    @Nullable
    private File root;

    public LintModelWriter(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter, @NotNull PrintWriter printer) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        this.adapter = adapter;
        this.printer = printer;
        this.root = this.adapter.getRoot();
    }

    @NotNull
    protected final LintModelSerialization.LintModelSerializationAdapter getAdapter() {
        return this.adapter;
    }

    @NotNull
    protected final PrintWriter getPrinter() {
        return this.printer;
    }

    @Nullable
    protected final File getRoot() {
        return this.root;
    }

    protected final void setRoot(@Nullable File file) {
        this.root = file;
    }

    protected final void indent(int level) {
        for (int i = 0; i < level; ++i) {
            this.printer.print("  ");
        }
    }

    protected final void printAttribute(@NotNull PrintWriter $this$printAttribute, @NotNull String name, @NotNull String value, int indent) {
        Intrinsics.checkNotNullParameter((Object)$this$printAttribute, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $this$printAttribute.println();
        this.indent(indent + 2);
        $this$printAttribute.print(name);
        $this$printAttribute.print("=\"");
        $this$printAttribute.print(XmlUtils.toXmlAttributeValue((String)value));
        $this$printAttribute.print("\"");
    }

    protected final void printName(@NotNull PrintWriter $this$printName, @Nullable String name, int indent) {
        Intrinsics.checkNotNullParameter((Object)$this$printName, (String)"<this>");
        if (name == null) {
            return;
        }
        this.printAttribute($this$printName, "name", name, indent);
    }

    protected final void printFile(@NotNull PrintWriter $this$printFile, @NotNull String name, @Nullable File file, int indent, @Nullable File relativeTo) {
        Intrinsics.checkNotNullParameter((Object)$this$printFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (file == null) {
            return;
        }
        String path = this.adapter.toPathString(file, relativeTo);
        this.printAttribute($this$printFile, name, path, indent);
    }

    public static /* synthetic */ void printFile$default(LintModelWriter lintModelWriter, PrintWriter printWriter, String string, File file, int n, File file2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: printFile");
        }
        if ((n2 & 8) != 0) {
            file2 = lintModelWriter.root;
        }
        lintModelWriter.printFile(printWriter, string, file, n, file2);
    }

    protected final void printFiles(@NotNull PrintWriter $this$printFiles, @NotNull String name, @Nullable Collection<? extends File> path, int indent, @Nullable File relativeTo) {
        Intrinsics.checkNotNullParameter((Object)$this$printFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (path == null) {
            return;
        }
        if (path.isEmpty()) {
            return;
        }
        Iterable iterable = path;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        this.printAttribute($this$printFiles, name, CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)((Function1)new Function1<File, CharSequence>(this, relativeTo){
            final /* synthetic */ LintModelWriter this$0;
            final /* synthetic */ File $relativeTo;
            {
                this.this$0 = $receiver;
                this.$relativeTo = $relativeTo;
                super(1);
            }

            public final CharSequence invoke(File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.getAdapter().toPathString(it, this.$relativeTo);
            }
        }), (int)30, null), indent);
    }

    public static /* synthetic */ void printFiles$default(LintModelWriter lintModelWriter, PrintWriter printWriter, String string, Collection collection, int n, File file, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: printFiles");
        }
        if ((n2 & 8) != 0) {
            file = lintModelWriter.root;
        }
        lintModelWriter.printFiles(printWriter, string, collection, n, file);
    }

    protected final void printStrings(@NotNull PrintWriter $this$printStrings, @NotNull String name, @NotNull Collection<String> strings, int indent, @NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)$this$printStrings, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        if (strings.isEmpty()) {
            return;
        }
        this.printAttribute($this$printStrings, name, CollectionsKt.joinToString$default((Iterable)strings, (CharSequence)separator, null, null, (int)0, null, null, (int)62, null), indent);
    }

    public static /* synthetic */ void printStrings$default(LintModelWriter lintModelWriter, PrintWriter printWriter, String string, Collection collection, int n, String string2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: printStrings");
        }
        if ((n2 & 8) != 0) {
            string2 = ",";
        }
        lintModelWriter.printStrings(printWriter, string, collection, n, string2);
    }

    protected final void writeSourceProviders(@NotNull List<? extends LintModelSourceProvider> sourceProviders, @NotNull String tag, int indent) {
        Intrinsics.checkNotNullParameter(sourceProviders, (String)"sourceProviders");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.indent(indent);
        this.printer.print("<");
        this.printer.print(tag);
        this.printer.println(">");
        for (LintModelSourceProvider lintModelSourceProvider : sourceProviders) {
            LintModelWriter.writeSourceProvider$default(this, lintModelSourceProvider, indent + 1, null, 4, null);
        }
        this.indent(indent);
        this.printer.print("</");
        this.printer.print(tag);
        this.printer.println(">");
    }

    protected final void writeSourceProvider(@NotNull LintModelSourceProvider sourceProvider, int indent, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)sourceProvider, (String)"sourceProvider");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.indent(indent);
        this.printer.print("<");
        this.printer.print(tag);
        LintModelWriter.printFiles$default(this, this.printer, "manifests", sourceProvider.getManifestFiles(), indent, null, 8, null);
        LintModelWriter.printFiles$default(this, this.printer, "javaDirectories", sourceProvider.getJavaDirectories(), indent, null, 8, null);
        LintModelWriter.printFiles$default(this, this.printer, "resDirectories", sourceProvider.getResDirectories(), indent, null, 8, null);
        LintModelWriter.printFiles$default(this, this.printer, "assetsDirectories", sourceProvider.getAssetsDirectories(), indent, null, 8, null);
        if (sourceProvider.isInstrumentationTest()) {
            this.printAttribute(this.printer, "androidTest", "true", indent);
        }
        if (sourceProvider.isUnitTest()) {
            this.printAttribute(this.printer, "unitTest", "true", indent);
        }
        if (sourceProvider.isDebugOnly()) {
            this.printAttribute(this.printer, "debugOnly", "true", indent);
        }
        if (sourceProvider.isTestFixture()) {
            this.printAttribute(this.printer, "testFixture", "true", indent);
        }
        this.printer.println("/>");
    }

    public static /* synthetic */ void writeSourceProvider$default(LintModelWriter lintModelWriter, LintModelSourceProvider lintModelSourceProvider, int n, String string, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeSourceProvider");
        }
        if ((n2 & 4) != 0) {
            string = "sourceProvider";
        }
        lintModelWriter.writeSourceProvider(lintModelSourceProvider, n, string);
    }
}

