/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.io.impl;

import com.android.repository.io.FileOp;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Properties;

public class FileOpImpl
implements FileOp {
    private static Method sFileSetExecutable = null;
    private static final Object[] sFileSetExecutableParams = new Object[]{Boolean.TRUE, Boolean.FALSE};

    @Override
    public void deleteFileOrFolder(File fileOrFolder) {
        File[] files;
        if (this.isDirectory(fileOrFolder) && (files = fileOrFolder.listFiles()) != null) {
            for (File item : files) {
                this.deleteFileOrFolder(item);
            }
        }
        if (!this.exists(fileOrFolder)) {
            return;
        }
        if (this.isWindows()) {
            for (int i = 0; i < 5; ++i) {
                if (fileOrFolder.delete()) {
                    return;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            fileOrFolder.deleteOnExit();
        } else if (!fileOrFolder.delete()) {
            fileOrFolder.deleteOnExit();
        }
    }

    @Override
    public void setExecutablePermission(File file) throws IOException {
        if (this.isWindows()) {
            throw new IllegalStateException("Can't setExecutablePermission on windows!");
        }
        if (sFileSetExecutable != null) {
            try {
                sFileSetExecutable.invoke((Object)file, sFileSetExecutableParams);
                return;
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        Runtime.getRuntime().exec(new String[]{"chmod", "+x", file.getAbsolutePath()});
    }

    @Override
    public void setReadOnly(File file) {
        file.setReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFile(File source, File dest) throws IOException {
        byte[] buffer = new byte[8192];
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int read;
            fis = new FileInputStream(source);
            fos = new FileOutputStream(dest);
            while ((read = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, read);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSameFile(File file1, File file2) throws IOException {
        if (file1.length() != file2.length()) {
            return false;
        }
        FileInputStream fis1 = null;
        FileInputStream fis2 = null;
        try {
            boolean bl;
            fis1 = new FileInputStream(file1);
            fis2 = new FileInputStream(file2);
            byte[] buffer1 = new byte[8192];
            byte[] buffer2 = new byte[8192];
            do {
                int n;
                int read1;
                if ((read1 = fis1.read(buffer1)) == -1) return true;
                int read2 = 0;
                while (read2 < read1 && (n = fis2.read(buffer2, read2, read1 - read2)) != -1) {
                }
                if (read2 == read1) continue;
                bl = false;
                return bl;
            } while (Arrays.equals(buffer1, buffer2));
            bl = false;
            return bl;
        }
        finally {
            if (fis2 != null) {
                try {
                    fis2.close();
                }
                catch (IOException e) {}
            }
            if (fis1 != null) {
                try {
                    fis1.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public boolean isFile(File file) {
        return file.isFile();
    }

    @Override
    public boolean isDirectory(File file) {
        return file.isDirectory();
    }

    @Override
    public boolean exists(File file) {
        return file.exists();
    }

    @Override
    public boolean canWrite(File file) {
        return file.canWrite();
    }

    @Override
    public long length(File file) {
        return file.length();
    }

    @Override
    public boolean delete(File file) {
        return file.delete();
    }

    @Override
    public boolean mkdirs(File file) {
        return file.mkdirs();
    }

    @Override
    public File[] listFiles(File file) {
        File[] r = file.listFiles();
        if (r == null) {
            return EMPTY_FILE_ARRAY;
        }
        return r;
    }

    @Override
    public boolean renameTo(File oldFile, File newFile) {
        return oldFile.renameTo(newFile);
    }

    @Override
    public OutputStream newFileOutputStream(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    @Override
    public InputStream newFileInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties loadProperties(File file) {
        Properties props = new Properties();
        Closer closer = Closer.create();
        try {
            FileInputStream fis = (FileInputStream)closer.register((Closeable)new FileInputStream(file));
            props.load(fis);
        }
        catch (IOException ignore) {
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {}
        }
        return props;
    }

    @Override
    public void saveProperties(File file, Properties props, String comments) throws IOException {
        Closer closer = Closer.create();
        try {
            OutputStream fos = (OutputStream)closer.register((Closeable)this.newFileOutputStream(file));
            props.store(fos, comments);
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    @Override
    public long lastModified(File file) {
        return file.lastModified();
    }

    @Override
    public boolean createNewFile(File file) throws IOException {
        return file.createNewFile();
    }

    @Override
    public boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    @Override
    public boolean canExecute(File file) {
        return file.canExecute();
    }

    @Override
    public File ensureRealFile(File in) {
        return in;
    }

    @Override
    public String toString(File f, Charset c) throws IOException {
        return Files.toString((File)f, (Charset)c);
    }

    @Override
    public String[] list(File folder, FilenameFilter filenameFilter) {
        return folder.list(filenameFilter);
    }

    @Override
    public File[] listFiles(File folder, FilenameFilter filenameFilter) {
        return folder.listFiles(filenameFilter);
    }

    @Override
    public void deleteOnExit(File file) {
        file.deleteOnExit();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof FileOpImpl;
    }

    static {
        try {
            sFileSetExecutable = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

