/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.installer;

import com.android.repository.api.DelegatingProgressIndicator;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.repository.util.InstallerUtil;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public abstract class AbstractPackageOperation
implements PackageOperation {
    private static final String PATH_KEY = "path";
    private static final String CLASSNAME_KEY = "class";
    private static final String PREPARE_COMPLETE_FN = ".prepareComplete";
    private static final String INSTALL_DATA_FN = ".installData";
    static final String TEMP_DIR_PREFIX = "PackageOperation";
    private PackageOperation.InstallStatus mInstallStatus = PackageOperation.InstallStatus.NOT_STARTED;
    private Properties mInstallProperties;
    private PackageOperation mFallbackOperation;
    private final Object mStateChangeLock = new Object();
    private List<PackageOperation.StatusChangeListener> mListeners = Lists.newArrayList();
    private final RepoManager mRepoManager;
    protected final FileOp mFop;
    private DelegatingProgressIndicator mProgress;
    private final Object mProgressLock = new Object();

    protected AbstractPackageOperation(RepoManager repoManager, FileOp fop) {
        this.mRepoManager = repoManager;
        this.mFop = fop;
    }

    protected abstract boolean doPrepare(File var1, ProgressIndicator var2);

    protected abstract boolean doComplete(File var1, ProgressIndicator var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean complete(ProgressIndicator progress) {
        File installTemp;
        boolean result;
        block14: {
            this.addProgress(progress);
            StartTaskStatus startResult = this.startTask(PackageOperation.InstallStatus.RUNNING);
            if (startResult != StartTaskStatus.STARTED) {
                return startResult == StartTaskStatus.ALREADY_DONE;
            }
            if (this.mInstallProperties == null) {
                try {
                    this.mInstallProperties = AbstractPackageOperation.readInstallProperties(this.mFop.toPath(this.getLocation(this.mProgress)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            result = false;
            String installTempPath = null;
            if (this.mInstallProperties != null) {
                installTempPath = this.mInstallProperties.getProperty(PATH_KEY);
            }
            installTemp = installTempPath == null ? null : new File(installTempPath);
            try {
                if (InstallerUtil.checkValidPath(this.getLocation(this.mProgress), this.getRepoManager(), this.mProgress)) break block14;
                boolean bl = false;
                if (!result && this.mProgress.isCanceled()) {
                    this.cleanup();
                }
                if ((result &= this.updateStatus(result ? PackageOperation.InstallStatus.COMPLETE : PackageOperation.InstallStatus.FAILED)) && installTemp != null) {
                    this.mFop.deleteFileOrFolder(installTemp);
                }
                this.getRepoManager().installEnded(this.getPackage());
                this.getRepoManager().markLocalCacheInvalid();
                return bl;
            }
            catch (Throwable throwable) {
                if (!result && this.mProgress.isCanceled()) {
                    this.cleanup();
                }
                if ((result &= this.updateStatus(result ? PackageOperation.InstallStatus.COMPLETE : PackageOperation.InstallStatus.FAILED)) && installTemp != null) {
                    this.mFop.deleteFileOrFolder(installTemp);
                }
                this.getRepoManager().installEnded(this.getPackage());
                this.getRepoManager().markLocalCacheInvalid();
                throw throwable;
            }
        }
        result = this.doComplete(installTemp, this.mProgress);
        this.mProgress.logInfo(String.format("\"%1$s\" complete.", this.getName()));
        if (!result && this.mProgress.isCanceled()) {
            this.cleanup();
        }
        if ((result &= this.updateStatus(result ? PackageOperation.InstallStatus.COMPLETE : PackageOperation.InstallStatus.FAILED)) && installTemp != null) {
            this.mFop.deleteFileOrFolder(installTemp);
        }
        this.getRepoManager().installEnded(this.getPackage());
        this.getRepoManager().markLocalCacheInvalid();
        this.mProgress.setFraction(1.0);
        this.mProgress.setIndeterminate(false);
        this.mProgress.logInfo(String.format("\"%1$s\" %2$s.", this.getName(), result ? "finished" : "failed"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StartTaskStatus startTask(PackageOperation.InstallStatus inProgress) {
        boolean success;
        boolean alreadyStarted = false;
        CompletableFuture f = new CompletableFuture();
        Object object = this.mStateChangeLock;
        synchronized (object) {
            if (this.mInstallStatus == PackageOperation.InstallStatus.FAILED) {
                return StartTaskStatus.FAILED;
            }
            if (this.mInstallStatus.compareTo(inProgress) > 0) {
                return StartTaskStatus.ALREADY_DONE;
            }
            if (this.mInstallStatus == inProgress) {
                this.registerStateChangeListener((op, p) -> {
                    if (op.getInstallStatus().compareTo(inProgress) > 0) {
                        f.complete(null);
                    }
                });
                alreadyStarted = true;
            } else {
                this.mInstallStatus = inProgress;
            }
        }
        if (alreadyStarted) {
            try {
                f.get();
                success = this.getInstallStatus() != PackageOperation.InstallStatus.FAILED;
            }
            catch (InterruptedException | ExecutionException e) {
                success = false;
            }
        } else {
            success = this.updateStatus(inProgress);
        }
        if (!success) {
            this.mProgress.setFraction(1.0);
            this.mProgress.setIndeterminate(false);
            this.mProgress.logInfo(String.format("\"%1$s\" failed.", this.getName()));
            return StartTaskStatus.FAILED;
        }
        return alreadyStarted ? StartTaskStatus.ALREADY_DONE : StartTaskStatus.STARTED;
    }

    private static Properties readInstallProperties(Path installPath) throws IOException {
        Path metaDir = installPath.resolve(".installer");
        Path dataFile = metaDir.resolve(INSTALL_DATA_FN);
        if (Files.exists(dataFile, new LinkOption[0])) {
            Properties installProperties = new Properties();
            try (InputStream inStream = Files.newInputStream(dataFile, new OpenOption[0]);){
                installProperties.load(inStream);
                Properties properties = installProperties;
                return properties;
            }
        }
        return null;
    }

    private void cleanup() {
        this.mFop.deleteFileOrFolder(new File(this.getLocation(this.mProgress), ".installer"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean prepare(ProgressIndicator progress) {
        this.addProgress(progress);
        StartTaskStatus startResult = this.startTask(PackageOperation.InstallStatus.PREPARING);
        if (startResult != StartTaskStatus.STARTED) {
            return startResult == StartTaskStatus.ALREADY_DONE;
        }
        this.mProgress.logInfo(String.format("Preparing \"%1$s\".", this.getName()));
        try {
            File dest = this.getLocation(this.mProgress);
            this.mInstallProperties = this.readOrCreateInstallProperties(dest);
        }
        catch (IOException e) {
            this.mProgress.logWarning("Failed to read or create install properties file.");
            return false;
        }
        this.getRepoManager().installBeginning(this.getPackage(), this);
        boolean result = false;
        try {
            if (!InstallerUtil.checkValidPath(this.getLocation(this.mProgress), this.getRepoManager(), this.mProgress)) {
                boolean bl = false;
                return bl;
            }
            File installTempPath = this.writeInstallerMetadata();
            if (installTempPath == null) {
                this.mProgress.logInfo(String.format("\"%1$s\" failed.", this.getName()));
                boolean bl = false;
                return bl;
            }
            File prepareCompleteMarker = new File(installTempPath, PREPARE_COMPLETE_FN);
            if (!this.mFop.exists(prepareCompleteMarker)) {
                if (this.doPrepare(installTempPath, this.mProgress)) {
                    this.mFop.createNewFile(prepareCompleteMarker);
                    result = this.updateStatus(PackageOperation.InstallStatus.PREPARED);
                }
            } else {
                this.mProgress.logInfo("Found existing prepared package.");
                result = true;
            }
        }
        catch (IOException e) {
            result = false;
        }
        finally {
            if (!result) {
                this.getRepoManager().installEnded(this.getPackage());
                this.updateStatus(PackageOperation.InstallStatus.FAILED);
                if (this.mProgress.isCanceled()) {
                    this.cleanup();
                }
            }
        }
        this.mProgress.logInfo(String.format("\"%1$s\" %2$s.", this.getName(), result ? "ready" : "failed"));
        return result;
    }

    private Properties readOrCreateInstallProperties(File affectedPath) throws IOException {
        Properties installProperties = AbstractPackageOperation.readInstallProperties(this.mFop.toPath(affectedPath));
        if (installProperties != null) {
            return installProperties;
        }
        installProperties = new Properties();
        File metaDir = new File(affectedPath, ".installer");
        if (!this.mFop.exists(metaDir)) {
            this.mFop.mkdirs(metaDir);
        }
        File dataFile = new File(metaDir, INSTALL_DATA_FN);
        File installTempPath = FileOpUtils.getNewTempDir(TEMP_DIR_PREFIX, this.mFop);
        if (installTempPath == null) {
            this.deleteOrphanedTempDirs();
            installTempPath = FileOpUtils.getNewTempDir(TEMP_DIR_PREFIX, this.mFop);
            if (installTempPath == null) {
                throw new IOException("Failed to create temp path");
            }
        }
        installProperties.put(PATH_KEY, installTempPath.getPath());
        installProperties.put(CLASSNAME_KEY, this.getClass().getName());
        this.mFop.createNewFile(dataFile);
        try (OutputStream out = this.mFop.newFileOutputStream(dataFile);){
            installProperties.store(out, null);
        }
        return installProperties;
    }

    private void deleteOrphanedTempDirs() {
        Path root = this.mFop.toPath(this.mRepoManager.getLocalPath());
        Path suffixPath = this.mFop.toPath(new File(".installer", INSTALL_DATA_FN));
        try {
            Set<File> tempDirs = Files.walk(root, new FileVisitOption[0]).filter(path2 -> path2.endsWith(suffixPath)).map(this::getPathPropertiesOrNull).filter(Objects::nonNull).map(props -> props.getProperty(PATH_KEY)).map(File::new).collect(Collectors.toSet());
            FileOpUtils.retainTempDirs(tempDirs, TEMP_DIR_PREFIX, this.mFop);
        }
        catch (IOException e) {
            this.mProgress.logWarning("Error while searching for in-use temporary directories.", e);
        }
    }

    private Properties getPathPropertiesOrNull(Path path) {
        try {
            return AbstractPackageOperation.readInstallProperties(path.getParent().getParent());
        }
        catch (IOException e) {
            return null;
        }
    }

    private File writeInstallerMetadata() throws IOException {
        File installPath = this.getLocation(this.mProgress);
        Properties installProperties = this.readOrCreateInstallProperties(installPath);
        File installTempPath = new File((String)installProperties.get(PATH_KEY));
        if (!this.mFop.exists(installPath) && !this.mFop.mkdirs(installPath) || !this.mFop.isDirectory(installPath)) {
            this.mProgress.logWarning("Failed to create output directory: " + installPath);
            return null;
        }
        this.mFop.deleteOnExit(installTempPath);
        return installTempPath;
    }

    @Override
    public RepoManager getRepoManager() {
        return this.mRepoManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void registerStateChangeListener(PackageOperation.StatusChangeListener listener) {
        Object object = this.mStateChangeLock;
        synchronized (object) {
            this.mListeners.add(listener);
        }
    }

    @Override
    public final PackageOperation.InstallStatus getInstallStatus() {
        return this.mInstallStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean updateStatus(PackageOperation.InstallStatus status) {
        ArrayList<PackageOperation.StatusChangeListener> listeners;
        Iterator iterator = this.mStateChangeLock;
        synchronized (iterator) {
            this.mInstallStatus = status;
            listeners = new ArrayList<PackageOperation.StatusChangeListener>(this.mListeners);
        }
        try {
            for (PackageOperation.StatusChangeListener listener : listeners) {
                try {
                    listener.statusChanged(this, this.mProgress);
                }
                catch (Exception e) {
                    if (status == PackageOperation.InstallStatus.FAILED) continue;
                    throw e;
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.mProgress.logError("Failed to update status to " + (Object)((Object)status), e);
            this.updateStatus(PackageOperation.InstallStatus.FAILED);
            return false;
        }
    }

    @Override
    public PackageOperation getFallbackOperation() {
        return this.mFallbackOperation;
    }

    @Override
    public void setFallbackOperation(PackageOperation mFallbackOperation) {
        this.mFallbackOperation = mFallbackOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProgress(ProgressIndicator progress) {
        Object object = this.mProgressLock;
        synchronized (object) {
            if (this.mProgress == null) {
                this.mProgress = new DelegatingProgressIndicator(progress);
            } else {
                this.mProgress.addDelegate(progress);
            }
        }
    }

    private static enum StartTaskStatus {
        STARTED,
        ALREADY_DONE,
        FAILED;

    }
}

