/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public class SchemaModule<T> {
    private final Map<String, SchemaModuleVersion> mVersions = Maps.newHashMap();
    private final SchemaModuleVersion<T> mLatestVersion;
    private final Class mResourceRoot;

    public SchemaModule(String ofPattern, String xsdPattern, Class resourceRoot) {
        if (!ofPattern.matches(".*%[0-9.$]*d.*") || !xsdPattern.matches(".*%[0-9.$]*d.*")) assert (false) : "ofPattern and xsdPattern must contain a single %d parameter";
        SchemaModuleVersion version = null;
        int i = 1;
        while (true) {
            Class<?> objectFactory;
            try {
                objectFactory = Class.forName(String.format(Locale.US, ofPattern, i));
            }
            catch (ClassNotFoundException e) {
                break;
            }
            String xsdLocation = String.format(Locale.US, xsdPattern, i);
            version = new SchemaModuleVersion(objectFactory, xsdLocation);
            this.mVersions.put(version.getNamespace(), version);
            ++i;
        }
        this.mLatestVersion = version;
        assert (!this.mVersions.isEmpty()) : "No versions found";
        this.mResourceRoot = resourceRoot;
    }

    public T createLatestFactory() {
        Class<T> of = this.mLatestVersion.getObjectFactory();
        try {
            return of.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            assert (false) : e;
            return null;
        }
    }

    public Map<String, SchemaModuleVersion> getNamespaceVersionMap() {
        return this.mVersions;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SchemaModule)) {
            return false;
        }
        return this.mVersions.equals(((SchemaModule)obj).getNamespaceVersionMap());
    }

    public int hashCode() {
        return this.mVersions.hashCode();
    }

    public String getNamespacePrefix() {
        return this.mLatestVersion.getNamespacePrefix();
    }

    public String getLatestNamespace() {
        return this.mLatestVersion.getNamespace();
    }

    public class SchemaModuleVersion<R> {
        private final Class<? extends R> mObjectFactory;
        private final String mXsdLocation;
        private final String mNamespace;

        public SchemaModuleVersion(Class<? extends R> objectFactory, String xsdLocation) {
            this.mObjectFactory = objectFactory;
            this.mXsdLocation = xsdLocation;
            String namespace = objectFactory.getPackage().getAnnotation(XmlSchema.class).namespace();
            assert (namespace != null) : "Can't create schema module version with no namespace";
            this.mNamespace = namespace;
        }

        public Class<? extends R> getObjectFactory() {
            return this.mObjectFactory;
        }

        public InputStream getXsd() {
            return SchemaModule.this.mResourceRoot.getResourceAsStream(this.mXsdLocation);
        }

        public String getNamespace() {
            return this.mNamespace;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SchemaModuleVersion)) {
                return false;
            }
            return this.mXsdLocation.equals(((SchemaModuleVersion)obj).mXsdLocation) && this.mNamespace.equals(((SchemaModuleVersion)obj).mNamespace);
        }

        public int hashCode() {
            return this.mXsdLocation.hashCode() * 37 + this.mNamespace.hashCode();
        }

        public String getNamespacePrefix() {
            return this.mNamespace.replaceAll("/[0-9]*$", "/");
        }
    }
}

