/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.testframework;

import com.android.repository.api.ProgressIndicator;
import com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class FakeProgressIndicator
implements ProgressIndicator {
    private List<String> mInfos = Lists.newArrayList();
    private List<String> mWarnings = Lists.newArrayList();
    private List<String> mErrors = Lists.newArrayList();
    private boolean mCancelled = false;
    private boolean mCancellable = true;
    private boolean mIndeterminate = false;
    private double mPercent = 0.0;
    private final boolean mValidateMonotonicProgress;

    public FakeProgressIndicator() {
        this(false);
    }

    public FakeProgressIndicator(boolean validateMonotonicProgress) {
        this.mValidateMonotonicProgress = validateMonotonicProgress;
    }

    @Override
    public void setText(String s) {
    }

    @Override
    public boolean isCanceled() {
        return this.mCancelled;
    }

    @Override
    public void cancel() {
        if (this.mCancellable) {
            this.mCancelled = true;
        }
    }

    @Override
    public void setCancellable(boolean cancellable) {
        this.mCancellable = cancellable;
    }

    @Override
    public boolean isCancellable() {
        return this.mCancellable;
    }

    @Override
    public void setFraction(double v) {
        assert (v >= 0.0 && v <= 1.0);
        assert (!this.mValidateMonotonicProgress || this.mPercent <= v);
        this.mPercent = v;
    }

    @Override
    public double getFraction() {
        return this.mPercent;
    }

    @Override
    public void setSecondaryText(String s) {
    }

    private static String getStackTrace() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        new Throwable().printStackTrace(pw);
        return sw.toString();
    }

    @Override
    public void logWarning(String s) {
        this.mWarnings.add(s);
        this.mWarnings.add(FakeProgressIndicator.getStackTrace());
    }

    @Override
    public void logWarning(String s, Throwable e) {
        this.mWarnings.add(s + "\n" + e.toString());
        this.mWarnings.add(FakeProgressIndicator.getStackTrace());
    }

    @Override
    public void logError(String s) {
        this.mErrors.add(s);
        this.mErrors.add(FakeProgressIndicator.getStackTrace());
    }

    @Override
    public void logError(String s, Throwable e) {
        this.mErrors.add(s + "\n" + e.toString());
        this.mErrors.add(FakeProgressIndicator.getStackTrace());
    }

    @Override
    public void logInfo(String s) {
        this.mInfos.add(s);
    }

    @Override
    public boolean isIndeterminate() {
        return this.mIndeterminate;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.mIndeterminate = indeterminate;
    }

    public List<String> getInfos() {
        return this.mInfos;
    }

    public List<String> getWarnings() {
        return this.mWarnings;
    }

    public List<String> getErrors() {
        return this.mErrors;
    }

    public void assertNoErrorsOrWarnings() {
        this.assertNoErrors();
        if (!this.getWarnings().isEmpty()) {
            throw new Error(this.getWarnings().toString());
        }
    }

    public void assertNoErrors() {
        if (!this.getErrors().isEmpty()) {
            throw new Error(this.getErrors().toString());
        }
    }
}

