/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.manager;

import com.android.ProgressManagerAdapter;
import com.android.io.CancellableFileIo;
import com.android.repository.api.FallbackLocalRepoLoader;
import com.android.repository.api.License;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Repository;
import com.android.repository.impl.manager.LocalRepoLoader;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.LocalPackageImpl;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBException;

public final class LocalRepoLoaderImpl
implements LocalRepoLoader {
    public static final String PACKAGE_XML_FN = "package.xml";
    private static final int MAX_SCAN_DEPTH = 10;
    @VisibleForTesting
    static final String KNOWN_PACKAGES_HASH_FN = ".knownPackages";
    private static final ImmutableSet<String> RESOURCE_CACHE_DIRS = ImmutableSet.of((Object)"fonts", (Object)"icons", (Object)"skins");
    private Map<String, LocalPackage> mPackages = null;
    private Set<Path> mPackageRoots = null;
    private final Path mRoot;
    private final RepoManager mRepoManager;
    private final FallbackLocalRepoLoader mFallback;

    public LocalRepoLoaderImpl(Path root, RepoManager manager, FallbackLocalRepoLoader fallback) {
        this.mRoot = root;
        this.mRepoManager = manager;
        this.mFallback = fallback;
    }

    @Override
    public Map<String, LocalPackage> getPackages(ProgressIndicator progress) {
        if (this.mPackages == null) {
            Set<Path> possiblePackageDirs = this.collectPackages();
            this.mPackages = this.parsePackages(possiblePackageDirs, progress);
            if (!this.mPackages.isEmpty()) {
                this.writeHashFile(this.getLocalPackagesHash());
                progress.logVerbose("SDK Manager found the following installed packages: " + this.mPackages.keySet().stream().sorted().collect(Collectors.joining(" ")));
            }
        }
        return Collections.unmodifiableMap(this.mPackages);
    }

    @Override
    public boolean needsUpdate(long lastLocalRefreshMs, boolean deepCheck) {
        boolean needsUpdate = this.checkKnownPackagesUpdateTime(lastLocalRefreshMs);
        if (!needsUpdate && deepCheck) {
            needsUpdate = this.updateKnownPackageHashFileIfNecessary();
        }
        return needsUpdate;
    }

    private Map<String, LocalPackage> parsePackages(Collection<Path> possiblePackageDirs, ProgressIndicator progress) {
        HashMap result = Maps.newHashMap();
        for (Path packageDir : possiblePackageDirs) {
            Path packageXml = packageDir.resolve(PACKAGE_XML_FN);
            RepoPackage p = null;
            if (CancellableFileIo.exists((Path)packageXml, (LinkOption[])new LinkOption[0])) {
                try {
                    p = this.parsePackage(packageXml, progress);
                }
                catch (Exception e) {
                    ProgressManagerAdapter.throwIfCancellation((Throwable)e);
                    progress.logWarning("Found corrupted package.xml at " + packageXml);
                }
            }
            if ((p == null || p.getDisplayName().startsWith("Unknown")) && this.mFallback != null) {
                p = this.mFallback.parseLegacyLocalPackage(packageDir, progress);
                if (p != null) {
                    this.writePackage((LocalPackage)p, packageXml, progress);
                } else if (CancellableFileIo.exists((Path)packageXml, (LinkOption[])new LinkOption[0])) {
                    progress.logWarning(String.format("Invalid package.xml found at %1$s and failed to parse using fallback.", packageXml));
                }
            }
            if (p == null) continue;
            this.addPackage((LocalPackage)p, result, progress);
        }
        return result;
    }

    private Set<Path> collectPackages() {
        if (this.mPackageRoots == null) {
            TreeSet dirs = Sets.newTreeSet();
            this.collectPackages(dirs, this.mRoot, 0);
            this.mPackageRoots = dirs;
        }
        return this.mPackageRoots;
    }

    private void collectPackages(Collection<Path> collector, Path root, int depth) {
        if (depth > 10) {
            return;
        }
        if (root != this.mRoot && CancellableFileIo.isDirectory((Path)root, (LinkOption[])new LinkOption[0]) && root.getFileName().toString().startsWith(".")) {
            return;
        }
        Path packageXml = root.resolve(PACKAGE_XML_FN);
        if (CancellableFileIo.exists((Path)packageXml, (LinkOption[])new LinkOption[0]) || this.mFallback != null && this.mFallback.shouldParse(root)) {
            collector.add(root);
        } else {
            try (Stream contents = CancellableFileIo.list((Path)root);){
                contents.filter(x$0 -> CancellableFileIo.isDirectory((Path)x$0, (LinkOption[])new LinkOption[0])).filter(Predicates.in(this.resourceCachePaths()).negate()).forEach(f -> this.collectPackages(collector, (Path)f, depth + 1));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void addPackage(LocalPackage p, Map<String, LocalPackage> collector, ProgressIndicator progress) {
        Path actual;
        String filePath = p.getPath().replace(';', File.separatorChar);
        Path desired = this.mRoot.resolve(filePath);
        if (!desired.equals(actual = p.getLocation())) {
            progress.logWarning(String.format("Observed package id '%1$s' in inconsistent location '%2$s' (Expected '%3$s')", p.getPath(), actual, desired));
            LocalPackage existing = collector.get(p.getPath());
            if (existing != null) {
                progress.logWarning(String.format("Already observed package id '%1$s' in '%2$s'. Skipping duplicate at '%3$s'", p.getPath(), existing.getLocation(), actual));
                return;
            }
        }
        collector.put(p.getPath(), p);
    }

    private void writePackage(LocalPackage p, Path packageXml, ProgressIndicator progress) {
        LocalPackageImpl impl = LocalPackageImpl.create(p);
        try (OutputStream fos = Files.newOutputStream(packageXml, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            Repository repo = impl.createFactory().createRepositoryType();
            repo.setLocalPackage(impl);
            License license = impl.getLicense();
            if (license != null) {
                repo.addLicense(license);
            }
            CommonFactory factory = p.createFactory();
            SchemaModuleUtil.marshal(factory.generateRepository(repo), this.mRepoManager.getSchemaModules(), fos, this.mRepoManager.getResourceResolver(progress), progress, false);
        }
        catch (IOException e) {
            progress.logInfo("Exception while marshalling " + packageXml + ". Probably the SDK is read-only");
        }
    }

    private LocalPackage parsePackage(Path packageXml, ProgressIndicator progress) throws JAXBException {
        Repository repo;
        try (InputStream stream = CancellableFileIo.newInputStream((Path)packageXml, (OpenOption[])new OpenOption[0]);){
            repo = (Repository)SchemaModuleUtil.unmarshal(stream, this.mRepoManager.getSchemaModules(), false, progress, packageXml.getFileName().toString());
        }
        catch (IOException e) {
            progress.logError(String.format("XML file %s doesn't exist", packageXml), e);
            return null;
        }
        if (repo == null) {
            progress.logWarning(String.format("Failed to parse %s", packageXml));
            return null;
        }
        LocalPackage p = repo.getLocalPackage();
        if (p == null) {
            progress.logWarning("Didn't find any local package in repository");
            return null;
        }
        p.setInstalledPath(packageXml.getParent());
        return p;
    }

    private Path getKnownPackagesHashFile(boolean create) {
        Path f = this.mRoot.resolve(KNOWN_PACKAGES_HASH_FN);
        if (CancellableFileIo.notExists((Path)f, (LinkOption[])new LinkOption[0])) {
            if (create) {
                try {
                    Files.createDirectories(f.getParent(), new FileAttribute[0]);
                    Files.createFile(f, new FileAttribute[0]);
                }
                catch (IOException e) {
                    return null;
                }
            } else {
                return null;
            }
        }
        return f;
    }

    private boolean updateKnownPackageHashFileIfNecessary() {
        Path knownPackagesHashFile = this.getKnownPackagesHashFile(false);
        if (knownPackagesHashFile != null) {
            byte[] localPackagesHash;
            byte[] buf = null;
            if (this.getLatestPackageUpdateTime() <= this.getLastModifiedTime(knownPackagesHashFile)) {
                try {
                    buf = CancellableFileIo.readAllBytes((Path)knownPackagesHashFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!Arrays.equals(buf, localPackagesHash = this.getLocalPackagesHash())) {
                this.writeHashFile(localPackagesHash);
                return true;
            }
        } else {
            this.writeHashFile(this.getLocalPackagesHash());
            return true;
        }
        return false;
    }

    private long getLastModifiedTime(Path file) {
        long knownPackagesModificationTime;
        try {
            knownPackagesModificationTime = CancellableFileIo.getLastModifiedTime((Path)file, (LinkOption[])new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            knownPackagesModificationTime = 0L;
        }
        return knownPackagesModificationTime;
    }

    private void writeHashFile(byte[] buf) {
        Path knownPackagesHashFile = this.getKnownPackagesHashFile(true);
        if (knownPackagesHashFile != null) {
            try {
                Files.write(knownPackagesHashFile, buf, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean checkKnownPackagesUpdateTime(long lastUpdate) {
        Path knownPackagesHashFile = this.getKnownPackagesHashFile(false);
        return knownPackagesHashFile == null || this.getLastModifiedTime(knownPackagesHashFile) > lastUpdate;
    }

    private byte[] getLocalPackagesHash() {
        Set<Path> dirs = this.collectPackages();
        Hasher digester = Hashing.md5().newHasher();
        for (Path f : dirs) {
            digester.putBytes(f.toAbsolutePath().toString().getBytes(StandardCharsets.UTF_8));
        }
        return digester.hash().asBytes();
    }

    private long getLatestPackageUpdateTime() {
        long latest = 0L;
        for (Path f : this.collectPackages()) {
            long t = this.getLastModifiedTime(f.resolve(PACKAGE_XML_FN));
            latest = Math.max(t, latest);
        }
        return latest;
    }

    private ImmutableSet<Path> resourceCachePaths() {
        return (ImmutableSet)RESOURCE_CACHE_DIRS.stream().map(this.mRoot::resolve).collect(ImmutableSet.toImmutableSet());
    }
}

