/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.process;

import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.ide.common.process.ProcessResultImpl;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultProcessExecutor
implements ProcessExecutor {
    private final ILogger mLogger;

    public DefaultProcessExecutor(ILogger logger) {
        this.mLogger = logger;
    }

    @Override
    public ListenableFuture<ProcessResult> submit(ProcessInfo processInfo, final ProcessOutputHandler processOutputHandler) {
        final List<String> command = DefaultProcessExecutor.buildCommand(processInfo);
        this.mLogger.info("command: " + Joiner.on((char)' ').join(command), new Object[0]);
        final SettableFuture result = SettableFuture.create();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(DefaultProcessExecutor.buildCommand(processInfo));
            Map<String, Object> envVariableMap = processInfo.getEnvironment();
            if (!envVariableMap.isEmpty()) {
                Map<String, String> env = processBuilder.environment();
                for (Map.Entry<String, Object> entry : envVariableMap.entrySet()) {
                    env.put(entry.getKey(), entry.getValue().toString());
                }
            }
            Process process = processBuilder.start();
            final ProcessOutput output = processOutputHandler.createOutput();
            ListenableFuture<Integer> outputFuture = DefaultProcessExecutor.grabProcessOutput(process, output);
            Futures.addCallback(outputFuture, (FutureCallback)new FutureCallback<Integer>(){

                public void onSuccess(Integer exit) {
                    try {
                        output.close();
                        processOutputHandler.handleOutput(output);
                        result.set((Object)new ProcessResultImpl((List<String>)command, exit));
                    }
                    catch (Exception e) {
                        result.set((Object)new ProcessResultImpl((List<String>)command, e));
                    }
                }

                public void onFailure(Throwable t) {
                    result.set((Object)new ProcessResultImpl((List<String>)command, t));
                }
            });
        }
        catch (Exception e) {
            result.set((Object)new ProcessResultImpl(command, e));
        }
        return result;
    }

    @Override
    public ProcessResult execute(ProcessInfo processInfo, ProcessOutputHandler processOutputHandler) {
        try {
            return (ProcessResult)this.submit(processInfo, processOutputHandler).get();
        }
        catch (Exception e) {
            return new ProcessResultImpl(DefaultProcessExecutor.buildCommand(processInfo), e);
        }
    }

    private static ListenableFuture<Integer> grabProcessOutput(final Process process, final ProcessOutput output) {
        final SettableFuture result = SettableFuture.create();
        final AtomicReference exceptionHolder = new AtomicReference();
        final Thread threadErr = new Thread("stderr"){

            @Override
            public void run() {
                InputStream stderr = process.getErrorStream();
                OutputStream stream = output.getErrorOutput();
                try {
                    ByteStreams.copy((InputStream)stderr, (OutputStream)stream);
                    stream.flush();
                }
                catch (IOException e) {
                    exceptionHolder.compareAndSet(null, e);
                }
            }
        };
        Thread threadOut = new Thread("stdout"){

            @Override
            public void run() {
                InputStream stdout = process.getInputStream();
                OutputStream stream = output.getStandardOutput();
                try {
                    ByteStreams.copy((InputStream)stdout, (OutputStream)stream);
                    stream.flush();
                }
                catch (Exception e) {
                    exceptionHolder.compareAndSet(null, e);
                }
                try {
                    threadErr.join();
                    int processResult = process.waitFor();
                    if (exceptionHolder.get() != null) {
                        result.setException((Throwable)exceptionHolder.get());
                    }
                    result.set((Object)processResult);
                    output.close();
                }
                catch (Exception e) {
                    result.setException((Throwable)e);
                }
            }
        };
        threadErr.start();
        threadOut.start();
        return result;
    }

    private static List<String> buildCommand(ProcessInfo processInfo) {
        ArrayList command = Lists.newArrayList();
        command.add(processInfo.getExecutable());
        command.addAll(processInfo.getArgs());
        return command;
    }
}

