/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.fonts;

import com.android.ide.common.fonts.DirectoryHandlerKt;
import com.android.ide.common.fonts.FontDetailKt;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontFamilyKt;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.FontSource;
import com.android.ide.common.fonts.MutableFontDetail;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\rJ(\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0017R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/ide/common/fonts/DirectoryHandler;", "Lorg/xml/sax/helpers/DefaultHandler;", "provider", "Lcom/android/ide/common/fonts/FontProvider;", "(Lcom/android/ide/common/fonts/FontProvider;)V", "fontDetails", "Ljava/util/ArrayList;", "Lcom/android/ide/common/fonts/MutableFontDetail;", "fontFamilies", "Lcom/android/ide/common/fonts/FontFamily;", "getFontFamilies", "()Ljava/util/ArrayList;", "fontMenu", "", "fontMenuName", "fontName", "addProtocol", "url", "endElement", "", "uri", "localName", "name", "parseInt", "", "intAsString", "defaultValue", "parseItalics", "", "italics", "startElement", "attributes", "Lorg/xml/sax/Attributes;", "sdk-common_main"})
public final class DirectoryHandler
extends DefaultHandler {
    private final ArrayList<MutableFontDetail> fontDetails;
    private String fontName;
    private String fontMenu;
    private String fontMenuName;
    @NotNull
    private final ArrayList<FontFamily> fontFamilies;
    private final FontProvider provider;

    @NotNull
    public final ArrayList<FontFamily> getFontFamilies() {
        return this.fontFamilies;
    }

    @Override
    public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String name, @NotNull Attributes attributes) throws SAXException {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)localName, (String)"localName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        String string = name;
        if (Intrinsics.areEqual((Object)string, (Object)DirectoryHandlerKt.access$getFAMILY$p())) {
            String string2 = attributes.getValue(DirectoryHandlerKt.access$getATTR_FONT_NAME$p());
            if (string2 == null) {
                string2 = "";
            }
            this.fontName = string2;
            this.fontMenu = this.addProtocol(attributes.getValue(DirectoryHandlerKt.access$getATTR_MENU$p()));
            String string3 = attributes.getValue(DirectoryHandlerKt.access$getATTR_MENU_NAME$p());
            if (string3 == null) {
                string3 = "";
            }
            this.fontMenuName = string3;
        } else if (Intrinsics.areEqual((Object)string, (Object)DirectoryHandlerKt.access$getFONT$p())) {
            MutableFontDetail font = new MutableFontDetail();
            font.setWeight(this.parseInt(attributes.getValue(DirectoryHandlerKt.access$getATTR_WEIGHT$p()), FontDetailKt.DEFAULT_WEIGHT));
            font.setWidth(this.parseInt(attributes.getValue(DirectoryHandlerKt.access$getATTR_WIDTH$p()), FontDetailKt.DEFAULT_WIDTH));
            font.setItalics(this.parseItalics(attributes.getValue(DirectoryHandlerKt.access$getATTR_ITALIC$p())));
            font.setFontUrl(this.addProtocol(attributes.getValue(DirectoryHandlerKt.access$getATTR_FONT_URL$p())));
            String string4 = attributes.getValue(DirectoryHandlerKt.access$getATTR_STYLE_NAME$p());
            if (string4 == null) {
                string4 = "";
            }
            font.setStyleName(string4);
            if (font.getWeight() > 0 && font.getWidth() > 0) {
                CharSequence charSequence = font.getFontUrl();
                if (charSequence.length() > 0) {
                    this.fontDetails.add(font);
                }
            }
        }
    }

    @Override
    public void endElement(@NotNull String uri, @NotNull String localName, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)localName, (String)"localName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (Intrinsics.areEqual((Object)name, (Object)DirectoryHandlerKt.access$getFAMILY$p())) {
            CharSequence charSequence = this.fontName;
            if (charSequence.length() > 0) {
                charSequence = this.fontMenu;
                if (charSequence.length() > 0) {
                    this.fontFamilies.add(new FontFamily(this.provider, FontSource.DOWNLOADABLE, this.fontName, this.fontMenu, this.fontMenuName, (List<MutableFontDetail>)this.fontDetails));
                }
            }
            this.fontDetails.clear();
        }
    }

    private final int parseInt(String intAsString, int defaultValue) {
        if (intAsString == null) {
            return defaultValue;
        }
        try {
            return Math.round(Float.parseFloat(intAsString));
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public final boolean parseItalics(@Nullable String italics) {
        return italics != null && StringsKt.startsWith$default((String)italics, (String)"1", (boolean)false, (int)2, null);
    }

    private final String addProtocol(String url) {
        if (url == null) {
            return "";
        }
        if (StringsKt.startsWith$default((String)url, (String)"//", (boolean)false, (int)2, null)) {
            String string = url;
            int n = 2;
            StringBuilder stringBuilder = new StringBuilder().append(FontFamilyKt.HTTPS_PROTOCOL_START);
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String string4 = string3;
            return stringBuilder.append(string4).toString();
        }
        return url;
    }

    public DirectoryHandler(@NotNull FontProvider provider) {
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        this.provider = provider;
        this.fontDetails = new ArrayList();
        this.fontName = "";
        this.fontMenu = "";
        this.fontMenuName = "";
        this.fontFamilies = new ArrayList();
    }
}

