/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.sampledata;

import com.android.ide.common.resources.sampledata.CSVReader;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;

public class SampleDataCsvParser {
    private final ImmutableMultimap<String, String> myTable;

    private SampleDataCsvParser(ImmutableMultimap<String, String> table) {
        this.myTable = table;
    }

    public static SampleDataCsvParser parse(FileReader reader) throws IOException {
        String[] values;
        CSVReader csvReader = new CSVReader(reader);
        String[] headers = csvReader.readNext();
        ImmutableMultimap.Builder mapBuilder = ImmutableMultimap.builder();
        while ((values = csvReader.readNext()) != null) {
            for (int i = 0; i < headers.length && i < values.length; ++i) {
                mapBuilder.put((Object)("/" + headers[i]), (Object)values[i]);
            }
        }
        return new SampleDataCsvParser((ImmutableMultimap<String, String>)mapBuilder.build());
    }

    public Set<String> getPossiblePaths() {
        return this.myTable.keySet();
    }

    public ImmutableCollection<String> getPath(String path) {
        return this.myTable.get((Object)path);
    }
}

