/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmakeOutputParser
implements PatternAwareOutputParser {
    private static final String CMAKE_ERROR = "CMake Error";
    private static final String CMAKE_WARNING = "CMake Warning";
    private static final String ERROR = "Error";
    private final Pattern fileAndLineNumber = Pattern.compile("^(.*):([0-9]+)? *:([0-9]+)?");
    private final Pattern errorFileAndLineNumber = Pattern.compile("CMake (Error|Warning).*at ([^:]+):([0-9]+)?.*(\\([^:]*\\))?:([0-9]+)?");

    @Override
    public boolean parse(String line, OutputLineReader reader, List<Message> messages, ILogger logger) throws ParsingFailedException {
        return this.matchesErrorFileAndLineNumberError(line, messages) || this.matchesFileAndLineNumberError(line, messages);
    }

    private boolean matchesFileAndLineNumberError(String line, List<Message> messages) {
        Matcher matcher = this.fileAndLineNumber.matcher(line);
        if (matcher.matches()) {
            File file = new File(matcher.group(1));
            if (!file.isAbsolute()) {
                return false;
            }
            Message.Kind kind = Message.Kind.WARNING;
            for (Message m : messages) {
                if (m.getText().startsWith(CMAKE_ERROR)) {
                    kind = Message.Kind.ERROR;
                    continue;
                }
                if (!m.getText().startsWith(CMAKE_WARNING)) continue;
                kind = Message.Kind.WARNING;
            }
            int lineNumber = -1;
            if (matcher.group(2) != null) {
                lineNumber = Integer.valueOf(matcher.group(2));
            }
            int columnNumber = -1;
            if (matcher.group(3) != null) {
                columnNumber = Integer.valueOf(matcher.group(3));
            }
            SourceFilePosition position = new SourceFilePosition(file, new SourcePosition(lineNumber, columnNumber, -1));
            Message message = new Message(kind, line, position, new SourceFilePosition[0]);
            messages.add(new Message(Message.Kind.SIMPLE, line, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]));
            messages.add(message);
            return true;
        }
        return false;
    }

    private boolean matchesErrorFileAndLineNumberError(String line, List<Message> messages) {
        Matcher matcher = this.errorFileAndLineNumber.matcher(line);
        if (matcher.matches()) {
            File file = new File(matcher.group(2));
            if (!file.isAbsolute()) {
                return false;
            }
            Message.Kind kind = Message.Kind.WARNING;
            if (matcher.group(1).equals(ERROR)) {
                kind = Message.Kind.ERROR;
            }
            int lineNumber = -1;
            if (matcher.group(3) != null) {
                lineNumber = Integer.valueOf(matcher.group(3));
            }
            String reason = line;
            if (matcher.group(4) != null) {
                reason = matcher.group(4);
            }
            int columnNumber = -1;
            if (matcher.group(5) != null) {
                columnNumber = Integer.valueOf(matcher.group(5));
            }
            SourceFilePosition position = new SourceFilePosition(file, new SourcePosition(lineNumber, columnNumber, -1));
            Message message = new Message(kind, reason, position, new SourceFilePosition[0]);
            messages.add(new Message(Message.Kind.SIMPLE, line, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]));
            messages.add(message);
            return true;
        }
        return false;
    }
}

