/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.symbols.Symbol;
import com.android.builder.symbols.SymbolTable;
import com.android.resources.ResourceType;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\b'\u0018\u0000 \u00132\u00020\u0001:\u0003\u0012\u0013\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0006R$\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/android/builder/symbols/SymbolTable;", "", "()V", "symbols", "Lcom/google/common/collect/ImmutableTable;", "Lcom/android/resources/ResourceType;", "", "Lcom/android/builder/symbols/Symbol;", "getSymbols", "()Lcom/google/common/collect/ImmutableTable;", "tablePackage", "getTablePackage", "()Ljava/lang/String;", "filter", "table", "merge", "m", "rename", "Builder", "Companion", "SymbolTableImpl", "sdk-common_main"})
public abstract class SymbolTable {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract String getTablePackage();

    @NotNull
    public abstract ImmutableTable<ResourceType, String, Symbol> getSymbols();

    @NotNull
    public final SymbolTable filter(@NotNull SymbolTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (ResourceType resourceType : this.getSymbols().rowKeySet()) {
            ImmutableCollection symbols2 = (ImmutableCollection)this.getSymbols().row((Object)resourceType).values();
            ImmutableSet filteringSymbolNames = (ImmutableSet)table.getSymbols().row((Object)resourceType).keySet();
            for (Symbol symbol : symbols2) {
                if (!filteringSymbolNames.contains((Object)symbol.getName())) continue;
                builder.put((Object)resourceType, (Object)symbol.getName(), (Object)symbol);
            }
        }
        String string = this.getTablePackage();
        ImmutableTable immutableTable = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableTable, (String)"builder.build()");
        return new SymbolTableImpl(string, (ImmutableTable<ResourceType, String, Symbol>)immutableTable);
    }

    @NotNull
    public final SymbolTable merge(@NotNull SymbolTable m) {
        Intrinsics.checkParameterIsNotNull((Object)m, (String)"m");
        List<SymbolTable> list = Arrays.asList(this, m);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(this, m)");
        return Companion.merge(list);
    }

    @NotNull
    public final SymbolTable rename(@NotNull String tablePackage) {
        Intrinsics.checkParameterIsNotNull((Object)tablePackage, (String)"tablePackage");
        return new SymbolTableImpl(tablePackage, this.getSymbols());
    }

    private SymbolTable() {
    }

    public /* synthetic */ SymbolTable(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @NotNull
    public static final SymbolTable merge(@NotNull List<? extends SymbolTable> tables) {
        Intrinsics.checkParameterIsNotNull(tables, (String)"tables");
        return Companion.merge(tables);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J/\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R&\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/android/builder/symbols/SymbolTable$SymbolTableImpl;", "Lcom/android/builder/symbols/SymbolTable;", "tablePackage", "", "symbols", "Lcom/google/common/collect/ImmutableTable;", "Lcom/android/resources/ResourceType;", "Lcom/android/builder/symbols/Symbol;", "(Ljava/lang/String;Lcom/google/common/collect/ImmutableTable;)V", "getSymbols", "()Lcom/google/common/collect/ImmutableTable;", "getTablePackage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "sdk-common_main"})
    private static final class SymbolTableImpl
    extends SymbolTable {
        @NotNull
        private final String tablePackage;
        @NotNull
        private final ImmutableTable<ResourceType, String, Symbol> symbols;

        @Override
        @NotNull
        public String getTablePackage() {
            return this.tablePackage;
        }

        @Override
        @NotNull
        public ImmutableTable<ResourceType, String, Symbol> getSymbols() {
            return this.symbols;
        }

        public SymbolTableImpl(@NotNull String tablePackage, @NotNull ImmutableTable<ResourceType, String, Symbol> symbols2) {
            Intrinsics.checkParameterIsNotNull((Object)tablePackage, (String)"tablePackage");
            Intrinsics.checkParameterIsNotNull(symbols2, (String)"symbols");
            super(null);
            this.tablePackage = tablePackage;
            this.symbols = symbols2;
        }

        @NotNull
        public final String component1() {
            return this.getTablePackage();
        }

        @NotNull
        public final ImmutableTable<ResourceType, String, Symbol> component2() {
            return this.getSymbols();
        }

        @NotNull
        public final SymbolTableImpl copy(@NotNull String tablePackage, @NotNull ImmutableTable<ResourceType, String, Symbol> symbols2) {
            Intrinsics.checkParameterIsNotNull((Object)tablePackage, (String)"tablePackage");
            Intrinsics.checkParameterIsNotNull(symbols2, (String)"symbols");
            return new SymbolTableImpl(tablePackage, symbols2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ SymbolTableImpl copy$default(SymbolTableImpl symbolTableImpl, String string, ImmutableTable immutableTable, int n, Object object) {
            if ((n & 1) != 0) {
                string = symbolTableImpl.getTablePackage();
            }
            if ((n & 2) != 0) {
                immutableTable = symbolTableImpl.getSymbols();
            }
            return symbolTableImpl.copy(string, immutableTable);
        }

        public String toString() {
            return "SymbolTableImpl(tablePackage=" + this.getTablePackage() + ", symbols=" + this.getSymbols() + ")";
        }

        public int hashCode() {
            String string = this.getTablePackage();
            ImmutableTable<ResourceType, String, Symbol> immutableTable = this.getSymbols();
            return (string != null ? string.hashCode() : 0) * 31 + (immutableTable != null ? immutableTable.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SymbolTableImpl)) break block3;
                    SymbolTableImpl symbolTableImpl = (SymbolTableImpl)object;
                    if (!Intrinsics.areEqual((Object)this.getTablePackage(), (Object)symbolTableImpl.getTablePackage()) || !Intrinsics.areEqual(this.getSymbols(), symbolTableImpl.getSymbols())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0007J\u0014\u0010\u000b\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0007H\u0086\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0006J\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0086\u0002J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0006R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/builder/symbols/SymbolTable$Builder;", "", "()V", "symbols", "Lcom/google/common/collect/Table;", "Lcom/android/resources/ResourceType;", "", "Lcom/android/builder/symbols/Symbol;", "tablePackage", "add", "symbol", "addAll", "", "build", "Lcom/android/builder/symbols/SymbolTable;", "contains", "", "resourceType", "name", "get", "sdk-common_main"})
    public static final class Builder {
        private String tablePackage = "";
        private final Table<ResourceType, String, Symbol> symbols;

        @NotNull
        public final Builder add(@NotNull Symbol symbol) {
            Intrinsics.checkParameterIsNotNull((Object)symbol, (String)"symbol");
            if (this.symbols.contains((Object)symbol.getResourceType(), (Object)symbol.getName())) {
                throw (Throwable)new IllegalArgumentException("Duplicate symbol in table with resource type '" + symbol.getResourceType() + "' " + ("and symbol name '" + symbol.getName() + "'"));
            }
            this.symbols.put((Object)symbol.getResourceType(), (Object)symbol.getName(), (Object)symbol);
            return this;
        }

        @NotNull
        public final Builder addAll(@NotNull Collection<? extends Symbol> symbols2) {
            Intrinsics.checkParameterIsNotNull(symbols2, (String)"symbols");
            Iterable $receiver$iv = symbols2;
            for (Object element$iv : $receiver$iv) {
                Symbol it = (Symbol)element$iv;
                this.add(it);
            }
            return this;
        }

        @NotNull
        public final Builder tablePackage(@NotNull String tablePackage) {
            Intrinsics.checkParameterIsNotNull((Object)tablePackage, (String)"tablePackage");
            CharSequence charSequence = tablePackage;
            if (!(charSequence.length() == 0) && !SourceVersion.isName(tablePackage)) {
                for (String segment : Splitter.on((char)'.').split((CharSequence)tablePackage)) {
                    if (!SourceVersion.isIdentifier(segment)) {
                        throw (Throwable)new IllegalArgumentException("Package '" + tablePackage + "' from AndroidManifest.xml is not a valid " + ("Java package name as '" + segment + "' is not a valid Java ") + "identifier.");
                    }
                    if (!SourceVersion.isKeyword(segment)) continue;
                    throw (Throwable)new IllegalArgumentException("Package '" + tablePackage + "' from AndroidManifest.xml is not a valid " + ("Java package name as '" + segment + "' is a Java keyword."));
                }
                throw (Throwable)new IllegalArgumentException("Package '" + tablePackage + "' from AndroidManifest.xml is not a valid Java " + "package name.");
            }
            this.tablePackage = tablePackage;
            return this;
        }

        public final boolean contains(@NotNull Symbol symbol) {
            Intrinsics.checkParameterIsNotNull((Object)symbol, (String)"symbol");
            return this.contains(symbol.getResourceType(), symbol.getName());
        }

        public final boolean contains(@NotNull ResourceType resourceType, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return this.symbols.contains((Object)resourceType, (Object)name);
        }

        @Nullable
        public final Symbol get(@NotNull Symbol symbol) {
            Intrinsics.checkParameterIsNotNull((Object)symbol, (String)"symbol");
            return (Symbol)this.symbols.get((Object)symbol.getResourceType(), (Object)symbol.getName());
        }

        @NotNull
        public final SymbolTable build() {
            ImmutableTable immutableTable = ImmutableTable.copyOf(this.symbols);
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableTable, (String)"ImmutableTable.copyOf(symbols)");
            return new SymbolTableImpl(this.tablePackage, (ImmutableTable<ResourceType, String, Symbol>)immutableTable);
        }

        public Builder() {
            Table table = Tables.newCustomTable((Map)Maps.newEnumMap(ResourceType.class), (Supplier)symbols.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)table, (String)"Tables.newCustomTable(\n \u2026           { HashMap() })");
            this.symbols = table;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/android/builder/symbols/SymbolTable$Companion;", "", "()V", "builder", "Lcom/android/builder/symbols/SymbolTable$Builder;", "merge", "Lcom/android/builder/symbols/SymbolTable;", "tables", "", "sdk-common_main"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SymbolTable merge(@NotNull List<? extends SymbolTable> tables) {
            Intrinsics.checkParameterIsNotNull(tables, (String)"tables");
            ImmutableTable.Builder builder = ImmutableTable.builder();
            HashSet<String> present = new HashSet<String>();
            ResourceType[] resourceTypeArray = ResourceType.values();
            for (int i = 0; i < resourceTypeArray.length; ++i) {
                ResourceType resourceType = resourceTypeArray[i];
                present.clear();
                for (SymbolTable symbolTable : tables) {
                    ImmutableMap tableSymbolMap = symbolTable.getSymbols().row((Object)resourceType);
                    if (tableSymbolMap == null || tableSymbolMap.isEmpty()) continue;
                    for (Symbol s : (ImmutableCollection)tableSymbolMap.values()) {
                        String name = s.getName();
                        if (present.contains(name)) continue;
                        present.add(name);
                        builder.put((Object)resourceType, (Object)name, (Object)s);
                    }
                }
            }
            String packageName = tables.isEmpty() ? "" : tables.get(0).getTablePackage();
            ImmutableTable immutableTable = builder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableTable, (String)"builder.build()");
            return new SymbolTableImpl(packageName, (ImmutableTable<ResourceType, String, Symbol>)immutableTable);
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

