/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.internal;

import com.android.utils.JvmWideVariable;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExecutorSingleton {
    private static final JvmWideVariable<ExecutorService> sExecutorService = new JvmWideVariable(ExecutorSingleton.class, "sExecutorService", ExecutorService.class, null);
    private static final JvmWideVariable<Integer> sThreadPoolSize = new JvmWideVariable(ExecutorSingleton.class, "sThreadPoolSize", Integer.class, (Object)Runtime.getRuntime().availableProcessors());

    public static ExecutorService getExecutor() {
        return (ExecutorService)sExecutorService.executeSupplierSynchronously(() -> {
            if (sExecutorService.get() == null) {
                sExecutorService.set((Object)Executors.newFixedThreadPool((Integer)sThreadPoolSize.get()));
            }
            return (ExecutorService)sExecutorService.get();
        });
    }

    public static void shutdown() {
        sExecutorService.executeRunnableSynchronously(() -> {
            if (sExecutorService.get() != null) {
                ((ExecutorService)sExecutorService.get()).shutdown();
                sExecutorService.set(null);
            }
        });
    }

    public static void setThreadPoolSize(int threadPoolSize) {
        sExecutorService.executeRunnableSynchronously(() -> sThreadPoolSize.set((Object)threadPoolSize));
    }

    static int getThreadPoolSize() {
        return (Integer)Objects.requireNonNull(sThreadPoolSize.get());
    }
}

