/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.GradientStop;
import com.android.ide.common.vectordrawable.PathParser;
import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.SvgGroupNode;
import com.android.ide.common.vectordrawable.SvgLeafNode;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import com.android.ide.common.vectordrawable.VdNodeRender;
import com.android.ide.common.vectordrawable.VdPath;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableMap;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class SvgGradientNode
extends SvgNode {
    private static final Logger logger = Logger.getLogger(SvgGroupNode.class.getSimpleName());
    private final ArrayList<GradientStop> myGradientStops = new ArrayList();
    private SvgLeafNode mSvgLeafNode;
    private Rectangle2D boundingBox;
    private GradientUsage mGradientUsage;
    private static final ImmutableMap<String, Integer> vectorCoordinateMap = ImmutableMap.builder().put((Object)"x1", (Object)0).put((Object)"y1", (Object)1).put((Object)"x2", (Object)2).put((Object)"y2", (Object)3).build();

    public SvgGradientNode(SvgTree svgTree, Node node, String nodeName) {
        super(svgTree, node, nodeName);
    }

    @Override
    public SvgGradientNode deepCopy() {
        SvgGradientNode newInstance = new SvgGradientNode(this.getTree(), this.getDocumentNode(), this.getName());
        this.copyTo(newInstance);
        return newInstance;
    }

    @Override
    public boolean isGroupNode() {
        return false;
    }

    protected void copyTo(SvgGradientNode newInstance) {
        super.copyTo(newInstance);
        for (GradientStop g : this.myGradientStops) {
            newInstance.addGradientStop(g.getColor(), g.getOffset(), g.getOpacity());
        }
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + "current gradient is :" + this.getName());
    }

    @Override
    public void transformIfNeeded(AffineTransform rootTransform) {
        AffineTransform finalTransform = new AffineTransform(rootTransform);
        finalTransform.concatenate(this.mStackedTransform);
    }

    @Override
    public void flatten(AffineTransform transform) {
        this.mStackedTransform.setTransform(transform);
        this.mStackedTransform.concatenate(this.mLocalTransform);
    }

    private GradientCoordResult getGradientCoordinate(String x, double defaultValue) {
        boolean isPercentage = false;
        if (!this.mVdAttributesMap.containsKey(x)) {
            return new GradientCoordResult(defaultValue, isPercentage);
        }
        double val = defaultValue;
        String vdValue = ((String)this.mVdAttributesMap.get(x)).trim();
        if (x.equals("r") && vdValue.startsWith("-")) {
            return new GradientCoordResult(defaultValue, isPercentage);
        }
        if (vdValue.endsWith("%")) {
            isPercentage = true;
            try {
                val = Double.parseDouble(vdValue.substring(0, vdValue.length() - 1));
            }
            catch (NumberFormatException e) {
                this.getTree().logErrorLine("Unsupported coordinate percentage value", this.getDocumentNode(), SvgTree.SvgLogLevel.ERROR);
            }
            val /= 100.0;
        } else {
            try {
                val = Double.parseDouble(vdValue);
            }
            catch (NumberFormatException e) {
                this.getTree().logErrorLine("Unsupported coordinate value", this.getDocumentNode(), SvgTree.SvgLogLevel.ERROR);
            }
        }
        return new GradientCoordResult(val, isPercentage);
    }

    @Override
    public void writeXML(OutputStreamWriter writer, boolean inClipPath) throws IOException {
        double[] transformedBounds;
        double[] gradientBounds;
        if (this.myGradientStops.isEmpty()) {
            this.getTree().logErrorLine("Gradient has no stop info.", this.getDocumentNode(), SvgTree.SvgLogLevel.ERROR);
            return;
        }
        if (this.mGradientUsage == GradientUsage.FILL) {
            writer.write("        <aapt:attr name=\"android:fillColor\">");
            writer.write(System.lineSeparator());
        } else {
            writer.write("        <aapt:attr name=\"android:strokeColor\">");
            writer.write(System.lineSeparator());
        }
        writer.write("<gradient ");
        this.setBoundingBox();
        double height = this.boundingBox.getHeight();
        double width = this.boundingBox.getWidth();
        double startX = this.boundingBox.getX();
        double startY = this.boundingBox.getY();
        String gradientUnit = (String)this.mVdAttributesMap.get("gradientUnits");
        boolean isUserSpaceOnUse = "userSpaceOnUse".equals(gradientUnit);
        if (isUserSpaceOnUse) {
            startX = 0.0;
            startY = 0.0;
            height = this.getTree().getHeight();
            width = this.getTree().getWidth();
        }
        AffineTransform identity = new AffineTransform();
        if (this.mVdAttributesMap.containsKey("gradientTransform")) {
            String transformValue = (String)this.mVdAttributesMap.get("gradientTransform");
            this.parseLocalTransform(transformValue);
            if (!isUserSpaceOnUse) {
                identity.scale(1.0 / width, 1.0 / height);
                this.mLocalTransform.concatenate(identity);
                identity.setToIdentity();
                identity.scale(width, height);
                this.mLocalTransform.preConcatenate(identity);
            }
        }
        if (isUserSpaceOnUse) {
            this.mLocalTransform.preConcatenate(this.mSvgLeafNode.mStackedTransform);
        }
        String gradientType = "linear";
        if (this.mVdAttributesMap.containsKey("gradientType")) {
            gradientType = (String)this.mVdAttributesMap.get("gradientType");
        }
        if (gradientType.equals("linear")) {
            gradientBounds = new double[4];
            transformedBounds = new double[4];
            for (Map.Entry entry : vectorCoordinateMap.entrySet()) {
                String s = (String)entry.getKey();
                int index = (Integer)entry.getValue();
                double defaultValue = 0.0;
                if (index == 2) {
                    defaultValue = 1.0;
                }
                GradientCoordResult result = this.getGradientCoordinate(s, defaultValue);
                double coordValue = result.getValue();
                if (!isUserSpaceOnUse || result.isPercentage()) {
                    coordValue = index % 2 == 0 ? coordValue * width + startX : coordValue * height + startY;
                }
                gradientBounds[index] = coordValue;
                transformedBounds[index] = coordValue;
                if (this.mVdAttributesMap.containsKey(s)) continue;
                this.mVdAttributesMap.put(s, "");
            }
            this.mLocalTransform.transform(gradientBounds, 0, transformedBounds, 0, 2);
        } else {
            gradientBounds = new double[2];
            transformedBounds = new double[2];
            GradientCoordResult cxResult = this.getGradientCoordinate("cx", 0.5);
            double cx = cxResult.getValue();
            if (!isUserSpaceOnUse || cxResult.isPercentage()) {
                cx = width * cx + startX;
            }
            GradientCoordResult cyResult = this.getGradientCoordinate("cy", 0.5);
            double cy = cyResult.getValue();
            if (!isUserSpaceOnUse || cyResult.isPercentage()) {
                cy = height * cy + startY;
            }
            GradientCoordResult rResult = this.getGradientCoordinate("r", 0.5);
            double r = rResult.getValue();
            if (!isUserSpaceOnUse || rResult.isPercentage()) {
                r *= Math.max(height, width);
            }
            gradientBounds[0] = cx;
            transformedBounds[0] = cx;
            gradientBounds[1] = cy;
            transformedBounds[1] = cy;
            this.mLocalTransform.transform(gradientBounds, 0, transformedBounds, 0, 1);
            Point2D.Double radius = new Point2D.Double(r, 0.0);
            Point2D.Double transformedRadius = new Point2D.Double(r, 0.0);
            this.mLocalTransform.deltaTransform(radius, transformedRadius);
            this.mVdAttributesMap.put("cx", XmlUtils.formatFloatAttribute((double)transformedBounds[0]));
            this.mVdAttributesMap.put("cy", XmlUtils.formatFloatAttribute((double)transformedBounds[1]));
            this.mVdAttributesMap.put("r", XmlUtils.formatFloatAttribute((double)transformedRadius.distance(0.0, 0.0)));
        }
        for (String key : this.mVdAttributesMap.keySet()) {
            String gradientAttr = (String)Svg2Vector.gradientMap.get((Object)key);
            String svgValue = (String)this.mVdAttributesMap.get(key);
            String vdValue = svgValue.trim();
            if (vdValue.startsWith("rgb")) {
                String vdValueRGB = vdValue = vdValue.substring(3, vdValue.length());
                if ((vdValue = SvgLeafNode.convertRGBToHex(vdValue.substring(3, vdValue.length()))) == null) {
                    this.getTree().logErrorLine("Unsupported Color format " + vdValueRGB, this.getDocumentNode(), SvgTree.SvgLogLevel.ERROR);
                }
            } else if (SvgLeafNode.colorMap.containsKey((Object)vdValue.toLowerCase(Locale.ENGLISH))) {
                vdValue = (String)SvgLeafNode.colorMap.get((Object)vdValue.toLowerCase(Locale.ENGLISH));
            } else if (vectorCoordinateMap.containsKey((Object)key)) {
                double x = transformedBounds[(Integer)vectorCoordinateMap.get((Object)key)];
                vdValue = XmlUtils.formatFloatAttribute((double)x);
            } else if (key.equals("spreadMethod")) {
                if (vdValue.equals("pad")) {
                    vdValue = "clamp";
                } else if (vdValue.equals("reflect")) {
                    vdValue = "mirror";
                }
            } else if (vdValue.endsWith("%")) {
                vdValue = XmlUtils.formatFloatAttribute((double)this.getGradientCoordinate(key, 0.0).getValue());
            }
            if (gradientAttr.isEmpty()) continue;
            writer.write(System.lineSeparator());
            writer.write("        " + gradientAttr + "=\"" + vdValue + "\"");
        }
        writer.write(62);
        writer.write(System.lineSeparator());
        this.writeGradientStops(writer);
        writer.write("            </gradient>");
        writer.write("</aapt:attr>");
    }

    private void writeGradientStops(OutputStreamWriter writer) throws IOException {
        for (GradientStop g : this.myGradientStops) {
            g.formatStopAttributes();
            String color = g.getColor();
            float opacity = 1.0f;
            try {
                opacity = Float.parseFloat(g.getOpacity());
            }
            catch (NumberFormatException e) {
                this.getTree().logErrorLine("Unsupported opacity value", this.getDocumentNode(), SvgTree.SvgLogLevel.WARNING);
            }
            int color1 = VdPath.applyAlpha(VdPath.calculateColor(color), opacity);
            StringBuilder hex = new StringBuilder(Integer.toHexString(color1).toUpperCase(Locale.ENGLISH));
            while (hex.length() < 8) {
                hex.insert(0, "0");
            }
            color = "#" + hex;
            writer.write("<item android:offset=\"" + g.getOffset() + "\"");
            writer.write(" android:color=\"" + color + "\" />");
            writer.write(System.lineSeparator());
            if (this.myGradientStops.size() != 1) continue;
            this.getTree().logErrorLine("Gradient only have one color stops", this.getDocumentNode(), SvgTree.SvgLogLevel.WARNING);
            writer.write("<item android:offset=\"1.0\"");
            writer.write(" android:color=\"" + color + "\" />");
            writer.write(System.lineSeparator());
        }
    }

    public void addGradientStop(String color, String offset, String opacity) {
        GradientStop stop = new GradientStop(color, offset);
        stop.setOpacity(opacity);
        this.myGradientStops.add(stop);
    }

    public void setGradientUsage(GradientUsage gradientUsage) {
        this.mGradientUsage = gradientUsage;
    }

    public void setSvgLeafNode(SvgLeafNode mSvgLeafNode) {
        this.mSvgLeafNode = mSvgLeafNode;
    }

    private void setBoundingBox() {
        Path2D.Double svgPath = new Path2D.Double();
        VdPath.Node[] nodes = PathParser.parsePath(this.mSvgLeafNode.getPathData());
        VdNodeRender.createPath(nodes, svgPath);
        this.boundingBox = svgPath.getBounds2D();
    }

    protected static enum GradientUsage {
        FILL,
        STROKE;

    }

    private static class GradientCoordResult {
        private final double mValue;
        private final boolean mIsPercentage;

        public GradientCoordResult(double value, boolean isPercentage) {
            this.mValue = value;
            this.mIsPercentage = isPercentage;
        }

        public double getValue() {
            return this.mValue;
        }

        public boolean isPercentage() {
            return this.mIsPercentage;
        }
    }
}

