/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

class SvgGroupNode
extends SvgNode {
    private static final Logger logger = Logger.getLogger(SvgGroupNode.class.getSimpleName());
    private static final String INDENT_LEVEL = "    ";
    protected final ArrayList<SvgNode> mChildren = new ArrayList();

    public SvgGroupNode(SvgTree svgTree, Node docNode, String name) {
        super(svgTree, docNode, name);
    }

    @Override
    public SvgGroupNode deepCopy() {
        SvgGroupNode newInstance = new SvgGroupNode(this.getTree(), this.getDocumentNode(), this.getName());
        this.copyTo(newInstance);
        return newInstance;
    }

    protected void copyTo(SvgGroupNode newInstance) {
        super.copyTo(newInstance);
        for (SvgNode n : this.mChildren) {
            SvgNode m = n.deepCopy();
            newInstance.addChild(m);
        }
    }

    public void addChild(SvgNode child) {
        this.mChildren.add(child);
        child.fillEmptyAttributes(this.mVdAttributesMap);
    }

    public void removeChild(SvgNode child) {
        if (this.mChildren.contains(child)) {
            this.mChildren.remove(child);
        }
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + "current group is :" + this.getName());
        for (SvgNode node : this.mChildren) {
            node.dumpNode(indent + INDENT_LEVEL);
        }
    }

    public SvgGroupNode findParent(SvgNode node) {
        for (SvgNode n : this.mChildren) {
            SvgGroupNode parent;
            if (n == node) {
                return this;
            }
            if (!n.isGroupNode() || (parent = ((SvgGroupNode)n).findParent(node)) == null) continue;
            return parent;
        }
        return null;
    }

    @Override
    public boolean isGroupNode() {
        return true;
    }

    @Override
    public void transformIfNeeded(AffineTransform rootTransform) {
        for (SvgNode p : this.mChildren) {
            p.transformIfNeeded(rootTransform);
        }
    }

    @Override
    public void flatten(AffineTransform transform) {
        for (SvgNode n : this.mChildren) {
            this.mStackedTransform.setTransform(transform);
            this.mStackedTransform.concatenate(this.mLocalTransform);
            n.flatten(this.mStackedTransform);
        }
    }

    @Override
    public void writeXML(OutputStreamWriter writer, boolean inClipPath) throws IOException {
        for (SvgNode node : this.mChildren) {
            node.writeXML(writer, inClipPath);
        }
    }

    @Override
    public void fillPresentationAttributes(String name, String value) {
        for (SvgNode n : this.mChildren) {
            if (n.mVdAttributesMap.containsKey(name)) continue;
            n.fillPresentationAttributes(name, value);
        }
    }
}

