/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.vectordrawable.VdElement;
import com.android.ide.common.vectordrawable.VdGroup;
import com.android.ide.common.vectordrawable.VdPath;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class VdTree {
    private static final String SHAPE_VECTOR = "vector";
    private static final String SHAPE_PATH = "path";
    private static final String SHAPE_GROUP = "group";
    private static final String SHAPE_CLIP_PATH = "clip-path";
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("^\\s*(\\d+(\\.\\d+)*)\\s*([a-zA-Z]+)\\s*$");
    private final VdGroup mRootGroup = new VdGroup();
    private float mBaseWidth = 1.0f;
    private float mBaseHeight = 1.0f;
    private float mPortWidth = 1.0f;
    private float mPortHeight = 1.0f;
    private float mRootAlpha = 1.0f;
    private static final boolean DBG_PRINT_TREE = false;
    private static final String INDENT = "  ";

    VdTree() {
    }

    float getBaseWidth() {
        return this.mBaseWidth;
    }

    float getBaseHeight() {
        return this.mBaseHeight;
    }

    float getPortWidth() {
        return this.mPortWidth;
    }

    float getPortHeight() {
        return this.mPortHeight;
    }

    private void drawTree(Graphics2D g, int w, int h) {
        float scaleX = (float)w / this.mPortWidth;
        float scaleY = (float)h / this.mPortHeight;
        AffineTransform rootMatrix = new AffineTransform();
        this.mRootGroup.draw(g, rootMatrix, scaleX, scaleY);
    }

    public void drawIntoImage(BufferedImage image) {
        Graphics2D gFinal = (Graphics2D)image.getGraphics();
        int width = image.getWidth();
        int height = image.getHeight();
        gFinal.setColor(new Color(255, 255, 255, 0));
        gFinal.fillRect(0, 0, width, height);
        float rootAlpha = this.mRootAlpha;
        if ((double)rootAlpha < 1.0) {
            BufferedImage alphaImage = AssetUtil.newArgbBufferedImage(width, height);
            Graphics2D gTemp = (Graphics2D)alphaImage.getGraphics();
            this.drawTree(gTemp, width, height);
            gFinal.setComposite(AlphaComposite.getInstance(3, rootAlpha));
            gFinal.drawImage((Image)alphaImage, 0, 0, null);
            gTemp.dispose();
        } else {
            this.drawTree(gFinal, width, height);
        }
        gFinal.dispose();
    }

    public void parse(Document doc) {
        NodeList rootNodeList = doc.getElementsByTagName(SHAPE_VECTOR);
        assert (rootNodeList.getLength() == 1);
        Node rootNode = rootNodeList.item(0);
        this.parseRootNode(rootNode);
        VdTree.parseTree(rootNode, this.mRootGroup);
    }

    private static void parseTree(Node currentNode, VdGroup currentGroup) {
        NodeList childrenNodes = currentNode.getChildNodes();
        int length = childrenNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = childrenNodes.item(i);
            if (child.getNodeType() != 1) continue;
            if (SHAPE_GROUP.equals(child.getNodeName())) {
                VdGroup newGroup = VdTree.parseGroupAttributes(child.getAttributes());
                currentGroup.add(newGroup);
                VdTree.parseTree(child, newGroup);
                continue;
            }
            if (SHAPE_PATH.equals(child.getNodeName())) {
                VdPath newPath = VdTree.parsePathAttributes(child.getAttributes());
                newPath.addGradientIfExists(child);
                currentGroup.add(newPath);
                continue;
            }
            if (!SHAPE_CLIP_PATH.equals(child.getNodeName())) continue;
            VdPath newClipPath = VdTree.parsePathAttributes(child.getAttributes());
            newClipPath.setClipPath(true);
            currentGroup.add(newClipPath);
        }
    }

    private static void debugPrintTree(int level, VdGroup mRootGroup) {
        int len = mRootGroup.size();
        if (len == 0) {
            return;
        }
        StringBuilder prefixBuilder = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            prefixBuilder.append(INDENT);
        }
        String prefix = prefixBuilder.toString();
        ArrayList<VdElement> children = mRootGroup.getChildren();
        for (int i = 0; i < len; ++i) {
            VdElement child = children.get(i);
            System.out.println(prefix + child.toString());
            if (!child.isGroup()) continue;
            VdTree.debugPrintTree(level + 1, (VdGroup)child);
        }
    }

    private void parseRootNode(Node rootNode) {
        if (rootNode.hasAttributes()) {
            this.parseSize(rootNode.getAttributes());
        }
    }

    private void parseSize(NamedNodeMap attributes) {
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            String name = attributes.item(i).getNodeName();
            String value = attributes.item(i).getNodeValue();
            Matcher matcher = ATTRIBUTE_PATTERN.matcher(value);
            float size = 0.0f;
            if (matcher.matches()) {
                size = Float.parseFloat(matcher.group(1));
            }
            if ("android:width".equals(name)) {
                this.mBaseWidth = size;
                continue;
            }
            if ("android:height".equals(name)) {
                this.mBaseHeight = size;
                continue;
            }
            if ("android:viewportWidth".equals(name)) {
                this.mPortWidth = Float.parseFloat(value);
                continue;
            }
            if ("android:viewportHeight".equals(name)) {
                this.mPortHeight = Float.parseFloat(value);
                continue;
            }
            if (!"android:alpha".equals(name)) continue;
            this.mRootAlpha = Float.parseFloat(value);
        }
    }

    private static VdPath parsePathAttributes(NamedNodeMap attributes) {
        VdPath vgPath = new VdPath();
        vgPath.parseAttributes(attributes);
        return vgPath;
    }

    private static VdGroup parseGroupAttributes(NamedNodeMap attributes) {
        VdGroup vgGroup = new VdGroup();
        vgGroup.parseAttributes(attributes);
        return vgGroup;
    }
}

