/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SampleDataResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.sampledata.SampleDataManager;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceResolver
extends RenderResources {
    public static final String THEME_NAME = "Theme";
    public static final String THEME_NAME_DOT = "Theme.";
    public static final String XLIFF_NAMESPACE_PREFIX = "urn:oasis:names:tc:xliff:document:";
    public static final String XLIFF_G_TAG = "g";
    public static final String ATTR_EXAMPLE = "example";
    public static final String LEGACY_THEME = "";
    public static final Pattern DEVICE_DEFAULT_PATTERN = Pattern.compile("(\\p{Alpha}+)?\\.?DeviceDefault\\.?(.+)?");
    public static final int MAX_RESOURCE_INDIRECTION = 50;
    private final Map<ResourceType, ResourceValueMap> mProjectResources;
    private final Map<ResourceType, ResourceValueMap> mFrameworkResources;
    private final Map<StyleResourceValue, StyleResourceValue> mStyleInheritanceMap = new HashMap<StyleResourceValue, StyleResourceValue>();
    private StyleResourceValue mDefaultTheme;
    private final List<StyleResourceValue> mThemes;
    private RenderResources.ResourceIdProvider mFrameworkIdProvider = new RenderResources.FrameworkResourceIdProvider();
    private RenderResources.ResourceIdProvider mLibrariesIdProvider = new RenderResources.ResourceIdProvider();
    private LayoutLog mLogger;
    private final String mThemeName;
    private boolean mIsProjectTheme;
    private String mDeviceDefaultParent = null;
    private SampleDataManager mSampleDataManager = new SampleDataManager();

    private ResourceResolver(Map<ResourceType, ResourceValueMap> projectResources, Map<ResourceType, ResourceValueMap> frameworkResources, String themeName, boolean isProjectTheme) {
        this.mProjectResources = projectResources;
        this.mFrameworkResources = frameworkResources;
        this.mThemeName = themeName;
        this.mIsProjectTheme = isProjectTheme;
        this.mThemes = new LinkedList<StyleResourceValue>();
    }

    public static ResourceResolver create(Map<ResourceType, ResourceValueMap> projectResources, Map<ResourceType, ResourceValueMap> frameworkResources, String themeName, boolean isProjectTheme) {
        ResourceResolver resolver = new ResourceResolver(projectResources, frameworkResources, themeName, isProjectTheme);
        resolver.computeStyleMaps();
        return resolver;
    }

    public static ResourceResolver copy(ResourceResolver original) {
        if (original == null) {
            return null;
        }
        ResourceResolver resolver = new ResourceResolver(original.mProjectResources, original.mFrameworkResources, original.mThemeName, original.mIsProjectTheme);
        resolver.mFrameworkIdProvider = original.mFrameworkIdProvider;
        resolver.mLibrariesIdProvider = original.mLibrariesIdProvider;
        resolver.mLogger = original.mLogger;
        resolver.mDefaultTheme = original.mDefaultTheme;
        resolver.mStyleInheritanceMap.putAll(original.mStyleInheritanceMap);
        resolver.mThemes.addAll(original.mThemes);
        return resolver;
    }

    public void setDeviceDefaults(String deviceDefaultParent) {
        if (deviceDefaultParent.equals(this.mDeviceDefaultParent)) {
            return;
        }
        this.mDeviceDefaultParent = deviceDefaultParent;
        String parentName = Strings.emptyToNull((String)deviceDefaultParent);
        for (ResourceValue value : this.mFrameworkResources.get(ResourceType.STYLE).values()) {
            Matcher matcher = DEVICE_DEFAULT_PATTERN.matcher(value.getName());
            if (!matcher.matches()) continue;
            String newParentStyle = Joiner.on((char)'.').skipNulls().join((Object)matcher.group(1), (Object)parentName, new Object[]{matcher.groupCount() > 1 ? matcher.group(2) : null});
            this.patchFrameworkStyleParent(value.getName(), newParentStyle);
        }
    }

    private void patchFrameworkStyleParent(String childStyleName, String parentName) {
        ResourceValueMap map = this.mFrameworkResources.get(ResourceType.STYLE);
        if (map != null) {
            StyleResourceValue from = (StyleResourceValue)map.get(childStyleName);
            StyleResourceValue to = (StyleResourceValue)map.get(parentName);
            if (from != null && to != null) {
                StyleResourceValue newStyle = new StyleResourceValue(from.getResourceUrl(), parentName, from.getLibraryName());
                newStyle.replaceWith((ResourceValue)from);
                this.mStyleInheritanceMap.put(newStyle, to);
            }
        }
    }

    public String getThemeName() {
        return this.mThemeName;
    }

    public boolean isProjectTheme() {
        return this.mIsProjectTheme;
    }

    public Map<ResourceType, ResourceValueMap> getProjectResources() {
        return this.mProjectResources;
    }

    public Map<ResourceType, ResourceValueMap> getFrameworkResources() {
        return this.mFrameworkResources;
    }

    public void setLibrariesIdProvider(RenderResources.ResourceIdProvider provider) {
        this.mLibrariesIdProvider = provider;
    }

    public void setFrameworkResourceIdProvider(RenderResources.ResourceIdProvider provider) {
        this.mFrameworkIdProvider = provider;
    }

    public void setFrameworkResourceIdProvider(RenderResources.FrameworkResourceIdProvider provider) {
        this.setFrameworkResourceIdProvider((RenderResources.ResourceIdProvider)provider);
    }

    public void setLogger(LayoutLog logger) {
        this.mLogger = logger;
    }

    public StyleResourceValue getDefaultTheme() {
        return this.mDefaultTheme;
    }

    public void applyStyle(StyleResourceValue theme, boolean useAsPrimary) {
        if (theme == null) {
            return;
        }
        if (useAsPrimary) {
            this.mThemes.add(0, theme);
        } else {
            this.mThemes.add(theme);
        }
    }

    public void clearStyles() {
        this.mThemes.clear();
        this.mThemes.add(this.mDefaultTheme);
    }

    public List<StyleResourceValue> getAllThemes() {
        return this.mThemes;
    }

    public StyleResourceValue getTheme(String name, boolean frameworkTheme) {
        ResourceValue theme;
        if (frameworkTheme) {
            ResourceValueMap frameworkStyleMap = this.mFrameworkResources.get(ResourceType.STYLE);
            theme = (ResourceValue)frameworkStyleMap.get(name);
        } else {
            ResourceValueMap projectStyleMap = this.mProjectResources.get(ResourceType.STYLE);
            theme = (ResourceValue)projectStyleMap.get(name);
        }
        if (theme instanceof StyleResourceValue) {
            return (StyleResourceValue)theme;
        }
        return null;
    }

    public boolean themeIsParentOf(StyleResourceValue parentTheme, StyleResourceValue childTheme) {
        do {
            if ((childTheme = this.mStyleInheritanceMap.get(childTheme)) != null) continue;
            return false;
        } while (childTheme != parentTheme);
        return true;
    }

    public ResourceValue getFrameworkResource(ResourceType resourceType, String resourceName) {
        return this.getResource(resourceType, resourceName, this.mFrameworkResources);
    }

    public ResourceValue getProjectResource(ResourceType resourceType, String resourceName) {
        return this.getResource(resourceType, resourceName, this.mProjectResources);
    }

    @Deprecated
    public ItemResourceValue findItemInStyle(StyleResourceValue style, String attrName) {
        ItemResourceValue item = this.findItemInStyle(style, attrName, false);
        if (item == null) {
            item = this.findItemInStyle(style, attrName, true);
        }
        return item;
    }

    public ItemResourceValue findItemInStyle(StyleResourceValue style, String itemName, boolean isFrameworkAttr) {
        return this.findItemInStyle(style, itemName, isFrameworkAttr, 0);
    }

    private ItemResourceValue findItemInStyle(StyleResourceValue style, String itemName, boolean isFrameworkAttr, int depth) {
        StyleResourceValue parentStyle;
        ItemResourceValue item = style.getItem(itemName, isFrameworkAttr);
        if (item == null && (parentStyle = this.mStyleInheritanceMap.get(style)) != null) {
            if (depth >= 50) {
                if (this.mLogger != null) {
                    this.mLogger.error("broken", String.format("Cyclic style parent definitions: %1$s", this.computeCyclicStyleChain(style)), null);
                }
                return null;
            }
            return this.findItemInStyle(parentStyle, itemName, isFrameworkAttr, depth + 1);
        }
        return item;
    }

    private String computeCyclicStyleChain(StyleResourceValue style) {
        StringBuilder sb = new StringBuilder(100);
        this.appendStyleParents(style, new HashSet<StyleResourceValue>(), 0, sb);
        return sb.toString();
    }

    private void appendStyleParents(StyleResourceValue style, Set<StyleResourceValue> seen, int depth, StringBuilder sb) {
        if (depth >= 50) {
            sb.append("...");
            return;
        }
        boolean haveSeen = seen.contains(style);
        seen.add(style);
        sb.append('\"');
        if (style.isFramework()) {
            sb.append("android:");
        }
        sb.append(style.getName());
        sb.append('\"');
        if (haveSeen) {
            return;
        }
        StyleResourceValue parentStyle = this.mStyleInheritanceMap.get(style);
        if (parentStyle != null) {
            if (style.getParentStyle() != null) {
                sb.append(" specifies parent ");
            } else {
                sb.append(" implies parent ");
            }
            this.appendStyleParents(parentStyle, seen, depth + 1, sb);
        }
    }

    public ResourceValue findResValue(String reference, boolean forceFrameworkOnly) {
        if (reference == null) {
            return null;
        }
        ResourceUrl resource = ResourceUrl.parse((String)reference);
        if (resource == null || !resource.hasValidName()) {
            return null;
        }
        if (resource.theme) {
            if (this.mDefaultTheme == null) {
                return null;
            }
            if (resource.type != ResourceType.ATTR) {
                return null;
            }
            return this.findItemInTheme(resource.name, forceFrameworkOnly || resource.framework);
        }
        return this.findResValue(resource, forceFrameworkOnly);
    }

    public ResourceValue resolveResValue(ResourceValue resValue) {
        return this.resolveResValue(resValue, 0);
    }

    private ResourceValue resolveResValue(ResourceValue resValue, int depth) {
        if (resValue == null) {
            return null;
        }
        String value = resValue.getValue();
        if (value == null || resValue instanceof ArrayResourceValue) {
            return resValue;
        }
        ResourceValue resolvedResValue = this.findResValue(value, resValue.isFramework());
        if (resolvedResValue == null) {
            return resValue;
        }
        if (resValue == resolvedResValue || depth >= 50) {
            if (this.mLogger != null) {
                this.mLogger.error("broken", String.format("Potential stack overflow trying to resolve '%s': cyclic resource definitions? Render may not be accurate.", value), null);
            }
            return resValue;
        }
        return this.resolveResValue(resolvedResValue, depth + 1);
    }

    private ResourceValue findSampleDataValue(ResourceUrl url) {
        String name = (url.namespace == null ? LEGACY_THEME : url.namespace + ":") + url.name;
        return Optional.ofNullable(this.mProjectResources.get(ResourceType.SAMPLE_DATA)).map(t -> (ResourceValue)t.get(SampleDataManager.getResourceNameFromSampleReference(name))).filter(SampleDataResourceValue.class::isInstance).map(SampleDataResourceValue.class::cast).map(SampleDataResourceValue::getValueAsLines).map(content -> this.mSampleDataManager.getSampleDataLine(name, (ImmutableList<String>)content)).map(lineContent -> new ResourceValue(ResourceUrl.create((String)url.namespace, (ResourceType)ResourceType.SAMPLE_DATA, (String)name), lineContent)).orElse(null);
    }

    private ResourceValue findResValue(ResourceUrl url, boolean forceFramework) {
        ResourceValue item;
        ResourceValueMap typeMap;
        if (url.type == ResourceType.AAPT) {
            return null;
        }
        if (url.type == ResourceType.SAMPLE_DATA) {
            return this.findSampleDataValue(url);
        }
        ResourceType resType = url.type;
        String resName = url.name;
        boolean isFramework = forceFramework || url.framework;
        ResourceValueMap resourceValueMap = typeMap = !isFramework ? this.mProjectResources.get(resType) : this.mFrameworkResources.get(resType);
        if (typeMap != null && (item = (ResourceValue)typeMap.get(resName)) != null) {
            return item;
        }
        if (!url.create) {
            if (resType == ResourceType.ID) {
                boolean idExists;
                boolean bl = isFramework ? this.mFrameworkIdProvider.getId(resType, resName) != null : (idExists = this.mLibrariesIdProvider.getId(resType, resName) != null);
                if (idExists) {
                    return new ResourceValue(isFramework ? url.withFramework(true) : url, null);
                }
            }
            if (this.mLogger != null) {
                this.mLogger.warning("resources.resolve", "Couldn't resolve resource @" + (isFramework ? "android:" : LEGACY_THEME) + resType + "/" + resName, null, (Object)url.withFramework(isFramework));
            }
        }
        return null;
    }

    private ResourceValue getResource(ResourceType resourceType, String resourceName, Map<ResourceType, ResourceValueMap> resourceRepository) {
        ResourceValue item;
        ResourceValueMap typeMap = resourceRepository.get(resourceType);
        if (typeMap != null && (item = (ResourceValue)typeMap.get(resourceName)) != null) {
            item = this.resolveResValue(item);
            return item;
        }
        return null;
    }

    private void computeStyleMaps() {
        ResourceValueMap projectStyleMap = this.mProjectResources.get(ResourceType.STYLE);
        ResourceValueMap frameworkStyleMap = this.mFrameworkResources.get(ResourceType.STYLE);
        ResourceValue theme = null;
        if (this.mIsProjectTheme) {
            if (projectStyleMap != null) {
                theme = (ResourceValue)projectStyleMap.get(this.mThemeName);
            }
        } else if (frameworkStyleMap != null) {
            theme = (ResourceValue)frameworkStyleMap.get(this.mThemeName);
        }
        if (theme instanceof StyleResourceValue) {
            this.computeStyleInheritance(projectStyleMap.values(), projectStyleMap, frameworkStyleMap);
            if (frameworkStyleMap != null) {
                this.computeStyleInheritance(frameworkStyleMap.values(), null, frameworkStyleMap);
            }
            this.mDefaultTheme = (StyleResourceValue)theme;
            this.mThemes.clear();
            this.mThemes.add(this.mDefaultTheme);
        }
    }

    private void computeStyleInheritance(Collection<ResourceValue> styles, ResourceValueMap inProjectStyleMap, ResourceValueMap inFrameworkStyleMap) {
        this.mDeviceDefaultParent = null;
        for (ResourceValue value : styles) {
            StyleResourceValue parentStyle;
            StyleResourceValue style;
            String parentName;
            if (!(value instanceof StyleResourceValue) || (parentName = ResourceResolver.getParentName(style = (StyleResourceValue)value)) == null || (parentStyle = this.getStyle(parentName, inProjectStyleMap, inFrameworkStyleMap)) == null) continue;
            this.mStyleInheritanceMap.put(style, parentStyle);
        }
    }

    public static String getParentName(StyleResourceValue style) {
        String parentName = style.getParentStyle();
        if (parentName != null) {
            return parentName;
        }
        String styleName = style.getName();
        int index = styleName.lastIndexOf(46);
        if (index != -1) {
            return styleName.substring(0, index);
        }
        return null;
    }

    public StyleResourceValue getParent(StyleResourceValue style) {
        return this.mStyleInheritanceMap.get(style);
    }

    public StyleResourceValue getStyle(String styleName, boolean isFramework) {
        ResourceValueMap styleMap = isFramework ? this.mFrameworkResources.get(ResourceType.STYLE) : this.mProjectResources.get(ResourceType.STYLE);
        ResourceValue res = this.getStyleFromMap(styleMap, styleName);
        return res instanceof StyleResourceValue ? (StyleResourceValue)res : null;
    }

    private ResourceValue getStyleFromMap(ResourceValueMap styleMap, String styleName) {
        ResourceValue res = (ResourceValue)styleMap.get(styleName);
        if (res != null && !(res instanceof StyleResourceValue) && this.mLogger != null) {
            this.mLogger.error(null, String.format("Style %1$s is not of type STYLE (instead %2$s)", styleName, res.getResourceType().toString()), null);
        }
        return res;
    }

    private StyleResourceValue getStyle(String parentName, ResourceValueMap inProjectStyleMap, ResourceValueMap inFrameworkStyleMap) {
        boolean frameworkOnly = false;
        String name = parentName;
        if (name.startsWith("@")) {
            name = name.substring("@".length());
        }
        if (name.startsWith("android:")) {
            frameworkOnly = true;
            name = name.substring("android:".length());
        }
        if (name.startsWith("style/")) {
            name = name.substring("style/".length());
        } else if (name.indexOf(47) != -1) {
            return null;
        }
        ResourceValue parent = null;
        if (!frameworkOnly && inProjectStyleMap != null) {
            parent = (ResourceValue)inProjectStyleMap.get(name);
        }
        if (parent == null) {
            if (inFrameworkStyleMap == null) {
                return null;
            }
            parent = (ResourceValue)inFrameworkStyleMap.get(name);
        }
        if (parent instanceof StyleResourceValue) {
            return (StyleResourceValue)parent;
        }
        if (this.mLogger != null) {
            this.mLogger.error("resources.resolve", String.format("Unable to resolve parent style name: %s", parentName), null);
        }
        return null;
    }

    public boolean isTheme(ResourceValue value, Map<ResourceValue, Boolean> cache) {
        return this.isTheme(value, cache, 0);
    }

    private boolean isTheme(ResourceValue value, Map<ResourceValue, Boolean> cache, int depth) {
        Boolean known;
        if (cache != null && (known = cache.get(value)) != null) {
            return known;
        }
        if (value instanceof StyleResourceValue) {
            StyleResourceValue srv = (StyleResourceValue)value;
            String name = srv.getName();
            if (srv.isFramework() && (name.equals(THEME_NAME) || name.startsWith(THEME_NAME_DOT))) {
                if (cache != null) {
                    cache.put(value, true);
                }
                return true;
            }
            StyleResourceValue parentStyle = this.mStyleInheritanceMap.get(srv);
            if (parentStyle != null) {
                if (depth >= 50) {
                    if (this.mLogger != null) {
                        this.mLogger.error("broken", String.format("Cyclic style parent definitions: %1$s", this.computeCyclicStyleChain(srv)), null);
                    }
                    return false;
                }
                boolean result = this.isTheme((ResourceValue)parentStyle, cache, depth + 1);
                if (cache != null) {
                    cache.put(value, result);
                }
                return result;
            }
        }
        return false;
    }

    public boolean themeExtends(String parentStyle, String themeStyle) {
        ResourceValue parentValue = this.findResValue(parentStyle, parentStyle.startsWith("@android:style/"));
        if (parentValue instanceof StyleResourceValue) {
            ResourceValue themeValue = this.findResValue(themeStyle, themeStyle.startsWith("@android:style/"));
            if (themeValue == parentValue) {
                return true;
            }
            if (themeValue instanceof StyleResourceValue) {
                return this.themeIsParentOf((StyleResourceValue)parentValue, (StyleResourceValue)themeValue);
            }
        }
        return false;
    }

    public ResourceResolver createRecorder(List<ResourceValue> lookupChain) {
        RecordingResourceResolver resolver = new RecordingResourceResolver(lookupChain, this.mProjectResources, this.mFrameworkResources, this.mThemeName, this.mIsProjectTheme);
        resolver.mFrameworkIdProvider = this.mFrameworkIdProvider;
        resolver.mLogger = this.mLogger;
        resolver.mDefaultTheme = this.mDefaultTheme;
        resolver.mStyleInheritanceMap.putAll(this.mStyleInheritanceMap);
        resolver.mThemes.addAll(this.mThemes);
        return resolver;
    }

    private static class RecordingResourceResolver
    extends ResourceResolver {
        private List<ResourceValue> mLookupChain;

        private RecordingResourceResolver(List<ResourceValue> lookupChain, Map<ResourceType, ResourceValueMap> projectResources, Map<ResourceType, ResourceValueMap> frameworkResources, String themeName, boolean isProjectTheme) {
            super(projectResources, frameworkResources, themeName, isProjectTheme);
            this.mLookupChain = lookupChain;
        }

        @Override
        public ResourceValue resolveResValue(ResourceValue resValue) {
            if (resValue != null) {
                this.mLookupChain.add(resValue);
            }
            return super.resolveResValue(resValue);
        }

        @Override
        public ResourceValue findResValue(String reference, boolean forceFrameworkOnly) {
            ResourceValue resValue;
            ResourceValue prev;
            if (!this.mLookupChain.isEmpty() && reference != null && reference.startsWith("@") && !reference.equals((prev = this.mLookupChain.get(this.mLookupChain.size() - 1)).getValue())) {
                ResourceValue next = new ResourceValue(prev.getResourceUrl(), null, prev.getLibraryName());
                next.setValue(reference);
                this.mLookupChain.add(next);
            }
            if ((resValue = super.findResValue(reference, forceFrameworkOnly)) != null) {
                this.mLookupChain.add(resValue);
            }
            return resValue;
        }

        @Override
        public ItemResourceValue findItemInStyle(StyleResourceValue style, String itemName, boolean isFrameworkAttr) {
            ItemResourceValue value = super.findItemInStyle(style, itemName, isFrameworkAttr);
            if (value != null) {
                this.mLookupChain.add((ResourceValue)value);
            }
            return value;
        }

        public ResourceValue findItemInTheme(String attrName, boolean isFrameworkAttr) {
            ResourceValue value = super.findItemInTheme(attrName, isFrameworkAttr);
            if (value != null) {
                this.mLookupChain.add(value);
            }
            return value;
        }
    }
}

