/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ArtifactMetaData;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.JavaCompileOptions;
import com.android.builder.model.LintOptions;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.IdeAaptOptions;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeBuildTypeContainer;
import com.android.ide.common.gradle.model.IdeJavaCompileOptions;
import com.android.ide.common.gradle.model.IdeLintOptions;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeNativeToolchain;
import com.android.ide.common.gradle.model.IdeProductFlavorContainer;
import com.android.ide.common.gradle.model.IdeSigningConfig;
import com.android.ide.common.gradle.model.IdeSyncIssue;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.gradle.model.IdeVariantImpl;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.UnusedModelMethodException;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;

public final class IdeAndroidProjectImpl
extends IdeModel
implements IdeAndroidProject {
    private static final long serialVersionUID = 2L;
    private final String myModelVersion;
    private final String myName;
    private final ProductFlavorContainer myDefaultConfig;
    private final Collection<BuildTypeContainer> myBuildTypes;
    private final Collection<ProductFlavorContainer> myProductFlavors;
    private final Collection<SyncIssue> mySyncIssues;
    private final Collection<Variant> myVariants;
    private final Collection<String> myFlavorDimensions;
    private final String myCompileTarget;
    private final Collection<String> myBootClassPath;
    private final Collection<NativeToolchain> myNativeToolchains;
    private final Collection<SigningConfig> mySigningConfigs;
    private final LintOptions myLintOptions;
    private final Collection<String> myUnresolvedDependencies;
    private final JavaCompileOptions myJavaCompileOptions;
    private final AaptOptions myAaptOptions;
    private final File myBuildFolder;
    private final GradleVersion myParsedModelVersion;
    private final String myBuildToolsVersion;
    private final String myResourcePrefix;
    private final Integer myPluginGeneration;
    private final int myApiVersion;
    private final boolean myLibrary;
    private final int myProjectType;
    private final boolean myBaseSplit;
    private final int myHashCode;

    public IdeAndroidProjectImpl(AndroidProject project, IdeDependenciesFactory dependenciesFactory) {
        this(project, new ModelCache(), dependenciesFactory);
    }

    @VisibleForTesting
    IdeAndroidProjectImpl(AndroidProject project, ModelCache modelCache, IdeDependenciesFactory dependenciesFactory) {
        super(project, modelCache);
        this.myModelVersion = project.getModelVersion();
        this.myParsedModelVersion = GradleVersion.tryParse(this.myModelVersion);
        this.myName = project.getName();
        this.myDefaultConfig = modelCache.computeIfAbsent(project.getDefaultConfig(), container -> new IdeProductFlavorContainer((ProductFlavorContainer)container, modelCache));
        this.myBuildTypes = IdeAndroidProjectImpl.copy(project.getBuildTypes(), modelCache, (K container) -> new IdeBuildTypeContainer((BuildTypeContainer)container, modelCache));
        this.myProductFlavors = IdeAndroidProjectImpl.copy(project.getProductFlavors(), modelCache, (K container) -> new IdeProductFlavorContainer((ProductFlavorContainer)container, modelCache));
        this.myBuildToolsVersion = IdeAndroidProjectImpl.copyNewProperty(() -> ((AndroidProject)project).getBuildToolsVersion(), null);
        this.mySyncIssues = IdeAndroidProjectImpl.copy(project.getSyncIssues(), modelCache, (K issue) -> new IdeSyncIssue((SyncIssue)issue, modelCache));
        this.myVariants = IdeAndroidProjectImpl.copy(project.getVariants(), modelCache, (K variant) -> new IdeVariantImpl((Variant)variant, modelCache, dependenciesFactory, this.myParsedModelVersion));
        this.myFlavorDimensions = IdeAndroidProjectImpl.copyNewProperty(() -> ImmutableList.copyOf((Collection)project.getFlavorDimensions()), Collections.emptyList());
        this.myCompileTarget = project.getCompileTarget();
        this.myBootClassPath = ImmutableList.copyOf((Collection)project.getBootClasspath());
        this.myNativeToolchains = IdeAndroidProjectImpl.copy(project.getNativeToolchains(), modelCache, (K toolchain) -> new IdeNativeToolchain((NativeToolchain)toolchain, modelCache));
        this.mySigningConfigs = IdeAndroidProjectImpl.copy(project.getSigningConfigs(), modelCache, (K config) -> new IdeSigningConfig((SigningConfig)config, modelCache));
        this.myLintOptions = modelCache.computeIfAbsent(project.getLintOptions(), options -> new IdeLintOptions((LintOptions)options, modelCache, this.myParsedModelVersion));
        this.myUnresolvedDependencies = ImmutableSet.copyOf((Collection)project.getUnresolvedDependencies());
        this.myJavaCompileOptions = modelCache.computeIfAbsent(project.getJavaCompileOptions(), options -> new IdeJavaCompileOptions((JavaCompileOptions)options, modelCache));
        this.myAaptOptions = modelCache.computeIfAbsent(project.getAaptOptions(), options -> new IdeAaptOptions((AaptOptions)options, modelCache));
        this.myBuildFolder = project.getBuildFolder();
        this.myResourcePrefix = project.getResourcePrefix();
        this.myApiVersion = project.getApiVersion();
        this.myLibrary = project.isLibrary();
        this.myProjectType = IdeAndroidProjectImpl.getProjectType(project, this.myParsedModelVersion);
        this.myPluginGeneration = IdeAndroidProjectImpl.copyNewProperty(() -> ((AndroidProject)project).getPluginGeneration(), null);
        this.myBaseSplit = IdeAndroidProjectImpl.copyNewProperty(() -> ((AndroidProject)project).isBaseSplit(), false);
        this.myHashCode = this.calculateHashCode();
    }

    private static int getProjectType(AndroidProject project, GradleVersion modelVersion) {
        if (modelVersion != null && modelVersion.isAtLeast(2, 3, 0)) {
            return project.getProjectType();
        }
        return project.isLibrary() ? 1 : 0;
    }

    @Override
    public GradleVersion getParsedModelVersion() {
        return this.myParsedModelVersion;
    }

    public String getModelVersion() {
        return this.myModelVersion;
    }

    public String getName() {
        return this.myName;
    }

    public ProductFlavorContainer getDefaultConfig() {
        return this.myDefaultConfig;
    }

    public Collection<BuildTypeContainer> getBuildTypes() {
        return this.myBuildTypes;
    }

    public Collection<ProductFlavorContainer> getProductFlavors() {
        return this.myProductFlavors;
    }

    public String getBuildToolsVersion() {
        if (this.myBuildToolsVersion != null) {
            return this.myBuildToolsVersion;
        }
        throw new UnsupportedOperationException("Unsupported method: AndroidProject.getBuildToolsVersion()");
    }

    public Collection<SyncIssue> getSyncIssues() {
        return this.mySyncIssues;
    }

    public Collection<Variant> getVariants() {
        return this.myVariants;
    }

    public Collection<String> getFlavorDimensions() {
        return this.myFlavorDimensions;
    }

    public Collection<ArtifactMetaData> getExtraArtifacts() {
        throw new UnusedModelMethodException("getExtraArtifacts");
    }

    public String getCompileTarget() {
        return this.myCompileTarget;
    }

    public Collection<String> getBootClasspath() {
        return this.myBootClassPath;
    }

    public Collection<File> getFrameworkSources() {
        throw new UnusedModelMethodException("getFrameworkSources");
    }

    public Collection<NativeToolchain> getNativeToolchains() {
        return this.myNativeToolchains;
    }

    public AaptOptions getAaptOptions() {
        return this.myAaptOptions;
    }

    public Collection<SigningConfig> getSigningConfigs() {
        return this.mySigningConfigs;
    }

    public LintOptions getLintOptions() {
        return this.myLintOptions;
    }

    @Deprecated
    public Collection<String> getUnresolvedDependencies() {
        return this.myUnresolvedDependencies;
    }

    public JavaCompileOptions getJavaCompileOptions() {
        return this.myJavaCompileOptions;
    }

    public File getBuildFolder() {
        return this.myBuildFolder;
    }

    public String getResourcePrefix() {
        return this.myResourcePrefix;
    }

    public int getApiVersion() {
        return this.myApiVersion;
    }

    @Deprecated
    public boolean isLibrary() {
        return this.myLibrary;
    }

    public int getProjectType() {
        return this.myProjectType;
    }

    public int getPluginGeneration() {
        if (this.myPluginGeneration != null) {
            return this.myPluginGeneration;
        }
        throw new UnsupportedOperationException("Unsupported method: AndroidProject.getPluginGeneration()");
    }

    public boolean isBaseSplit() {
        return this.myBaseSplit;
    }

    @Override
    public void forEachVariant(Consumer<IdeVariant> action) {
        for (Variant variant : this.myVariants) {
            action.accept((IdeVariant)variant);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeAndroidProjectImpl)) {
            return false;
        }
        IdeAndroidProjectImpl project = (IdeAndroidProjectImpl)o;
        return this.myApiVersion == project.myApiVersion && this.myLibrary == project.myLibrary && this.myProjectType == project.myProjectType && this.myBaseSplit == project.myBaseSplit && Objects.equals(this.myPluginGeneration, project.myPluginGeneration) && Objects.equals(this.myModelVersion, project.myModelVersion) && Objects.equals(this.myParsedModelVersion, project.myParsedModelVersion) && Objects.equals(this.myName, project.myName) && Objects.equals(this.myDefaultConfig, project.myDefaultConfig) && Objects.equals(this.myBuildTypes, project.myBuildTypes) && Objects.equals(this.myProductFlavors, project.myProductFlavors) && Objects.equals(this.myBuildToolsVersion, project.myBuildToolsVersion) && Objects.equals(this.mySyncIssues, project.mySyncIssues) && Objects.equals(this.myVariants, project.myVariants) && Objects.equals(this.myFlavorDimensions, project.myFlavorDimensions) && Objects.equals(this.myCompileTarget, project.myCompileTarget) && Objects.equals(this.myBootClassPath, project.myBootClassPath) && Objects.equals(this.myNativeToolchains, project.myNativeToolchains) && Objects.equals(this.mySigningConfigs, project.mySigningConfigs) && Objects.equals(this.myLintOptions, project.myLintOptions) && Objects.equals(this.myUnresolvedDependencies, project.myUnresolvedDependencies) && Objects.equals(this.myJavaCompileOptions, project.myJavaCompileOptions) && Objects.equals(this.myAaptOptions, project.myAaptOptions) && Objects.equals(this.myBuildFolder, project.myBuildFolder) && Objects.equals(this.myResourcePrefix, project.myResourcePrefix);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myModelVersion, this.myParsedModelVersion, this.myName, this.myDefaultConfig, this.myBuildTypes, this.myProductFlavors, this.myBuildToolsVersion, this.mySyncIssues, this.myVariants, this.myFlavorDimensions, this.myCompileTarget, this.myBootClassPath, this.myNativeToolchains, this.mySigningConfigs, this.myLintOptions, this.myUnresolvedDependencies, this.myJavaCompileOptions, this.myBuildFolder, this.myResourcePrefix, this.myApiVersion, this.myLibrary, this.myProjectType, this.myPluginGeneration, this.myAaptOptions, this.myBaseSplit);
    }

    public String toString() {
        return "IdeAndroidProject{myModelVersion='" + this.myModelVersion + '\'' + ", myName='" + this.myName + '\'' + ", myDefaultConfig=" + this.myDefaultConfig + ", myBuildTypes=" + this.myBuildTypes + ", myProductFlavors=" + this.myProductFlavors + ", myBuildToolsVersion='" + this.myBuildToolsVersion + '\'' + ", mySyncIssues=" + this.mySyncIssues + ", myVariants=" + this.myVariants + ", myFlavorDimensions=" + this.myFlavorDimensions + ", myCompileTarget='" + this.myCompileTarget + '\'' + ", myBootClassPath=" + this.myBootClassPath + ", myNativeToolchains=" + this.myNativeToolchains + ", mySigningConfigs=" + this.mySigningConfigs + ", myLintOptions=" + this.myLintOptions + ", myUnresolvedDependencies=" + this.myUnresolvedDependencies + ", myJavaCompileOptions=" + this.myJavaCompileOptions + ", myBuildFolder=" + this.myBuildFolder + ", myResourcePrefix='" + this.myResourcePrefix + '\'' + ", myApiVersion=" + this.myApiVersion + ", myLibrary=" + this.myLibrary + ", myProjectType=" + this.myProjectType + ", myPluginGeneration=" + this.myPluginGeneration + ", myAaptOptions=" + this.myAaptOptions + ", myBaseSplit=" + this.myBaseSplit + "}";
    }
}

