/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.blame.Message;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.DataItem;
import com.android.ide.common.res2.DataSet;
import com.android.ide.common.res2.FileResourceNameValidator;
import com.android.ide.common.res2.GeneratedResourceItem;
import com.android.ide.common.res2.IdGeneratingResourceParser;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.NoOpResourcePreprocessor;
import com.android.ide.common.res2.NodeUtils;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourcePreprocessor;
import com.android.ide.common.res2.ValueResourceParser2;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.ILogger;
import com.android.utils.SdkUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceSet
extends DataSet<ResourceItem, ResourceFile> {
    public static final String ATTR_GENERATED_SET = "generated-set";
    public static final String ATTR_FROM_DEPENDENCY = "from-dependency";
    private final String mLibraryName;
    private final ResourceNamespace mNamespace;
    private ResourceSet mGeneratedSet;
    private ResourcePreprocessor mPreprocessor;
    private boolean mIsFromDependency;
    private boolean mShouldParseResourceIds;
    private boolean mDontNormalizeQualifiers;
    private boolean mTrackSourcePositions = true;

    public ResourceSet(String name, ResourceNamespace namespace, String libraryName, boolean validateEnabled) {
        super(name, validateEnabled);
        this.mNamespace = namespace;
        this.mPreprocessor = NoOpResourcePreprocessor.INSTANCE;
        this.mLibraryName = libraryName;
    }

    public String getLibraryName() {
        return this.mLibraryName;
    }

    public void setGeneratedSet(ResourceSet generatedSet) {
        this.mGeneratedSet = generatedSet;
    }

    public void setPreprocessor(ResourcePreprocessor preprocessor) {
        this.mPreprocessor = (ResourcePreprocessor)Preconditions.checkNotNull((Object)preprocessor);
    }

    public void setShouldParseResourceIds(boolean shouldParse) {
        this.mShouldParseResourceIds = shouldParse;
    }

    public void setDontNormalizeQualifiers(boolean dontNormalizeQualifiers) {
        this.mDontNormalizeQualifiers = dontNormalizeQualifiers;
    }

    public void setTrackSourcePositions(boolean shouldTrack) {
        this.mTrackSourcePositions = shouldTrack;
    }

    @Override
    protected DataSet<ResourceItem, ResourceFile> createSet(String name) {
        return new ResourceSet(name, this.mNamespace, this.mLibraryName, true);
    }

    @Override
    protected ResourceFile createFileAndItems(File sourceFolder, File file, ILogger logger) throws MergingException {
        FolderData folderData = this.getFolderData(file.getParentFile());
        if (folderData == null) {
            return null;
        }
        return this.createResourceFile(file, folderData, logger);
    }

    @Override
    protected ResourceFile createFileAndItemsFromXml(File file, Node fileNode) throws MergingException {
        String qualifier = (String)MoreObjects.firstNonNull((Object)NodeUtils.getAttribute(fileNode, "qualifiers"), (Object)"");
        String typeAttr = NodeUtils.getAttribute(fileNode, "type");
        FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForQualifierString(qualifier);
        if (folderConfiguration == null) {
            return null;
        }
        if (NodeUtils.getAttribute(fileNode, "preprocessing") != null) {
            NodeList childNodes = fileNode.getChildNodes();
            int childCount = childNodes.getLength();
            ArrayList resourceItems = Lists.newArrayListWithCapacity((int)childCount);
            for (int i = 0; i < childCount; ++i) {
                String qualifers;
                Node childNode = childNodes.item(i);
                String path = NodeUtils.getAttribute(childNode, "path");
                if (path == null) continue;
                File generatedFile = new File(path);
                String resourceType = NodeUtils.getAttribute(childNode, "type");
                if (resourceType == null || (qualifers = NodeUtils.getAttribute(childNode, "qualifiers")) == null) continue;
                resourceItems.add(new GeneratedResourceItem(ResourceSet.getNameForFile(generatedFile), this.mNamespace, generatedFile, (ResourceType)FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)ResourceFolderType.getTypeByName((String)resourceType)).get(0), qualifers, this.mLibraryName));
            }
            return ResourceFile.generatedFiles(file, resourceItems, qualifier, folderConfiguration);
        }
        if (typeAttr == null) {
            ArrayList resourceList = Lists.newArrayList();
            NodeList resNodes = fileNode.getChildNodes();
            int nnn = resNodes.getLength();
            for (int iii = 0; iii < nnn; ++iii) {
                ResourceItem r;
                Node resNode = resNodes.item(iii);
                if (resNode.getNodeType() != 1 || (r = ValueResourceParser2.getResource(resNode, file, this.mNamespace, this.mLibraryName)) == null) continue;
                resourceList.add(r);
                if (r.getType() != ResourceType.DECLARE_STYLEABLE) continue;
                try {
                    ValueResourceParser2.addStyleableItems(resNode, resourceList, null, file, this.mNamespace, this.mLibraryName);
                    continue;
                }
                catch (MergingException ignored) {
                    assert (false) : file + ": " + ignored.getMessage();
                    continue;
                }
            }
            return new ResourceFile(file, resourceList, qualifier, folderConfiguration);
        }
        ResourceType type = ResourceType.getEnum((String)typeAttr);
        if (type == null) {
            return null;
        }
        String nameAttr = NodeUtils.getAttribute(fileNode, "name");
        if (nameAttr == null) {
            return null;
        }
        if (this.getValidateEnabled()) {
            FileResourceNameValidator.validate(file, ResourceFolderType.getFolderType((String)file.getParentFile().getName()));
        }
        ResourceItem item = new ResourceItem(nameAttr, this.mNamespace, type, null, this.mLibraryName);
        return new ResourceFile(file, item, qualifier, folderConfiguration);
    }

    @Override
    protected void readSourceFolder(File sourceFolder, ILogger logger) throws MergingException {
        ArrayList errors = Lists.newArrayList();
        File[] folders = sourceFolder.listFiles();
        if (folders != null) {
            for (File folder : folders) {
                FolderData folderData;
                if (!folder.isDirectory() || this.isIgnored(folder) || (folderData = this.getFolderData(folder)) == null) continue;
                try {
                    this.parseFolder(sourceFolder, folder, folderData, logger);
                }
                catch (MergingException e) {
                    errors.addAll(e.getMessages());
                }
            }
        }
        MergingException.throwIfNonEmpty(errors);
    }

    @Override
    protected boolean isValidSourceFile(File sourceFolder, File file) {
        if (!super.isValidSourceFile(sourceFolder, file)) {
            return false;
        }
        File resFolder = file.getParentFile();
        return resFolder.getParentFile().equals(sourceFolder) && !this.isIgnored(resFolder) && ResourceFolderType.getFolderType((String)resFolder.getName()) != null;
    }

    @Override
    protected ResourceFile handleNewFile(File sourceFolder, File file, ILogger logger) throws MergingException {
        ResourceFile resourceFile = this.createFileAndItems(sourceFolder, file, logger);
        this.processNewResourceFile(sourceFolder, resourceFile);
        return resourceFile;
    }

    @Override
    protected boolean handleRemovedFile(File removedFile) {
        if (this.mGeneratedSet != null && this.mGeneratedSet.getDataFile(removedFile) != null) {
            return this.mGeneratedSet.handleRemovedFile(removedFile);
        }
        return super.handleRemovedFile(removedFile);
    }

    @Override
    protected boolean handleChangedFile(File sourceFolder, File changedFile, ILogger logger) throws MergingException {
        boolean needsPreprocessing;
        FolderData folderData = this.getFolderData(changedFile.getParentFile());
        if (folderData == null) {
            return true;
        }
        ResourceFile resourceFile = (ResourceFile)this.getDataFile(changedFile);
        if (this.mGeneratedSet == null) {
            this.doHandleChangedFile(changedFile, resourceFile);
            return true;
        }
        ResourceFile generatedSetResourceFile = (ResourceFile)this.mGeneratedSet.getDataFile(changedFile);
        boolean bl = needsPreprocessing = !this.getResourceItemsForGeneratedFilesIfNotFromDependency(changedFile).isEmpty();
        if (resourceFile != null && generatedSetResourceFile == null && needsPreprocessing) {
            this.handleRemovedFile(changedFile);
            this.mGeneratedSet.handleNewFile(sourceFolder, changedFile, logger);
        } else if (resourceFile == null && generatedSetResourceFile != null && !needsPreprocessing) {
            this.mGeneratedSet.handleRemovedFile(changedFile);
            this.handleNewFile(sourceFolder, changedFile, logger);
        } else if (resourceFile == null && generatedSetResourceFile != null && needsPreprocessing) {
            this.mGeneratedSet.handleChangedFile(sourceFolder, changedFile, logger);
        } else if (resourceFile != null && !needsPreprocessing && generatedSetResourceFile == null) {
            this.doHandleChangedFile(changedFile, resourceFile);
        } else {
            throw MergingException.withMessage("In DataSet '%s', no data file for changedFile. This is an internal error in the incremental builds code; to work around it, try doing a full clean build.", this.getConfigName()).withFile(changedFile).build();
        }
        return true;
    }

    private void doHandleChangedFile(File changedFile, ResourceFile resourceFile) throws MergingException {
        switch (resourceFile.getType()) {
            case SINGLE_FILE: {
                ((ResourceItem)resourceFile.getItem()).setTouched();
                break;
            }
            case GENERATED_FILES: {
                this.handleChangedItems(resourceFile, this.getResourceItemsForGeneratedFiles(changedFile));
                break;
            }
            case XML_VALUES: {
                ValueResourceParser2 parser = new ValueResourceParser2(changedFile, this.mNamespace, this.mLibraryName);
                parser.setTrackSourcePositions(this.mTrackSourcePositions);
                List<ResourceItem> parsedItems = parser.parseFile();
                this.handleChangedItems(resourceFile, parsedItems);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void handleChangedItems(ResourceFile resourceFile, List<ResourceItem> currentItems) throws MergingException {
        HashMap oldItems = Maps.newHashMap(resourceFile.getItemMap());
        HashMap addedItems = Maps.newHashMap();
        for (ResourceItem resourceItem : currentItems) {
            resourceItem.setSource(resourceFile);
        }
        for (ResourceItem resourceItem : currentItems) {
            String newKey = resourceItem.getKey();
            ResourceItem oldItem = (ResourceItem)oldItems.get(newKey);
            if (oldItem == null) {
                resourceItem.setTouched();
                addedItems.put(newKey, resourceItem);
                continue;
            }
            oldItems.remove(oldItem.getKey());
            if (((ResourceFile)oldItem.getSource()).getType() == DataFile.FileType.XML_VALUES) {
                if (oldItem.compareValueWith(resourceItem)) continue;
                oldItem.setValue(resourceItem);
                continue;
            }
            oldItem.setTouched();
        }
        for (ResourceItem resourceItem : oldItems.values()) {
            resourceItem.setRemoved();
        }
        for (Map.Entry entry : addedItems.entrySet()) {
            ((ResourceItem)entry.getValue()).setSource(null);
            this.addItem((DataItem)entry.getValue(), (String)entry.getKey());
        }
        resourceFile.addItems(addedItems.values());
    }

    private void parseFolder(File sourceFolder, File folder, FolderData folderData, ILogger logger) throws MergingException {
        File[] files = folder.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (!file.isFile() || this.isIgnored(file)) continue;
                ResourceFile resourceFile = this.createResourceFile(file, folderData, logger);
                this.processNewResourceFile(sourceFolder, resourceFile);
            }
        }
    }

    private void processNewResourceFile(File sourceFolder, ResourceFile resourceFile) throws MergingException {
        if (resourceFile != null) {
            if (resourceFile.getType() == DataFile.FileType.GENERATED_FILES && this.mGeneratedSet != null) {
                this.mGeneratedSet.processNewDataFile(sourceFolder, resourceFile, true);
            } else {
                this.processNewDataFile(sourceFolder, resourceFile, true);
            }
        }
    }

    private ResourceFile createResourceFile(File file, FolderData folderData, ILogger logger) throws MergingException {
        if (this.getValidateEnabled()) {
            FileResourceNameValidator.validate(file, folderData.folderType);
        }
        if (folderData.type != null) {
            List<ResourceItem> generatedFiles = this.getResourceItemsForGeneratedFilesIfNotFromDependency(file);
            if (!generatedFiles.isEmpty()) {
                return ResourceFile.generatedFiles(file, generatedFiles, folderData.qualifiers, folderData.folderConfiguration);
            }
            if (this.mShouldParseResourceIds && folderData.isIdGenerating && SdkUtils.endsWithIgnoreCase((String)file.getPath(), (String)".xml")) {
                List<ResourceItem> items;
                String resourceName = ResourceSet.getNameForFile(file);
                if (resourceName.isEmpty()) {
                    items = Collections.emptyList();
                } else {
                    IdGeneratingResourceParser parser = new IdGeneratingResourceParser(file, resourceName, folderData.type, this.mNamespace);
                    items = parser.getIdResourceItems();
                    ResourceItem fileItem = parser.getFileResourceItem();
                    items.add(fileItem);
                }
                return new ResourceFile(file, items, folderData.qualifiers, folderData.folderConfiguration);
            }
            return new ResourceFile(file, new ResourceItem(ResourceSet.getNameForFile(file), this.mNamespace, folderData.type, null, this.mLibraryName), folderData.qualifiers, folderData.folderConfiguration);
        }
        try {
            ValueResourceParser2 parser = new ValueResourceParser2(file, this.mNamespace, this.mLibraryName);
            parser.setTrackSourcePositions(this.mTrackSourcePositions);
            List<ResourceItem> items = parser.parseFile();
            return new ResourceFile(file, items, folderData.qualifiers, folderData.folderConfiguration);
        }
        catch (MergingException e) {
            logger.error((Throwable)e, "Failed to parse %s", new Object[]{file.getAbsolutePath()});
            throw e;
        }
    }

    private List<ResourceItem> getResourceItemsForGeneratedFilesIfNotFromDependency(File file) throws MergingException {
        if (this.mIsFromDependency) {
            return Collections.emptyList();
        }
        return this.getResourceItemsForGeneratedFiles(file);
    }

    private List<ResourceItem> getResourceItemsForGeneratedFiles(File file) throws MergingException {
        Collection<File> filesToBeGenerated;
        try {
            filesToBeGenerated = this.mPreprocessor.getFilesToBeGenerated(file);
        }
        catch (IOException e) {
            throw new MergingException(e, new Message[0]);
        }
        ArrayList<ResourceItem> resourceItems = new ArrayList<ResourceItem>(filesToBeGenerated.size());
        for (File generatedFile : filesToBeGenerated) {
            FolderData generatedFileFolderData = this.getFolderData(generatedFile.getParentFile());
            Preconditions.checkState((generatedFileFolderData != null ? 1 : 0) != 0, (String)"Can't determine folder type for %s", (Object)generatedFile.getPath());
            resourceItems.add(new GeneratedResourceItem(ResourceSet.getNameForFile(generatedFile), this.mNamespace, generatedFile, generatedFileFolderData.type, generatedFileFolderData.qualifiers, this.mLibraryName));
        }
        return resourceItems;
    }

    private static String getNameForFile(File file) {
        String name = file.getName();
        int pos = name.indexOf(46);
        if (pos >= 0) {
            name = name.substring(0, pos);
        }
        return name;
    }

    public boolean isFromDependency() {
        return this.mIsFromDependency;
    }

    public void setFromDependency(boolean fromDependency) {
        this.mIsFromDependency = fromDependency;
    }

    private FolderData getFolderData(File folder) throws MergingException {
        FolderData fd = new FolderData();
        String folderName = folder.getName();
        int pos = folderName.indexOf("-");
        if (pos != -1) {
            fd.folderType = ResourceFolderType.getTypeByName((String)folderName.substring(0, pos));
            if (fd.folderType == null) {
                return null;
            }
            FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForFolder(folderName);
            if (folderConfiguration == null) {
                throw MergingException.withMessage("Invalid resource directory name", new Object[0]).withFile(folder).build();
            }
            if (!this.mDontNormalizeQualifiers) {
                folderConfiguration.normalize();
            }
            fd.qualifiers = folderConfiguration.getUniqueKey().substring(1);
            fd.folderConfiguration = folderConfiguration;
        } else {
            fd.folderType = ResourceFolderType.getTypeByName((String)folderName);
        }
        if (fd.folderType != null && fd.folderType != ResourceFolderType.VALUES) {
            fd.type = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)fd.folderType);
            fd.isIdGenerating = FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)fd.folderType);
        }
        return fd;
    }

    @Override
    void appendToXml(Node setNode, Document document, MergeConsumer<ResourceItem> consumer, boolean includeTimestamps) {
        if (this.mGeneratedSet != null) {
            NodeUtils.addAttribute(document, setNode, null, ATTR_GENERATED_SET, this.mGeneratedSet.getConfigName());
        }
        if (this.mIsFromDependency) {
            NodeUtils.addAttribute(document, setNode, null, ATTR_FROM_DEPENDENCY, "true");
        }
        super.appendToXml(setNode, document, consumer, includeTimestamps);
    }

    public ResourceNamespace getNamespace() {
        return this.mNamespace;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceSet that = (ResourceSet)o;
        return this.mIsFromDependency == that.mIsFromDependency && this.mShouldParseResourceIds == that.mShouldParseResourceIds && this.mDontNormalizeQualifiers == that.mDontNormalizeQualifiers && this.mTrackSourcePositions == that.mTrackSourcePositions && Objects.equals(this.mNamespace, that.mNamespace) && Objects.equals(this.mLibraryName, that.mLibraryName) && Objects.equals(this.mGeneratedSet, that.mGeneratedSet) && Objects.equals(this.mPreprocessor, that.mPreprocessor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mLibraryName, this.mGeneratedSet, this.mPreprocessor, this.mIsFromDependency, this.mNamespace, this.mShouldParseResourceIds, this.mDontNormalizeQualifiers, this.mTrackSourcePositions);
    }

    private static class FolderData {
        String qualifiers = "";
        FolderConfiguration folderConfiguration = new FolderConfiguration();
        ResourceType type = null;
        ResourceFolderType folderType = null;
        boolean isIdGenerating = false;

        private FolderData() {
        }
    }
}

