/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.resources.DataFile;
import com.android.ide.common.resources.DataItem;
import com.android.ide.common.resources.MergingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class DuplicateDataException
extends MergingException {
    private static final String DUPLICATE_RESOURCES = "Duplicate resources";

    DuplicateDataException(Message[] messages) {
        super(null, messages);
    }

    static <I extends DataItem> Message[] createMessages(Collection<Collection<I>> duplicateDataItemSets) {
        ArrayList messages = Lists.newArrayListWithCapacity((int)duplicateDataItemSets.size());
        for (Collection<I> duplicateItems : duplicateDataItemSets) {
            ImmutableList.Builder positions = ImmutableList.builder();
            for (DataItem item : duplicateItems) {
                if (item.isRemoved()) continue;
                positions.add((Object)DuplicateDataException.getPosition(item));
            }
            messages.add(new Message(Message.Kind.ERROR, DUPLICATE_RESOURCES, DUPLICATE_RESOURCES, "Resource and asset merger", positions.build()));
        }
        return (Message[])Iterables.toArray((Iterable)messages, Message.class);
    }

    private static SourceFilePosition getPosition(DataItem item) {
        Object dataFile = item.getSource();
        if (dataFile == null) {
            return new SourceFilePosition(new SourceFile(item.getKey()), SourcePosition.UNKNOWN);
        }
        File f = ((DataFile)dataFile).getFile();
        SourcePosition sourcePosition = SourcePosition.UNKNOWN;
        return new SourceFilePosition(new SourceFile(f, item.getKey()), sourcePosition);
    }
}

