/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolJavaType;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.resources.ResourceAccessibility;
import com.android.resources.ResourceType;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class SymbolIo {
    public static final String ANDROID_ATTR_PREFIX = "android_";

    private SymbolIo() {
    }

    public static SymbolTable read(File file, String tablePackage) throws IOException {
        return SymbolIo.read(file, tablePackage, InOrderHandler::new, SymbolIo::readLine);
    }

    public static SymbolTable readFromAapt(File file, String tablePackage) throws IOException {
        return SymbolIo.read(file, tablePackage, AaptHandler::new, SymbolIo::readLine);
    }

    public static SymbolTable readFromPartialRFile(File file, String tablePackage) throws IOException {
        return SymbolIo.read(file, tablePackage, InOrderHandler::new, SymbolIo::readPartialRLine);
    }

    private static SymbolTable read(File file, String tablePackage, Function<String, StyleableIndexHandler> handlerFunction, LineReader lineReader) throws IOException {
        List<String> lines = Files.readAllLines(file.toPath(), Charsets.UTF_8);
        SymbolTable.Builder table = SymbolIo.readLines(lines, 1, file.toPath(), handlerFunction, lineReader);
        if (tablePackage != null) {
            table.tablePackage(tablePackage);
        }
        return table.build();
    }

    public static SymbolTable readTableWithPackage(File file) throws IOException {
        return SymbolIo.readTableWithPackage(file.toPath());
    }

    public static SymbolTable readTableWithPackage(Path file) throws IOException {
        List<String> lines = Files.readAllLines(file, Charsets.UTF_8);
        if (lines.isEmpty()) {
            throw new IOException("Internal error: Symbol file with package cannot be empty. File located at: " + file);
        }
        SymbolTable.Builder table = SymbolIo.readLines(lines, 2, file, InOrderHandler::new, SymbolIo::readLine);
        table.tablePackage(lines.get(0).trim());
        return table.build();
    }

    private static SymbolTable.Builder readLines(List<String> lines, int startLine, Path file, Function<String, StyleableIndexHandler> handlerFunction, LineReader lineReader) throws IOException {
        int lineIndex;
        SymbolTable.Builder table = SymbolTable.builder();
        String line = null;
        try {
            SymbolFilter symbolFilter = (resType, javaType) -> resType.equals(ResourceType.STYLEABLE.getName()) && javaType.equals(SymbolJavaType.INT.getTypeName());
            int count = lines.size();
            for (lineIndex = startLine; lineIndex <= count; ++lineIndex) {
                line = lines.get(lineIndex - 1);
                SymbolData data = lineReader.readLine(line, null);
                if (data.resourceType == ResourceType.STYLEABLE) {
                    SymbolData subData;
                    if (data.javaType != SymbolJavaType.INT_LIST) continue;
                    String data_name = data.name + "_";
                    StyleableIndexHandler indexHandler = handlerFunction.apply(data_name);
                    while (lineIndex < count && (subData = lineReader.readLine(lines.get(lineIndex), symbolFilter)) != null) {
                        ++lineIndex;
                        indexHandler.handle(subData);
                    }
                    table.add(Symbol.createSymbol(data.accessibility, data.resourceType, data.name, data.javaType, data.value, indexHandler.getChildrenNames()));
                    continue;
                }
                table.add(Symbol.createSymbol(data.accessibility, data.resourceType, data.name, data.javaType, data.value, (List<String>)ImmutableList.of()));
            }
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new IOException(String.format("File format error reading %s line %d: '%s'", file.toString(), lineIndex, line), e);
        }
        return table;
    }

    private static SymbolData readLine(String line, SymbolFilter filter2) throws IOException {
        int pos = line.indexOf(32);
        String typeName = line.substring(0, pos);
        SymbolJavaType type = SymbolJavaType.getEnum(typeName);
        if (type == null) {
            throw new IOException("Invalid symbol type " + typeName);
        }
        int pos2 = line.indexOf(32, pos + 1);
        String className = line.substring(pos + 1, pos2);
        if (filter2 != null && !filter2.validate(className, typeName)) {
            return null;
        }
        ResourceType resourceType = ResourceType.getEnum((String)className);
        if (resourceType == null) {
            throw new IOException("Invalid resource type " + className);
        }
        int pos3 = line.indexOf(32, pos2 + 1);
        String name = line.substring(pos2 + 1, pos3);
        String value = line.substring(pos3 + 1);
        return new SymbolData(resourceType, name, type, value);
    }

    private static SymbolData readPartialRLine(String line, SymbolFilter filter2) throws IOException {
        int pos = line.indexOf(32);
        String accessName = line.substring(0, pos);
        ResourceAccessibility accessibility = ResourceAccessibility.getEnum((String)accessName);
        if (accessibility == null) {
            throw new IOException("Invalid resource access qualifier " + accessName);
        }
        int pos2 = line.indexOf(32, pos + 1);
        String typeName = line.substring(pos + 1, pos2);
        SymbolJavaType type = SymbolJavaType.getEnum(typeName);
        if (type == null) {
            throw new IOException("Invalid symbol type " + typeName);
        }
        int pos3 = line.indexOf(32, pos2 + 1);
        String className = line.substring(pos2 + 1, pos3);
        if (filter2 != null && !filter2.validate(className, typeName)) {
            return null;
        }
        ResourceType resourceType = ResourceType.getEnum((String)className);
        if (resourceType == null) {
            throw new IOException("Invalid resource type " + className);
        }
        String name = line.substring(pos3 + 1);
        String value = type == SymbolJavaType.INT ? "0" : "{ }";
        return new SymbolData(accessibility, resourceType, name, type, value);
    }

    public static void write(SymbolTable table, File file) {
        SymbolIo.write(table, file.toPath(), null);
    }

    public static void write(SymbolTable table, Path file) {
        SymbolIo.write(table, file, null);
    }

    public static void write(SymbolTable table, Path file, String packageName) {
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));
             PrintWriter pw = new PrintWriter(os);){
            if (packageName != null) {
                pw.println(packageName);
            }
            for (ResourceType resType : ResourceType.values()) {
                List<Symbol> symbols2 = table.getSymbolByResourceType(resType);
                if (symbols2.isEmpty()) continue;
                for (Symbol s : symbols2) {
                    pw.print(s.getJavaType().getTypeName());
                    pw.print(' ');
                    pw.print(s.getResourceType().getName());
                    pw.print(' ');
                    pw.print(s.getName());
                    pw.print(' ');
                    pw.print(s.getValue());
                    pw.print('\n');
                    if (s.getJavaType() != SymbolJavaType.INT_LIST) continue;
                    Preconditions.checkArgument((s.getResourceType() == ResourceType.STYLEABLE ? 1 : 0) != 0, (Object)"Only resource type 'styleable' is allowed to have java type 'int[]'");
                    ImmutableList<String> children = s.getChildren();
                    for (int i = 0; i < children.size(); ++i) {
                        pw.print(SymbolJavaType.INT.getTypeName());
                        pw.print(' ');
                        pw.print(ResourceType.STYLEABLE.getName());
                        pw.print(' ');
                        pw.print(s.getName());
                        pw.print('_');
                        pw.print(SymbolUtils.canonicalizeValueResourceName((String)children.get(i)));
                        pw.print(' ');
                        pw.print(Integer.toString(i));
                        pw.print('\n');
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writePartialR(SymbolTable table, Path file) {
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));
             PrintWriter pw = new PrintWriter(os);){
            for (ResourceType resType : ResourceType.values()) {
                List<Symbol> symbols2 = table.getSymbolByResourceType(resType);
                if (symbols2.isEmpty()) continue;
                for (Symbol s : symbols2) {
                    pw.print(s.getResourceAccessibility().getName());
                    pw.print(' ');
                    pw.print(s.getJavaType().getTypeName());
                    pw.print(' ');
                    pw.print(s.getResourceType().getName());
                    pw.print(' ');
                    pw.print(s.getName());
                    pw.print('\n');
                    if (s.getJavaType() != SymbolJavaType.INT_LIST) continue;
                    Preconditions.checkArgument((s.getResourceType() == ResourceType.STYLEABLE ? 1 : 0) != 0, (Object)"Only resource type 'styleable' is allowed to have java type 'int[]'");
                    ImmutableList<String> children = s.getChildren();
                    for (int i = 0; i < children.size(); ++i) {
                        pw.print(s.getResourceAccessibility().getName());
                        pw.print(' ');
                        pw.print(SymbolJavaType.INT.getTypeName());
                        pw.print(' ');
                        pw.print(ResourceType.STYLEABLE.getName());
                        pw.print(' ');
                        pw.print(s.getName());
                        pw.print('_');
                        pw.print(SymbolUtils.canonicalizeValueResourceName((String)children.get(i)));
                        pw.print('\n');
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeSymbolTableWithPackage(Path symbolTable, Path manifest, Path outputFile) throws IOException {
        String packageName;
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(manifest, new OpenOption[0]));){
            packageName = AndroidManifestParser.parse(is).getPackage();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        SymbolIo.writeSymbolTableWithPackage(symbolTable, packageName, outputFile);
    }

    public static void writeSymbolTableWithPackage(SymbolTable symbolTable, String pkg, File outputFile) {
        SymbolIo.write(symbolTable, outputFile.toPath(), pkg);
    }

    public static void writeSymbolTableWithPackage(Path symbolTable, String packageName, Path outputFile) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(outputFile, new OpenOption[0]));){
            if (packageName != null) {
                ((OutputStream)os).write(packageName.getBytes(Charsets.UTF_8));
            }
            ((OutputStream)os).write(10);
            if (!Files.exists(symbolTable, new LinkOption[0])) {
                return;
            }
            try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(symbolTable, new OpenOption[0]));){
                ByteStreams.copy((InputStream)is, (OutputStream)os);
            }
        }
    }

    public static File exportToJava(SymbolTable table, File directory, boolean finalIds) {
        Preconditions.checkArgument((boolean)directory.isDirectory());
        Splitter splitter = Splitter.on((char)'.');
        Iterable directories = splitter.split((CharSequence)table.getTablePackage());
        File file = directory;
        for (String d : directories) {
            file = new File(file, d);
        }
        FileUtils.mkdirs((File)file);
        file = new File(file, "R.java");
        String idModifiers = finalIds ? "public static final" : "public static";
        try (PrintWriter pw = new PrintWriter(new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])));){
            pw.println("/* AUTO-GENERATED FILE.  DO NOT MODIFY.");
            pw.println(" *");
            pw.println(" * This class was automatically generated by the");
            pw.println(" * gradle plugin from the resource data it found. It");
            pw.println(" * should not be modified by hand.");
            pw.println(" */");
            if (!table.getTablePackage().isEmpty()) {
                pw.print("package ");
                pw.print(table.getTablePackage());
                pw.print(';');
                pw.println();
            }
            pw.println();
            pw.println("public final class R {");
            pw.println("    private R() {}");
            pw.println();
            String typeName = SymbolJavaType.INT.getTypeName();
            for (ResourceType resType : ResourceType.values()) {
                List<Symbol> symbols2 = table.getSymbolByResourceType(resType);
                if (symbols2.isEmpty()) continue;
                pw.print("    public static final class ");
                pw.print(resType.getName());
                pw.print(" {");
                pw.println();
                pw.print("        private ");
                pw.print(resType.getName());
                pw.println("() {}");
                pw.println();
                for (Symbol s : symbols2) {
                    String name = s.getName();
                    pw.print("        ");
                    pw.print(idModifiers);
                    pw.print(' ');
                    pw.print(s.getJavaType().getTypeName());
                    pw.print(' ');
                    pw.print(name);
                    pw.print(" = ");
                    pw.print(s.getValue());
                    pw.print(';');
                    pw.println();
                    if (s.getJavaType() != SymbolJavaType.INT_LIST) continue;
                    Preconditions.checkArgument((s.getResourceType() == ResourceType.STYLEABLE ? 1 : 0) != 0, (Object)"Only resource type 'styleable' is allowed to have java type 'int[]'");
                    ImmutableList<String> children = s.getChildren();
                    for (int i = 0; i < children.size(); ++i) {
                        pw.print("        ");
                        pw.print(idModifiers);
                        pw.print(' ');
                        pw.print(typeName);
                        pw.print(' ');
                        pw.print(name);
                        pw.print('_');
                        pw.print(SymbolUtils.canonicalizeValueResourceName((String)children.get(i)));
                        pw.print(" = ");
                        pw.print(i);
                        pw.print(';');
                        pw.println();
                    }
                }
                pw.print("    }");
                pw.println();
            }
            pw.print('}');
            pw.println();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return file;
    }

    private static class AaptHandler
    extends BaseHandler {
        private final List<SymbolData> allDatas = Lists.newArrayList();

        public AaptHandler(String prefix) {
            super(prefix);
        }

        @Override
        public void handle(SymbolData data) {
            this.allDatas.add(data);
        }

        @Override
        public List<String> getChildrenNames() throws IOException {
            try {
                this.allDatas.sort(Comparator.comparingInt(o -> Integer.parseInt(o.value)));
            }
            catch (NumberFormatException e) {
                throw new IOException(e);
            }
            return this.allDatas.stream().map(this::computeName).collect(Collectors.toList());
        }

        private String computeName(SymbolData data) {
            return this.computeItemName(data.name);
        }
    }

    private static class InOrderHandler
    extends BaseHandler {
        private final List<String> childrenNames = Lists.newArrayList();

        InOrderHandler(String prefix) {
            super(prefix);
        }

        @Override
        public void handle(SymbolData subData) {
            if (subData.name.startsWith(this.prefix)) {
                this.childrenNames.add(this.computeItemName(subData.name));
            }
        }

        @Override
        public List<String> getChildrenNames() {
            return ImmutableList.copyOf(this.childrenNames);
        }
    }

    private static abstract class BaseHandler
    implements StyleableIndexHandler {
        protected final String prefix;

        BaseHandler(String prefix) {
            this.prefix = prefix;
        }

        protected String computeItemName(String name) {
            String indexName = name.substring(this.prefix.length());
            if (indexName.startsWith(SymbolIo.ANDROID_ATTR_PREFIX)) {
                indexName = "android:" + indexName.substring(SymbolIo.ANDROID_ATTR_PREFIX.length());
            }
            return indexName;
        }
    }

    private static interface StyleableIndexHandler {
        public void handle(SymbolData var1);

        public List<String> getChildrenNames() throws IOException;
    }

    @FunctionalInterface
    private static interface LineReader {
        public SymbolData readLine(String var1, SymbolFilter var2) throws IOException;
    }

    @FunctionalInterface
    private static interface SymbolFilter {
        public boolean validate(String var1, String var2);
    }

    private static class SymbolData {
        final ResourceAccessibility accessibility;
        final ResourceType resourceType;
        final String name;
        final SymbolJavaType javaType;
        final String value;

        public SymbolData(ResourceType resourceType, String name, SymbolJavaType javaType, String value) {
            this.accessibility = ResourceAccessibility.DEFAULT;
            this.resourceType = resourceType;
            this.name = name;
            this.javaType = javaType;
            this.value = value;
        }

        public SymbolData(ResourceAccessibility accessibility, ResourceType resourceType, String name, SymbolJavaType javaType, String value) {
            this.accessibility = accessibility;
            this.resourceType = resourceType;
            this.name = name;
            this.javaType = javaType;
            this.value = value;
        }
    }
}

