/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolJavaType;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.resources.ResourceAccessibility;
import com.android.resources.ResourceType;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class SymbolIo {
    public static final String ANDROID_ATTR_PREFIX = "android_";

    private SymbolIo() {
    }

    public static SymbolTable read(File file, String tablePackage) throws IOException {
        return SymbolIo.read(file, tablePackage, ReadConfiguration.AAR);
    }

    public static SymbolTable readFromAapt(File file, String tablePackage) throws IOException {
        return SymbolIo.read(file, tablePackage, ReadConfiguration.AAPT);
    }

    public static SymbolTable readFromPartialRFile(File file, String tablePackage) throws IOException {
        return SymbolIo.read(file, tablePackage, ReadConfiguration.PARTIAL_FILE);
    }

    private static SymbolTable read(File file, String tablePackage, ReadConfiguration readConfiguration) throws IOException {
        SymbolTable.Builder table;
        try (Stream<String> lines = Files.lines(file.toPath(), Charsets.UTF_8);){
            table = new SymbolLineReader(readConfiguration, lines.iterator(), file.toPath(), 1).readLines();
        }
        if (tablePackage != null) {
            table.tablePackage(tablePackage);
        }
        return table.build();
    }

    public static SymbolTable readTableWithPackage(File file) throws IOException {
        return SymbolIo.readTableWithPackage(file.toPath());
    }

    public static SymbolTable readTableWithPackage(Path file) throws IOException {
        SymbolTable.Builder table;
        String tablePackage;
        try (Stream<String> lines = Files.lines(file, Charsets.UTF_8);){
            Iterator<String> linesIterator = lines.iterator();
            if (!linesIterator.hasNext()) {
                throw new IOException("Internal error: Symbol file with package cannot be empty. File located at: " + file);
            }
            tablePackage = ((String)linesIterator.next()).trim();
            table = new SymbolLineReader(ReadConfiguration.AAR, linesIterator, file, 2).readLines();
        }
        table.tablePackage(tablePackage);
        return table.build();
    }

    private static SymbolData readLine(String line, SymbolFilter filter2) throws IOException {
        int pos = line.indexOf(32);
        String typeName = line.substring(0, pos);
        SymbolJavaType type = SymbolJavaType.getEnum(typeName);
        if (type == null) {
            throw new IOException("Invalid symbol type " + typeName);
        }
        int pos2 = line.indexOf(32, pos + 1);
        String className = line.substring(pos + 1, pos2);
        if (filter2 != null && !filter2.validate(className, typeName)) {
            return null;
        }
        ResourceType resourceType = ResourceType.getEnum((String)className);
        if (resourceType == null) {
            throw new IOException("Invalid resource type " + className);
        }
        int pos3 = line.indexOf(32, pos2 + 1);
        String name = line.substring(pos2 + 1, pos3);
        String value = line.substring(pos3 + 1).trim();
        return new SymbolData(resourceType, name, type, value);
    }

    private static SymbolData readPartialRLine(String line, SymbolFilter filter2) throws IOException {
        int pos = line.indexOf(32);
        String accessName = line.substring(0, pos);
        ResourceAccessibility accessibility = ResourceAccessibility.getEnum((String)accessName);
        if (accessibility == null) {
            throw new IOException("Invalid resource access qualifier " + accessName);
        }
        int pos2 = line.indexOf(32, pos + 1);
        String typeName = line.substring(pos + 1, pos2);
        SymbolJavaType type = SymbolJavaType.getEnum(typeName);
        if (type == null) {
            throw new IOException("Invalid symbol type " + typeName);
        }
        int pos3 = line.indexOf(32, pos2 + 1);
        String className = line.substring(pos2 + 1, pos3);
        if (filter2 != null && !filter2.validate(className, typeName)) {
            return null;
        }
        ResourceType resourceType = ResourceType.getEnum((String)className);
        if (resourceType == null) {
            throw new IOException("Invalid resource type " + className);
        }
        String name = line.substring(pos3 + 1);
        String value = type == SymbolJavaType.INT ? "0x000000" : "{ }";
        return new SymbolData(accessibility, resourceType, name, type, value);
    }

    private static String computeItemName(String prefix, String name) {
        String indexName = name.substring(prefix.length());
        if (indexName.startsWith(ANDROID_ATTR_PREFIX)) {
            indexName = "android:" + indexName.substring(ANDROID_ATTR_PREFIX.length());
        }
        return indexName;
    }

    public static void write(SymbolTable table, File file) {
        SymbolIo.write(table, file.toPath(), null);
    }

    public static void write(SymbolTable table, Path file) {
        SymbolIo.write(table, file, null);
    }

    public static void write(SymbolTable table, Path file, String packageName) {
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));
             PrintWriter pw = new PrintWriter(os);){
            if (packageName != null) {
                pw.println(packageName);
            }
            for (ResourceType resType : ResourceType.values()) {
                List<Symbol> symbols2 = table.getSymbolByResourceType(resType);
                if (symbols2.isEmpty()) continue;
                for (Symbol s : symbols2) {
                    pw.print(s.getJavaType().getTypeName());
                    pw.print(' ');
                    pw.print(s.getResourceType().getName());
                    pw.print(' ');
                    pw.print(s.getName());
                    pw.print(' ');
                    if (s.getResourceType() != ResourceType.STYLEABLE) {
                        Symbol.NormalSymbol symbol = (Symbol.NormalSymbol)s;
                        pw.print("0x");
                        pw.print(Integer.toHexString(symbol.getIntValue()));
                        pw.print('\n');
                        continue;
                    }
                    Symbol.StyleableSymbol styleable = (Symbol.StyleableSymbol)s;
                    SymbolIo.writeStyleableValue(styleable, pw);
                    pw.print('\n');
                    ImmutableList<String> children = styleable.getChildren();
                    for (int i = 0; i < children.size(); ++i) {
                        pw.print(SymbolJavaType.INT.getTypeName());
                        pw.print(' ');
                        pw.print(ResourceType.STYLEABLE.getName());
                        pw.print(' ');
                        pw.print(s.getName());
                        pw.print('_');
                        pw.print(SymbolUtils.canonicalizeValueResourceName((String)children.get(i)));
                        pw.print(' ');
                        pw.print(Integer.toString(i));
                        pw.print('\n');
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void writeStyleableValue(Symbol.StyleableSymbol s, PrintWriter pw) {
        pw.print("{ ");
        ImmutableList<Integer> values = s.getValues();
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("0x");
            pw.print(Integer.toHexString((Integer)values.get(i)));
        }
        pw.print(" }");
    }

    public static void writePartialR(SymbolTable table, Path file) {
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));
             PrintWriter pw = new PrintWriter(os);){
            for (ResourceType resType : ResourceType.values()) {
                List<Symbol> symbols2 = table.getSymbolByResourceType(resType);
                if (symbols2.isEmpty()) continue;
                for (Symbol s : symbols2) {
                    pw.print(s.getResourceAccessibility().getName());
                    pw.print(' ');
                    pw.print(s.getJavaType().getTypeName());
                    pw.print(' ');
                    pw.print(s.getResourceType().getName());
                    pw.print(' ');
                    pw.print(s.getName());
                    pw.print('\n');
                    if (s.getResourceType() != ResourceType.STYLEABLE) continue;
                    ImmutableList<String> children = ((Symbol.StyleableSymbol)s).getChildren();
                    for (String child : children) {
                        pw.print(s.getResourceAccessibility().getName());
                        pw.print(' ');
                        pw.print(SymbolJavaType.INT.getTypeName());
                        pw.print(' ');
                        pw.print(ResourceType.STYLEABLE.getName());
                        pw.print(' ');
                        pw.print(s.getName());
                        pw.print('_');
                        pw.print(SymbolUtils.canonicalizeValueResourceName(child));
                        pw.print('\n');
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeSymbolTableWithPackage(Path symbolTable, Path manifest, Path outputFile) throws IOException {
        String packageName;
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(manifest, new OpenOption[0]));){
            packageName = AndroidManifestParser.parse(is).getPackage();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        SymbolIo.writeSymbolTableWithPackage(symbolTable, packageName, outputFile);
    }

    public static void writeSymbolTableWithPackage(SymbolTable symbolTable, String pkg, File outputFile) {
        SymbolIo.write(symbolTable, outputFile.toPath(), pkg);
    }

    public static void writeSymbolTableWithPackage(Path symbolTable, String packageName, Path outputFile) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(outputFile, new OpenOption[0]));){
            if (packageName != null) {
                ((OutputStream)os).write(packageName.getBytes(Charsets.UTF_8));
            }
            ((OutputStream)os).write(10);
            if (!Files.exists(symbolTable, new LinkOption[0])) {
                return;
            }
            try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(symbolTable, new OpenOption[0]));){
                ByteStreams.copy((InputStream)is, (OutputStream)os);
            }
        }
    }

    public static File exportToJava(SymbolTable table, File directory, boolean finalIds) {
        Preconditions.checkArgument((boolean)directory.isDirectory());
        Splitter splitter = Splitter.on((char)'.');
        Iterable directories = splitter.split((CharSequence)table.getTablePackage());
        File file = directory;
        for (String d : directories) {
            file = new File(file, d);
        }
        FileUtils.mkdirs((File)file);
        file = new File(file, "R.java");
        String idModifiers = finalIds ? "public static final" : "public static";
        try (PrintWriter pw = new PrintWriter(new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])));){
            pw.println("/* AUTO-GENERATED FILE.  DO NOT MODIFY.");
            pw.println(" *");
            pw.println(" * This class was automatically generated by the");
            pw.println(" * gradle plugin from the resource data it found. It");
            pw.println(" * should not be modified by hand.");
            pw.println(" */");
            if (!table.getTablePackage().isEmpty()) {
                pw.print("package ");
                pw.print(table.getTablePackage());
                pw.print(';');
                pw.println();
            }
            pw.println();
            pw.println("public final class R {");
            pw.println("    private R() {}");
            pw.println();
            String typeName = SymbolJavaType.INT.getTypeName();
            for (ResourceType resType : ResourceType.values()) {
                List<Symbol> symbols2 = table.getSymbolByResourceType(resType);
                if (symbols2.isEmpty()) continue;
                pw.print("    public static final class ");
                pw.print(resType.getName());
                pw.print(" {");
                pw.println();
                pw.print("        private ");
                pw.print(resType.getName());
                pw.println("() {}");
                pw.println();
                for (Symbol s : symbols2) {
                    String name = s.getName();
                    pw.print("        ");
                    pw.print(idModifiers);
                    pw.print(' ');
                    pw.print(s.getJavaType().getTypeName());
                    pw.print(' ');
                    pw.print(name);
                    pw.print(" = ");
                    if (s.getResourceType() != ResourceType.STYLEABLE) {
                        Symbol.NormalSymbol symbol = (Symbol.NormalSymbol)s;
                        pw.print("0x");
                        pw.print(Integer.toHexString(symbol.getIntValue()));
                        pw.print(';');
                        pw.println();
                        continue;
                    }
                    Symbol.StyleableSymbol styleable = (Symbol.StyleableSymbol)s;
                    SymbolIo.writeStyleableValue(styleable, pw);
                    pw.print(';');
                    pw.println();
                    ImmutableList<String> children = styleable.getChildren();
                    for (int i = 0; i < children.size(); ++i) {
                        pw.print("        ");
                        pw.print(idModifiers);
                        pw.print(' ');
                        pw.print(typeName);
                        pw.print(' ');
                        pw.print(name);
                        pw.print('_');
                        pw.print(SymbolUtils.canonicalizeValueResourceName((String)children.get(i)));
                        pw.print(" = ");
                        pw.print(i);
                        pw.print(';');
                        pw.println();
                    }
                }
                pw.print("    }");
                pw.println();
            }
            pw.print('}');
            pw.println();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return file;
    }

    private static enum ReadConfiguration {
        AAR(true, true, true){

            @Override
            public SymbolData parseLine(String line, SymbolFilter filter2) throws IOException {
                return SymbolIo.readLine(line, filter2);
            }
        }
        ,
        AAPT(true, false, false){

            @Override
            public SymbolData parseLine(String line, SymbolFilter filter2) throws IOException {
                return SymbolIo.readLine(line, filter2);
            }
        }
        ,
        LOCAL(true, false, false){

            @Override
            public SymbolData parseLine(String line, SymbolFilter filter2) throws IOException {
                return SymbolIo.readLine(line, filter2);
            }
        }
        ,
        PARTIAL_FILE(false, true, false){

            @Override
            public SymbolData parseLine(String line, SymbolFilter filter2) throws IOException {
                return SymbolIo.readPartialRLine(line, filter2);
            }
        };

        final boolean readValues;
        final boolean numericallySortedStyleableChildren;
        final boolean bestEffortMisorderedFile;

        private ReadConfiguration(boolean readValues, boolean numericallySortedStyleableChildren, boolean bestEffortMisorderedFile) {
            this.readValues = readValues;
            this.numericallySortedStyleableChildren = numericallySortedStyleableChildren;
            this.bestEffortMisorderedFile = bestEffortMisorderedFile;
        }

        abstract SymbolData parseLine(String var1, SymbolFilter var2) throws IOException;
    }

    @FunctionalInterface
    private static interface SymbolFilter {
        public boolean validate(String var1, String var2);
    }

    private static class SymbolData {
        final ResourceAccessibility accessibility;
        final ResourceType resourceType;
        final String name;
        final SymbolJavaType javaType;
        final String value;

        public SymbolData(ResourceType resourceType, String name, SymbolJavaType javaType, String value) {
            this.accessibility = ResourceAccessibility.DEFAULT;
            this.resourceType = resourceType;
            this.name = name;
            this.javaType = javaType;
            this.value = value;
        }

        public SymbolData(ResourceAccessibility accessibility, ResourceType resourceType, String name, SymbolJavaType javaType, String value) {
            this.accessibility = accessibility;
            this.resourceType = resourceType;
            this.name = name;
            this.javaType = javaType;
            this.value = value;
        }
    }

    private static class SymbolLineReader {
        private final SymbolTable.Builder table = SymbolTable.builder();
        private final Iterator<String> lines;
        private final Path file;
        private final ReadConfiguration readConfiguration;
        private int currentLineNumber;
        private String currentLineContent;
        private final List<String> styleableChildrenCache = new ArrayList<String>(10);
        private final List<SymbolData> aaptStyleableChildrenCache = new ArrayList<SymbolData>(10);
        private static final SymbolFilter ONLY_STYLEABLE_CHILDREN = (resType, javaType) -> resType.equals(ResourceType.STYLEABLE.getName()) && javaType.equals(SymbolJavaType.INT.getTypeName());
        private static final Comparator<SymbolData> SYMBOL_DATA_VALUE_COMPARATOR = Comparator.comparingInt(o -> Integer.parseInt(o.value));

        SymbolLineReader(ReadConfiguration readConfiguration, Iterator<String> lines, Path file, int startLine) {
            this.readConfiguration = readConfiguration;
            this.lines = lines;
            this.file = file;
            this.currentLineNumber = startLine - 1;
        }

        private void readNextLine() {
            if (!this.lines.hasNext()) {
                this.currentLineContent = null;
            } else {
                this.currentLineContent = this.lines.next();
                ++this.currentLineNumber;
            }
        }

        SymbolTable.Builder readLines() throws IOException {
            if (!this.lines.hasNext()) {
                return this.table;
            }
            this.readNextLine();
            try {
                while (this.currentLineContent != null) {
                    SymbolData data = this.readConfiguration.parseLine(this.currentLineContent, null);
                    if (data.resourceType == ResourceType.STYLEABLE) {
                        switch (data.javaType) {
                            case INT: {
                                if (!this.readConfiguration.bestEffortMisorderedFile) {
                                    throw new IOException("Unexpected stylable child " + this.currentLineContent);
                                }
                                this.readNextLine();
                                break;
                            }
                            case INT_LIST: {
                                this.readNextLine();
                                this.handleStyleable(this.table, data);
                            }
                        }
                        continue;
                    }
                    int value = 0;
                    if (this.readConfiguration.readValues) {
                        value = SymbolUtils.valueStringToInt(data.value);
                    }
                    this.table.add(new Symbol.NormalSymbol(data.resourceType, data.name, value, data.accessibility));
                    this.readNextLine();
                }
            }
            catch (IOException | IndexOutOfBoundsException e) {
                throw new IOException(String.format("File format error reading %1$s line %2$d: '%3$s'", this.file.toString(), this.currentLineNumber, this.currentLineContent), e);
            }
            return this.table;
        }

        private void handleStyleable(SymbolTable.Builder table, SymbolData data) throws IOException {
            ImmutableList<Integer> values;
            ImmutableList childNames;
            SymbolData subData;
            String styleableLineContent = this.currentLineContent;
            int styleableLineIndex = this.currentLineNumber;
            String data_name = data.name + "_";
            this.styleableChildrenCache.clear();
            this.aaptStyleableChildrenCache.clear();
            while (this.currentLineContent != null && (subData = this.readConfiguration.parseLine(this.currentLineContent, ONLY_STYLEABLE_CHILDREN)) != null) {
                if (this.readConfiguration.numericallySortedStyleableChildren) {
                    if (subData.name.startsWith(data_name)) {
                        this.styleableChildrenCache.add(SymbolIo.computeItemName(data_name, subData.name));
                    } else if (!this.readConfiguration.bestEffortMisorderedFile) {
                        throw new IOException("Unexpected styleable child " + subData.name);
                    }
                } else {
                    this.aaptStyleableChildrenCache.add(subData);
                }
                this.readNextLine();
            }
            if (this.readConfiguration.numericallySortedStyleableChildren) {
                childNames = ImmutableList.copyOf(this.styleableChildrenCache);
            } else {
                try {
                    this.aaptStyleableChildrenCache.sort(SYMBOL_DATA_VALUE_COMPARATOR);
                }
                catch (NumberFormatException e) {
                    this.currentLineContent = styleableLineContent;
                    this.currentLineNumber = styleableLineIndex;
                    throw new IOException(e);
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                for (SymbolData aaptStyleableChild : this.aaptStyleableChildrenCache) {
                    builder.add((Object)SymbolIo.computeItemName(data_name, aaptStyleableChild.name));
                }
                childNames = builder.build();
            }
            if (this.readConfiguration.readValues) {
                try {
                    if (this.readConfiguration.bestEffortMisorderedFile) {
                        values = SymbolUtils.parseArrayLiteralLenient(data.value);
                    }
                    values = SymbolUtils.parseArrayLiteral(childNames.size(), data.value);
                }
                catch (NumberFormatException e) {
                    this.currentLineContent = styleableLineContent;
                    this.currentLineNumber = styleableLineIndex;
                    throw new IOException("Unable to parse array literal " + data.name + " = " + data.value, e);
                }
            } else {
                values = ImmutableList.of();
            }
            table.add(new Symbol.StyleableSymbol(data.name, values, (ImmutableList<String>)childNames, data.accessibility));
        }
    }
}

