/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.SdkConstants;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceValuesXmlParseException;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.resources.ResourceType;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ResourceValuesXmlParser {
    private ResourceValuesXmlParser() {
    }

    public static SymbolTable parse(Document xmlDocument, IdProvider idProvider, SymbolTable platformAttrSymbols) {
        Element root = xmlDocument.getDocumentElement();
        if (root == null) {
            throw new ResourceValuesXmlParseException("XML document does not have a root element.");
        }
        if (!"resources".equals(root.getTagName())) {
            throw new ResourceValuesXmlParseException("XML document root is not 'resources'");
        }
        if (root.getNamespaceURI() != null) {
            throw new ResourceValuesXmlParseException("XML document root has a namespace");
        }
        SymbolTable.Builder builder = SymbolTable.builder();
        ArrayList<Symbol> enumSymbols = new ArrayList<Symbol>();
        for (Node current = root.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getNodeType() != 1) continue;
            ResourceValuesXmlParser.parseChild((Element)current, builder, idProvider, enumSymbols, platformAttrSymbols);
        }
        for (Symbol enumSymbol : enumSymbols) {
            if (builder.contains(enumSymbol)) continue;
            builder.add(enumSymbol);
        }
        return builder.build();
    }

    private static void parseChild(Element child, SymbolTable.Builder builder, IdProvider idProvider, List<Symbol> enumSymbols, SymbolTable platformAttrSymbols) {
        ResourceType resourceType;
        String type = child.getTagName();
        if (type.equals("eat-comment")) {
            return;
        }
        if (type.equals("item")) {
            type = child.getAttribute("type");
        }
        if (type.contains(":")) {
            type = type.substring(type.lastIndexOf(58) + 1, type.length());
        }
        if ((resourceType = ResourceType.getEnum((String)type)) == null) {
            throw new ResourceValuesXmlParseException("Unknown resource value XML element '" + type + "'");
        }
        if (resourceType == ResourceType.PUBLIC) {
            return;
        }
        String name = SymbolUtils.canonicalizeValueResourceName(ResourceValuesXmlParser.getMandatoryAttr(child, "name"));
        switch (resourceType) {
            case ANIM: 
            case ANIMATOR: 
            case ARRAY: 
            case BOOL: 
            case COLOR: 
            case DIMEN: 
            case DRAWABLE: 
            case FONT: 
            case FRACTION: 
            case ID: 
            case INTEGER: 
            case INTERPOLATOR: 
            case LAYOUT: 
            case MENU: 
            case MIPMAP: 
            case PLURALS: 
            case RAW: 
            case STRING: 
            case STYLE: 
            case TRANSITION: 
            case XML: {
                builder.add(Symbol.createAndValidateSymbol(resourceType, name, idProvider));
                break;
            }
            case DECLARE_STYLEABLE: {
                ResourceValuesXmlParser.parseDeclareStyleable(child, idProvider, name, builder, enumSymbols, platformAttrSymbols);
                break;
            }
            case ATTR: {
                ResourceValuesXmlParser.parseAttr(child, idProvider, name, builder, enumSymbols);
                break;
            }
            case PUBLIC: {
                throw new AssertionError((Object)"Already checked above.");
            }
            default: {
                throw new ResourceValuesXmlParseException("Unknown resource value XML element '" + type + "'");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseDeclareStyleable(Element declareStyleable, IdProvider idProvider, String name, SymbolTable.Builder builder, List<Symbol> enumSymbols, SymbolTable platformAttrSymbols) {
        ImmutableList.Builder attrValues = ImmutableList.builder();
        ArrayList<String> attrNames = new ArrayList<String>();
        Node attrNode = declareStyleable.getFirstChild();
        while (attrNode != null) {
            if (attrNode.getNodeType() != 1) {
                attrNode = attrNode.getNextSibling();
                continue;
            }
            Element attrElement = (Element)attrNode;
            String tagName = attrElement.getTagName();
            if (tagName.equals("item")) {
                tagName = attrElement.getAttribute("type");
            }
            if (!tagName.equals(ResourceType.ATTR.getName()) || attrElement.getNamespaceURI() != null) {
                if (!tagName.equals("eat-comment")) throw new ResourceValuesXmlParseException(String.format("Illegal type under declare-styleable: was <%s>, only accepted is <attr>", tagName));
                attrNode = attrNode.getNextSibling();
                continue;
            }
            String attrName = ResourceValuesXmlParser.getMandatoryAttr(attrElement, "name");
            if (attrName.startsWith("android:")) {
                if (platformAttrSymbols == null) {
                    attrName = SymbolUtils.canonicalizeValueResourceName(attrName);
                    attrValues.add((Object)-1);
                } else {
                    String realAttrName = attrName.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
                    Symbol attrSymbol = (Symbol)platformAttrSymbols.getSymbols().get((Object)ResourceType.ATTR, (Object)realAttrName);
                    if (attrSymbol == null) throw new ResourceValuesXmlParseException(String.format("Unknown android attribute '%s'", name));
                    attrValues.add((Object)((Symbol.NormalSymbol)attrSymbol).getIntValue());
                }
            } else {
                attrName = SymbolUtils.canonicalizeValueResourceName(attrName);
                attrValues.add((Object)ResourceValuesXmlParser.parseAttr(attrElement, idProvider, attrName, builder, enumSymbols));
            }
            attrNames.add(attrName);
            attrNode = attrNode.getNextSibling();
        }
        builder.add(Symbol.createAndValidateStyleableSymbol(name, (ImmutableList<Integer>)attrValues.build(), attrNames));
    }

    private static int parseAttr(Element attr, IdProvider idProvider, String name, SymbolTable.Builder builder, List<Symbol> enumSymbols) {
        Node enumNode = attr.getFirstChild();
        while (enumNode != null) {
            if (enumNode.getNodeType() != 1) {
                enumNode = enumNode.getNextSibling();
                continue;
            }
            Element enumElement = (Element)enumNode;
            String tagName = enumElement.getTagName();
            if (tagName.equals("item")) {
                tagName = enumElement.getAttribute("type");
            }
            if (!tagName.equals("enum") || enumElement.getNamespaceURI() != null) {
                enumNode = enumNode.getNextSibling();
                continue;
            }
            Symbol.NormalSymbol newEnum = Symbol.createAndValidateSymbol(ResourceType.ID, SymbolUtils.canonicalizeValueResourceName(ResourceValuesXmlParser.getMandatoryAttr(enumElement, "name")), idProvider);
            enumSymbols.add(newEnum);
            enumNode = enumNode.getNextSibling();
        }
        Symbol.NormalSymbol newAttr = Symbol.createAndValidateSymbol(ResourceType.ATTR, name, idProvider);
        if (!builder.contains(newAttr)) {
            builder.add(newAttr);
            return newAttr.getIntValue();
        }
        return Objects.requireNonNull((Symbol.NormalSymbol)builder.get(newAttr)).getIntValue();
    }

    private static String getMandatoryAttr(Element element, String attrName) {
        Attr attr = element.getAttributeNodeNS(null, attrName);
        if (attr == null) {
            throw new ResourceValuesXmlParseException("Element '" + element.getTagName() + "' should have attribute '" + attrName + "'");
        }
        return attr.getValue();
    }
}

