/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.SdkConstants;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.resources.ResourceType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a(\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007\u001a&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0007\u001a\u001e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0002\u001a\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000fH\u0007\u001a\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0!H\u0007\u001a,\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u001f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0&2\u0006\u0010'\u001a\u00020\u001f\u001a\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u0006\u001a\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0007\u001a\u000e\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0006\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"NORMALIZED_VALUE_NAME_CHARS", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "VALUE_ID_SPLITTER", "Lcom/google/common/base/Splitter;", "canonicalizeValueResourceName", "", "name", "generateKeepRules", "", "manifest", "Lcom/android/ide/common/xml/ManifestData;", "isMainDex", "", "mergedResources", "Ljava/io/File;", "generateKeepRulesFromLayoutXmlFile", "", "layout", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "rules", "", "generateKeepRulesFromXmlNode", "node", "Lorg/w3c/dom/Element;", "generateMinifyKeepRules", "getPackageNameFromManifest", "manifestFile", "loadDependenciesSymbolTables", "Lcom/google/common/collect/ImmutableSet;", "Lcom/android/ide/common/symbols/SymbolTable;", "libraries", "", "mergeAndRenumberSymbols", "mainPackageName", "librarySymbols", "dependencySymbols", "", "platformSymbols", "parseArrayLiteral", "Lcom/google/common/collect/ImmutableList;", "", "size", "valuesString", "parseManifest", "valueStringToInt", "valueString", "sdk-common"})
@JvmName(name="SymbolUtils")
public final class SymbolUtils {
    private static final CharMatcher NORMALIZED_VALUE_NAME_CHARS = CharMatcher.anyOf((CharSequence)".:").precomputed();
    private static final Splitter VALUE_ID_SPLITTER = Splitter.on((char)',').trimResults();

    @NotNull
    public static final SymbolTable mergeAndRenumberSymbols(@NotNull String mainPackageName, @NotNull SymbolTable librarySymbols, @NotNull Collection<? extends SymbolTable> dependencySymbols, @NotNull SymbolTable platformSymbols) {
        Object $i$a$1$forEach;
        Intrinsics.checkParameterIsNotNull((Object)mainPackageName, (String)"mainPackageName");
        Intrinsics.checkParameterIsNotNull((Object)librarySymbols, (String)"librarySymbols");
        Intrinsics.checkParameterIsNotNull(dependencySymbols, (String)"dependencySymbols");
        Intrinsics.checkParameterIsNotNull((Object)platformSymbols, (String)"platformSymbols");
        ArrayList<? extends SymbolTable> tables = new ArrayList<SymbolTable>(dependencySymbols.size() + 1);
        tables.add(librarySymbols);
        tables.addAll(dependencySymbols);
        IdProvider idProvider = IdProvider.sequential();
        HashMultimap newSymbolMap = HashMultimap.create();
        HashMultimap arrayToAttrs = HashMultimap.create();
        Iterable $receiver$iv = tables;
        for (Object element$iv : $receiver$iv) {
            SymbolTable table = (SymbolTable)element$iv;
            ImmutableCollection immutableCollection = table.getSymbols().values();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableCollection, (String)"table.symbols.values()");
            Iterable $receiver$iv2 = (Iterable)immutableCollection;
            for (Object element$iv2 : $receiver$iv2) {
                Symbol symbol = (Symbol)element$iv2;
                Symbol symbol2 = symbol;
                if (symbol2 instanceof Symbol.NormalSymbol) {
                    newSymbolMap.put((Object)symbol.getResourceType(), (Object)symbol.getName());
                    continue;
                }
                if (symbol2 instanceof Symbol.StyleableSymbol) {
                    arrayToAttrs.putAll((Object)symbol.getName(), (Iterable)symbol.getChildren());
                    continue;
                }
                throw (Throwable)new IllegalStateException("Unexpected symbol " + symbol);
            }
        }
        SymbolTable.Builder tableBuilder = SymbolTable.Companion.builder().tablePackage(mainPackageName);
        HashMap attrToValue = new HashMap();
        for (ResourceType resourceType : newSymbolMap.keySet()) {
            ArrayList symbolNames;
            ArrayList arrayList = symbolNames = Lists.newArrayList((Iterable)newSymbolMap.get((Object)resourceType));
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"symbolNames");
            CollectionsKt.sort((List)arrayList);
            for (String symbolName : symbolNames) {
                int value = idProvider.next(resourceType);
                ResourceType resourceType2 = resourceType;
                Intrinsics.checkExpressionValueIsNotNull((Object)resourceType2, (String)"resourceType");
                String string = symbolName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"symbolName");
                Symbol.NormalSymbol newSymbol = new Symbol.NormalSymbol(resourceType2, string, value, null, 8, null);
                tableBuilder.add(newSymbol);
                if (!Intrinsics.areEqual((Object)resourceType, (Object)ResourceType.ATTR)) continue;
                $i$a$1$forEach = attrToValue;
                String string2 = symbolName;
                Symbol.NormalSymbol normalSymbol = newSymbol;
                $i$a$1$forEach.put(string2, normalSymbol);
            }
        }
        for (String arrayName : arrayToAttrs.keySet()) {
            ArrayList attributes;
            ArrayList arrayList = attributes = Lists.newArrayList((Iterable)arrayToAttrs.get((Object)arrayName));
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"attributes");
            CollectionsKt.sort((List)arrayList);
            ImmutableList.Builder attributeValues = ImmutableList.builder();
            Iterator iterator = attributes.iterator();
            while (iterator.hasNext()) {
                String attribute;
                String string = attribute = (String)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"attribute");
                if (StringsKt.startsWith$default((String)string, (String)"android:", (boolean)false, (int)2, null)) {
                    String name;
                    $i$a$1$forEach = attribute;
                    int n = SdkConstants.ANDROID_NS_NAME_PREFIX_LEN;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((String)$i$a$1$forEach).substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                    Symbol.NormalSymbol platformSymbol = (Symbol.NormalSymbol)platformSymbols.getSymbols().get((Object)ResourceType.ATTR, (Object)name);
                    if (platformSymbol == null) continue;
                    attributeValues.add((Object)platformSymbol.getIntValue());
                    continue;
                }
                Symbol.NormalSymbol symbol = (Symbol.NormalSymbol)attrToValue.get(attribute);
                if (symbol == null) continue;
                attributeValues.add((Object)symbol.getIntValue());
            }
            String string = arrayName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"arrayName");
            ImmutableList immutableList = attributeValues.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"attributeValues.build()");
            ImmutableList immutableList2 = ImmutableList.copyOf((Collection)attributes);
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList2, (String)"ImmutableList.copyOf(attributes)");
            tableBuilder.add(new Symbol.StyleableSymbol(string, immutableList, immutableList2, null, 8, null));
        }
        return tableBuilder.build();
    }

    @NotNull
    public static final ImmutableSet<SymbolTable> loadDependenciesSymbolTables(@NotNull Iterable<? extends File> libraries) throws IOException {
        ImmutableSet.Builder builder;
        Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
        ImmutableSet.Builder $receiver = builder = ImmutableSet.builder();
        for (File file : libraries) {
            $receiver.add((Object)SymbolIo.readSymbolListWithPackageName(file.toPath()));
        }
        ImmutableSet immutableSet = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"ImmutableSet.builder<Sym\u2026)\n        }\n    }.build()");
        return immutableSet;
    }

    @NotNull
    public static final String getPackageNameFromManifest(@NotNull File manifestFile) throws IOException {
        ManifestData manifestData;
        ManifestData manifestData2;
        Intrinsics.checkParameterIsNotNull((Object)manifestFile, (String)"manifestFile");
        try {
            manifestData2 = AndroidManifestParser.parse((IAbstractFile)new FileWrapper(manifestFile));
        }
        catch (SAXException e) {
            throw (Throwable)new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath() + '\'', e);
        }
        catch (IOException e) {
            throw (Throwable)new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath() + '\'', e);
        }
        ManifestData manifestData3 = manifestData = manifestData2;
        Intrinsics.checkExpressionValueIsNotNull((Object)manifestData3, (String)"manifestData");
        String string = manifestData3.getPackage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"manifestData.`package`");
        return string;
    }

    @NotNull
    public static final String getPackageNameFromManifest(@NotNull ManifestData manifest) {
        Intrinsics.checkParameterIsNotNull((Object)manifest, (String)"manifest");
        String string = manifest.getPackage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"manifest.`package`");
        return string;
    }

    @NotNull
    public static final List<String> generateMinifyKeepRules(@NotNull ManifestData manifest, @Nullable File mergedResources) {
        Intrinsics.checkParameterIsNotNull((Object)manifest, (String)"manifest");
        return SymbolUtils.generateKeepRules(manifest, false, mergedResources);
    }

    @VisibleForTesting
    @NotNull
    public static final List<String> generateKeepRules(@NotNull ManifestData manifest, boolean isMainDex, @Nullable File mergedResources) {
        File[] fileArray;
        Intrinsics.checkParameterIsNotNull((Object)manifest, (String)"manifest");
        ArrayList<String> rules = new ArrayList<String>();
        rules.add("# Generated by the gradle plugin");
        ManifestData.KeepClass[] keepClassArray = manifest.getKeepClasses();
        for (int i = 0; i < keepClassArray.length; ++i) {
            String string;
            Object object;
            ManifestData.KeepClass keepClass = keepClassArray[i];
            if (isMainDex) {
                ManifestData.KeepClass keepClass2 = keepClass;
                Intrinsics.checkExpressionValueIsNotNull((Object)keepClass2, (String)"keepClass");
                String type = keepClass2.getType();
                String process = keepClass.getProcess();
                if (!(!Intrinsics.areEqual((Object)type, (Object)"activity") && !Intrinsics.areEqual((Object)type, (Object)"service") && !Intrinsics.areEqual((Object)type, (Object)"provider") && !Intrinsics.areEqual((Object)type, (Object)"receiver") || process != null && !((object = (CharSequence)process).length() == 0) && !StringsKt.startsWith$default((String)process, (String)":", (boolean)false, (int)2, null))) continue;
            }
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            fileArray = "-keep class %s { <init>(...); }";
            Object[] objectArray = new Object[1];
            ManifestData.KeepClass keepClass3 = keepClass;
            Intrinsics.checkExpressionValueIsNotNull((Object)keepClass3, (String)"keepClass");
            objectArray[0] = keepClass3.getName();
            object = objectArray;
            ArrayList<String> arrayList = rules;
            Object object2 = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format((String)fileArray, Arrays.copyOf(object2, ((Object)object2).length)), (String)"java.lang.String.format(format, *args)");
            arrayList.add(string);
        }
        if (mergedResources != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                fileArray = mergedResources.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File typeDir;
                    File file = typeDir = fileArray[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"typeDir");
                    if (!file.isDirectory()) continue;
                    String string = typeDir.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"typeDir.name");
                    if (!StringsKt.startsWith$default((String)string, (String)"layout", (boolean)false, (int)2, null)) continue;
                    File[] fileArray2 = typeDir.listFiles();
                    for (int j = 0; j < fileArray2.length; ++j) {
                        File layoutXml;
                        File file2 = layoutXml = fileArray2[j];
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"layoutXml");
                        if (!file2.isFile()) continue;
                        DocumentBuilder documentBuilder2 = documentBuilder;
                        Intrinsics.checkExpressionValueIsNotNull((Object)documentBuilder2, (String)"documentBuilder");
                        SymbolUtils.generateKeepRulesFromLayoutXmlFile(layoutXml, documentBuilder2, (List<String>)rules);
                    }
                }
            }
            catch (ParserConfigurationException e) {
                throw (Throwable)new IOException("Failed to read merged resources", e);
            }
        }
        CollectionsKt.sort((List)rules);
        return rules;
    }

    public static final void generateKeepRulesFromLayoutXmlFile(@NotNull File layout, @NotNull DocumentBuilder documentBuilder, @NotNull List<String> rules) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)layout, (String)"layout");
        Intrinsics.checkParameterIsNotNull((Object)documentBuilder, (String)"documentBuilder");
        Intrinsics.checkParameterIsNotNull(rules, (String)"rules");
        try {
            Document xmlDocument;
            Document document = xmlDocument = documentBuilder.parse(layout);
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"xmlDocument");
            Element root = document.getDocumentElement();
            if (root != null) {
                SymbolUtils.generateKeepRulesFromXmlNode(root, rules);
            }
        }
        catch (SAXException e) {
            throw (Throwable)new IOException("Failed to parse XML resource file " + layout.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw (Throwable)new IOException("Failed to parse XML resource file " + layout.getAbsolutePath(), e);
        }
    }

    private static final void generateKeepRulesFromXmlNode(Element node, List<String> rules) {
        String tag;
        String string = tag = node.getTagName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tag");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)".", (boolean)false, (int)2, null)) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "-keep class %s { <init>(...); }";
            Object[] objectArray = new Object[]{tag};
            List<String> list = rules;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String string4 = string3;
            list.add(string4);
        }
        for (Node current = node.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getNodeType() != 1) continue;
            SymbolUtils.generateKeepRulesFromXmlNode((Element)current, rules);
        }
    }

    @NotNull
    public static final ManifestData parseManifest(@NotNull File manifestFile) throws IOException {
        ManifestData manifestData;
        Intrinsics.checkParameterIsNotNull((Object)manifestFile, (String)"manifestFile");
        try {
            ManifestData manifestData2 = AndroidManifestParser.parse((IAbstractFile)new FileWrapper(manifestFile));
            Intrinsics.checkExpressionValueIsNotNull((Object)manifestData2, (String)"AndroidManifestParser.pa\u2026ileWrapper(manifestFile))");
            manifestData = manifestData2;
        }
        catch (SAXException e) {
            throw (Throwable)new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw (Throwable)new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath(), e);
        }
        return manifestData;
    }

    @NotNull
    public static final String canonicalizeValueResourceName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String string = NORMALIZED_VALUE_NAME_CHARS.replaceFrom((CharSequence)name, '_');
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"NORMALIZED_VALUE_NAME_CHARS.replaceFrom(name, '_')");
        return string;
    }

    public static final int valueStringToInt(@NotNull String valueString) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)valueString, (String)"valueString");
        if (StringsKt.startsWith$default((String)valueString, (String)"0x", (boolean)false, (int)2, null)) {
            String string = valueString;
            int n2 = 2;
            String string2 = string.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            n = Integer.parseUnsignedInt(string2, 16);
        } else {
            n = Integer.parseInt(valueString);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ImmutableList<Integer> parseArrayLiteral(int size, @NotNull String valuesString) {
        Intrinsics.checkParameterIsNotNull((Object)valuesString, (String)"valuesString");
        if (size == 0) {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
            return immutableList;
        }
        ImmutableList.Builder ints = ImmutableList.builder();
        Iterator values = VALUE_ID_SPLITTER.split(valuesString.subSequence(1, valuesString.length() - 1)).iterator();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            if (!values.hasNext()) {
                throw (Throwable)new IllegalArgumentException("Values string " + valuesString + " should have " + size + " items.");
            }
            Object t = values.next();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"values.next()");
            ints.add((Object)SymbolUtils.valueStringToInt((String)t));
            ++i;
        }
        if (values.hasNext()) {
            throw (Throwable)new IllegalArgumentException("Values string " + valuesString + " should have " + size + " items.");
        }
        ImmutableList immutableList = ints.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ints.build()");
        return immutableList;
    }
}

