/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.SdkConstants;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceValuesXmlParseException;
import com.android.ide.common.symbols.ResourceValuesXmlParser$WhenMappings;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.resources.ResourceType;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a6\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u001a@\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u001a \u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a8\u0006\u001a"}, d2={"getMandatoryAttr", "", "element", "Lorg/w3c/dom/Element;", "attrName", "parseAttr", "", "attr", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "name", "builder", "Lcom/android/ide/common/symbols/SymbolTable$Builder;", "enumSymbols", "", "Lcom/android/ide/common/symbols/Symbol;", "parseChild", "", "child", "platformAttrSymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "parseDeclareStyleable", "declareStyleable", "parseValuesResource", "xmlDocument", "Lorg/w3c/dom/Document;", "sdk-common"})
@JvmName(name="ResourceValuesXmlParser")
public final class ResourceValuesXmlParser {
    @NotNull
    public static final SymbolTable parseValuesResource(@NotNull Document xmlDocument, @NotNull IdProvider idProvider, @Nullable SymbolTable platformAttrSymbols) {
        Intrinsics.checkParameterIsNotNull((Object)xmlDocument, (String)"xmlDocument");
        Intrinsics.checkParameterIsNotNull((Object)idProvider, (String)"idProvider");
        Element element = xmlDocument.getDocumentElement();
        if (element == null) {
            throw (Throwable)new ResourceValuesXmlParseException("XML document does not have a root element.");
        }
        Element root = element;
        if (Intrinsics.areEqual((Object)root.getTagName(), (Object)"resources") ^ true) {
            throw (Throwable)new ResourceValuesXmlParseException("XML document root is not 'resources'");
        }
        if (root.getNamespaceURI() != null) {
            throw (Throwable)new ResourceValuesXmlParseException("XML document root has a namespace");
        }
        SymbolTable.Builder builder = SymbolTable.Companion.builder();
        ArrayList enumSymbols = new ArrayList();
        for (Node current = root.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getNodeType() != 1) continue;
            ResourceValuesXmlParser.parseChild((Element)current, builder, idProvider, enumSymbols, platformAttrSymbols);
        }
        Iterator iterator = enumSymbols.iterator();
        while (iterator.hasNext()) {
            Symbol enumSymbol;
            Symbol symbol = enumSymbol = (Symbol)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)symbol, (String)"enumSymbol");
            if (builder.contains(symbol)) continue;
            builder.add(enumSymbol);
        }
        return builder.build();
    }

    private static final void parseChild(Element child, SymbolTable.Builder builder, IdProvider idProvider, List<Symbol> enumSymbols, SymbolTable platformAttrSymbols) {
        String type = child.getTagName();
        if (Intrinsics.areEqual((Object)type, (Object)"eat-comment")) {
            return;
        }
        if (Intrinsics.areEqual((Object)type, (Object)"item")) {
            type = child.getAttribute("type");
        }
        String string = type;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)":", (boolean)false, (int)2, null)) {
            String string2 = type;
            int n = StringsKt.lastIndexOf$default((CharSequence)type, (char)':', (int)0, (boolean)false, (int)6, null) + 1;
            int n2 = type.length();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            type = string3;
        }
        ResourceType resourceType = ResourceType.getEnum((String)type);
        if (resourceType == null) {
            throw (Throwable)new ResourceValuesXmlParseException("Unknown resource value XML element '" + type + '\'');
        }
        ResourceType resourceType2 = resourceType;
        if (Intrinsics.areEqual((Object)resourceType2, (Object)ResourceType.PUBLIC)) {
            return;
        }
        String name = SymbolUtils.canonicalizeValueResourceName(ResourceValuesXmlParser.getMandatoryAttr(child, "name"));
        switch (ResourceValuesXmlParser$WhenMappings.$EnumSwitchMapping$0[resourceType2.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                builder.add(Symbol.Companion.createAndValidateSymbol(resourceType2, name, idProvider));
                break;
            }
            case 22: {
                ResourceValuesXmlParser.parseDeclareStyleable(child, idProvider, name, builder, enumSymbols, platformAttrSymbols);
                break;
            }
            case 23: {
                ResourceValuesXmlParser.parseAttr(child, idProvider, name, builder, enumSymbols);
                break;
            }
            case 24: {
                throw (Throwable)((Object)new AssertionError((Object)"Already checked above."));
            }
            default: {
                throw (Throwable)new ResourceValuesXmlParseException("Unknown resource value XML element '" + type + '\'');
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void parseDeclareStyleable(Element declareStyleable, IdProvider idProvider, String name, SymbolTable.Builder builder, List<Symbol> enumSymbols, SymbolTable platformAttrSymbols) {
        ImmutableList.Builder attrValues = ImmutableList.builder();
        ArrayList<String> attrNames = new ArrayList<String>();
        Node attrNode = declareStyleable.getFirstChild();
        while (true) {
            if (attrNode == null) {
                ImmutableList immutableList = attrValues.build();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"attrValues.build()");
                builder.add(Symbol.Companion.createAndValidateStyleableSymbol(name, (ImmutableList<Integer>)immutableList, (List<String>)attrNames));
                return;
            }
            if (attrNode.getNodeType() != 1) {
                attrNode = attrNode.getNextSibling();
                continue;
            }
            Element attrElement = (Element)attrNode;
            String tagName = attrElement.getTagName();
            if (Intrinsics.areEqual((Object)tagName, (Object)"item")) {
                tagName = attrElement.getAttribute("type");
            }
            if (Intrinsics.areEqual((Object)tagName, (Object)ResourceType.ATTR.getName()) ^ true || attrElement.getNamespaceURI() != null) {
                if (!Intrinsics.areEqual((Object)tagName, (Object)"eat-comment")) {
                    throw (Throwable)new ResourceValuesXmlParseException("Illegal type under declare-styleable: was <" + tagName + ">, only accepted is " + "<attr>");
                }
                attrNode = ((Element)attrNode).getNextSibling();
                continue;
            }
            String attrName = ResourceValuesXmlParser.getMandatoryAttr(attrElement, "name");
            if (StringsKt.startsWith$default((String)attrName, (String)"android:", (boolean)false, (int)2, null)) {
                if (platformAttrSymbols == null) {
                    attrName = SymbolUtils.canonicalizeValueResourceName(attrName);
                    attrValues.add((Object)-1);
                } else {
                    String realAttrName;
                    String string = attrName;
                    int n = SdkConstants.ANDROID_NS_NAME_PREFIX_LEN;
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                    Symbol attrSymbol = (Symbol)platformAttrSymbols.getSymbols().get((Object)ResourceType.ATTR, (Object)realAttrName);
                    if (attrSymbol == null) {
                        ResourceValuesXmlParseException resourceValuesXmlParseException;
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string3 = "Unknown android attribute '%s'";
                        Object[] objectArray = new Object[]{name};
                        ResourceValuesXmlParseException resourceValuesXmlParseException2 = resourceValuesXmlParseException;
                        ResourceValuesXmlParseException resourceValuesXmlParseException3 = resourceValuesXmlParseException;
                        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
                        String string5 = string4;
                        resourceValuesXmlParseException2(string5);
                        throw (Throwable)resourceValuesXmlParseException3;
                    }
                    attrValues.add((Object)((Symbol.NormalSymbol)attrSymbol).getIntValue());
                }
            } else {
                attrName = SymbolUtils.canonicalizeValueResourceName(attrName);
                attrValues.add((Object)ResourceValuesXmlParser.parseAttr(attrElement, idProvider, attrName, builder, enumSymbols));
            }
            attrNames.add(attrName);
            attrNode = ((Element)attrNode).getNextSibling();
        }
    }

    private static final int parseAttr(Element attr, IdProvider idProvider, String name, SymbolTable.Builder builder, List<Symbol> enumSymbols) {
        Node enumNode = attr.getFirstChild();
        while (enumNode != null) {
            if (enumNode.getNodeType() != 1) {
                enumNode = enumNode.getNextSibling();
                continue;
            }
            Element enumElement = (Element)enumNode;
            String tagName = enumElement.getTagName();
            if (Intrinsics.areEqual((Object)tagName, (Object)"item")) {
                tagName = enumElement.getAttribute("type");
            }
            if (Intrinsics.areEqual((Object)tagName, (Object)"enum") ^ true || enumElement.getNamespaceURI() != null) {
                enumNode = ((Element)enumNode).getNextSibling();
                continue;
            }
            Symbol.NormalSymbol newEnum = Symbol.Companion.createAndValidateSymbol(ResourceType.ID, SymbolUtils.canonicalizeValueResourceName(ResourceValuesXmlParser.getMandatoryAttr(enumElement, "name")), idProvider);
            enumSymbols.add(newEnum);
            enumNode = ((Element)enumNode).getNextSibling();
        }
        Symbol.NormalSymbol newAttr = Symbol.Companion.createAndValidateSymbol(ResourceType.ATTR, name, idProvider);
        if (!builder.contains(newAttr)) {
            builder.add(newAttr);
            return newAttr.getIntValue();
        }
        Symbol symbol = builder.get(newAttr);
        if (symbol == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.ide.common.symbols.Symbol.NormalSymbol");
        }
        return ((Symbol.NormalSymbol)symbol).getIntValue();
    }

    private static final String getMandatoryAttr(Element element, String attrName) {
        Attr attr = element.getAttributeNodeNS(null, attrName);
        if (attr == null) {
            throw (Throwable)new ResourceValuesXmlParseException("Element '" + element.getTagName() + "' should have attribute '" + attrName + '\'');
        }
        Attr attr2 = attr;
        String string = attr2.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"attr.value");
        return string;
    }
}

