/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SampleDataResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.sampledata.SampleDataManager;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceResolver
extends RenderResources {
    public static final String THEME_NAME = "Theme";
    public static final String THEME_NAME_DOT = "Theme.";
    public static final String LEGACY_THEME = "";
    public static final Pattern DEVICE_DEFAULT_PATTERN = Pattern.compile("(\\p{Alpha}+)?\\.?DeviceDefault\\.?(.+)?");
    private final Map<ResourceNamespace, Map<ResourceType, ResourceValueMap>> mResources;
    private final Map<StyleResourceValue, StyleResourceValue> mStyleInheritanceMap = new HashMap<StyleResourceValue, StyleResourceValue>();
    private final Multimap<StyleResourceValue, StyleResourceValue> mReverseStyleInheritanceMap = HashMultimap.create();
    private final StyleResourceValue mDefaultTheme;
    private final List<StyleResourceValue> mThemes;
    private Predicate<ResourceReference> mProjectIdChecker = res -> false;
    private LayoutLog mLogger;
    private String mDeviceDefaultParent;
    private SampleDataManager mSampleDataManager = new SampleDataManager();

    private ResourceResolver(Map<ResourceNamespace, Map<ResourceType, ResourceValueMap>> resources, StyleResourceValue theme) {
        this.mResources = resources;
        this.mDefaultTheme = theme;
        this.mThemes = new LinkedList<StyleResourceValue>();
    }

    public static ResourceResolver create(Map<ResourceNamespace, Map<ResourceType, ResourceValueMap>> resources, ResourceReference themeReference) {
        StyleResourceValue theme = null;
        if (themeReference != null) {
            assert (themeReference.getResourceType() == ResourceType.STYLE);
            theme = ResourceResolver.findTheme(themeReference, resources);
        }
        ResourceResolver resolver = new ResourceResolver(resources, theme);
        resolver.preProcessStyles();
        return resolver;
    }

    private static StyleResourceValue findTheme(ResourceReference themeReference, Map<ResourceNamespace, Map<ResourceType, ResourceValueMap>> resources) {
        Map<ResourceType, ResourceValueMap> namespaceMap = resources.get(themeReference.getNamespace());
        if (namespaceMap == null) {
            return null;
        }
        ResourceValueMap stylesMap = namespaceMap.get(ResourceType.STYLE);
        if (stylesMap == null) {
            return null;
        }
        ResourceValue resourceValue = (ResourceValue)stylesMap.get(themeReference.getName());
        return resourceValue instanceof StyleResourceValue ? (StyleResourceValue)resourceValue : null;
    }

    public static ResourceResolver copy(ResourceResolver original) {
        if (original == null) {
            return null;
        }
        ResourceResolver resolver = new ResourceResolver(original.mResources, original.mDefaultTheme);
        resolver.mProjectIdChecker = original.mProjectIdChecker;
        resolver.mLogger = original.mLogger;
        resolver.mStyleInheritanceMap.putAll(original.mStyleInheritanceMap);
        resolver.mReverseStyleInheritanceMap.putAll(original.mReverseStyleInheritanceMap);
        resolver.mThemes.addAll(original.mThemes);
        return resolver;
    }

    public static ResourceResolver withValues(ResourceValue ... values) {
        return ResourceResolver.withValues(Arrays.asList(values), null);
    }

    public static ResourceResolver withValues(Iterable<ResourceValue> values, ResourceReference themeReference) {
        HashMap<ResourceNamespace, Map<ResourceType, ResourceValueMap>> resources = new HashMap<ResourceNamespace, Map<ResourceType, ResourceValueMap>>();
        for (ResourceValue value : values) {
            Map byType = resources.computeIfAbsent(value.getNamespace(), ns -> new EnumMap(ResourceType.class));
            ResourceValueMap resourceValueMap = byType.computeIfAbsent(value.getResourceType(), t -> ResourceValueMap.create());
            Preconditions.checkArgument((!resourceValueMap.containsKey(value.getName()) ? 1 : 0) != 0, (Object)("Duplicate resource: " + value));
            resourceValueMap.put(value);
        }
        return ResourceResolver.create(resources, themeReference);
    }

    private ResourceValueMap getResourceValueMap(ResourceNamespace namespace, ResourceType type) {
        Map<ResourceType, ResourceValueMap> row = this.mResources.get(namespace);
        return row != null ? row.get(type) : null;
    }

    public void setDeviceDefaults(String deviceDefaultParent) {
        if (deviceDefaultParent.equals(this.mDeviceDefaultParent)) {
            return;
        }
        this.mDeviceDefaultParent = deviceDefaultParent;
        String parentName = Strings.emptyToNull((String)deviceDefaultParent);
        ResourceValueMap frameworkStyles = this.getResourceValueMap(ResourceNamespace.ANDROID, ResourceType.STYLE);
        if (frameworkStyles == null) {
            return;
        }
        for (ResourceValue value : frameworkStyles.values()) {
            Matcher matcher = DEVICE_DEFAULT_PATTERN.matcher(value.getName());
            if (!matcher.matches()) continue;
            String newParentStyle = Joiner.on((char)'.').skipNulls().join((Object)matcher.group(1), (Object)parentName, new Object[]{matcher.groupCount() > 1 ? matcher.group(2) : null});
            this.patchFrameworkStyleParent(value.getName(), newParentStyle);
        }
    }

    private void patchFrameworkStyleParent(String childStyleName, String parentName) {
        ResourceValueMap map = this.getResourceValueMap(ResourceNamespace.ANDROID, ResourceType.STYLE);
        if (map != null) {
            StyleResourceValue from = (StyleResourceValue)map.get(childStyleName);
            StyleResourceValue to = (StyleResourceValue)map.get(parentName);
            if (from != null && to != null) {
                StyleResourceValue newStyle = new StyleResourceValue(from.asReference(), parentName, from.getLibraryName());
                newStyle.replaceWith((ResourceValue)from);
                this.mStyleInheritanceMap.put(newStyle, to);
                this.mReverseStyleInheritanceMap.clear();
            }
        }
    }

    public StyleResourceValue getTheme() {
        return this.mDefaultTheme;
    }

    @Deprecated
    public Map<ResourceType, ResourceValueMap> getProjectResources() {
        return this.mResources.get(ResourceNamespace.RES_AUTO);
    }

    @Deprecated
    public Map<ResourceType, ResourceValueMap> getFrameworkResources() {
        return this.mResources.get(ResourceNamespace.ANDROID);
    }

    public void setProjectIdChecker(Predicate<ResourceReference> predicate) {
        this.mProjectIdChecker = predicate;
    }

    public void setLogger(LayoutLog logger) {
        this.mLogger = logger;
    }

    public StyleResourceValue getDefaultTheme() {
        return this.mDefaultTheme;
    }

    public void applyStyle(StyleResourceValue theme, boolean useAsPrimary) {
        if (theme == null) {
            return;
        }
        if (useAsPrimary) {
            this.mThemes.add(0, theme);
        } else {
            this.mThemes.add(theme);
        }
    }

    public void clearStyles() {
        this.mThemes.clear();
        if (this.mDefaultTheme != null) {
            this.mThemes.add(this.mDefaultTheme);
        }
    }

    public List<StyleResourceValue> getAllThemes() {
        return this.mThemes;
    }

    public boolean themeIsParentOf(StyleResourceValue parentTheme, StyleResourceValue childTheme) {
        do {
            if ((childTheme = this.mStyleInheritanceMap.get(childTheme)) != null) continue;
            return false;
        } while (childTheme != parentTheme);
        return true;
    }

    public ItemResourceValue findItemInStyle(StyleResourceValue style, ResourceReference attr) {
        return this.findItemInStyle(style, attr, 0);
    }

    private ItemResourceValue findItemInStyle(StyleResourceValue style, ResourceReference attr, int depth) {
        StyleResourceValue parentStyle;
        ItemResourceValue item = style.getItem(attr);
        if (item == null && (parentStyle = this.mStyleInheritanceMap.get(style)) != null) {
            if (depth >= 50) {
                if (this.mLogger != null) {
                    this.mLogger.error("broken", String.format("Cyclic style parent definitions: %1$s", this.computeCyclicStyleChain(style)), null, null, null);
                }
                return null;
            }
            return this.findItemInStyle(parentStyle, attr, depth + 1);
        }
        return item;
    }

    private String computeCyclicStyleChain(StyleResourceValue style) {
        StringBuilder sb = new StringBuilder(100);
        this.appendStyleParents(style, new HashSet<StyleResourceValue>(), 0, sb);
        return sb.toString();
    }

    private void appendStyleParents(StyleResourceValue style, Set<StyleResourceValue> seen, int depth, StringBuilder sb) {
        if (depth >= 50) {
            sb.append("...");
            return;
        }
        boolean haveSeen = seen.contains(style);
        seen.add(style);
        sb.append('\"');
        sb.append(style.getResourceUrl().getQualifiedName());
        sb.append('\"');
        if (haveSeen) {
            return;
        }
        StyleResourceValue parentStyle = this.mStyleInheritanceMap.get(style);
        if (parentStyle != null) {
            if (style.getParentStyleName() != null) {
                sb.append(" specifies parent ");
            } else {
                sb.append(" implies parent ");
            }
            this.appendStyleParents(parentStyle, seen, depth + 1, sb);
        }
    }

    public ResourceValue getUnresolvedResource(ResourceReference reference) {
        ResourceValueMap resourceValueMap = this.getResourceValueMap(reference.getNamespace(), reference.getResourceType());
        if (resourceValueMap != null) {
            return (ResourceValue)resourceValueMap.get(reference.getName());
        }
        return null;
    }

    public ResourceValue dereference(ResourceValue value) {
        ResourceReference reference = value.getReference();
        if (reference == null || !ResourceUrl.isValidName((String)reference.getName(), (ResourceType)reference.getResourceType())) {
            return null;
        }
        assert (value.getValue() != null);
        if (value.getValue().startsWith("?")) {
            if (this.mDefaultTheme == null) {
                return null;
            }
            if (reference.getResourceType() != ResourceType.ATTR) {
                return null;
            }
            return this.findItemInTheme(reference);
        }
        if (reference.getResourceType() == ResourceType.AAPT) {
            return null;
        }
        if (reference.getResourceType() == ResourceType.SAMPLE_DATA) {
            return this.findSampleDataValue(reference);
        }
        ResourceValue result = this.getUnresolvedResource(reference);
        if (result != null) {
            return result;
        }
        if (value.getValue().startsWith("@+id/")) {
            return null;
        }
        if (reference.getResourceType() == ResourceType.ID) {
            boolean idExists;
            boolean bl = idExists = reference.isFramework() || this.mProjectIdChecker.test(reference);
            if (idExists) {
                return new ResourceValue(reference, null);
            }
        }
        if (this.mLogger != null) {
            this.mLogger.warning("resources.resolve", "Couldn't resolve resource " + reference.getResourceUrl(), null, (Object)reference);
        }
        return null;
    }

    public ResourceValue resolveResValue(ResourceValue resValue) {
        for (int depth = 0; depth < 50; ++depth) {
            if (resValue == null) {
                return null;
            }
            String value = resValue.getValue();
            if (value == null || resValue instanceof ArrayResourceValue) {
                return resValue;
            }
            ResourceValue resolvedResValue = this.dereference(resValue);
            if (resolvedResValue == null) {
                return resValue;
            }
            if (resValue == resolvedResValue) break;
            resValue = resolvedResValue;
        }
        if (this.mLogger != null) {
            this.mLogger.error("broken", String.format("Potential stack overflow trying to resolve '%s': cyclic resource definitions? Render may not be accurate.", resValue.getValue()), null, null, null);
        }
        return resValue;
    }

    private ResourceValue findSampleDataValue(ResourceReference value) {
        String name = value.getName();
        return Optional.ofNullable(this.getResourceValueMap(value.getNamespace(), value.getResourceType())).map(t -> (ResourceValue)t.get(SampleDataManager.getResourceNameFromSampleReference(name))).filter(SampleDataResourceValue.class::isInstance).map(SampleDataResourceValue.class::cast).map(SampleDataResourceValue::getValueAsLines).map(content -> this.mSampleDataManager.getSampleDataLine(name, (ImmutableList<String>)content)).map(lineContent -> new ResourceValue(value.getNamespace(), ResourceType.SAMPLE_DATA, name, lineContent)).orElse(null);
    }

    private void preProcessStyles() {
        if (this.mDefaultTheme == null) {
            return;
        }
        this.mDeviceDefaultParent = null;
        for (Map<ResourceType, ResourceValueMap> mapForNamespace : this.mResources.values()) {
            ResourceValueMap styles = mapForNamespace.get(ResourceType.STYLE);
            if (styles == null) continue;
            for (ResourceValue value : styles.values()) {
                ResourceValue parentStyle;
                if (!(value instanceof StyleResourceValue)) continue;
                StyleResourceValue style = (StyleResourceValue)value;
                ResourceReference parent = style.getParentStyle();
                if (parent != null && (parentStyle = this.getUnresolvedResource(parent)) instanceof StyleResourceValue) {
                    this.mStyleInheritanceMap.put(style, (StyleResourceValue)parentStyle);
                    continue;
                }
                if (this.mLogger == null) continue;
                this.mLogger.error("resources.resolve", String.format("Unable to resolve parent style name: %s", style.getParentStyleName()), null, null, null);
            }
        }
        this.clearStyles();
    }

    private void computeReverseStyleInheritance() {
        for (Map.Entry<StyleResourceValue, StyleResourceValue> entry : this.mStyleInheritanceMap.entrySet()) {
            this.mReverseStyleInheritanceMap.put((Object)entry.getValue(), (Object)entry.getKey());
        }
    }

    public StyleResourceValue getParent(StyleResourceValue style) {
        return this.mStyleInheritanceMap.get(style);
    }

    public Collection<StyleResourceValue> getChildren(StyleResourceValue style) {
        if (this.mReverseStyleInheritanceMap.isEmpty()) {
            this.computeReverseStyleInheritance();
        }
        return this.mReverseStyleInheritanceMap.get((Object)style);
    }

    public boolean styleExtends(StyleResourceValue child, StyleResourceValue ancestor) {
        StyleResourceValue current = child;
        while (current != null) {
            if (current.equals((Object)ancestor)) {
                return true;
            }
            current = this.getParent(current);
        }
        return false;
    }

    public StyleResourceValue getStyle(ResourceReference styleReference) {
        ResourceValue style = this.getUnresolvedResource(styleReference);
        if (style == null) {
            return null;
        }
        if (style instanceof StyleResourceValue) {
            return (StyleResourceValue)style;
        }
        if (this.mLogger != null) {
            this.mLogger.error(null, String.format("Style %1$s is not of type STYLE (instead %2$s)", styleReference, style.getResourceType().toString()), null, null, (Object)styleReference);
        }
        return null;
    }

    public boolean isTheme(ResourceValue value, Map<ResourceValue, Boolean> cache) {
        return this.isTheme(value, cache, 0);
    }

    private boolean isTheme(ResourceValue value, Map<ResourceValue, Boolean> cache, int depth) {
        Boolean known;
        if (cache != null && (known = cache.get(value)) != null) {
            return known;
        }
        if (value instanceof StyleResourceValue) {
            StyleResourceValue srv = (StyleResourceValue)value;
            String name = srv.getName();
            if (srv.getNamespace() == ResourceNamespace.ANDROID && (name.equals(THEME_NAME) || name.startsWith(THEME_NAME_DOT))) {
                if (cache != null) {
                    cache.put(value, true);
                }
                return true;
            }
            StyleResourceValue parentStyle = this.mStyleInheritanceMap.get(srv);
            if (parentStyle != null) {
                if (depth >= 50) {
                    if (this.mLogger != null) {
                        this.mLogger.error("broken", String.format("Cyclic style parent definitions: %1$s", this.computeCyclicStyleChain(srv)), null, null, null);
                    }
                    return false;
                }
                boolean result = this.isTheme((ResourceValue)parentStyle, cache, depth + 1);
                if (cache != null) {
                    cache.put(value, result);
                }
                return result;
            }
        }
        return false;
    }

    public ResourceResolver createRecorder(List<ResourceValue> lookupChain) {
        RecordingResourceResolver resolver = new RecordingResourceResolver(lookupChain, this.mResources, this.mDefaultTheme);
        resolver.mLogger = this.mLogger;
        resolver.mStyleInheritanceMap.putAll(this.mStyleInheritanceMap);
        resolver.mThemes.addAll(this.mThemes);
        return resolver;
    }

    private static class RecordingResourceResolver
    extends ResourceResolver {
        private List<ResourceValue> mLookupChain;

        private RecordingResourceResolver(List<ResourceValue> lookupChain, Map<ResourceNamespace, Map<ResourceType, ResourceValueMap>> resources, StyleResourceValue theme) {
            super(resources, theme);
            this.mLookupChain = lookupChain;
        }

        @Override
        public ResourceValue resolveResValue(ResourceValue resValue) {
            if (resValue != null) {
                this.mLookupChain.add(resValue);
            }
            return super.resolveResValue(resValue);
        }

        @Override
        public ResourceValue dereference(ResourceValue value) {
            ResourceValue resValue;
            if (!this.mLookupChain.isEmpty() && !this.mLookupChain.get(this.mLookupChain.size() - 1).equals((Object)value)) {
                this.mLookupChain.add(value);
            }
            if ((resValue = super.dereference(value)) != null) {
                this.mLookupChain.add(resValue);
            }
            return resValue;
        }

        @Override
        public ItemResourceValue findItemInStyle(StyleResourceValue style, ResourceReference attr) {
            ItemResourceValue value = super.findItemInStyle(style, attr);
            if (value != null) {
                this.mLookupChain.add((ResourceValue)value);
            }
            return value;
        }

        public ResourceValue findItemInTheme(ResourceReference attr) {
            ResourceValue value = super.findItemInTheme(attr);
            if (value != null) {
                this.mLookupChain.add(value);
            }
            return value;
        }
    }
}

