/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.SymbolJavaType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0004H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u0082\u0001\u0002\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lcom/android/ide/common/symbols/Symbol;", "", "()V", "canonicalName", "", "getCanonicalName", "()Ljava/lang/String;", "children", "Lcom/google/common/collect/ImmutableList;", "getChildren", "()Lcom/google/common/collect/ImmutableList;", "javaType", "Lcom/android/ide/common/symbols/SymbolJavaType;", "getJavaType", "()Lcom/android/ide/common/symbols/SymbolJavaType;", "resourceType", "Lcom/android/resources/ResourceType;", "getResourceType", "()Lcom/android/resources/ResourceType;", "resourceVisibility", "Lcom/android/resources/ResourceVisibility;", "getResourceVisibility", "()Lcom/android/resources/ResourceVisibility;", "getValue", "Companion", "NormalSymbol", "StyleableSymbol", "Lcom/android/ide/common/symbols/Symbol$NormalSymbol;", "Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "sdk-common"})
public abstract class Symbol {
    @JvmField
    @NotNull
    public static final ImmutableList<String> NO_CHILDREN;
    public static final Companion Companion;

    @NotNull
    public abstract ResourceVisibility getResourceVisibility();

    @NotNull
    public abstract ResourceType getResourceType();

    @NotNull
    public abstract String getCanonicalName();

    @NotNull
    public abstract String getValue();

    @NotNull
    public abstract SymbolJavaType getJavaType();

    @NotNull
    public abstract ImmutableList<String> getChildren();

    private Symbol() {
    }

    static {
        Companion = new Companion(null);
        ImmutableList immutableList = ImmutableList.of();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
        NO_CHILDREN = immutableList;
    }

    public /* synthetic */ Symbol(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @NotNull
    public static final NormalSymbol createAndValidateSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull IdProvider idProvider) {
        return Companion.createAndValidateSymbol(resourceType, name, idProvider);
    }

    @JvmStatic
    @NotNull
    public static final NormalSymbol createAndValidateSymbol(@NotNull ResourceType resourceType, @NotNull String name, int value) {
        return Companion.createAndValidateSymbol(resourceType, name, value);
    }

    @JvmStatic
    @NotNull
    public static final StyleableSymbol createAndValidateStyleableSymbol(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull List<String> children) {
        return Companion.createAndValidateStyleableSymbol(name, values, children);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J1\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\b\u0010$\u001a\u00020\u0005H\u0016J\t\u0010%\u001a\u00020\u0007H\u00d6\u0001J\b\u0010&\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lcom/android/ide/common/symbols/Symbol$NormalSymbol;", "Lcom/android/ide/common/symbols/Symbol;", "resourceType", "Lcom/android/resources/ResourceType;", "canonicalName", "", "intValue", "", "resourceVisibility", "Lcom/android/resources/ResourceVisibility;", "(Lcom/android/resources/ResourceType;Ljava/lang/String;ILcom/android/resources/ResourceVisibility;)V", "getCanonicalName", "()Ljava/lang/String;", "children", "Lcom/google/common/collect/ImmutableList;", "getChildren", "()Lcom/google/common/collect/ImmutableList;", "getIntValue", "()I", "javaType", "Lcom/android/ide/common/symbols/SymbolJavaType;", "getJavaType", "()Lcom/android/ide/common/symbols/SymbolJavaType;", "getResourceType", "()Lcom/android/resources/ResourceType;", "getResourceVisibility", "()Lcom/android/resources/ResourceVisibility;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "getValue", "hashCode", "toString", "sdk-common"})
    public static final class NormalSymbol
    extends Symbol {
        @NotNull
        private final ResourceType resourceType;
        @NotNull
        private final String canonicalName;
        private final int intValue;
        @NotNull
        private final ResourceVisibility resourceVisibility;

        @Override
        @NotNull
        public SymbolJavaType getJavaType() {
            return SymbolJavaType.INT;
        }

        @Override
        @NotNull
        public String getValue() {
            return "0x" + Integer.toHexString(this.intValue);
        }

        @Override
        @NotNull
        public ImmutableList<String> getChildren() {
            throw (Throwable)new UnsupportedOperationException("Only styleables have children.");
        }

        @NotNull
        public String toString() {
            int n = this.intValue;
            int n2 = 16;
            StringBuilder stringBuilder = new StringBuilder().append("").append(this.getResourceVisibility()).append(' ').append(this.getResourceType()).append(' ').append(this.getCanonicalName()).append(" = 0x");
            String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            String string2 = string;
            return stringBuilder.append(string2).toString();
        }

        @Override
        @NotNull
        public ResourceType getResourceType() {
            return this.resourceType;
        }

        @Override
        @NotNull
        public String getCanonicalName() {
            return this.canonicalName;
        }

        public final int getIntValue() {
            return this.intValue;
        }

        @Override
        @NotNull
        public ResourceVisibility getResourceVisibility() {
            return this.resourceVisibility;
        }

        @JvmOverloads
        public NormalSymbol(@NotNull ResourceType resourceType, @NotNull String canonicalName, int intValue, @NotNull ResourceVisibility resourceVisibility) {
            Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)canonicalName, (String)"canonicalName");
            Intrinsics.checkParameterIsNotNull((Object)resourceVisibility, (String)"resourceVisibility");
            super(null);
            this.resourceType = resourceType;
            this.canonicalName = canonicalName;
            this.intValue = intValue;
            this.resourceVisibility = resourceVisibility;
            Preconditions.checkArgument((this.getResourceType() != ResourceType.STYLEABLE ? 1 : 0) != 0, (String)"Internal Error: Styleables must be represented by StyleableSymbol.", (Object[])new Object[0]);
        }

        @JvmOverloads
        public /* synthetic */ NormalSymbol(ResourceType resourceType, String string, int n, ResourceVisibility resourceVisibility, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                resourceVisibility = ResourceVisibility.UNDEFINED;
            }
            this(resourceType, string, n, resourceVisibility);
        }

        @JvmOverloads
        public NormalSymbol(@NotNull ResourceType resourceType, @NotNull String canonicalName, int intValue) {
            this(resourceType, canonicalName, intValue, null, 8, null);
        }

        @NotNull
        public final ResourceType component1() {
            return this.getResourceType();
        }

        @NotNull
        public final String component2() {
            return this.getCanonicalName();
        }

        public final int component3() {
            return this.intValue;
        }

        @NotNull
        public final ResourceVisibility component4() {
            return this.getResourceVisibility();
        }

        @NotNull
        public final NormalSymbol copy(@NotNull ResourceType resourceType, @NotNull String canonicalName, int intValue, @NotNull ResourceVisibility resourceVisibility) {
            Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)canonicalName, (String)"canonicalName");
            Intrinsics.checkParameterIsNotNull((Object)resourceVisibility, (String)"resourceVisibility");
            return new NormalSymbol(resourceType, canonicalName, intValue, resourceVisibility);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ NormalSymbol copy$default(NormalSymbol normalSymbol, ResourceType resourceType, String string, int n, ResourceVisibility resourceVisibility, int n2, Object object) {
            if ((n2 & 1) != 0) {
                resourceType = normalSymbol.getResourceType();
            }
            if ((n2 & 2) != 0) {
                string = normalSymbol.getCanonicalName();
            }
            if ((n2 & 4) != 0) {
                n = normalSymbol.intValue;
            }
            if ((n2 & 8) != 0) {
                resourceVisibility = normalSymbol.getResourceVisibility();
            }
            return normalSymbol.copy(resourceType, string, n, resourceVisibility);
        }

        public int hashCode() {
            ResourceType resourceType = this.getResourceType();
            String string = this.getCanonicalName();
            ResourceVisibility resourceVisibility = this.getResourceVisibility();
            return (((resourceType != null ? resourceType.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + Integer.hashCode(this.intValue)) * 31 + (resourceVisibility != null ? resourceVisibility.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NormalSymbol)) break block3;
                    NormalSymbol normalSymbol = (NormalSymbol)object;
                    if (!Intrinsics.areEqual((Object)this.getResourceType(), (Object)normalSymbol.getResourceType()) || !Intrinsics.areEqual((Object)this.getCanonicalName(), (Object)normalSymbol.getCanonicalName()) || !(this.intValue == normalSymbol.intValue) || !Intrinsics.areEqual((Object)this.getResourceVisibility(), (Object)normalSymbol.getResourceVisibility())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B5\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003J=\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\b\u0010#\u001a\u00020\u0003H\u0016J\t\u0010$\u001a\u00020\u0006H\u00d6\u0001J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000e\u00a8\u0006&"}, d2={"Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "Lcom/android/ide/common/symbols/Symbol;", "canonicalName", "", "values", "Lcom/google/common/collect/ImmutableList;", "", "children", "resourceVisibility", "Lcom/android/resources/ResourceVisibility;", "(Ljava/lang/String;Lcom/google/common/collect/ImmutableList;Lcom/google/common/collect/ImmutableList;Lcom/android/resources/ResourceVisibility;)V", "getCanonicalName", "()Ljava/lang/String;", "getChildren", "()Lcom/google/common/collect/ImmutableList;", "javaType", "Lcom/android/ide/common/symbols/SymbolJavaType;", "getJavaType", "()Lcom/android/ide/common/symbols/SymbolJavaType;", "resourceType", "Lcom/android/resources/ResourceType;", "getResourceType", "()Lcom/android/resources/ResourceType;", "getResourceVisibility", "()Lcom/android/resources/ResourceVisibility;", "getValues", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "getValue", "hashCode", "toString", "sdk-common"})
    public static final class StyleableSymbol
    extends Symbol {
        @NotNull
        private final String canonicalName;
        @NotNull
        private final ImmutableList<Integer> values;
        @NotNull
        private final ImmutableList<String> children;
        @NotNull
        private final ResourceVisibility resourceVisibility;

        @Override
        @NotNull
        public ResourceType getResourceType() {
            return ResourceType.STYLEABLE;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String getValue() {
            StringBuilder stringBuilder;
            StringBuilder $receiver = stringBuilder = new StringBuilder(this.values.size() * 12 + 2);
            $receiver.append("{ ");
            int n = 0;
            int n2 = this.values.size();
            while (n < n2) {
                void i;
                if (i != false) {
                    $receiver.append(", ");
                }
                $receiver.append("0x");
                Object object = this.values.get((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"values[i]");
                $receiver.append(Integer.toHexString(((Number)object).intValue()));
                ++i;
            }
            $receiver.append(" }");
            String string = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder(values.siz\u2026             }.toString()");
            return string;
        }

        @Override
        @NotNull
        public SymbolJavaType getJavaType() {
            return SymbolJavaType.INT_LIST;
        }

        @Override
        @NotNull
        public String getCanonicalName() {
            return this.canonicalName;
        }

        @NotNull
        public final ImmutableList<Integer> getValues() {
            return this.values;
        }

        @Override
        @NotNull
        public ImmutableList<String> getChildren() {
            return this.children;
        }

        @Override
        @NotNull
        public ResourceVisibility getResourceVisibility() {
            return this.resourceVisibility;
        }

        @JvmOverloads
        public StyleableSymbol(@NotNull String canonicalName, @NotNull ImmutableList<Integer> values, @NotNull ImmutableList<String> children, @NotNull ResourceVisibility resourceVisibility) {
            Intrinsics.checkParameterIsNotNull((Object)canonicalName, (String)"canonicalName");
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            Intrinsics.checkParameterIsNotNull(children, (String)"children");
            Intrinsics.checkParameterIsNotNull((Object)resourceVisibility, (String)"resourceVisibility");
            super(null);
            this.canonicalName = canonicalName;
            this.values = values;
            this.children = children;
            this.resourceVisibility = resourceVisibility;
        }

        @JvmOverloads
        public /* synthetic */ StyleableSymbol(String string, ImmutableList immutableList, ImmutableList immutableList2, ResourceVisibility resourceVisibility, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                resourceVisibility = ResourceVisibility.UNDEFINED;
            }
            this(string, (ImmutableList<Integer>)immutableList, (ImmutableList<String>)immutableList2, resourceVisibility);
        }

        @JvmOverloads
        public StyleableSymbol(@NotNull String canonicalName, @NotNull ImmutableList<Integer> values, @NotNull ImmutableList<String> children) {
            this(canonicalName, values, children, null, 8, null);
        }

        @NotNull
        public final String component1() {
            return this.getCanonicalName();
        }

        @NotNull
        public final ImmutableList<Integer> component2() {
            return this.values;
        }

        @NotNull
        public final ImmutableList<String> component3() {
            return this.getChildren();
        }

        @NotNull
        public final ResourceVisibility component4() {
            return this.getResourceVisibility();
        }

        @NotNull
        public final StyleableSymbol copy(@NotNull String canonicalName, @NotNull ImmutableList<Integer> values, @NotNull ImmutableList<String> children, @NotNull ResourceVisibility resourceVisibility) {
            Intrinsics.checkParameterIsNotNull((Object)canonicalName, (String)"canonicalName");
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            Intrinsics.checkParameterIsNotNull(children, (String)"children");
            Intrinsics.checkParameterIsNotNull((Object)resourceVisibility, (String)"resourceVisibility");
            return new StyleableSymbol(canonicalName, values, children, resourceVisibility);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ StyleableSymbol copy$default(StyleableSymbol styleableSymbol, String string, ImmutableList immutableList, ImmutableList immutableList2, ResourceVisibility resourceVisibility, int n, Object object) {
            if ((n & 1) != 0) {
                string = styleableSymbol.getCanonicalName();
            }
            if ((n & 2) != 0) {
                immutableList = styleableSymbol.values;
            }
            if ((n & 4) != 0) {
                immutableList2 = styleableSymbol.getChildren();
            }
            if ((n & 8) != 0) {
                resourceVisibility = styleableSymbol.getResourceVisibility();
            }
            return styleableSymbol.copy(string, immutableList, immutableList2, resourceVisibility);
        }

        public String toString() {
            return "StyleableSymbol(canonicalName=" + this.getCanonicalName() + ", values=" + this.values + ", children=" + this.getChildren() + ", resourceVisibility=" + this.getResourceVisibility() + ")";
        }

        public int hashCode() {
            String string = this.getCanonicalName();
            ImmutableList<Integer> immutableList = this.values;
            ImmutableList<String> immutableList2 = this.getChildren();
            ResourceVisibility resourceVisibility = this.getResourceVisibility();
            return (((string != null ? string.hashCode() : 0) * 31 + (immutableList != null ? immutableList.hashCode() : 0)) * 31 + (immutableList2 != null ? immutableList2.hashCode() : 0)) * 31 + (resourceVisibility != null ? resourceVisibility.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StyleableSymbol)) break block3;
                    StyleableSymbol styleableSymbol = (StyleableSymbol)object;
                    if (!Intrinsics.areEqual((Object)this.getCanonicalName(), (Object)styleableSymbol.getCanonicalName()) || !Intrinsics.areEqual(this.values, styleableSymbol.values) || !Intrinsics.areEqual(this.getChildren(), styleableSymbol.getChildren()) || !Intrinsics.areEqual((Object)this.getResourceVisibility(), (Object)styleableSymbol.getResourceVisibility())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0007J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\nH\u0007J\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/ide/common/symbols/Symbol$Companion;", "", "()V", "NO_CHILDREN", "Lcom/google/common/collect/ImmutableList;", "", "createAndValidateStyleableSymbol", "Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "name", "values", "", "children", "", "createAndValidateSymbol", "Lcom/android/ide/common/symbols/Symbol$NormalSymbol;", "resourceType", "Lcom/android/resources/ResourceType;", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "value", "validateSymbol", "", "sdk-common"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final NormalSymbol createAndValidateSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull IdProvider idProvider) {
            Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)idProvider, (String)"idProvider");
            this.validateSymbol(name, resourceType);
            return new NormalSymbol(resourceType, name, idProvider.next(resourceType), null, 8, null);
        }

        @JvmStatic
        @NotNull
        public final NormalSymbol createAndValidateSymbol(@NotNull ResourceType resourceType, @NotNull String name, int value) {
            Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.validateSymbol(name, resourceType);
            return new NormalSymbol(resourceType, name, value, null, 8, null);
        }

        @JvmStatic
        @NotNull
        public final StyleableSymbol createAndValidateStyleableSymbol(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull List<String> children) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            Intrinsics.checkParameterIsNotNull(children, (String)"children");
            this.validateSymbol(name, ResourceType.STYLEABLE);
            ImmutableList immutableList = ImmutableList.copyOf((Collection)children);
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.copyOf(children)");
            return new StyleableSymbol(name, values, immutableList, null, 8, null);
        }

        @JvmStatic
        @NotNull
        public static /* bridge */ /* synthetic */ StyleableSymbol createAndValidateStyleableSymbol$default(Companion companion, String string, ImmutableList immutableList, List list, int n, Object object) {
            if ((n & 4) != 0) {
                ImmutableList immutableList2 = ImmutableList.of();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableList2, (String)"ImmutableList.of()");
                list = (List)immutableList2;
            }
            return companion.createAndValidateStyleableSymbol(string, (ImmutableList<Integer>)immutableList, list);
        }

        private final void validateSymbol(String name, ResourceType resourceType) {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Resource name cannot be null", (Object[])new Object[0]);
            String string = name;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Preconditions.checkArgument((!StringsKt.contains$default((CharSequence)string, (CharSequence)".", (boolean)false, (int)2, null) ? 1 : 0) != 0, (String)("Resource name cannot contain dots: " + name), (Object[])new Object[0]);
            try {
                ValueResourceNameValidator.validate(name, resourceType, null);
            }
            catch (MergingException e) {
                throw (Throwable)new IllegalArgumentException(e);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

