/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.utils.SdkUtils;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class LocaleManager {
    private static final String[] ISO_639_2_CODES = new String[]{"aar", "abk", "ace", "ach", "ada", "ady", "afa", "afh", "afr", "agq", "ain", "aka", "akk", "ale", "alg", "alt", "amh", "ang", "anp", "apa", "ara", "arc", "arg", "arn", "arp", "art", "arw", "asa", "asm", "ast", "ath", "aus", "ava", "ave", "awa", "aym", "aze", "bad", "bai", "bak", "bal", "bam", "ban", "bas", "bat", "bej", "bel", "bem", "ben", "ber", "bez", "bho", "bih", "bik", "bin", "bis", "bla", "bnt", "bod", "bos", "bra", "bre", "brx", "btk", "bua", "bug", "bul", "byn", "cad", "cai", "car", "cat", "cau", "ceb", "cel", "ces", "cgg", "cha", "chb", "che", "chg", "chk", "chm", "chn", "cho", "chp", "chr", "chu", "chv", "chy", "cmc", "cop", "cor", "cos", "cpe", "cpf", "cpp", "cre", "crh", "crp", "csb", "cus", "cym", "dak", "dan", "dar", "dav", "day", "del", "den", "deu", "dgr", "din", "div", "dje", "doi", "dra", "dsb", "dua", "dum", "dyo", "dyu", "dzo", "ebu", "efi", "egy", "eka", "ell", "elx", "eng", "enm", "epo", "est", "eus", "ewe", "ewo", "fan", "fao", "fas", "fat", "fij", "fil", "fin", "fiu", "fon", "fra", "frm", "fro", "frr", "frs", "fry", "ful", "fur", "gaa", "gay", "gba", "gem", "gez", "gil", "gla", "gle", "glg", "glv", "gmh", "goh", "gon", "gor", "got", "grb", "grc", "grn", "gsw", "guj", "guz", "gwi", "hai", "hat", "hau", "haw", "heb", "her", "hil", "him", "hin", "hit", "hmn", "hmo", "hrv", "hsb", "hun", "hup", "hye", "iba", "ibo", "ido", "iii", "ijo", "iku", "ile", "ilo", "ina", "inc", "ind", "ine", "inh", "ipk", "ira", "iro", "isl", "ita", "jav", "jbo", "jgo", "jmc", "jpn", "jpr", "jrb", "kaa", "kab", "kac", "kal", "kam", "kan", "kar", "kas", "kat", "kau", "kaw", "kaz", "kbd", "kde", "kea", "kha", "khi", "khm", "kho", "khq", "kik", "kin", "kir", "kkj", "kln", "kmb", "kok", "kom", "kon", "kor", "kos", "kpe", "krc", "krl", "kro", "kru", "ksb", "ksf", "ksh", "kua", "kum", "kur", "kut", "lad", "lag", "lah", "lam", "lao", "lat", "lav", "lez", "lim", "lin", "lit", "lkt", "lol", "loz", "ltz", "lua", "lub", "lug", "lui", "lun", "luo", "lus", "luy", "mad", "mag", "mah", "mai", "mak", "mal", "man", "mao", "map", "mar", "mas", "mdf", "mdr", "men", "mer", "mfe", "mga", "mgh", "mgo", "mic", "min", "mis", "mkd", "mkh", "mlg", "mlt", "mnc", "mni", "mno", "moh", "mon", "mos", "msa", "mua", "mul", "mun", "mus", "mwl", "mwr", "mya", "myn", "myv", "nah", "nai", "nap", "naq", "nau", "nav", "nbl", "nde", "ndo", "nds", "nep", "new", "nia", "nic", "niu", "nld", "nmg", "nnh", "nno", "nob", "nog", "non", "nor", "nqo", "nso", "nub", "nus", "nwc", "nya", "nym", "nyn", "nyo", "nzi", "oci", "oji", "ori", "orm", "osa", "oss", "ota", "oto", "paa", "pag", "pal", "pam", "pan", "pap", "pau", "peo", "phi", "phn", "pli", "pol", "pon", "por", "pra", "pro", "pus", "que", "raj", "rap", "rar", "roa", "rof", "roh", "rom", "ron", "run", "rup", "rus", "rwk", "sad", "sag", "sah", "sai", "sal", "sam", "san", "saq", "sas", "sat", "sbp", "scn", "sco", "seh", "sel", "sem", "ses", "sga", "sgn", "shi", "shn", "sid", "sin", "sio", "sit", "sla", "slk", "slv", "sma", "sme", "smi", "smj", "smn", "smo", "sms", "sna", "snd", "snk", "sog", "som", "son", "sot", "spa", "sqi", "srd", "srn", "srp", "srr", "ssa", "ssw", "suk", "sun", "sus", "sux", "swa", "swc", "swe", "syc", "syr", "tah", "tai", "tam", "tat", "tel", "tem", "teo", "ter", "tet", "tgk", "tgl", "tha", "tig", "tir", "tiv", "tkl", "tlh", "tli", "tmh", "tog", "ton", "tpi", "tsi", "tsn", "tso", "tuk", "tum", "tup", "tur", "tut", "tvl", "twi", "twq", "tyv", "tzm", "udm", "uga", "uig", "ukr", "umb", "und", "urd", "uzb", "vai", "ven", "vie", "vol", "vot", "vun", "wae", "wak", "wal", "war", "was", "wen", "wln", "wol", "xal", "xho", "xog", "yao", "yap", "yav", "yid", "yor", "ypk", "zap", "zbl", "zen", "zgh", "zha", "zho", "znd", "zul", "zun", "zza"};
    private static final String[] ISO_639_2_NAMES = new String[]{"Afar", "Abkhazian", "Achinese", "Acoli", "Adangme", "Adyghe; Adygei", "Afro-Asiatic languages", "Afrihili", "Afrikaans", "Aghem", "Ainu", "Akan", "Akkadian", "Aleut", "Algonquian languages", "Southern Altai", "Amharic", "English, Old (ca.450-1100)", "Angika", "Apache languages", "Arabic", "Official Aramaic (700-300 BCE); Imperial Aramaic (700-300 BCE)", "Aragonese", "Mapudungun; Mapuche", "Arapaho", "Artificial languages", "Arawak", "Asu", "Assamese", "Asturian; Bable; Leonese; Asturleonese", "Athapascan languages", "Australian languages", "Avaric", "Avestan", "Awadhi", "Aymara", "Azerbaijani", "Banda languages", "Bamileke languages", "Bashkir", "Baluchi", "Bambara", "Balinese", "Basa", "Baltic languages", "Beja; Bedawiyet", "Belarusian", "Bemba", "Bengali", "Berber languages", "Bena", "Bhojpuri", "Bihari languages", "Bikol", "Bini; Edo", "Bislama", "Siksika", "Bantu (Other)", "Tibetan", "Bosnian", "Braj", "Breton", "Bodo", "Batak languages", "Buriat", "Buginese", "Bulgarian", "Blin; Bilin", "Caddo", "Central American Indian languages", "Galibi Carib", "Catalan", "Caucasian languages", "Cebuano", "Celtic languages", "Czech", "Chiga", "Chamorro", "Chibcha", "Chechen", "Chagatai", "Chuukese", "Mari", "Chinook jargon", "Choctaw", "Chipewyan; Dene Suline", "Cherokee", "Church Slavic; Old Slavonic; Church Slavonic; Old Bulgarian; Old Church Slavonic", "Chuvash", "Cheyenne", "Chamic languages", "Coptic", "Cornish", "Corsican", "Creoles and pidgins, English based", "Creoles and pidgins, French-based ", "Creoles and pidgins, Portuguese-based ", "Cree", "Crimean Tatar; Crimean Turkish", "Creoles and pidgins ", "Kashubian", "Cushitic languages", "Welsh", "Dakota", "Danish", "Dargwa", "Taita", "Land Dayak languages", "Delaware", "Slave (Athapascan)", "German", "Dogrib", "Dinka", "Divehi; Dhivehi; Maldivian", "Zarma", "Dogri", "Dravidian languages", "Lower Sorbian", "Duala", "Dutch, Middle (ca.1050-1350)", "Jola-Fonyi", "Dyula", "Dzongkha", "Embu", "Efik", "Egyptian (Ancient)", "Ekajuk", "Greek", "Elamite", "English", "English, Middle (1100-1500)", "Esperanto", "Estonian", "Basque", "Ewe", "Ewondo", "Fang", "Faroese", "Persian", "Fanti", "Fijian", "Filipino; Pilipino", "Finnish", "Finno-Ugrian languages", "Fon", "French", "French, Middle (ca.1400-1600)", "French, Old (842-ca.1400)", "Northern Frisian", "Eastern Frisian", "Western Frisian", "Fulah", "Friulian", "Ga", "Gayo", "Gbaya", "Germanic languages", "Geez", "Gilbertese", "Scottish Gaelic", "Irish", "Galician", "Manx", "German, Middle High (ca.1050-1500)", "German, Old High (ca.750-1050)", "Gondi", "Gorontalo", "Gothic", "Grebo", "Greek, Ancient (to 1453)", "Guarani", "Swiss German; Alemannic; Alsatian", "Gujarati", "Gusii", "Gwich'in", "Haida", "Haitian; Haitian Creole", "Hausa", "Hawaiian", "Hebrew", "Herero", "Hiligaynon", "Himachali languages; Western Pahari languages", "Hindi", "Hittite", "Hmong; Mong", "Hiri Motu", "Croatian", "Upper Sorbian", "Hungarian", "Hupa", "Armenian", "Iban", "Igbo", "Ido", "Sichuan Yi", "Ijo languages", "Inuktitut", "Interlingue; Occidental", "Iloko", "Interlingua (International Auxiliary Language Association)", "Indic languages", "Indonesian", "Indo-European languages", "Ingush", "Inupiaq", "Iranian languages", "Iroquoian languages", "Icelandic", "Italian", "Javanese", "Lojban", "Ngomba", "Machame", "Japanese", "Judeo-Persian", "Judeo-Arabic", "Kara-Kalpak", "Kabyle", "Kachin; Jingpho", "Kalaallisut", "Kamba", "Kannada", "Karen languages", "Kashmiri", "Georgian", "Kanuri", "Kawi", "Kazakh", "Kabardian", "Makonde", "Kabuverdianu", "Khasi", "Khoisan languages", "Khmer", "Khotanese; Sakan", "Koyra Chiini", "Kikuyu", "Kinyarwanda", "Kyrgyz", "Kako", "Kalenjin", "Kimbundu", "Konkani", "Komi", "Kongo", "Korean", "Kosraean", "Kpelle", "Karachay-Balkar", "Karelian", "Kru languages", "Kurukh", "Shambala", "Bafia", "Colognian", "Kuanyama; Kwanyama", "Kumyk", "Kurdish", "Kutenai", "Ladino", "Langi", "Lahnda", "Lamba", "Lao", "Latin", "Latvian", "Lezghian", "Limburgan; Limburger; Limburgish", "Lingala", "Lithuanian", "Lakota", "Mongo", "Lozi", "Luxembourgish", "Luba-Lulua", "Luba-Katanga", "Ganda", "Luiseno", "Lunda", "Luo (Kenya and Tanzania)", "Lushai", "Luyia", "Madurese", "Magahi", "Marshallese", "Maithili", "Makasar", "Malayalam", "Mandingo", "Maori", "Austronesian languages", "Marathi", "Masai", "Moksha", "Mandar", "Mende", "Meru", "Morisyen", "Irish, Middle (900-1200)", "Makhuwa-Meetto", "Meta\u02bc", "Mi'kmaq; Micmac", "Minangkabau", "Uncoded languages", "Macedonian", "Mon-Khmer languages", "Malagasy", "Maltese", "Manchu", "Manipuri", "Manobo languages", "Mohawk", "Mongolian", "Mossi", "Malay", "Mundang", "Multiple languages", "Munda languages", "Creek", "Mirandese", "Marwari", "Burmese", "Mayan languages", "Erzya", "Nahuatl languages", "North American Indian languages", "Neapolitan", "Nama", "Nauru", "Navajo; Navaho", "Ndebele, South; South Ndebele", "North Ndebele", "Ndonga", "Low German; Low Saxon; German, Low; Saxon, Low", "Nepali", "Nepal Bhasa; Newari", "Nias", "Niger-Kordofanian languages", "Niuean", "Dutch", "Kwasio", "Ngiemboon", "Norwegian Nynorsk", "Norwegian Bokm\u00e5l", "Nogai", "Norse, Old", "Norwegian", "N'Ko", "Pedi; Sepedi; Northern Sotho", "Nubian languages", "Nuer", "Classical Newari; Old Newari; Classical Nepal Bhasa", "Chichewa; Chewa; Nyanja", "Nyamwezi", "Nyankole", "Nyoro", "Nzima", "Occitan (post 1500); Proven\u00e7al", "Ojibwa", "Oriya", "Oromo", "Osage", "Ossetic", "Turkish, Ottoman (1500-1928)", "Otomian languages", "Papuan languages", "Pangasinan", "Pahlavi", "Pampanga; Kapampangan", "Punjabi", "Papiamento", "Palauan", "Persian, Old (ca.600-400 B.C.)", "Philippine languages", "Phoenician", "Pali", "Polish", "Pohnpeian", "Portuguese", "Prakrit languages", "Proven\u00e7al, Old (to 1500)", "Pashto", "Quechua", "Rajasthani", "Rapanui", "Rarotongan; Cook Islands Maori", "Romance languages", "Rombo", "Romansh", "Romany", "Romanian", "Rundi", "Aromanian; Arumanian; Macedo-Romanian", "Russian", "Rwa", "Sandawe", "Sango", "Yakut", "South American Indian (Other)", "Salishan languages", "Samaritan Aramaic", "Sanskrit", "Samburu", "Sasak", "Santali", "Sangu", "Sicilian", "Scots", "Sena", "Selkup", "Semitic languages", "Koyraboro Senni", "Irish, Old (to 900)", "Sign Languages", "Tachelhit", "Shan", "Sidamo", "Sinhala", "Siouan languages", "Sino-Tibetan languages", "Slavic languages", "Slovak", "Slovenian", "Southern Sami", "Northern Sami", "Sami languages", "Lule Sami", "Inari Sami", "Samoan", "Skolt Sami", "Shona", "Sindhi", "Soninke", "Sogdian", "Somali", "Songhai languages", "Sotho, Southern", "Spanish", "Albanian", "Sardinian", "Sranan Tongo", "Serbian", "Serer", "Nilo-Saharan languages", "Swati", "Sukuma", "Sundanese", "Susu", "Sumerian", "Swahili", "Congo Swahili", "Swedish", "Classical Syriac", "Syriac", "Tahitian", "Tai languages", "Tamil", "Tatar", "Telugu", "Timne", "Teso", "Tereno", "Tetum", "Tajik", "Tagalog", "Thai", "Tigre", "Tigrinya", "Tiv", "Tokelau", "Klingon; tlhIngan-Hol", "Tlingit", "Tamashek", "Tonga (Nyasa)", "Tongan", "Tok Pisin", "Tsimshian", "Tswana", "Tsonga", "Turkmen", "Tumbuka", "Tupi languages", "Turkish", "Altaic languages", "Tuvalu", "Twi", "Tasawaq", "Tuvinian", "Central Atlas Tamazight", "Udmurt", "Ugaritic", "Uyghur", "Ukrainian", "Umbundu", "Undetermined", "Urdu", "Uzbek", "Vai", "Venda", "Vietnamese", "Volap\u00fck", "Votic", "Vunjo", "Walser", "Wakashan languages", "Walamo", "Waray", "Washo", "Sorbian languages", "Walloon", "Wolof", "Kalmyk; Oirat", "Xhosa", "Soga", "Yao", "Yapese", "Yangben", "Yiddish", "Yoruba", "Yupik languages", "Zapotec", "Blissymbols; Blissymbolics; Bliss", "Zenaga", "Standard Moroccan Tamazight", "Zhuang; Chuang", "Chinese", "Zande languages", "Zulu", "Zuni", "Zaza; Dimili; Dimli; Kirdki; Kirmanjki; Zazaki"};
    private static final String[] ISO_639_1_CODES = new String[]{"aa", "ab", "ae", "af", "ak", "am", "an", "ar", "as", "av", "ay", "az", "ba", "be", "bg", "bh", "bi", "bm", "bn", "bo", "br", "bs", "ca", "ce", "ch", "co", "cr", "cs", "cu", "cv", "cy", "da", "de", "dv", "dz", "ee", "el", "en", "eo", "es", "et", "eu", "fa", "ff", "fi", "fj", "fo", "fr", "fy", "ga", "gd", "gl", "gn", "gu", "gv", "ha", "he", "hi", "ho", "hr", "ht", "hu", "hy", "hz", "ia", "id", "ie", "ig", "ii", "ik", "in", "io", "is", "it", "iu", "iw", "ja", "ji", "jv", "ka", "kg", "ki", "kj", "kk", "kl", "km", "kn", "ko", "kr", "ks", "ku", "kv", "kw", "ky", "la", "lb", "lg", "li", "ln", "lo", "lt", "lu", "lv", "mg", "mh", "mi", "mk", "ml", "mn", "mr", "ms", "mt", "my", "na", "nb", "nd", "ne", "ng", "nl", "nn", "no", "nr", "nv", "ny", "oc", "oj", "om", "or", "os", "pa", "pi", "pl", "ps", "pt", "qu", "rm", "rn", "ro", "ru", "rw", "sa", "sc", "sd", "se", "sg", "si", "sk", "sl", "sm", "sn", "so", "sq", "sr", "ss", "st", "su", "sv", "sw", "ta", "te", "tg", "th", "ti", "tk", "tl", "tn", "to", "tr", "ts", "tt", "tw", "ty", "ug", "uk", "ur", "uz", "ve", "vi", "vo", "wa", "wo", "xh", "yi", "yo", "za", "zh", "zu"};
    private static final int[] ISO_639_1_TO_2 = new int[]{0, 1, 33, 8, 11, 16, 22, 20, 28, 32, 35, 36, 39, 46, 66, 52, 55, 41, 48, 58, 61, 59, 71, 79, 77, 93, 97, 75, 87, 88, 102, 104, 110, 113, 122, 134, 127, 129, 131, 438, 132, 133, 138, 151, 142, 140, 137, 145, 150, 160, 159, 161, 170, 172, 162, 177, 179, 183, 186, 187, 176, 189, 191, 180, 200, 202, 198, 193, 195, 205, 202, 194, 208, 209, 197, 179, 214, 518, 210, 225, 245, 237, 256, 228, 220, 234, 222, 246, 226, 224, 258, 244, 92, 239, 265, 274, 277, 268, 269, 264, 270, 276, 266, 307, 285, 290, 305, 288, 313, 292, 315, 308, 322, 329, 344, 332, 335, 333, 340, 343, 347, 331, 330, 353, 358, 359, 361, 360, 363, 370, 376, 377, 382, 379, 383, 389, 392, 391, 394, 238, 402, 440, 432, 425, 397, 418, 422, 423, 429, 431, 435, 439, 442, 445, 437, 447, 452, 450, 457, 459, 464, 466, 468, 480, 465, 478, 475, 483, 479, 458, 486, 455, 492, 493, 496, 497, 499, 500, 501, 510, 511, 513, 518, 519, 525, 526, 528};
    private static final int[] ISO_639_2_TO_1 = new int[]{0, 1, -1, -1, -1, -1, -1, -1, 3, -1, -1, 4, -1, -1, -1, -1, 5, -1, -1, -1, 7, -1, 6, -1, -1, -1, -1, -1, 8, -1, -1, -1, 9, 2, -1, 10, 11, -1, -1, 12, -1, 17, -1, -1, -1, -1, 13, -1, 18, -1, -1, -1, 15, -1, -1, 16, -1, -1, 19, 21, -1, 20, -1, -1, -1, -1, 14, -1, -1, -1, -1, 22, -1, -1, -1, 27, -1, 24, -1, 23, -1, -1, -1, -1, -1, -1, -1, 28, 29, -1, -1, -1, 92, 25, -1, -1, -1, 26, -1, -1, -1, -1, 30, -1, 31, -1, -1, -1, -1, -1, 32, -1, -1, 33, -1, -1, -1, -1, -1, -1, -1, -1, 34, -1, -1, -1, -1, 36, -1, 37, -1, 38, 40, 41, 35, -1, -1, 46, 42, -1, 45, -1, 44, -1, -1, 47, -1, -1, -1, -1, 48, 43, -1, -1, -1, -1, -1, -1, -1, 50, 49, 51, 54, -1, -1, -1, -1, -1, -1, -1, 52, -1, 53, -1, -1, -1, 60, 55, -1, 75, 63, -1, -1, 57, -1, -1, 58, 59, -1, 61, -1, 62, -1, 67, 71, 68, -1, 74, 66, -1, 64, -1, 70, -1, -1, 69, -1, -1, 72, 73, 78, -1, -1, -1, 76, -1, -1, -1, -1, -1, 84, -1, 86, -1, 89, 79, 88, -1, 83, -1, -1, -1, -1, -1, 85, -1, -1, 81, 139, 93, -1, -1, -1, -1, 91, 80, 87, -1, -1, -1, -1, -1, -1, -1, -1, -1, 82, -1, 90, -1, -1, -1, -1, -1, 99, 94, 102, -1, 97, 98, 100, -1, -1, -1, 95, -1, 101, 96, -1, -1, -1, -1, -1, -1, -1, 104, -1, -1, 107, -1, 105, -1, 109, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 106, -1, 103, 111, -1, -1, -1, -1, 108, -1, 110, -1, -1, -1, -1, -1, -1, 112, -1, -1, -1, -1, -1, -1, 113, 122, 121, 115, 117, -1, 116, -1, -1, -1, -1, 118, -1, -1, 119, 114, -1, -1, 120, -1, -1, -1, -1, -1, 123, -1, -1, -1, -1, 124, 125, 127, 126, -1, 128, -1, -1, -1, -1, -1, -1, 129, -1, -1, -1, -1, -1, 130, 131, -1, 133, -1, -1, 132, 134, -1, -1, -1, -1, -1, 135, -1, 137, 136, -1, 138, -1, -1, 144, -1, -1, -1, -1, 140, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 145, -1, -1, -1, 146, 147, -1, 143, -1, -1, -1, 148, -1, 149, 142, -1, -1, 150, -1, 154, 39, 151, 141, -1, 152, -1, -1, 153, -1, 155, -1, -1, 157, -1, 156, -1, -1, 171, -1, 158, 169, 159, -1, -1, -1, -1, 160, 164, 161, -1, 162, -1, -1, -1, -1, -1, -1, 166, -1, -1, 165, 168, 163, -1, -1, 167, -1, -1, 170, -1, -1, -1, -1, -1, 172, 173, -1, -1, 174, 175, -1, 176, 177, 178, -1, -1, -1, -1, -1, -1, -1, -1, 179, 180, -1, 181, -1, -1, -1, -1, 77, 183, -1, -1, -1, -1, -1, 184, 185, -1, 186, -1, -1};
    private static final String[] ISO_3166_2_CODES = new String[]{"ABW", "AFG", "AGO", "AIA", "ALA", "ALB", "AND", "ARE", "ARG", "ARM", "ASM", "ATA", "ATF", "ATG", "AUS", "AUT", "AZE", "BDI", "BEL", "BEN", "BES", "BFA", "BGD", "BGR", "BHR", "BHS", "BIH", "BLM", "BLR", "BLZ", "BMU", "BOL", "BRA", "BRB", "BRN", "BTN", "BVT", "BWA", "CAF", "CAN", "CCK", "CHE", "CHL", "CHN", "CIV", "CMR", "COD", "COG", "COK", "COL", "COM", "CPV", "CRI", "CUB", "CUW", "CXR", "CYM", "CYP", "CZE", "DEU", "DJI", "DMA", "DNK", "DOM", "DZA", "ECU", "EGY", "ERI", "ESH", "ESP", "EST", "ETH", "FIN", "FJI", "FLK", "FRA", "FRO", "FSM", "GAB", "GBR", "GEO", "GGY", "GHA", "GIB", "GIN", "GLP", "GMB", "GNB", "GNQ", "GRC", "GRD", "GRL", "GTM", "GUF", "GUM", "GUY", "HKG", "HMD", "HND", "HRV", "HTI", "HUN", "IDN", "IMN", "IND", "IOT", "IRL", "IRN", "IRQ", "ISL", "ISR", "ITA", "JAM", "JEY", "JOR", "JPN", "KAZ", "KEN", "KGZ", "KHM", "KIR", "KNA", "KOR", "KWT", "LAO", "LBN", "LBR", "LBY", "LCA", "LIE", "LKA", "LSO", "LTU", "LUX", "LVA", "MAC", "MAF", "MAR", "MCO", "MDA", "MDG", "MDV", "MEX", "MHL", "MKD", "MLI", "MLT", "MMR", "MNE", "MNG", "MNP", "MOZ", "MRT", "MSR", "MTQ", "MUS", "MWI", "MYS", "MYT", "NAM", "NCL", "NER", "NFK", "NGA", "NIC", "NIU", "NLD", "NOR", "NPL", "NRU", "NZL", "OMN", "PAK", "PAN", "PCN", "PER", "PHL", "PLW", "PNG", "POL", "PRI", "PRK", "PRT", "PRY", "PSE", "PYF", "QAT", "REU", "ROU", "RUS", "RWA", "SAU", "SDN", "SEN", "SGP", "SGS", "SHN", "SJM", "SLB", "SLE", "SLV", "SMR", "SOM", "SPM", "SRB", "SSD", "STP", "SUR", "SVK", "SVN", "SWE", "SWZ", "SXM", "SYC", "SYR", "TCA", "TCD", "TGO", "THA", "TJK", "TKL", "TKM", "TLS", "TON", "TTO", "TUN", "TUR", "TUV", "TWN", "TZA", "UGA", "UKR", "UMI", "URY", "USA", "UZB", "VAT", "VCT", "VEN", "VGB", "VIR", "VNM", "VUT", "WLF", "WSM", "YEM", "ZAF", "ZMB", "ZWE"};
    private static final String[] ISO_3166_2_NAMES = new String[]{"Aruba", "Afghanistan", "Angola", "Anguilla", "\u00c5land Islands", "Albania", "Andorra", "United Arab Emirates", "Argentina", "Armenia", "American Samoa", "Antarctica", "French Southern Territories", "Antigua & Barbuda", "Australia", "Austria", "Azerbaijan", "Burundi", "Belgium", "Benin", "Caribbean Netherlands", "Burkina Faso", "Bangladesh", "Bulgaria", "Bahrain", "Bahamas", "Bosnia & Herzegovina", "St. Barth\u00e9lemy", "Belarus", "Belize", "Bermuda", "Bolivia", "Brazil", "Barbados", "Brunei", "Bhutan", "Bouvet Island", "Botswana", "Central African Republic", "Canada", "Cocos (Keeling) Islands", "Switzerland", "Chile", "China", "C\u00f4te d\u2019Ivoire", "Cameroon", "Congo - Kinshasa", "Congo - Brazzaville", "Cook Islands", "Colombia", "Comoros", "Cape Verde", "Costa Rica", "Cuba", "Cura\u00e7ao", "Christmas Island", "Cayman Islands", "Cyprus", "Czech Republic", "Germany", "Djibouti", "Dominica", "Denmark", "Dominican Republic", "Algeria", "Ecuador", "Egypt", "Eritrea", "Western Sahara", "Spain", "Estonia", "Ethiopia", "Finland", "Fiji", "Falkland Islands", "France", "Faroe Islands", "Micronesia", "Gabon", "United Kingdom", "Georgia", "Guernsey", "Ghana", "Gibraltar", "Guinea", "Guadeloupe", "Gambia", "Guinea-Bissau", "Equatorial Guinea", "Greece", "Grenada", "Greenland", "Guatemala", "French Guiana", "Guam", "Guyana", "Hong Kong SAR China", "Heard Island and McDonald Islands", "Honduras", "Croatia", "Haiti", "Hungary", "Indonesia", "Isle of Man", "India", "British Indian Ocean Territory", "Ireland", "Iran", "Iraq", "Iceland", "Israel", "Italy", "Jamaica", "Jersey", "Jordan", "Japan", "Kazakhstan", "Kenya", "Kyrgyzstan", "Cambodia", "Kiribati", "St. Kitts & Nevis", "South Korea", "Kuwait", "Laos", "Lebanon", "Liberia", "Libya", "St. Lucia", "Liechtenstein", "Sri Lanka", "Lesotho", "Lithuania", "Luxembourg", "Latvia", "Macau SAR China", "St. Martin", "Morocco", "Monaco", "Moldova", "Madagascar", "Maldives", "Mexico", "Marshall Islands", "Macedonia", "Mali", "Malta", "Myanmar (Burma)", "Montenegro", "Mongolia", "Northern Mariana Islands", "Mozambique", "Mauritania", "Montserrat", "Martinique", "Mauritius", "Malawi", "Malaysia", "Mayotte", "Namibia", "New Caledonia", "Niger", "Norfolk Island", "Nigeria", "Nicaragua", "Niue", "Netherlands", "Norway", "Nepal", "Nauru", "New Zealand", "Oman", "Pakistan", "Panama", "Pitcairn Islands", "Peru", "Philippines", "Palau", "Papua New Guinea", "Poland", "Puerto Rico", "North Korea", "Portugal", "Paraguay", "Palestine", "French Polynesia", "Qatar", "R\u00e9union", "Romania", "Russia", "Rwanda", "Saudi Arabia", "Sudan", "Senegal", "Singapore", "South Georgia and the South Sandwich Islands", "St. Helena", "Svalbard & Jan Mayen", "Solomon Islands", "Sierra Leone", "El Salvador", "San Marino", "Somalia", "St. Pierre & Miquelon", "Serbia", "South Sudan", "S\u00e3o Tom\u00e9 & Pr\u00edncipe", "Suriname", "Slovakia", "Slovenia", "Sweden", "Swaziland", "Sint Maarten", "Seychelles", "Syria", "Turks & Caicos Islands", "Chad", "Togo", "Thailand", "Tajikistan", "Tokelau", "Turkmenistan", "Timor-Leste", "Tonga", "Trinidad & Tobago", "Tunisia", "Turkey", "Tuvalu", "Taiwan", "Tanzania", "Uganda", "Ukraine", "U.S. Outlying Islands", "Uruguay", "United States", "Uzbekistan", "Holy See (Vatican City State)", "St. Vincent & Grenadines", "Venezuela", "British Virgin Islands", "U.S. Virgin Islands", "Vietnam", "Vanuatu", "Wallis & Futuna", "Samoa", "Yemen", "South Africa", "Zambia", "Zimbabwe"};
    private static final String[] ISO_3166_1_CODES = new String[]{"AD", "AE", "AF", "AG", "AI", "AL", "AM", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AX", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BL", "BM", "BN", "BO", "BQ", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CW", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GG", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IM", "IN", "IO", "IQ", "IR", "IS", "IT", "JE", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MF", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "SS", "ST", "SV", "SX", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "ZA", "ZM", "ZW"};
    private static final int[] ISO_3166_1_TO_2 = new int[]{6, 7, 1, 13, 3, 5, 9, 2, 11, 8, 10, 15, 14, 0, 4, 16, 26, 33, 22, 18, 21, 23, 24, 17, 19, 27, 30, 34, 31, 20, 32, 25, 35, 36, 37, 28, 29, 39, 40, 46, 38, 47, 41, 44, 48, 42, 45, 43, 49, 52, 53, 51, 54, 55, 57, 58, 59, 60, 62, 61, 63, 64, 65, 70, 66, 68, 67, 69, 71, 72, 73, 74, 77, 76, 75, 78, 79, 90, 80, 93, 81, 82, 83, 91, 86, 84, 85, 88, 89, 195, 92, 94, 87, 95, 96, 97, 98, 99, 100, 101, 102, 106, 110, 103, 104, 105, 108, 107, 109, 111, 113, 112, 114, 115, 117, 118, 119, 120, 50, 121, 181, 122, 123, 56, 116, 124, 125, 128, 129, 130, 126, 131, 132, 133, 134, 127, 137, 138, 139, 148, 136, 140, 143, 144, 145, 147, 149, 135, 150, 154, 152, 153, 146, 155, 141, 156, 142, 157, 151, 159, 160, 161, 162, 163, 164, 166, 167, 168, 169, 165, 170, 171, 173, 175, 185, 178, 176, 172, 179, 203, 174, 180, 184, 182, 177, 183, 186, 187, 188, 204, 189, 190, 191, 198, 213, 192, 210, 194, 196, 209, 197, 208, 199, 201, 193, 202, 207, 205, 206, 200, 212, 214, 211, 215, 216, 12, 217, 218, 219, 220, 222, 221, 225, 223, 226, 224, 227, 228, 229, 231, 230, 232, 234, 233, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 158, 246, 247, 248};
    private static final int[] ISO_3166_2_TO_1 = new int[]{13, 2, 7, 4, 14, 5, 0, 1, 9, 6, 10, 8, 215, 3, 12, 11, 15, 23, 19, 24, 29, 20, 18, 21, 22, 31, 16, 25, 35, 36, 26, 28, 30, 17, 27, 32, 33, 34, 40, 37, 38, 42, 45, 47, 43, 46, 39, 41, 44, 48, 118, 51, 49, 50, 52, 53, 123, 54, 55, 56, 57, 59, 58, 60, 61, 62, 64, 66, 65, 67, 63, 68, 69, 70, 71, 74, 73, 72, 75, 76, 78, 80, 81, 82, 85, 86, 84, 92, 87, 88, 77, 83, 90, 79, 91, 93, 94, 95, 96, 97, 98, 99, 100, 103, 104, 105, 101, 107, 106, 108, 102, 109, 111, 110, 112, 113, 124, 114, 115, 116, 117, 119, 121, 122, 125, 126, 130, 135, 127, 128, 129, 131, 132, 133, 134, 147, 140, 136, 137, 138, 141, 154, 156, 142, 143, 144, 152, 145, 139, 146, 148, 158, 150, 151, 149, 153, 155, 157, 245, 159, 160, 161, 162, 163, 164, 169, 165, 166, 167, 168, 170, 171, 177, 172, 180, 173, 176, 184, 175, 178, 181, 120, 183, 185, 182, 174, 186, 187, 188, 190, 191, 192, 195, 204, 197, 89, 198, 200, 193, 202, 209, 203, 205, 179, 189, 207, 208, 206, 201, 199, 196, 212, 210, 194, 211, 213, 214, 216, 217, 218, 219, 221, 220, 223, 225, 222, 224, 226, 227, 228, 230, 229, 231, 233, 232, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 246, 247, 248};
    private static final int[] REGIONS_AFR = new int[]{246, 159};
    private static final int[] REGIONS_ARA = new int[]{7, 24, 50, 60, 64, 66, 67, 68, 108, 110, 114, 123, 125, 127, 137, 152, 171, 184, 186, 191, 192, 202, 205, 214, 216, 225, 245};
    private static final int[] REGIONS_BEN = new int[]{22, 104};
    private static final int[] REGIONS_BOD = new int[]{43, 104};
    private static final int[] REGIONS_CAT = new int[]{6, 69, 75, 111};
    private static final int[] REGIONS_DAN = new int[]{62, 91};
    private static final int[] REGIONS_DEU = new int[]{59, 15, 18, 41, 129, 133};
    private static final int[] REGIONS_ELL = new int[]{89, 57};
    private static final int[] REGIONS_ENG = new int[]{234, 3, 10, 13, 14, 18, 25, 29, 30, 33, 37, 39, 40, 45, 48, 55, 56, 61, 67, 73, 74, 77, 79, 81, 82, 83, 86, 90, 94, 95, 96, 103, 104, 105, 106, 112, 113, 117, 120, 121, 126, 128, 131, 135, 140, 143, 146, 150, 153, 155, 156, 157, 159, 162, 163, 165, 169, 170, 172, 174, 176, 177, 178, 180, 190, 192, 194, 196, 198, 199, 205, 211, 212, 213, 215, 220, 223, 224, 227, 229, 230, 232, 237, 239, 240, 242, 244, 246, 247, 248};
    private static final int[] REGIONS_EWE = new int[]{82, 217};
    private static final int[] REGIONS_FAS = new int[]{107, 1};
    private static final int[] REGIONS_FRA = new int[]{75, 17, 18, 19, 21, 27, 38, 39, 41, 44, 45, 46, 47, 50, 60, 64, 78, 84, 85, 88, 93, 100, 133, 136, 137, 138, 140, 145, 152, 154, 155, 158, 160, 161, 185, 187, 190, 193, 203, 213, 214, 216, 217, 225, 242, 243};
    private static final int[] REGIONS_FUL = new int[]{193, 45, 84, 152};
    private static final int[] REGIONS_GSW = new int[]{41, 75, 129};
    private static final int[] REGIONS_HAU = new int[]{163, 82, 161};
    private static final int[] REGIONS_HRV = new int[]{99, 26};
    private static final int[] REGIONS_ITA = new int[]{111, 41, 201};
    private static final int[] REGIONS_KOR = new int[]{122, 181};
    private static final int[] REGIONS_LIN = new int[]{46, 2, 38, 47};
    private static final int[] REGIONS_MAS = new int[]{117, 229};
    private static final int[] REGIONS_MSA = new int[]{157, 34, 194};
    private static final int[] REGIONS_NEP = new int[]{168, 104};
    private static final int[] REGIONS_NLD = new int[]{166, 0, 18, 20, 54, 207, 212};
    private static final int[] REGIONS_NOB = new int[]{167, 197};
    private static final int[] REGIONS_ORM = new int[]{71, 117};
    private static final int[] REGIONS_OSS = new int[]{189, 80};
    private static final int[] REGIONS_PAN = new int[]{172, 104};
    private static final int[] REGIONS_POR = new int[]{182, 2, 32, 51, 87, 135, 151, 206, 222};
    private static final int[] REGIONS_QUE = new int[]{175, 31, 65};
    private static final int[] REGIONS_RON = new int[]{188, 139};
    private static final int[] REGIONS_RUS = new int[]{189, 28, 116, 118, 139, 231};
    private static final int[] REGIONS_SME = new int[]{167, 72, 210};
    private static final int[] REGIONS_SOM = new int[]{202, 60, 71, 117};
    private static final int[] REGIONS_SPA = new int[]{69, 8, 31, 42, 49, 52, 53, 63, 65, 88, 92, 98, 142, 164, 173, 175, 176, 180, 183, 200, 233, 234, 238};
    private static final int[] REGIONS_SQI = new int[]{5, 144};
    private static final int[] REGIONS_SRP = new int[]{204, 26, 148};
    private static final int[] REGIONS_SWA = new int[]{229, 117, 230};
    private static final int[] REGIONS_SWE = new int[]{210, 4, 72};
    private static final int[] REGIONS_TAM = new int[]{104, 130, 157, 194};
    private static final int[] REGIONS_TEO = new int[]{117, 230};
    private static final int[] REGIONS_TIR = new int[]{67, 71};
    private static final int[] REGIONS_TUR = new int[]{226, 57};
    private static final int[] REGIONS_URD = new int[]{104, 172};
    private static final int[] REGIONS_UZB = new int[]{235, 1};
    private static final int[] REGIONS_YOR = new int[]{163, 19};
    private static final int[] REGIONS_ZHO = new int[]{43, 96, 135, 194, 228};
    private static final int[][] LANGUAGE_REGIONS = new int[][]{null, null, null, null, null, null, null, null, REGIONS_AFR, null, null, null, null, null, null, null, null, null, null, null, REGIONS_ARA, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_BEN, null, null, null, null, null, null, null, null, null, REGIONS_BOD, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_CAT, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_DAN, null, null, null, null, null, REGIONS_DEU, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_ELL, null, REGIONS_ENG, null, null, null, null, REGIONS_EWE, null, null, null, REGIONS_FAS, null, null, null, null, null, null, REGIONS_FRA, null, null, null, null, null, REGIONS_FUL, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_GSW, null, null, null, null, null, REGIONS_HAU, null, null, null, null, null, null, null, null, null, REGIONS_HRV, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_ITA, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_KOR, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_LIN, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_MAS, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_MSA, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_NEP, null, null, null, null, REGIONS_NLD, null, null, null, REGIONS_NOB, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_ORM, null, REGIONS_OSS, null, null, null, null, null, null, REGIONS_PAN, null, null, null, null, null, null, null, null, REGIONS_POR, null, null, null, REGIONS_QUE, null, null, null, null, null, null, null, REGIONS_RON, null, null, REGIONS_RUS, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_SME, null, null, null, null, null, null, null, null, null, REGIONS_SOM, null, null, REGIONS_SPA, REGIONS_SQI, null, null, REGIONS_SRP, null, null, null, null, null, null, null, REGIONS_SWA, null, REGIONS_SWE, null, null, null, null, REGIONS_TAM, null, null, null, REGIONS_TEO, null, null, null, null, null, null, REGIONS_TIR, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_TUR, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_URD, REGIONS_UZB, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, REGIONS_YOR, null, null, null, null, null, null, REGIONS_ZHO, null, null, null, null};
    private static final int[] LANGUAGE_REGION = new int[]{71, 80, -1, -1, -1, -1, -1, -1, 246, 45, -1, 82, -1, -1, -1, -1, 71, -1, -1, -1, 7, -1, 69, -1, -1, -1, -1, 229, 104, -1, -1, -1, 16, -1, -1, 31, 16, -1, -1, 189, -1, 145, -1, 45, -1, -1, 28, 247, 22, -1, 229, -1, 104, -1, -1, 242, -1, -1, 43, 26, -1, 75, 104, -1, -1, -1, 23, -1, -1, -1, -1, 6, -1, -1, -1, 58, 230, 94, -1, 189, -1, -1, -1, -1, -1, -1, 234, -1, 189, -1, -1, -1, 79, 75, -1, -1, -1, 39, -1, -1, -1, -1, 79, -1, 62, -1, 117, -1, -1, -1, 59, -1, -1, 141, 161, -1, -1, 59, 45, -1, 193, -1, 35, 117, -1, -1, -1, 89, -1, 234, -1, -1, 70, 69, 82, 45, -1, 76, 107, -1, 73, 176, 72, -1, -1, 75, -1, -1, -1, -1, 166, 193, 111, -1, -1, -1, -1, -1, -1, 79, 106, 69, 103, -1, -1, -1, -1, -1, -1, -1, 183, 41, 104, 117, -1, -1, 100, 163, 234, 110, 159, -1, -1, 104, -1, -1, 178, 99, 59, 101, -1, 9, -1, 163, -1, 43, -1, 39, -1, -1, -1, -1, 102, -1, -1, 234, -1, -1, 109, 111, 102, -1, 45, 229, 115, -1, -1, -1, 64, -1, 91, 117, 104, -1, 104, 80, 163, -1, 116, -1, 229, 51, -1, -1, 119, -1, 145, 117, 190, 118, 45, 117, -1, 104, 189, 2, 122, -1, -1, -1, -1, -1, -1, 229, 45, 59, 2, -1, -1, -1, -1, 229, -1, -1, 124, -1, 134, -1, 166, 46, 132, 234, -1, -1, 133, -1, 46, 230, -1, -1, 117, -1, 117, -1, -1, 143, -1, -1, 104, -1, 170, -1, 104, 117, -1, -1, -1, 117, 155, -1, 151, 45, -1, -1, -1, 144, -1, 140, 146, -1, -1, -1, -1, 149, -1, 157, 45, -1, -1, -1, -1, -1, 147, -1, -1, -1, -1, -1, 159, 169, 234, 246, 248, 159, -1, 168, -1, -1, -1, -1, 166, 45, 45, 167, 167, -1, -1, 167, -1, -1, -1, 192, -1, 156, -1, 230, -1, -1, 75, 39, 104, 71, -1, 189, -1, -1, -1, -1, -1, -1, 172, -1, -1, -1, -1, -1, -1, 179, -1, 182, -1, -1, 1, 175, -1, -1, -1, -1, 229, 41, -1, 188, 17, -1, 189, 229, -1, 38, 189, -1, -1, -1, 104, 117, -1, -1, 229, -1, -1, 151, -1, -1, 145, -1, -1, 137, -1, -1, 130, -1, -1, -1, 208, 209, -1, 167, -1, -1, 72, 244, -1, 248, 172, -1, -1, 202, -1, 131, 69, 5, 111, -1, 204, -1, -1, 211, -1, 102, -1, -1, 229, 46, 210, -1, -1, 185, -1, 104, 189, 104, -1, 117, -1, -1, 219, 176, 218, -1, 67, -1, -1, -1, -1, -1, -1, 223, -1, -1, 37, 151, 221, -1, -1, 226, -1, -1, 82, 161, -1, 137, -1, -1, 43, 231, -1, -1, 104, 235, 126, 246, 241, -1, -1, 229, 41, -1, -1, -1, -1, -1, 18, 193, -1, 246, 230, -1, -1, 45, 234, 163, -1, -1, -1, -1, -1, 43, 43, -1, 246, -1, -1};

    private LocaleManager() {
    }

    public static String getRegionName(String regionCode) {
        if (regionCode.length() == 2) {
            assert (Character.isUpperCase(regionCode.charAt(0)) && Character.isUpperCase(regionCode.charAt(1))) : regionCode;
            int index = Arrays.binarySearch(ISO_3166_1_CODES, regionCode);
            if (index < 0 || index >= ISO_3166_1_TO_2.length) {
                return null;
            }
            return ISO_3166_2_NAMES[ISO_3166_1_TO_2[index]];
        }
        if (regionCode.length() == 3) {
            assert (Character.isUpperCase(regionCode.charAt(0)) && Character.isUpperCase(regionCode.charAt(1)) && Character.isUpperCase(regionCode.charAt(2))) : regionCode;
            int index = Arrays.binarySearch(ISO_3166_2_CODES, regionCode);
            if (index < 0) {
                return null;
            }
            return ISO_3166_2_NAMES[index];
        }
        return null;
    }

    public static String getLanguageName(String languageCode) {
        if (languageCode.length() == 2) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1))) : languageCode;
            int index = Arrays.binarySearch(ISO_639_1_CODES, languageCode);
            if (index < 0 || index >= ISO_639_1_TO_2.length) {
                return null;
            }
            return ISO_639_2_NAMES[ISO_639_1_TO_2[index]];
        }
        if (languageCode.length() == 3) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1)) && Character.isLowerCase(languageCode.charAt(2))) : languageCode;
            int index = Arrays.binarySearch(ISO_639_2_CODES, languageCode);
            if (index < 0) {
                return null;
            }
            return ISO_639_2_NAMES[index];
        }
        return null;
    }

    public static List<String> getLanguageCodes() {
        return LocaleManager.getLanguageCodes(false);
    }

    public static List<String> getLanguageCodes(boolean include3) {
        if (!include3) {
            return Arrays.asList(ISO_639_1_CODES);
        }
        ArrayList<String> codes = new ArrayList<String>(ISO_639_2_CODES.length);
        for (int i = 0; i < ISO_639_2_TO_1.length; ++i) {
            int iso2 = ISO_639_2_TO_1[i];
            if (iso2 != -1) {
                codes.add(ISO_639_1_CODES[iso2]);
                continue;
            }
            codes.add(ISO_639_2_CODES[i]);
        }
        return codes;
    }

    public static List<String> getRegionCodes() {
        return LocaleManager.getRegionCodes(false);
    }

    public static List<String> getRegionCodes(boolean include3) {
        if (!include3) {
            return Arrays.asList(ISO_3166_1_CODES);
        }
        ArrayList<String> codes = new ArrayList<String>(ISO_3166_2_CODES.length);
        for (int i = 0; i < ISO_3166_2_TO_1.length; ++i) {
            int iso2 = ISO_3166_2_TO_1[i];
            if (iso2 != -1) {
                codes.add(ISO_3166_1_CODES[iso2]);
                continue;
            }
            codes.add(ISO_3166_2_CODES[i]);
        }
        return codes;
    }

    public static boolean isValidLanguageCode(String languageCode) {
        if (languageCode.length() == 2) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1))) : languageCode;
            return Arrays.binarySearch(ISO_639_1_CODES, languageCode) >= 0;
        }
        if (languageCode.length() == 3) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1)) && Character.isLowerCase(languageCode.charAt(2))) : languageCode;
            return Arrays.binarySearch(ISO_639_2_CODES, languageCode) >= 0;
        }
        return false;
    }

    public static boolean isValidRegionCode(String regionCode) {
        if (regionCode.length() == 2) {
            assert (Character.isUpperCase(regionCode.charAt(0)) && Character.isUpperCase(regionCode.charAt(1))) : regionCode;
            return Arrays.binarySearch(ISO_3166_1_CODES, regionCode) >= 0;
        }
        if (regionCode.length() == 3) {
            assert (Character.isUpperCase(regionCode.charAt(0)) && Character.isUpperCase(regionCode.charAt(1)) && Character.isUpperCase(regionCode.charAt(2))) : regionCode;
            return Arrays.binarySearch(ISO_3166_2_CODES, regionCode) >= 0;
        }
        return false;
    }

    public static String getDefaultLanguageRegion(String languageCode) {
        if (languageCode.length() == 2) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1))) : languageCode;
            int index = Arrays.binarySearch(ISO_639_1_CODES, languageCode);
            if (index < 0 || index >= ISO_639_1_TO_2.length) {
                return null;
            }
            int regionIndex = LANGUAGE_REGION[ISO_639_1_TO_2[index]];
            if (regionIndex != -1) {
                int twoLetterIndex = ISO_3166_2_TO_1[regionIndex];
                if (twoLetterIndex != -1) {
                    return ISO_3166_1_CODES[twoLetterIndex];
                }
                return ISO_3166_2_CODES[regionIndex];
            }
            return null;
        }
        if (languageCode.length() == 3) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1)) && Character.isLowerCase(languageCode.charAt(2))) : languageCode;
            int index = Arrays.binarySearch(ISO_639_2_CODES, languageCode);
            if (index < 0) {
                return null;
            }
            return LocaleManager.getRegionCode(LANGUAGE_REGION[index]);
        }
        assert (false) : languageCode;
        return null;
    }

    public static String getLanguageRegion(String languageCode) {
        String country;
        Locale locale;
        String option = System.getenv("STUDIO_LOCALES");
        if (option == null) {
            option = System.getProperty("studio.locales");
        }
        if (option != null) {
            for (String regionLocale : Splitter.on((char)',').trimResults().split((CharSequence)option)) {
                if (!SdkUtils.startsWithIgnoreCase((String)regionLocale, (String)languageCode)) continue;
                if (regionLocale.length() == 5 && (regionLocale.charAt(2) == '_' || regionLocale.charAt(2) == '-')) {
                    return regionLocale.substring(3).toUpperCase(Locale.US);
                }
                if (regionLocale.length() != 6 || regionLocale.charAt(2) != '-' || regionLocale.charAt(3) != 'r') continue;
                return regionLocale.substring(4).toUpperCase(Locale.US);
            }
        }
        if (languageCode.equalsIgnoreCase((locale = Locale.getDefault()).getLanguage()) && !(country = locale.getCountry()).isEmpty() && (country = country.toUpperCase(Locale.US)).length() == 2) {
            return country;
        }
        List<String> regions = LocaleManager.getRelevantRegions(languageCode);
        if (regions.size() > 1) {
            List<String> relevant = LocaleManager.getDisambiguateRegions(languageCode);
            String country2 = locale.getCountry();
            if (!country2.isEmpty() && relevant != null && (country2 = country2.toUpperCase(Locale.US)).length() == 2 && regions.contains(country2) && (relevant.isEmpty() || relevant.contains(country2))) {
                return country2;
            }
            if (relevant != null) {
                String region = LocaleManager.getTimeZoneRegionAlpha2(TimeZone.getDefault());
                if (region == null) {
                    return null;
                }
                if (regions.contains(region) && (relevant.isEmpty() || relevant.contains(region))) {
                    return region;
                }
            }
            Locale candidate = null;
            for (Locale available : Locale.getAvailableLocales()) {
                if (!languageCode.equals(available.getLanguage()) || !regions.contains(available.getCountry())) continue;
                if (candidate != null) {
                    candidate = null;
                    break;
                }
                candidate = available;
            }
            if (candidate != null && relevant != null && (relevant.isEmpty() || relevant.contains(candidate.getCountry()))) {
                return candidate.getCountry();
            }
            char first = Character.toUpperCase(languageCode.charAt(0));
            char second = Character.toUpperCase(languageCode.charAt(1));
            for (String r : regions) {
                if (r.charAt(0) != first || r.charAt(1) != second) continue;
                return r;
            }
        } else if (regions.size() == 1) {
            return regions.get(0);
        }
        return LocaleManager.getDefaultLanguageRegion(languageCode);
    }

    private static List<String> getDisambiguateRegions(String languageCode) {
        if ("ar".equals(languageCode) || "zh".equals(languageCode)) {
            return Collections.emptyList();
        }
        if ("en".equals(languageCode)) {
            return Arrays.asList("US", "GB");
        }
        if ("es".equals(languageCode)) {
            return Arrays.asList("MX", "AR", "CL", "CO", "CR", "CU", "DO", "GT", "HN", "NI", "PA", "PY", "SV", "UY", "VE", "ME");
        }
        if ("pt".equals(languageCode)) {
            return Arrays.asList("PT", "BR");
        }
        if ("ru".equals(languageCode)) {
            return Collections.singletonList("ru");
        }
        return null;
    }

    private static String getRegionCode(int index) {
        if (index != -1) {
            int twoLetterIndex = ISO_3166_2_TO_1[index];
            if (twoLetterIndex != -1) {
                return ISO_3166_1_CODES[twoLetterIndex];
            }
            return ISO_3166_2_CODES[index];
        }
        return null;
    }

    public static List<String> getRelevantRegions(String languageCode) {
        int languageIndex;
        if (languageCode.length() == 2) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1))) : languageCode;
            int index = Arrays.binarySearch(ISO_639_1_CODES, languageCode);
            if (index < 0 || index >= ISO_639_1_TO_2.length) {
                return Collections.emptyList();
            }
            languageIndex = ISO_639_1_TO_2[index];
        } else if (languageCode.length() == 3) {
            assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1)) && Character.isLowerCase(languageCode.charAt(2))) : languageCode;
            languageIndex = Arrays.binarySearch(ISO_639_2_CODES, languageCode);
            if (languageIndex < 0) {
                return Collections.emptyList();
            }
        } else {
            assert (false) : languageCode;
            return Collections.emptyList();
        }
        int[] regionIndices = LANGUAGE_REGIONS[languageIndex];
        if (regionIndices == null) {
            String regionCode = LocaleManager.getRegionCode(LANGUAGE_REGION[languageIndex]);
            return regionCode != null ? Collections.singletonList(regionCode) : Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(regionIndices.length);
        for (int regionIndex : regionIndices) {
            String regionCode = LocaleManager.getRegionCode(regionIndex);
            if (regionCode == null) continue;
            result.add(regionCode);
        }
        return result;
    }

    public static String getLanguageAlpha2(String languageCode) {
        assert (languageCode.length() == 3) : languageCode;
        assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1)) && Character.isLowerCase(languageCode.charAt(2))) : languageCode;
        int index = Arrays.binarySearch(ISO_639_2_CODES, languageCode);
        if (index < 0) {
            return null;
        }
        int alpha2 = ISO_639_2_TO_1[index];
        if (alpha2 != -1) {
            return ISO_639_1_CODES[alpha2];
        }
        return null;
    }

    public static String getLanguageAlpha3(String languageCode) {
        assert (languageCode.length() == 2) : languageCode;
        assert (Character.isLowerCase(languageCode.charAt(0)) && Character.isLowerCase(languageCode.charAt(1))) : languageCode;
        int index = Arrays.binarySearch(ISO_639_1_CODES, languageCode);
        if (index < 0) {
            return null;
        }
        int alpha2 = ISO_639_1_TO_2[index];
        if (alpha2 != -1) {
            return ISO_639_2_CODES[alpha2];
        }
        return null;
    }

    public static String getRegionAlpha2(String regionCode) {
        assert (regionCode.length() == 3) : regionCode;
        assert (Character.isUpperCase(regionCode.charAt(0)) && Character.isUpperCase(regionCode.charAt(1)) && Character.isUpperCase(regionCode.charAt(2))) : regionCode;
        int index = Arrays.binarySearch(ISO_3166_2_CODES, regionCode);
        if (index < 0) {
            return null;
        }
        int alpha2 = ISO_3166_2_TO_1[index];
        if (alpha2 != -1) {
            return ISO_3166_1_CODES[alpha2];
        }
        return null;
    }

    public static String getRegionAlpha3(String regionCode) {
        assert (regionCode.length() == 2) : regionCode;
        assert (Character.isUpperCase(regionCode.charAt(0)) && Character.isUpperCase(regionCode.charAt(1))) : regionCode;
        int index = Arrays.binarySearch(ISO_3166_1_CODES, regionCode);
        if (index < 0) {
            return null;
        }
        int alpha2 = ISO_3166_1_TO_2[index];
        if (alpha2 != -1) {
            return ISO_3166_2_CODES[alpha2];
        }
        return null;
    }

    public static String getTimeZoneRegionAlpha3(TimeZone zone) {
        int index = LocaleManager.getTimeZoneRegionIndex(zone);
        if (index != -1) {
            return ISO_3166_2_CODES[index];
        }
        return null;
    }

    public static String getTimeZoneRegionAlpha2(TimeZone zone) {
        int index = LocaleManager.getTimeZoneRegionIndex(zone);
        if (index != -1 && (index = ISO_3166_2_TO_1[index]) != -1) {
            return ISO_3166_1_CODES[index];
        }
        return null;
    }

    private static int getTimeZoneRegionIndex(TimeZone zone) {
        String id = zone.getID();
        int hashedId = 0;
        int n = id.length();
        for (int i = 0; i < n; ++i) {
            hashedId = 31 * hashedId + id.charAt(i);
        }
        switch (zone.getRawOffset()) {
            case -36000000: {
                return 234;
            }
            case -32400000: {
                return 234;
            }
            case -28800000: {
                switch (hashedId) {
                    case -1983011822: 
                    case -459287604: 
                    case 256046501: 
                    case 1647318035: {
                        return 142;
                    }
                    case -2010814355: 
                    case -347637707: 
                    case 364935240: 
                    case 900028252: 
                    case 1389185817: {
                        return 39;
                    }
                }
                return 234;
            }
            case -25200000: {
                switch (hashedId) {
                    case -641163936: 
                    case 202222115: 
                    case 611591843: 
                    case 1532263802: 
                    case 2142546433: {
                        return 142;
                    }
                    case -1998145482: 
                    case -1774689070: 
                    case -906910905: 
                    case -302339179: 
                    case 1544280457: 
                    case 1850095790: 
                    case 1924477936: {
                        return 39;
                    }
                }
                return 234;
            }
            case -21600000: {
                switch (hashedId) {
                    case -355081471: {
                        return 52;
                    }
                    case 662067781: {
                        return 65;
                    }
                    case 268098540: {
                        return 92;
                    }
                    case -1192934179: {
                        return 98;
                    }
                    case -496169397: {
                        return 164;
                    }
                    case -610612331: {
                        return 200;
                    }
                    case -2089950224: 
                    case 35870737: {
                        return 42;
                    }
                    case -1436528620: 
                    case -905842704: 
                    case -380253810: 
                    case 958016402: 
                    case 1033313139: 
                    case 1360273357: 
                    case 1650383341: {
                        return 142;
                    }
                    case -1997850159: 
                    case -1958461186: 
                    case -1616213428: 
                    case 99854508: 
                    case 569007676: 
                    case 1290869225: 
                    case 1334007082: 
                    case 1793201705: 
                    case 1837303604: {
                        return 39;
                    }
                }
                return 234;
            }
            case -18000000: {
                switch (hashedId) {
                    case 1344376451: {
                        return 49;
                    }
                    case 407688513: {
                        return 65;
                    }
                    case 1732450137: {
                        return 173;
                    }
                    case 2039677810: {
                        return 175;
                    }
                    case 2111569: 
                    case 1503655288: {
                        return 53;
                    }
                    case -1756511823: 
                    case -615687308: 
                    case 42696295: 
                    case 1213658776: {
                        return 32;
                    }
                    case -1694184172: 
                    case -792567293: 
                    case 151241566: 
                    case 622452689: 
                    case 695184620: 
                    case 977509670: 
                    case 1356626855: 
                    case 1826315056: 
                    case 1908749375: {
                        return 39;
                    }
                }
                return 234;
            }
            case -16200000: {
                return 238;
            }
            case -14400000: {
                switch (hashedId) {
                    case 1501639611: {
                        return 8;
                    }
                    case 1617469984: {
                        return 31;
                    }
                    case -432820086: {
                        return 63;
                    }
                    case 1367207089: {
                        return 183;
                    }
                    case -2036395347: 
                    case -611834443: {
                        return 42;
                    }
                    case -691236908: 
                    case 79506: {
                        return 180;
                    }
                    case -2087755565: 
                    case -2011036567: 
                    case -1680637607: 
                    case -640330778: 
                    case -95289381: 
                    case 1275531960: {
                        return 39;
                    }
                }
                return 32;
            }
            case -12600000: {
                return 39;
            }
            case -10800000: {
                switch (hashedId) {
                    case 1987071743: {
                        return 233;
                    }
                    case -1887400619: 
                    case -1756511823: 
                    case -1523781592: 
                    case -1203975328: 
                    case -1203852432: 
                    case -615687308: 
                    case -612056498: 
                    case 65649: 
                    case 42696295: 
                    case 1213658776: 
                    case 1213776064: 
                    case 1231674648: 
                    case 1646238717: 
                    case 1793082297: {
                        return 32;
                    }
                }
                return 8;
            }
            case -7200000: {
                return 32;
            }
            case -3600000: {
                return 182;
            }
            case 0: {
                switch (hashedId) {
                    case -2002672065: {
                        return 69;
                    }
                    case -3562122: {
                        return 137;
                    }
                    case 2160119: 
                    case 300259341: {
                        return 106;
                    }
                    case -1722575083: 
                    case -1000832298: {
                        return 109;
                    }
                    case -1677314468: 
                    case 518707320: 
                    case 794006110: {
                        return 182;
                    }
                }
                return 79;
            }
            case 3600000: {
                switch (hashedId) {
                    case 747709736: {
                        return 5;
                    }
                    case 804593244: {
                        return 15;
                    }
                    case 1036497278: {
                        return 26;
                    }
                    case -516035308: {
                        return 18;
                    }
                    case 930574244: {
                        return 41;
                    }
                    case 641004357: {
                        return 58;
                    }
                    case -862787273: {
                        return 62;
                    }
                    case -977866396: {
                        return 64;
                    }
                    case 911784828: {
                        return 99;
                    }
                    case 1643067635: {
                        return 101;
                    }
                    case -1407095582: {
                        return 111;
                    }
                    case 432607731: {
                        return 133;
                    }
                    case -1834768363: {
                        return 148;
                    }
                    case 720852545: {
                        return 144;
                    }
                    case -675325160: {
                        return 146;
                    }
                    case 1107183657: {
                        return 166;
                    }
                    case 562540219: {
                        return 204;
                    }
                    case -1783944015: {
                        return 210;
                    }
                    case -1262503490: {
                        return 209;
                    }
                    case -1871032358: {
                        return 208;
                    }
                    case 1817919522: {
                        return 225;
                    }
                    case 228701359: 
                    case 2079834968: {
                        return 59;
                    }
                    case 539516618: 
                    case 1801750059: {
                        return 69;
                    }
                    case -672549154: 
                    case 68470: {
                        return 75;
                    }
                    case -1121325742: 
                    case 73413677: {
                        return 127;
                    }
                    case -1407181132: 
                    case -72083073: {
                        return 167;
                    }
                }
                return 179;
            }
            case 0x6DDD00: {
                switch (hashedId) {
                    case -669373067: {
                        return 23;
                    }
                    case 1469914287: {
                        return 70;
                    }
                    case -1854672812: {
                        return 72;
                    }
                    case 213620546: {
                        return 89;
                    }
                    case -1678352343: {
                        return 114;
                    }
                    case -468176592: {
                        return 125;
                    }
                    case -820952635: {
                        return 132;
                    }
                    case -1407101538: {
                        return 134;
                    }
                    case -1305089392: {
                        return 188;
                    }
                    case 1640682817: {
                        return 189;
                    }
                    case 1088211684: {
                        return 214;
                    }
                    case 1587535273: {
                        return 246;
                    }
                    case -2046172313: {
                        return -1;
                    }
                    case 540421055: 
                    case 660679831: {
                        return 57;
                    }
                    case -1121325742: 
                    case 73413677: {
                        return 127;
                    }
                    case 65091: 
                    case 66911291: 
                    case 1801619315: {
                        return 66;
                    }
                    case -2095341728: 
                    case -1868494453: 
                    case 511371267: {
                        return 110;
                    }
                    case -1778564402: 
                    case -359165265: 
                    case 207779975: {
                        return 226;
                    }
                }
                return 231;
            }
            case 10800000: {
                switch (hashedId) {
                    case -1744032040: {
                        return 24;
                    }
                    case -675084931: {
                        return 28;
                    }
                    case -1745250846: {
                        return 108;
                    }
                    case -195337532: {
                        return 123;
                    }
                    case -1663926768: {
                        return 186;
                    }
                    case -5956312: {
                        return 191;
                    }
                    case 581080470: {
                        return 192;
                    }
                    case -1439622607: {
                        return 245;
                    }
                    case -2046172313: {
                        return -1;
                    }
                }
                return 189;
            }
            case 14400000: {
                switch (hashedId) {
                    case -1675354028: {
                        return 7;
                    }
                    case -138196720: {
                        return 171;
                    }
                    case -2046172313: {
                        return -1;
                    }
                }
                return 189;
            }
            case 18000000: {
                return 189;
            }
            case 19800000: {
                return 104;
            }
            case 21600000: {
                switch (hashedId) {
                    case 88135602: 
                    case 1958400136: {
                        return 43;
                    }
                }
                return 189;
            }
            case 25200000: {
                switch (hashedId) {
                    case -1738808822: {
                        return 218;
                    }
                    case -788096746: 
                    case 1063310893: {
                        return 102;
                    }
                    case 85303: 
                    case 14814128: 
                    case 1214715332: {
                        return 241;
                    }
                }
                return 189;
            }
            case 28800000: {
                switch (hashedId) {
                    case -156810007: {
                        return 176;
                    }
                    case 43451613: {
                        return 228;
                    }
                    case 307946178: 
                    case 1811257630: {
                        return 14;
                    }
                    case -390386883: 
                    case 404568855: {
                        return 96;
                    }
                    case -463608032: 
                    case -84259736: {
                        return 102;
                    }
                    case -1778758162: 
                    case -99068543: {
                        return 157;
                    }
                    case -808657565: 
                    case 663100500: {
                        return 189;
                    }
                    case 133428255: 
                    case 499614468: {
                        return 194;
                    }
                }
                return 43;
            }
            case 31500000: {
                return 14;
            }
            case 32400000: {
                switch (hashedId) {
                    case -996350568: {
                        return 102;
                    }
                    case -1661964753: 
                    case 81326: {
                        return 122;
                    }
                    case -1660747039: 
                    case 73771: 
                    case 71341030: {
                        return 115;
                    }
                }
                return 189;
            }
            case 34200000: {
                return 14;
            }
            case 36000000: {
                switch (hashedId) {
                    case -572853474: 
                    case -402306110: 
                    case 1409241312: 
                    case 1491561941: 
                    case 1755599521: 
                    case 1988570398: {
                        return 189;
                    }
                }
                return 14;
            }
            case 37800000: {
                return 14;
            }
            case 39600000: {
                switch (hashedId) {
                    case -1609966193: {
                        return 14;
                    }
                }
                return 189;
            }
            case 43200000: {
                switch (hashedId) {
                    case -572853474: 
                    case -488745714: 
                    case -345416640: {
                        return 189;
                    }
                }
                return 170;
            }
            case 45900000: {
                return 170;
            }
        }
        return -1;
    }

    /*
     * Opcode count of 18647 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        assert (ISO_639_2_CODES.length == 531);
        assert (ISO_639_2_NAMES.length == 531);
        assert (ISO_639_2_TO_1.length == 531);
        assert (ISO_639_1_CODES.length == 187);
        assert (ISO_639_1_TO_2.length == 187);
        assert (ISO_3166_2_CODES.length == 249);
        assert (ISO_3166_2_NAMES.length == 249);
        assert (ISO_3166_2_TO_1.length == 249);
        assert (ISO_3166_1_CODES.length == 249);
        assert (ISO_3166_1_TO_2.length == 249);
        assert (LANGUAGE_REGION.length == 531);
        assert (LANGUAGE_REGIONS.length == 531);
    }
}

