/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.repository.GradleVersion;
import com.android.utils.HashCodes;
import com.google.common.base.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class GradleVersionRange {
    private static final Pattern RANGE_PATTERN = Pattern.compile("\\[([^,)]+),([^,)]+)\\)");
    private final GradleVersion myMin;
    private final GradleVersion myMax;

    public static GradleVersionRange parse(String value) {
        return GradleVersionRange.parse(value, false);
    }

    public static GradleVersionRange parse(String value, boolean useSemanticVersioning) {
        if (!value.startsWith("[")) {
            GradleVersion minimum = GradleVersion.parse(value);
            if (!useSemanticVersioning) {
                return new GradleVersionRange(minimum, null);
            }
            return new GradleVersionRange(minimum, new GradleVersion(minimum.getMajor() + 1, 0, 0));
        }
        Matcher matcher = RANGE_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw GradleVersionRange.parsingFailure(value);
        }
        return new GradleVersionRange(GradleVersion.parse(matcher.group(1)), GradleVersion.parse(matcher.group(2)));
    }

    @Nullable
    public static GradleVersionRange tryParse(String value, boolean useSemanticVersioning) {
        try {
            return GradleVersionRange.parse(value, useSemanticVersioning);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Nullable
    public static GradleVersionRange tryParse(String value) {
        return GradleVersionRange.tryParse(value, false);
    }

    private static IllegalArgumentException parsingFailure(String value) {
        return new IllegalArgumentException(String.format("'%1$s' is not a valid version range", value));
    }

    private GradleVersionRange(GradleVersion min, @Nullable GradleVersion max) {
        this.myMin = min;
        this.myMax = max;
    }

    public GradleVersion getMin() {
        return this.myMin;
    }

    @Nullable
    public GradleVersion getMax() {
        return this.myMax;
    }

    @Nullable
    public GradleVersionRange intersection(GradleVersionRange other) {
        if (this.myMax == null && other.myMax == null) {
            return other.myMin.equals(this.myMin) ? this : null;
        }
        if (this.myMax == null) {
            return this.myMin.compareTo(other.myMin) >= 0 && this.myMin.compareTo(other.myMax) < 0 ? this : null;
        }
        if (other.myMax == null) {
            return other.myMin.compareTo(this.myMin) >= 0 && other.myMin.compareTo(this.myMax) < 0 ? other : null;
        }
        GradleVersion min = this.myMin.compareTo(other.myMin) >= 0 ? this.myMin : other.myMin;
        GradleVersion max = this.myMax.compareTo(other.myMax) <= 0 ? this.myMax : other.myMax;
        return min.compareTo(max) < 0 ? new GradleVersionRange(min, max) : null;
    }

    @Nullable
    public GradleVersionRange intersection(GradleVersion version) {
        return this.intersection(new GradleVersionRange(version, null));
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myMin.hashCode(), (int)(this.myMax != null ? this.myMax.hashCode() : 0));
    }

    public boolean equals(Object other) {
        if (!(other instanceof GradleVersionRange)) {
            return false;
        }
        GradleVersionRange range = (GradleVersionRange)other;
        return Objects.equal((Object)this.myMin, (Object)range.myMin) && Objects.equal((Object)this.myMax, (Object)range.myMax);
    }

    public String toString() {
        if (this.myMax == null) {
            return this.myMin.toString();
        }
        return String.format("[%1$s,%2$s)", this.myMin, this.myMax);
    }
}

